/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;

public enum KVTableState {
    UNKNOWN,
    CREATING,
    DELETING,
    ACTIVE;


    public static boolean isTransitionAllowed(KVTableState currentState, KVTableState newState) {
        return StateTransitions.valueOf((String)currentState.name()).transitions.contains((Object)newState);
    }

    private static enum StateTransitions {
        UNKNOWN(UNKNOWN, CREATING),
        CREATING(CREATING, ACTIVE, DELETING),
        ACTIVE(ACTIVE, DELETING),
        DELETING(DELETING);

        private final Set<KVTableState> transitions;

        private StateTransitions(KVTableState ... states) {
            this.transitions = Sets.immutableEnumSet(Arrays.asList(states));
        }
    }
}

