/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.controller.server.SegmentHelper;
import io.pravega.controller.server.security.auth.GrpcAuthHelper;
import io.pravega.controller.store.client.StoreClient;
import io.pravega.controller.store.kvtable.InMemoryKVTMetadataStore;
import io.pravega.controller.store.kvtable.KVTableMetadataStore;
import io.pravega.controller.store.kvtable.PravegaTablesKVTMetadataStore;
import io.pravega.controller.store.kvtable.ZookeeperKVTMetadataStore;
import io.pravega.controller.store.stream.StreamMetadataStore;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.curator.framework.CuratorFramework;

public class KVTableStoreFactory {
    public static KVTableMetadataStore createStore(StoreClient storeClient, SegmentHelper segmentHelper, GrpcAuthHelper authHelper, ScheduledExecutorService executor, StreamMetadataStore streamStore) {
        switch (storeClient.getType()) {
            case PravegaTable: {
                return new PravegaTablesKVTMetadataStore(segmentHelper, (CuratorFramework)storeClient.getClient(), executor, authHelper);
            }
            case InMemory: {
                return new InMemoryKVTMetadataStore(streamStore);
            }
            case Zookeeper: {
                return new ZookeeperKVTMetadataStore((CuratorFramework)storeClient.getClient(), executor);
            }
        }
        throw new NotImplementedException(storeClient.getType().toString());
    }

    @VisibleForTesting
    public static KVTableMetadataStore createPravegaTablesStore(SegmentHelper segmentHelper, GrpcAuthHelper authHelper, CuratorFramework client, ScheduledExecutorService executor) {
        return new PravegaTablesKVTMetadataStore(segmentHelper, client, executor, authHelper);
    }

    @VisibleForTesting
    public static KVTableMetadataStore createZKStore(CuratorFramework client, ScheduledExecutorService executor) {
        return new ZookeeperKVTMetadataStore(client, executor);
    }

    @VisibleForTesting
    public static KVTableMetadataStore createInMemoryStore(StreamMetadataStore streamStore, ScheduledExecutorService executor) {
        return new InMemoryKVTMetadataStore(streamStore);
    }
}

