/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.server.SegmentHelper;
import io.pravega.controller.server.security.auth.GrpcAuthHelper;
import io.pravega.controller.store.PravegaTablesScope;
import io.pravega.controller.store.PravegaTablesStoreHelper;
import io.pravega.controller.store.index.ZKHostIndex;
import io.pravega.controller.store.kvtable.AbstractKVTableMetadataStore;
import io.pravega.controller.store.kvtable.PravegaTablesKVTable;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.shared.NameUtils;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.LoggerFactory;

public class PravegaTablesKVTMetadataStore
extends AbstractKVTableMetadataStore {
    static final String SCOPES_TABLE = NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{"scopes"});
    static final String DELETED_KVTABLES_TABLE = NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{"deletedKVTables"});
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(PravegaTablesKVTMetadataStore.class));
    @VisibleForTesting
    private final PravegaTablesStoreHelper storeHelper;
    private final ScheduledExecutorService executor;

    @VisibleForTesting
    PravegaTablesKVTMetadataStore(SegmentHelper segmentHelper, CuratorFramework curatorClient, ScheduledExecutorService executor, GrpcAuthHelper authHelper) {
        super(new ZKHostIndex(curatorClient, "/hostRequestIndex", executor));
        this.storeHelper = new PravegaTablesStoreHelper(segmentHelper, authHelper, executor);
        this.executor = executor;
    }

    @VisibleForTesting
    public PravegaTablesKVTMetadataStore(CuratorFramework curatorClient, ScheduledExecutorService executor, PravegaTablesStoreHelper storeHelper) {
        super(new ZKHostIndex(curatorClient, "/hostRequestIndex", executor));
        this.storeHelper = storeHelper;
        this.executor = executor;
    }

    @Override
    PravegaTablesKVTable newKeyValueTable(String scope, String name) {
        log.debug("Fetching KV Table from PravegaTables store {}/{}", (Object)scope, (Object)name);
        return new PravegaTablesKVTable(scope, name, this.storeHelper, (x, y) -> ((PravegaTablesScope)this.getScope(scope, (OperationContext)y)).getKVTablesInScopeTableName((OperationContext)y), this.executor);
    }

    @Override
    public CompletableFuture<Void> deleteFromScope(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(((PravegaTablesScope)this.getScope(scope, context)).removeKVTableFromScope(name, context), (Executor)executor);
    }

    @Override
    CompletableFuture<Void> recordLastKVTableSegment(String scope, String kvtable, int lastActiveSegment, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        String key = this.getScopedKVTName(scope, kvtable);
        return Futures.completeOn((CompletableFuture)this.storeHelper.createTable(DELETED_KVTABLES_TABLE, context.getRequestId()).thenCompose(created -> this.storeHelper.expectingDataNotFound(this.storeHelper.getCachedOrLoad(DELETED_KVTABLES_TABLE, key, PravegaTablesStoreHelper.BYTES_TO_INTEGER_FUNCTION, System.currentTimeMillis(), context.getRequestId()), null).thenCompose(existing -> {
            log.debug(context.getRequestId(), "Recording last segment {} for KeyValueTable {}/{} on deletion.", new Object[]{lastActiveSegment, scope, kvtable});
            if (existing != null) {
                int oldLastActiveSegment = (Integer)existing.getObject();
                Preconditions.checkArgument((lastActiveSegment >= oldLastActiveSegment ? 1 : 0) != 0, (String)"Old last active segment ({}) for {}/{} is higher than current one {}.", (Object)oldLastActiveSegment, (Object)scope, (Object)kvtable, (Object)lastActiveSegment);
                return Futures.toVoid(this.storeHelper.updateEntry(DELETED_KVTABLES_TABLE, key, lastActiveSegment, PravegaTablesStoreHelper.INTEGER_TO_BYTES_FUNCTION, existing.getVersion(), context.getRequestId()));
            }
            return Futures.toVoid(this.storeHelper.addNewEntryIfAbsent(DELETED_KVTABLES_TABLE, key, lastActiveSegment, PravegaTablesStoreHelper.INTEGER_TO_BYTES_FUNCTION, context.getRequestId()));
        })), (Executor)executor);
    }

    @Override
    public PravegaTablesScope newScope(String scopeName) {
        return new PravegaTablesScope(scopeName, this.storeHelper);
    }

    @Override
    public CompletableFuture<Boolean> checkScopeExists(String scope, OperationContext context, Executor executor) {
        long requestId = this.getOperationContext(context).getRequestId();
        return Futures.completeOn(this.storeHelper.expectingDataNotFound(this.storeHelper.getEntry(SCOPES_TABLE, scope, x -> x, requestId).thenApply(v -> true), false), (Executor)executor);
    }

    @Override
    public CompletableFuture<Boolean> checkTableExists(String scopeName, String kvt, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(((PravegaTablesScope)this.getScope(scopeName, context)).checkKeyValueTableExistsInScope(kvt, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> createEntryForKVTable(String scopeName, String kvtName, UUID id, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(((PravegaTablesScope)this.getScope(scopeName, context)).addKVTableToScope(kvtName, id, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Integer> getSafeStartingSegmentNumberFor(String scopeName, String kvtName, OperationContext context, Executor executor) {
        long requestId = this.getOperationContext(context).getRequestId();
        return Futures.completeOn((CompletableFuture)this.storeHelper.getEntry(DELETED_KVTABLES_TABLE, this.getScopedKVTName(scopeName, kvtName), PravegaTablesStoreHelper.BYTES_TO_INTEGER_FUNCTION, requestId).handle((data, ex) -> {
            if (ex == null) {
                return (Integer)data.getObject() + 1;
            }
            if (Exceptions.unwrap((Throwable)ex) instanceof StoreException.DataNotFoundException) {
                return 0;
            }
            log.error("Problem found while getting a safe starting segment number for {}.", (Object)this.getScopedKVTName(scopeName, kvtName), ex);
            throw new CompletionException((Throwable)ex);
        }), (Executor)executor);
    }

    @Override
    public void close() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    PravegaTablesStoreHelper getStoreHelper() {
        return this.storeHelper;
    }
}

