/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.store.PravegaTablesStoreHelper;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.kvtable.AbstractKVTableBase;
import io.pravega.controller.store.kvtable.CreateKVTableResponse;
import io.pravega.controller.store.kvtable.KVTableState;
import io.pravega.controller.store.kvtable.records.KVTConfigurationRecord;
import io.pravega.controller.store.kvtable.records.KVTEpochRecord;
import io.pravega.controller.store.kvtable.records.KVTStateRecord;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.shared.NameUtils;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PravegaTablesKVTable
extends AbstractKVTableBase {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PravegaTablesKVTable.class);
    public static final String PATH_SEPARATOR = ".#.";
    private static final String METADATA_TABLE = "metadata.#.%s";
    private static final String CREATION_TIME_KEY = "creationTime";
    private static final String CONFIGURATION_KEY = "configuration";
    private static final String STATE_KEY = "state";
    private static final String CURRENT_EPOCH_KEY = "currentEpochRecord";
    private static final String EPOCH_RECORD_KEY_FORMAT = "epochRecord-%d";
    private final PravegaTablesStoreHelper storeHelper;
    private final BiFunction<Boolean, OperationContext, CompletableFuture<String>> metadataTableNameSupplier;
    private final AtomicReference<String> idRef;

    @VisibleForTesting
    PravegaTablesKVTable(String scopeName, String kvtName, PravegaTablesStoreHelper storeHelper, BiFunction<Boolean, OperationContext, CompletableFuture<String>> tableName, ScheduledExecutorService executor) {
        super(scopeName, kvtName);
        this.storeHelper = storeHelper;
        this.metadataTableNameSupplier = tableName;
        this.idRef = new AtomicReference<Object>(null);
    }

    @Override
    public CompletableFuture<String> getId(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        String id = this.idRef.get();
        if (!Strings.isNullOrEmpty((String)id)) {
            return CompletableFuture.completedFuture(id);
        }
        return this.storeHelper.loadFromTableHandleStaleTableName(this.metadataTableNameSupplier, this.getName(), PravegaTablesStoreHelper.BYTES_TO_UUID_FUNCTION, context).thenComposeAsync(data -> {
            this.idRef.compareAndSet(null, ((UUID)data.getObject()).toString());
            return this.getId(context);
        });
    }

    @Override
    public void refresh() {
        this.idRef.set(null);
    }

    @Override
    public CompletableFuture<Long> getCreationTime(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return ((CompletableFuture)this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.getCachedOrLoad((String)metadataTable, CREATION_TIME_KEY, PravegaTablesStoreHelper.BYTES_TO_LONG_FUNCTION, context.getOperationStartTime(), context.getRequestId()))).thenApply(VersionedMetadata::getObject);
    }

    private CompletableFuture<String> getMetadataTable(OperationContext context) {
        return this.getId(context).thenApply(this::getMetadataTableName);
    }

    private String getMetadataTableName(String id) {
        return NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.getScopeName(), this.getName(), String.format(METADATA_TABLE, id)});
    }

    @Override
    public CompletableFuture<Void> createStateIfAbsent(KVTStateRecord state, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, STATE_KEY, state, KVTStateRecord::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<Version> setStateData(VersionedMetadata<KVTStateRecord> state, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, STATE_KEY, (KVTStateRecord)state.getObject(), KVTStateRecord::toBytes, state.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<KVTStateRecord>> getStateData(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            if (ignoreCached) {
                this.storeHelper.invalidateCache((String)metadataTable, STATE_KEY);
            }
            return this.storeHelper.getCachedOrLoad((String)metadataTable, STATE_KEY, KVTStateRecord::fromBytes, ignoreCached ? context.getOperationStartTime() : 0L, context.getRequestId());
        });
    }

    @Override
    CompletableFuture<VersionedMetadata<KVTConfigurationRecord>> getConfigurationData(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            if (ignoreCached) {
                this.storeHelper.invalidateCache((String)metadataTable, CONFIGURATION_KEY);
            }
            return this.storeHelper.getCachedOrLoad((String)metadataTable, CONFIGURATION_KEY, KVTConfigurationRecord::fromBytes, ignoreCached ? context.getOperationStartTime() : 0L, context.getRequestId());
        });
    }

    @Override
    public CompletableFuture<CreateKVTableResponse> checkKeyValueTableExists(KeyValueTableConfiguration configuration, long creationTime, int startingSegmentNumber, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.storeHelper.expectingDataNotFound(this.getCreationTime(context), null).thenCompose(storedCreationTime -> {
            if (storedCreationTime == null) {
                return CompletableFuture.completedFuture(new CreateKVTableResponse(CreateKVTableResponse.CreateStatus.NEW, configuration, creationTime, startingSegmentNumber));
            }
            return this.storeHelper.expectingDataNotFound(this.getConfiguration(context), null).thenCompose(config -> {
                if (config != null) {
                    return this.handleConfigExists((long)storedCreationTime, (KeyValueTableConfiguration)config, startingSegmentNumber, storedCreationTime == creationTime, context);
                }
                return CompletableFuture.completedFuture(new CreateKVTableResponse(CreateKVTableResponse.CreateStatus.NEW, configuration, (long)storedCreationTime, startingSegmentNumber));
            });
        });
    }

    private CompletableFuture<CreateKVTableResponse> handleConfigExists(long creationTime, KeyValueTableConfiguration config, int startingSegmentNumber, boolean creationTimeMatched, OperationContext context) {
        CreateKVTableResponse.CreateStatus status = creationTimeMatched ? CreateKVTableResponse.CreateStatus.NEW : CreateKVTableResponse.CreateStatus.EXISTS_CREATING;
        return this.storeHelper.expectingDataNotFound(this.getState(true, context), null).thenApply(state -> {
            if (state == null) {
                return new CreateKVTableResponse(status, config, creationTime, startingSegmentNumber);
            }
            if (state.equals((Object)KVTableState.UNKNOWN) || state.equals((Object)KVTableState.CREATING)) {
                return new CreateKVTableResponse(status, config, creationTime, startingSegmentNumber);
            }
            return new CreateKVTableResponse(CreateKVTableResponse.CreateStatus.EXISTS_ACTIVE, config, creationTime, startingSegmentNumber);
        });
    }

    @Override
    CompletableFuture<Void> createKVTableMetadata(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getId(context).thenCompose(id -> this.storeHelper.createTable(this.getMetadataTableName((String)id), context.getRequestId()));
    }

    @Override
    public CompletableFuture<Void> delete(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getId(context).thenCompose(id -> this.storeHelper.deleteTable(this.getMetadataTableName((String)id), false, context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> storeCreationTimeIfAbsent(long creationTime, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, CREATION_TIME_KEY, creationTime, PravegaTablesStoreHelper.LONG_TO_BYTES_FUNCTION, context.getRequestId())));
    }

    @Override
    public CompletableFuture<Void> createConfigurationIfAbsent(KVTConfigurationRecord configuration, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, CONFIGURATION_KEY, configuration, KVTConfigurationRecord::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<Void> createEpochRecordDataIfAbsent(int epoch, KVTEpochRecord data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        String key = String.format(EPOCH_RECORD_KEY_FORMAT, epoch);
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, key, data, KVTEpochRecord::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<Void> createCurrentEpochRecordDataIfAbsent(KVTEpochRecord data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, CURRENT_EPOCH_KEY, data.getEpoch(), PravegaTablesStoreHelper.INTEGER_TO_BYTES_FUNCTION, context.getRequestId())));
    }

    @Override
    CompletableFuture<VersionedMetadata<KVTEpochRecord>> getCurrentEpochRecordData(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            if (ignoreCached) {
                this.storeHelper.invalidateCache((String)metadataTable, CURRENT_EPOCH_KEY);
            }
            CompletableFuture<VersionedMetadata<Integer>> future = this.storeHelper.getCachedOrLoad((String)metadataTable, CURRENT_EPOCH_KEY, PravegaTablesStoreHelper.BYTES_TO_INTEGER_FUNCTION, ignoreCached ? context.getOperationStartTime() : 0L, context.getRequestId());
            return future.thenCompose(versionedEpochNumber -> this.getEpochRecord((Integer)versionedEpochNumber.getObject(), context).thenApply(epochRecord -> new VersionedMetadata<KVTEpochRecord>((KVTEpochRecord)epochRecord, versionedEpochNumber.getVersion())));
        });
    }

    @Override
    CompletableFuture<VersionedMetadata<KVTEpochRecord>> getEpochRecordData(int epoch, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            String key = String.format(EPOCH_RECORD_KEY_FORMAT, epoch);
            return this.storeHelper.getCachedOrLoad((String)metadataTable, key, KVTEpochRecord::fromBytes, context.getOperationStartTime(), context.getRequestId());
        });
    }
}

