/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.BitConverter;
import io.pravega.controller.store.ZKScope;
import io.pravega.controller.store.ZKStoreHelper;
import io.pravega.controller.store.index.ZKHostIndex;
import io.pravega.controller.store.kvtable.AbstractKVTableMetadataStore;
import io.pravega.controller.store.kvtable.CreateKVTableResponse;
import io.pravega.controller.store.kvtable.ZookeeperKVTable;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StoreException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperKVTMetadataStore
extends AbstractKVTableMetadataStore
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperKVTMetadataStore.class);
    @VisibleForTesting
    static final String SCOPE_ROOT_PATH = "/store";
    static final String DELETED_KVTABLES_PATH = "/lastActiveKVTableSegment/%s";
    @VisibleForTesting
    private ZKStoreHelper storeHelper;
    private final Executor executor;

    @VisibleForTesting
    public ZookeeperKVTMetadataStore(CuratorFramework client, Executor executor) {
        super(new ZKHostIndex(client, "/hostKVTRequestIndex", executor));
        this.storeHelper = new ZKStoreHelper(client, executor);
        this.executor = executor;
    }

    @Override
    ZookeeperKVTable newKeyValueTable(String scope, String name) {
        return new ZookeeperKVTable(scope, name, this.storeHelper, this.executor);
    }

    @Override
    public CompletableFuture<Boolean> checkScopeExists(String scope, OperationContext context, Executor executor) {
        String scopePath = ZKPaths.makePath((String)SCOPE_ROOT_PATH, (String)scope);
        return this.storeHelper.checkExists(scopePath);
    }

    @Override
    public CompletableFuture<Boolean> checkTableExists(String scopeName, String kvt, OperationContext context, Executor executor) {
        return Futures.completeOn(((ZKScope)this.getScope(scopeName, context)).checkKeyValueTableExistsInScope(kvt), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> createEntryForKVTable(String scopeName, String kvtName, UUID id, OperationContext context, Executor executor) {
        return Futures.completeOn((CompletableFuture)CompletableFuture.completedFuture((ZKScope)this.getScope(scopeName, context)).thenCompose(scope -> {
            scope.addKVTableToScope(kvtName, id);
            return CompletableFuture.completedFuture(null);
        }), (Executor)executor);
    }

    @Override
    public ZKScope newScope(String scopeName) {
        return new ZKScope(scopeName, this.storeHelper);
    }

    @Override
    public CompletableFuture<CreateKVTableResponse> createKeyValueTable(String scope, String name, KeyValueTableConfiguration configuration, long createTimestamp, OperationContext context, Executor executor) {
        return super.createKeyValueTable(scope, name, configuration, createTimestamp, context, executor);
    }

    @Override
    public CompletableFuture<Void> deleteFromScope(String scope, String name, OperationContext context, Executor executor) {
        return Futures.completeOn(((ZKScope)this.getScope(scope, context)).removeKVTableFromScope(name), (Executor)executor);
    }

    @Override
    CompletableFuture<Void> recordLastKVTableSegment(String scope, String kvtable, int lastActiveSegment, OperationContext context, Executor executor) {
        String deletePath = String.format(DELETED_KVTABLES_PATH, this.getScopedKVTName(scope, kvtable));
        byte[] maxSegmentNumberBytes = new byte[4];
        BitConverter.writeInt((byte[])maxSegmentNumberBytes, (int)0, (int)lastActiveSegment);
        return ((CompletableFuture)this.storeHelper.getData(deletePath, x -> BitConverter.readInt((byte[])x, (int)0)).exceptionally(e -> {
            if (e instanceof StoreException.DataNotFoundException) {
                return null;
            }
            throw new CompletionException((Throwable)e);
        })).thenCompose(data -> {
            log.debug("Recording last segment {} for stream {}/{} on deletion.", new Object[]{lastActiveSegment, scope, kvtable});
            if (data == null) {
                return Futures.toVoid(this.storeHelper.createZNodeIfNotExist(deletePath, maxSegmentNumberBytes));
            }
            int oldLastActiveSegment = (Integer)data.getObject();
            Preconditions.checkArgument((lastActiveSegment >= oldLastActiveSegment ? 1 : 0) != 0, (String)"Old last active segment ({}) for {}/{} is higher than current one {}.", (Object)oldLastActiveSegment, (Object)scope, (Object)kvtable, (Object)lastActiveSegment);
            return Futures.toVoid(this.storeHelper.setData(deletePath, maxSegmentNumberBytes, data.getVersion()));
        });
    }

    @Override
    public CompletableFuture<Integer> getSafeStartingSegmentNumberFor(String scopeName, String streamName, OperationContext operationContext, Executor executor) {
        return this.storeHelper.getData(String.format(DELETED_KVTABLES_PATH, this.getScopedKVTName(scopeName, streamName)), x -> BitConverter.readInt((byte[])x, (int)0)).handleAsync((data, ex) -> {
            if (ex == null) {
                return (Integer)data.getObject() + 1;
            }
            if (ex instanceof StoreException.DataNotFoundException) {
                return 0;
            }
            log.error("Problem found while getting a safe starting segment number for {}.", (Object)this.getScopedKVTName(scopeName, streamName), ex);
            throw new CompletionException((Throwable)ex);
        });
    }

    @VisibleForTesting
    public void setStoreHelperForTesting(ZKStoreHelper storeHelper) {
        this.storeHelper = storeHelper;
    }

    @Override
    public void close() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    ZKStoreHelper getStoreHelper() {
        return this.storeHelper;
    }
}

