/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.BitConverter;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.ZKScope;
import io.pravega.controller.store.ZKStoreHelper;
import io.pravega.controller.store.kvtable.AbstractKVTableBase;
import io.pravega.controller.store.kvtable.CreateKVTableResponse;
import io.pravega.controller.store.kvtable.KVTableState;
import io.pravega.controller.store.kvtable.records.KVTConfigurationRecord;
import io.pravega.controller.store.kvtable.records.KVTEpochRecord;
import io.pravega.controller.store.kvtable.records.KVTStateRecord;
import io.pravega.controller.store.stream.OperationContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZookeeperKVTable
extends AbstractKVTableBase {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperKVTable.class);
    private static final String SCOPE_PATH = "/store/%s";
    private static final String KVTABLE_PATH = "/store/%s/kvt/%s";
    private static final String CREATION_TIME_PATH = "/store/%s/kvt/%s/creationTime";
    private static final String CONFIGURATION_PATH = "/store/%s/kvt/%s/configuration";
    private static final String STATE_PATH = "/store/%s/kvt/%s/state";
    private static final String CURRENT_EPOCH_RECORD = "/store/%s/kvt/%s/currentEpochRecord";
    private static final String EPOCH_RECORD = "/store/%s/kvt/%s/epochRecords";
    private static final String ID_PATH = "/store/%s/kvt/%s/id";
    private final ZKStoreHelper zkStoreHelper;
    @VisibleForTesting
    private final String creationPath;
    private final String configurationPath;
    private final String statePath;
    private final String idPath;
    private final String kvtablePath;
    private final String currentEpochRecordPath;
    private final String epochRecordPathFormat;
    private final Executor executor;
    private final AtomicReference<String> idRef;

    @VisibleForTesting
    ZookeeperKVTable(String scopeName, String kvtName, ZKStoreHelper storeHelper, Executor executor) {
        super(scopeName, kvtName);
        this.zkStoreHelper = storeHelper;
        this.kvtablePath = String.format(KVTABLE_PATH, scopeName, kvtName);
        this.creationPath = String.format(CREATION_TIME_PATH, scopeName, kvtName);
        this.configurationPath = String.format(CONFIGURATION_PATH, scopeName, kvtName);
        this.statePath = String.format(STATE_PATH, scopeName, kvtName);
        this.idPath = String.format(ID_PATH, scopeName, kvtName);
        this.currentEpochRecordPath = String.format(CURRENT_EPOCH_RECORD, scopeName, kvtName);
        this.epochRecordPathFormat = String.format(EPOCH_RECORD, scopeName, kvtName) + "/%d";
        this.idRef = new AtomicReference();
        this.executor = executor;
    }

    @Override
    public CompletableFuture<CreateKVTableResponse> checkKeyValueTableExists(KeyValueTableConfiguration configuration, long creationTime, int startingSegmentNumber, OperationContext context) {
        return this.zkStoreHelper.checkExists(this.creationPath).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(new CreateKVTableResponse(CreateKVTableResponse.CreateStatus.NEW, configuration, creationTime, startingSegmentNumber));
            }
            return this.getCreationTime(context).thenCompose(storedCreationTime -> this.zkStoreHelper.checkExists(this.configurationPath).thenCompose(configExists -> {
                if (configExists.booleanValue()) {
                    return this.handleConfigExists((long)storedCreationTime, startingSegmentNumber, storedCreationTime == creationTime, context);
                }
                return CompletableFuture.completedFuture(new CreateKVTableResponse(CreateKVTableResponse.CreateStatus.NEW, configuration, (long)storedCreationTime, startingSegmentNumber));
            }));
        });
    }

    @Override
    CompletableFuture<Void> createKVTableMetadata(OperationContext context) {
        return Futures.toVoid(this.zkStoreHelper.createZNodeIfNotExist(this.getKvtablePath()));
    }

    private CompletableFuture<CreateKVTableResponse> handleConfigExists(long creationTime, int startingSegmentNumber, boolean creationTimeMatched, OperationContext context) {
        CreateKVTableResponse.CreateStatus status = creationTimeMatched ? CreateKVTableResponse.CreateStatus.NEW : CreateKVTableResponse.CreateStatus.EXISTS_CREATING;
        return this.getConfiguration(context).thenCompose(config -> this.zkStoreHelper.checkExists(this.statePath).thenCompose(stateExists -> {
            if (!stateExists.booleanValue()) {
                return CompletableFuture.completedFuture(new CreateKVTableResponse(status, (KeyValueTableConfiguration)config, creationTime, startingSegmentNumber));
            }
            return this.getState(false, context).thenApply(state -> {
                if (state.equals((Object)KVTableState.UNKNOWN) || state.equals((Object)KVTableState.CREATING)) {
                    return new CreateKVTableResponse(status, (KeyValueTableConfiguration)config, creationTime, startingSegmentNumber);
                }
                return new CreateKVTableResponse(CreateKVTableResponse.CreateStatus.EXISTS_ACTIVE, (KeyValueTableConfiguration)config, creationTime, startingSegmentNumber);
            });
        }));
    }

    @Override
    public CompletableFuture<Long> getCreationTime(OperationContext context) {
        return this.getId(context).thenCompose(id -> this.zkStoreHelper.getCachedData(this.creationPath, (String)id, x -> BitConverter.readLong((byte[])x, (int)0)).thenApply(VersionedMetadata::getObject));
    }

    @Override
    CompletableFuture<VersionedMetadata<KVTEpochRecord>> getCurrentEpochRecordData(boolean ignoreCached, OperationContext context) {
        return this.getId(context).thenCompose(id -> {
            CompletableFuture<VersionedMetadata<Integer>> future = ignoreCached ? this.zkStoreHelper.getData(this.currentEpochRecordPath, x -> BitConverter.readInt((byte[])x, (int)0)) : this.zkStoreHelper.getCachedData(this.currentEpochRecordPath, (String)id, x -> BitConverter.readInt((byte[])x, (int)0));
            return future.thenCompose(versionedEpochNumber -> this.getEpochRecord((Integer)versionedEpochNumber.getObject(), context).thenApply(epochRecord -> new VersionedMetadata<KVTEpochRecord>((KVTEpochRecord)epochRecord, versionedEpochNumber.getVersion())));
        });
    }

    @Override
    CompletableFuture<VersionedMetadata<KVTEpochRecord>> getEpochRecordData(int epoch, OperationContext context) {
        String path = String.format(this.epochRecordPathFormat, epoch);
        return this.getId(context).thenCompose(id -> this.zkStoreHelper.getCachedData(path, (String)id, KVTEpochRecord::fromBytes));
    }

    @Override
    CompletableFuture<Void> storeCreationTimeIfAbsent(long creationTime, OperationContext context) {
        byte[] b = new byte[8];
        BitConverter.writeLong((byte[])b, (int)0, (long)creationTime);
        return Futures.toVoid(this.zkStoreHelper.createZNodeIfNotExist(this.creationPath, b));
    }

    @Override
    CompletableFuture<VersionedMetadata<KVTConfigurationRecord>> getConfigurationData(boolean ignoreCached, OperationContext context) {
        return this.getId(context).thenCompose(id -> {
            if (ignoreCached) {
                return this.zkStoreHelper.getData(this.configurationPath, KVTConfigurationRecord::fromBytes);
            }
            return this.zkStoreHelper.getCachedData(this.configurationPath, (String)id, KVTConfigurationRecord::fromBytes);
        });
    }

    @Override
    CompletableFuture<Void> createConfigurationIfAbsent(KVTConfigurationRecord configuration, OperationContext context) {
        return Futures.toVoid(this.zkStoreHelper.createZNodeIfNotExist(this.configurationPath, configuration.toBytes()));
    }

    @Override
    CompletableFuture<Void> createCurrentEpochRecordDataIfAbsent(KVTEpochRecord data, OperationContext context) {
        byte[] epochData = new byte[4];
        BitConverter.writeInt((byte[])epochData, (int)0, (int)data.getEpoch());
        return Futures.toVoid(this.zkStoreHelper.createZNodeIfNotExist(this.currentEpochRecordPath, epochData));
    }

    @Override
    CompletableFuture<Void> createEpochRecordDataIfAbsent(int epoch, KVTEpochRecord data, OperationContext context) {
        String path = String.format(this.epochRecordPathFormat, epoch);
        return Futures.toVoid(this.zkStoreHelper.createZNodeIfNotExist(path, data.toBytes()));
    }

    @Override
    CompletableFuture<Version> setStateData(VersionedMetadata<KVTStateRecord> state, OperationContext context) {
        return this.getId(context).thenCompose(id -> this.zkStoreHelper.setData(this.statePath, ((KVTStateRecord)state.getObject()).toBytes(), state.getVersion()).thenApply(r -> {
            this.zkStoreHelper.invalidateCache(this.statePath, (String)id);
            return new Version.IntVersion((int)r);
        }));
    }

    @Override
    CompletableFuture<VersionedMetadata<KVTStateRecord>> getStateData(boolean ignoreCached, OperationContext context) {
        return this.getId(context).thenCompose(id -> {
            if (ignoreCached) {
                return this.zkStoreHelper.getData(this.statePath, KVTStateRecord::fromBytes);
            }
            return this.zkStoreHelper.getCachedData(this.statePath, (String)id, KVTStateRecord::fromBytes);
        });
    }

    @Override
    public void refresh() {
        String id = this.idRef.getAndSet(null);
        id = id == null ? "" : id;
        this.zkStoreHelper.invalidateCache(this.statePath, id);
        this.zkStoreHelper.invalidateCache(this.configurationPath, id);
        this.zkStoreHelper.invalidateCache(this.currentEpochRecordPath, id);
    }

    @Override
    public CompletableFuture<String> getId(OperationContext context) {
        String id = this.idRef.get();
        if (!Strings.isNullOrEmpty((String)id)) {
            return CompletableFuture.completedFuture(id);
        }
        return ZKScope.getKVTableInScopeZNodePath(this.scopeName, this.name).thenCompose(path -> this.zkStoreHelper.getData((String)path, x -> BitConverter.readUUID((byte[])x, (int)0)).thenApply(uuid -> {
            String s = uuid.toString();
            this.idRef.compareAndSet(null, s);
            return s;
        }));
    }

    @Override
    public CompletableFuture<Void> delete(OperationContext context) {
        return this.zkStoreHelper.deleteTree(this.kvtablePath);
    }

    @Override
    CompletableFuture<Void> createStateIfAbsent(KVTStateRecord state, OperationContext context) {
        return Futures.toVoid(this.zkStoreHelper.createZNodeIfNotExist(this.statePath, state.toBytes()));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    String getCreationPath() {
        return this.creationPath;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    String getKvtablePath() {
        return this.kvtablePath;
    }
}

