/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable.records;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVTConfigurationRecord {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KVTConfigurationRecord.class);
    public static final ConfigurationRecordSerializer SERIALIZER = new ConfigurationRecordSerializer();
    @NonNull
    private final String scope;
    @NonNull
    private final String kvtName;
    private final KeyValueTableConfiguration kvtConfiguration;

    public static KVTConfigurationRecord fromBytes(byte[] data) {
        return (KVTConfigurationRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static KVTConfigurationRecordBuilder builder() {
        return new KVTConfigurationRecordBuilder();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKvtName() {
        return this.kvtName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyValueTableConfiguration getKvtConfiguration() {
        return this.kvtConfiguration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KVTConfigurationRecord)) {
            return false;
        }
        KVTConfigurationRecord other = (KVTConfigurationRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$kvtName = this.getKvtName();
        String other$kvtName = other.getKvtName();
        if (this$kvtName == null ? other$kvtName != null : !this$kvtName.equals(other$kvtName)) {
            return false;
        }
        KeyValueTableConfiguration this$kvtConfiguration = this.getKvtConfiguration();
        KeyValueTableConfiguration other$kvtConfiguration = other.getKvtConfiguration();
        return !(this$kvtConfiguration == null ? other$kvtConfiguration != null : !this$kvtConfiguration.equals(other$kvtConfiguration));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KVTConfigurationRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $kvtName = this.getKvtName();
        result = result * 59 + ($kvtName == null ? 43 : $kvtName.hashCode());
        KeyValueTableConfiguration $kvtConfiguration = this.getKvtConfiguration();
        result = result * 59 + ($kvtConfiguration == null ? 43 : $kvtConfiguration.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "KVTConfigurationRecord(scope=" + this.getScope() + ", kvtName=" + this.getKvtName() + ", kvtConfiguration=" + this.getKvtConfiguration() + ")";
    }

    @ConstructorProperties(value={"scope", "kvtName", "kvtConfiguration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KVTConfigurationRecord(@NonNull String scope, @NonNull String kvtName, KeyValueTableConfiguration kvtConfiguration) {
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        if (kvtName == null) {
            throw new NullPointerException("kvtName is marked non-null but is null");
        }
        this.scope = scope;
        this.kvtName = kvtName;
        this.kvtConfiguration = kvtConfiguration;
    }

    private static class ConfigurationRecordSerializer
    extends VersionedSerializer.WithBuilder<KVTConfigurationRecord, KVTConfigurationRecordBuilder> {
        private ConfigurationRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        protected void beforeSerialization(KVTConfigurationRecord kvtConfigurationRecord) {
            Preconditions.checkNotNull((Object)kvtConfigurationRecord);
            Preconditions.checkNotNull((Object)kvtConfigurationRecord.getKvtConfiguration());
        }

        private void read00(RevisionDataInput revisionDataInput, KVTConfigurationRecordBuilder configurationRecordBuilder) throws IOException {
            configurationRecordBuilder.scope(revisionDataInput.readUTF()).kvtName(revisionDataInput.readUTF());
            KeyValueTableConfiguration config = KeyValueTableConfiguration.builder().partitionCount(revisionDataInput.readInt()).primaryKeyLength(revisionDataInput.readInt()).secondaryKeyLength(revisionDataInput.readInt()).build();
            configurationRecordBuilder.kvtConfiguration(config);
        }

        private void write00(KVTConfigurationRecord kvtConfigurationRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeUTF(kvtConfigurationRecord.getScope());
            revisionDataOutput.writeUTF(kvtConfigurationRecord.getKvtName());
            revisionDataOutput.writeInt(kvtConfigurationRecord.getKvtConfiguration().getPartitionCount());
            revisionDataOutput.writeInt(kvtConfigurationRecord.getKvtConfiguration().getPrimaryKeyLength());
            revisionDataOutput.writeInt(kvtConfigurationRecord.getKvtConfiguration().getSecondaryKeyLength());
        }

        protected KVTConfigurationRecordBuilder newBuilder() {
            return KVTConfigurationRecord.builder();
        }
    }

    public static class KVTConfigurationRecordBuilder
    implements ObjectBuilder<KVTConfigurationRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String kvtName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyValueTableConfiguration kvtConfiguration;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        KVTConfigurationRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTConfigurationRecordBuilder scope(@NonNull String scope) {
            if (scope == null) {
                throw new NullPointerException("scope is marked non-null but is null");
            }
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTConfigurationRecordBuilder kvtName(@NonNull String kvtName) {
            if (kvtName == null) {
                throw new NullPointerException("kvtName is marked non-null but is null");
            }
            this.kvtName = kvtName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTConfigurationRecordBuilder kvtConfiguration(KeyValueTableConfiguration kvtConfiguration) {
            this.kvtConfiguration = kvtConfiguration;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTConfigurationRecord build() {
            return new KVTConfigurationRecord(this.scope, this.kvtName, this.kvtConfiguration);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "KVTConfigurationRecord.KVTConfigurationRecordBuilder(scope=" + this.scope + ", kvtName=" + this.kvtName + ", kvtConfiguration=" + this.kvtConfiguration + ")";
        }
    }
}

