/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable.records;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.controller.store.kvtable.records.KVTSegmentRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class KVTEpochRecord {
    public static final EpochRecordSerializer SERIALIZER = new EpochRecordSerializer();
    private final int epoch;
    private final ImmutableList<KVTSegmentRecord> segments;
    private final long creationTime;
    private final Map<Long, KVTSegmentRecord> segmentMap;

    public KVTEpochRecord(int epoch, @NonNull ImmutableList<KVTSegmentRecord> segments, long creationTime) {
        if (segments == null) {
            throw new NullPointerException("segments is marked non-null but is null");
        }
        this.epoch = epoch;
        this.segments = segments;
        this.creationTime = creationTime;
        this.segmentMap = segments.stream().collect(Collectors.toMap(KVTSegmentRecord::segmentId, x -> x));
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    public static KVTEpochRecord fromBytes(byte[] record) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(record, 0, record.length);
        return (KVTEpochRecord)SERIALIZER.deserialize(inputStream);
    }

    public Set<Long> getSegmentIds() {
        return this.segmentMap.keySet();
    }

    public KVTSegmentRecord getSegment(long segmentId) {
        return this.segmentMap.get(segmentId);
    }

    public boolean containsSegment(long segmentId) {
        return this.segmentMap.containsKey(segmentId);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static KVTEpochRecordBuilder builder() {
        return new KVTEpochRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEpoch() {
        return this.epoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableList<KVTSegmentRecord> getSegments() {
        return this.segments;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getCreationTime() {
        return this.creationTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KVTEpochRecord)) {
            return false;
        }
        KVTEpochRecord other = (KVTEpochRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        ImmutableList<KVTSegmentRecord> this$segments = this.getSegments();
        ImmutableList<KVTSegmentRecord> other$segments = other.getSegments();
        if (this$segments == null ? other$segments != null : !this$segments.equals(other$segments)) {
            return false;
        }
        if (this.getCreationTime() != other.getCreationTime()) {
            return false;
        }
        Map<Long, KVTSegmentRecord> this$segmentMap = this.getSegmentMap();
        Map<Long, KVTSegmentRecord> other$segmentMap = other.getSegmentMap();
        return !(this$segmentMap == null ? other$segmentMap != null : !((Object)this$segmentMap).equals(other$segmentMap));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KVTEpochRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEpoch();
        ImmutableList<KVTSegmentRecord> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : $segments.hashCode());
        long $creationTime = this.getCreationTime();
        result = result * 59 + (int)($creationTime >>> 32 ^ $creationTime);
        Map<Long, KVTSegmentRecord> $segmentMap = this.getSegmentMap();
        result = result * 59 + ($segmentMap == null ? 43 : ((Object)$segmentMap).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "KVTEpochRecord(epoch=" + this.getEpoch() + ", segments=" + this.getSegments() + ", creationTime=" + this.getCreationTime() + ", segmentMap=" + this.getSegmentMap() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Map<Long, KVTSegmentRecord> getSegmentMap() {
        return this.segmentMap;
    }

    private static class EpochRecordSerializer
    extends VersionedSerializer.WithBuilder<KVTEpochRecord, KVTEpochRecordBuilder> {
        private EpochRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, KVTEpochRecordBuilder builder) throws IOException {
            builder.epoch(revisionDataInput.readInt());
            ImmutableList.Builder segmentsBuilder = ImmutableList.builder();
            revisionDataInput.readCollection(arg_0 -> ((KVTSegmentRecord.KVTSegmentRecordSerializer)KVTSegmentRecord.SERIALIZER).deserialize(arg_0), (ImmutableCollection.Builder)segmentsBuilder);
            builder.segments((ImmutableList<KVTSegmentRecord>)segmentsBuilder.build()).creationTime(revisionDataInput.readLong());
        }

        private void write00(KVTEpochRecord history, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeInt(history.getEpoch());
            revisionDataOutput.writeCollection(history.getSegments(), (arg_0, arg_1) -> ((KVTSegmentRecord.KVTSegmentRecordSerializer)KVTSegmentRecord.SERIALIZER).serialize(arg_0, arg_1));
            revisionDataOutput.writeLong(history.getCreationTime());
        }

        protected KVTEpochRecordBuilder newBuilder() {
            return KVTEpochRecord.builder();
        }
    }

    private static class KVTEpochRecordBuilder
    implements ObjectBuilder<KVTEpochRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int epoch;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableList<KVTSegmentRecord> segments;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long creationTime;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        KVTEpochRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTEpochRecordBuilder epoch(int epoch) {
            this.epoch = epoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTEpochRecordBuilder segments(@NonNull ImmutableList<KVTSegmentRecord> segments) {
            if (segments == null) {
                throw new NullPointerException("segments is marked non-null but is null");
            }
            this.segments = segments;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTEpochRecordBuilder creationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTEpochRecord build() {
            return new KVTEpochRecord(this.epoch, this.segments, this.creationTime);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "KVTEpochRecord.KVTEpochRecordBuilder(epoch=" + this.epoch + ", segments=" + this.segments + ", creationTime=" + this.creationTime + ")";
        }
    }
}

