/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.kvtable.records;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.controller.store.SegmentRecord;
import io.pravega.shared.NameUtils;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;

public class KVTSegmentRecord
implements SegmentRecord {
    public static final KVTSegmentRecordSerializer SERIALIZER = new KVTSegmentRecordSerializer();
    private final int segmentNumber;
    private final int creationEpoch;
    private final long creationTime;
    private final double keyStart;
    private final double keyEnd;

    @Override
    public long segmentId() {
        return NameUtils.computeSegmentId((int)this.segmentNumber, (int)this.creationEpoch);
    }

    @VisibleForTesting
    public static KVTSegmentRecord newSegmentRecord(int num, int epoch, long time, double start, double end) {
        return KVTSegmentRecord.builder().segmentNumber(num).creationEpoch(epoch).creationTime(time).keyStart(start).keyEnd(end).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static KVTSegmentRecordBuilder builder() {
        return new KVTSegmentRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getCreationEpoch() {
        return this.creationEpoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getKeyStart() {
        return this.keyStart;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getKeyEnd() {
        return this.keyEnd;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KVTSegmentRecord)) {
            return false;
        }
        KVTSegmentRecord other = (KVTSegmentRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSegmentNumber() != other.getSegmentNumber()) {
            return false;
        }
        if (this.getCreationEpoch() != other.getCreationEpoch()) {
            return false;
        }
        if (this.getCreationTime() != other.getCreationTime()) {
            return false;
        }
        if (Double.compare(this.getKeyStart(), other.getKeyStart()) != 0) {
            return false;
        }
        return Double.compare(this.getKeyEnd(), other.getKeyEnd()) == 0;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KVTSegmentRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSegmentNumber();
        result = result * 59 + this.getCreationEpoch();
        long $creationTime = this.getCreationTime();
        result = result * 59 + (int)($creationTime >>> 32 ^ $creationTime);
        long $keyStart = Double.doubleToLongBits(this.getKeyStart());
        result = result * 59 + (int)($keyStart >>> 32 ^ $keyStart);
        long $keyEnd = Double.doubleToLongBits(this.getKeyEnd());
        result = result * 59 + (int)($keyEnd >>> 32 ^ $keyEnd);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "KVTSegmentRecord(segmentNumber=" + this.getSegmentNumber() + ", creationEpoch=" + this.getCreationEpoch() + ", creationTime=" + this.getCreationTime() + ", keyStart=" + this.getKeyStart() + ", keyEnd=" + this.getKeyEnd() + ")";
    }

    @ConstructorProperties(value={"segmentNumber", "creationEpoch", "creationTime", "keyStart", "keyEnd"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KVTSegmentRecord(int segmentNumber, int creationEpoch, long creationTime, double keyStart, double keyEnd) {
        this.segmentNumber = segmentNumber;
        this.creationEpoch = creationEpoch;
        this.creationTime = creationTime;
        this.keyStart = keyStart;
        this.keyEnd = keyEnd;
    }

    static class KVTSegmentRecordSerializer
    extends VersionedSerializer.WithBuilder<KVTSegmentRecord, KVTSegmentRecordBuilder> {
        KVTSegmentRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, KVTSegmentRecordBuilder builder) throws IOException {
            builder.segmentNumber(revisionDataInput.readInt()).creationTime(revisionDataInput.readLong()).creationEpoch(revisionDataInput.readInt()).keyStart(Double.longBitsToDouble(revisionDataInput.readLong())).keyEnd(Double.longBitsToDouble(revisionDataInput.readLong()));
        }

        private void write00(KVTSegmentRecord segment, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeInt(segment.getSegmentNumber());
            revisionDataOutput.writeLong(segment.getCreationTime());
            revisionDataOutput.writeInt(segment.getCreationEpoch());
            revisionDataOutput.writeLong(Double.doubleToRawLongBits(segment.getKeyStart()));
            revisionDataOutput.writeLong(Double.doubleToRawLongBits(segment.getKeyEnd()));
        }

        protected KVTSegmentRecordBuilder newBuilder() {
            return KVTSegmentRecord.builder();
        }
    }

    public static class KVTSegmentRecordBuilder
    implements ObjectBuilder<KVTSegmentRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int segmentNumber;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int creationEpoch;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long creationTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private double keyStart;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private double keyEnd;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        KVTSegmentRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTSegmentRecordBuilder segmentNumber(int segmentNumber) {
            this.segmentNumber = segmentNumber;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTSegmentRecordBuilder creationEpoch(int creationEpoch) {
            this.creationEpoch = creationEpoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTSegmentRecordBuilder creationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTSegmentRecordBuilder keyStart(double keyStart) {
            this.keyStart = keyStart;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTSegmentRecordBuilder keyEnd(double keyEnd) {
            this.keyEnd = keyEnd;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KVTSegmentRecord build() {
            return new KVTSegmentRecord(this.segmentNumber, this.creationEpoch, this.creationTime, this.keyStart, this.keyEnd);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "KVTSegmentRecord.KVTSegmentRecordBuilder(segmentNumber=" + this.segmentNumber + ", creationEpoch=" + this.creationEpoch + ", creationTime=" + this.creationTime + ", keyStart=" + this.keyStart + ", keyEnd=" + this.keyEnd + ")";
        }
    }
}

