/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ReaderGroup;
import io.pravega.controller.store.stream.ReaderGroupState;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.records.ReaderGroupConfigRecord;
import io.pravega.controller.store.stream.records.ReaderGroupStateRecord;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReaderGroup
implements ReaderGroup {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractReaderGroup.class);
    private final String scope;
    private final String name;

    AbstractReaderGroup(String scopeName, String rgName) {
        this.scope = scopeName;
        this.name = rgName;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CompletableFuture<Void> create(ReaderGroupConfig configuration, long createTimestamp, OperationContext context) {
        return ((CompletableFuture)((CompletableFuture)this.createMetadataTables(context).thenCompose(v -> this.storeCreationTimeIfAbsent(createTimestamp, context))).thenCompose(v -> this.createConfigurationIfAbsent(configuration, context))).thenCompose(v -> this.createStateIfAbsent(context));
    }

    @Override
    public CompletableFuture<Void> startUpdateConfiguration(ReaderGroupConfig configuration, OperationContext context) {
        return this.getVersionedConfigurationRecord(context).thenCompose(configRecord -> {
            Preconditions.checkArgument((!((ReaderGroupConfigRecord)configRecord.getObject()).isUpdating() ? 1 : 0) != 0);
            Preconditions.checkArgument((((ReaderGroupConfigRecord)configRecord.getObject()).getGeneration() == configuration.getGeneration() ? 1 : 0) != 0);
            ReaderGroupConfigRecord update = ReaderGroupConfigRecord.update(configuration, configuration.getGeneration() + 1L, true);
            return Futures.toVoid(this.setConfigurationData(new VersionedMetadata<ReaderGroupConfigRecord>(update, configRecord.getVersion()), context));
        });
    }

    @Override
    public CompletableFuture<Void> completeUpdateConfiguration(VersionedMetadata<ReaderGroupConfigRecord> existing, OperationContext context) {
        Preconditions.checkNotNull((Object)existing.getObject());
        if (existing.getObject().isUpdating()) {
            ReaderGroupConfigRecord updatedRecord = ReaderGroupConfigRecord.complete(existing.getObject());
            return Futures.toVoid(this.setConfigurationData(new VersionedMetadata<ReaderGroupConfigRecord>(updatedRecord, existing.getVersion()), context));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<VersionedMetadata<ReaderGroupConfigRecord>> getVersionedConfigurationRecord(OperationContext context) {
        return this.getConfigurationData(true, context);
    }

    @Override
    public CompletableFuture<VersionedMetadata<ReaderGroupState>> getVersionedState(OperationContext context) {
        return this.getStateData(true, context).thenApply(x -> new VersionedMetadata<ReaderGroupState>(((ReaderGroupStateRecord)x.getObject()).getState(), x.getVersion()));
    }

    @Override
    public CompletableFuture<VersionedMetadata<ReaderGroupState>> updateVersionedState(VersionedMetadata<ReaderGroupState> previousState, ReaderGroupState newState, OperationContext context) {
        if (ReaderGroupState.isTransitionAllowed(previousState.getObject(), newState)) {
            return this.setStateData(new VersionedMetadata<ReaderGroupStateRecord>(ReaderGroupStateRecord.builder().state(newState).build(), previousState.getVersion()), context).thenApply(updatedVersion -> new VersionedMetadata<ReaderGroupState>(newState, (Version)updatedVersion));
        }
        return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.OPERATION_NOT_ALLOWED, "ReaderGroup: " + this.getName() + " State: " + newState.name() + " current state = " + (Object)((Object)previousState.getObject())));
    }

    @Override
    public CompletableFuture<ReaderGroupState> getState(boolean ignoreCached, OperationContext context) {
        return this.getStateData(ignoreCached, context).thenApply(x -> ((ReaderGroupStateRecord)x.getObject()).getState());
    }

    abstract CompletableFuture<Void> createMetadataTables(OperationContext var1);

    abstract CompletableFuture<Void> storeCreationTimeIfAbsent(long var1, OperationContext var3);

    abstract CompletableFuture<Void> createConfigurationIfAbsent(ReaderGroupConfig var1, OperationContext var2);

    abstract CompletableFuture<Void> createStateIfAbsent(OperationContext var1);

    abstract CompletableFuture<Version> setStateData(VersionedMetadata<ReaderGroupStateRecord> var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<ReaderGroupConfigRecord>> getConfigurationData(boolean var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<ReaderGroupStateRecord>> getStateData(boolean var1, OperationContext var2);

    abstract CompletableFuture<Version> setConfigurationData(VersionedMetadata<ReaderGroupConfigRecord> var1, OperationContext var2);
}

