/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.hash.RandomFactory;
import io.pravega.common.lang.Int96;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.metrics.StreamMetrics;
import io.pravega.controller.metrics.TransactionMetrics;
import io.pravega.controller.store.Scope;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.index.HostIndex;
import io.pravega.controller.store.stream.CreateStreamResponse;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.PersistentStreamBase;
import io.pravega.controller.store.stream.RGOperationContext;
import io.pravega.controller.store.stream.ReaderGroup;
import io.pravega.controller.store.stream.ReaderGroupState;
import io.pravega.controller.store.stream.ScaleMetadata;
import io.pravega.controller.store.stream.ScopeOperationContext;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.Stream;
import io.pravega.controller.store.stream.StreamCutComparison;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.StreamOperationContext;
import io.pravega.controller.store.stream.TxnStatus;
import io.pravega.controller.store.stream.TxnWriterMark;
import io.pravega.controller.store.stream.VersionedTransactionData;
import io.pravega.controller.store.stream.WriterTimestampResponse;
import io.pravega.controller.store.stream.records.ActiveTxnRecord;
import io.pravega.controller.store.stream.records.CommittingTransactionsRecord;
import io.pravega.controller.store.stream.records.EpochRecord;
import io.pravega.controller.store.stream.records.EpochTransitionRecord;
import io.pravega.controller.store.stream.records.HistoryTimeSeries;
import io.pravega.controller.store.stream.records.ReaderGroupConfigRecord;
import io.pravega.controller.store.stream.records.RetentionSet;
import io.pravega.controller.store.stream.records.SealedSegmentsMapShard;
import io.pravega.controller.store.stream.records.StreamConfigurationRecord;
import io.pravega.controller.store.stream.records.StreamCutRecord;
import io.pravega.controller.store.stream.records.StreamCutReferenceRecord;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.controller.store.stream.records.StreamSubscriber;
import io.pravega.controller.store.stream.records.StreamTruncationRecord;
import io.pravega.controller.store.stream.records.WriterMark;
import io.pravega.controller.store.task.TxnResource;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.ControllerEventSerializer;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamMetadataStore
implements StreamMetadataStore {
    public static final Predicate<Throwable> DATA_NOT_FOUND_PREDICATE = e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException;
    public static final Predicate<Throwable> DATA_NOT_EMPTY_PREDICATE = e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotEmptyException;
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(AbstractStreamMetadataStore.class));
    private static final String RESOURCE_PART_SEPARATOR = "_%_";
    private final LoadingCache<String, Scope> scopeCache;
    private final LoadingCache<Pair<String, String>, Stream> cache;
    private final LoadingCache<Pair<String, String>, ReaderGroup> rgCache;
    private final HostIndex hostTxnIndex;
    private final HostIndex hostTaskIndex;
    private final ControllerEventSerializer controllerEventSerializer = new ControllerEventSerializer();
    private final Random requestIdGenerator = new Random();

    protected AbstractStreamMetadataStore(HostIndex hostTxnIndex, HostIndex hostTaskIndex) {
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).refreshAfterWrite(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Pair<String, String>, Stream>(){

            @ParametersAreNonnullByDefault
            public Stream load(Pair<String, String> input) {
                try {
                    return AbstractStreamMetadataStore.this.newStream((String)input.getKey(), (String)input.getValue());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.rgCache = CacheBuilder.newBuilder().maximumSize(10000L).refreshAfterWrite(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Pair<String, String>, ReaderGroup>(){

            @ParametersAreNonnullByDefault
            public ReaderGroup load(Pair<String, String> input) {
                try {
                    return AbstractStreamMetadataStore.this.newReaderGroup((String)input.getKey(), (String)input.getValue());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.scopeCache = CacheBuilder.newBuilder().maximumSize(1000L).refreshAfterWrite(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Scope>(){

            @ParametersAreNonnullByDefault
            public Scope load(String scopeName) {
                try {
                    return AbstractStreamMetadataStore.this.newScope(scopeName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.hostTxnIndex = hostTxnIndex;
        this.hostTaskIndex = hostTaskIndex;
    }

    abstract Scope newScope(String var1);

    @Override
    public OperationContext createScopeContext(String scopeName, long requestId) {
        Scope scope = this.getScope(scopeName, null);
        return new ScopeOperationContext(scope, requestId);
    }

    @Override
    public OperationContext createStreamContext(String scopeName, String streamName, long requestId) {
        Scope scope = this.getScope(scopeName, null);
        Stream stream = this.getStream(scopeName, streamName, null);
        return new StreamOperationContext(scope, stream, requestId);
    }

    @Override
    public CompletableFuture<CreateStreamResponse> createStream(String scope, String name, StreamConfiguration configuration, long createTimestamp, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return this.getSafeStartingSegmentNumberFor(scope, name, context, executor).thenCompose(startingSegmentNumber -> Futures.completeOn((CompletableFuture)this.checkScopeExists(scope, context, executor).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.getStream(scope, name, context).create(configuration, createTimestamp, (int)startingSegmentNumber, context);
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, "scope does not exist"));
        }), (Executor)executor));
    }

    @Override
    public CompletableFuture<Void> deleteStream(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream s = this.getStream(scope, name, context);
        return ((CompletableFuture)Futures.exceptionallyExpecting((CompletableFuture)((CompletableFuture)s.getActiveEpoch(true, context).thenApply(epoch -> epoch.getSegments().stream().map(StreamSegmentRecord::getSegmentNumber).reduce(Integer::max).get())).thenCompose(lastActiveSegment -> this.recordLastStreamSegment(scope, name, (int)lastActiveSegment, context, executor)), DATA_NOT_FOUND_PREDICATE, null).thenCompose(v -> Futures.completeOn(s.delete(context), (Executor)executor))).thenAccept(v -> this.cache.invalidate((Object)new ImmutablePair((Object)scope, (Object)name)));
    }

    @Override
    public CompletableFuture<Long> getCreationTime(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).getCreationTime(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> setState(String scope, String name, State state, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).updateState(state, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<State> getState(String scope, String name, boolean ignoreCached, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).getState(ignoreCached, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<State>> updateVersionedState(String scope, String name, State state, VersionedMetadata<State> previous, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).updateVersionedState(previous, state, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<State>> getVersionedState(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).getVersionedState(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Controller.CreateScopeStatus> createScope(String scopeName, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Scope scope = this.getScope(scopeName, context);
        return Futures.completeOn((CompletableFuture)scope.createScope(context).handle((result, ex) -> {
            if (ex == null) {
                return Controller.CreateScopeStatus.newBuilder().setStatus(Controller.CreateScopeStatus.Status.SUCCESS).build();
            }
            if (Exceptions.unwrap((Throwable)ex) instanceof StoreException.DataExistsException) {
                return Controller.CreateScopeStatus.newBuilder().setStatus(Controller.CreateScopeStatus.Status.SCOPE_EXISTS).build();
            }
            log.error(context.getRequestId(), "Create scope failed for scope {} due to ", new Object[]{scopeName, ex});
            return Controller.CreateScopeStatus.newBuilder().setStatus(Controller.CreateScopeStatus.Status.FAILURE).build();
        }), (Executor)executor);
    }

    @Override
    public CompletableFuture<Controller.DeleteScopeStatus> deleteScope(String scopeName, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn((CompletableFuture)this.getScope(scopeName, context).deleteScope(context).handle((result, e) -> {
            Throwable ex = Exceptions.unwrap((Throwable)e);
            if (ex == null) {
                return Controller.DeleteScopeStatus.newBuilder().setStatus(Controller.DeleteScopeStatus.Status.SUCCESS).build();
            }
            if (ex instanceof StoreException.DataNotFoundException) {
                return Controller.DeleteScopeStatus.newBuilder().setStatus(Controller.DeleteScopeStatus.Status.SCOPE_NOT_FOUND).build();
            }
            if (ex instanceof StoreException.DataNotEmptyException) {
                return Controller.DeleteScopeStatus.newBuilder().setStatus(Controller.DeleteScopeStatus.Status.SCOPE_NOT_EMPTY).build();
            }
            log.error(context.getRequestId(), "DeleteScope failed for scope {} due to {} ", new Object[]{scopeName, ex});
            return Controller.DeleteScopeStatus.newBuilder().setStatus(Controller.DeleteScopeStatus.Status.FAILURE).build();
        }), (Executor)executor);
    }

    @Override
    public CompletableFuture<Map<String, StreamConfiguration>> listStreamsInScope(String scopeName, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn((CompletableFuture)this.getScope(scopeName, context).listStreamsInScope(context).thenCompose(streams -> {
            HashMap<String, CompletionStage> result = new HashMap<String, CompletionStage>();
            for (String s : streams) {
                Stream stream = this.getStream(scopeName, s, null);
                CompletableFuture<StreamConfiguration> configurationFuture = stream.getConfiguration(context);
                CompletableFuture<State> stateFuture = stream.getState(true, context);
                CompletionStage future = CompletableFuture.allOf(configurationFuture, stateFuture).thenApply(v -> {
                    State state = (State)((Object)((Object)((Object)stateFuture.join())));
                    if (state.equals((Object)State.CREATING) || state.equals((Object)State.UNKNOWN)) {
                        throw StoreException.create(StoreException.Type.DATA_NOT_FOUND, "Partially created stream");
                    }
                    return (StreamConfiguration)configurationFuture.join();
                });
                result.put(stream.getName(), Futures.exceptionallyExpecting((CompletableFuture)future, e -> e instanceof StoreException.DataNotFoundException, null).thenApply(Optional::ofNullable));
            }
            return Futures.allOfWithResults(result).thenApply(x -> x.entrySet().stream().filter(y -> ((Optional)y.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, entry -> (StreamConfiguration)((Optional)entry.getValue()).get())));
        }), (Executor)executor);
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listStream(String scopeName, String continuationToken, int limit, Executor executor, OperationContext ctx) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getScope(scopeName, context).listStreams(limit, continuationToken, executor, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listStreamsForTag(String scopeName, String tag, String continuationToken, Executor executor, OperationContext ctx) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getScope(scopeName, context).listStreamsForTag(tag, continuationToken, executor, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> startTruncation(String scope, String name, Map<Long, Long> streamCut, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).startTruncation(streamCut, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> completeTruncation(String scope, String name, VersionedMetadata<StreamTruncationRecord> record, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).completeTruncation(record, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<StreamTruncationRecord>> getTruncationRecord(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).getTruncationRecord(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> startUpdateConfiguration(String scope, String name, StreamConfiguration configuration, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).startUpdateConfiguration(configuration, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> completeUpdateConfiguration(String scope, String name, VersionedMetadata<StreamConfigurationRecord> existing, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).completeUpdateConfiguration(existing, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<StreamConfiguration> getConfiguration(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).getConfiguration(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<StreamConfigurationRecord>> getConfigurationRecord(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).getVersionedConfigurationRecord(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Boolean> isSealed(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn((CompletableFuture)this.getStream(scope, name, context).getState(true, context).thenApply(state -> state.equals((Object)State.SEALED)), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> setSealed(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).updateState(State.SEALED, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<StreamSegmentRecord> getSegment(String scope, String name, long segmentId, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).getSegment(segmentId, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Set<Long>> getAllSegmentIds(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).getAllSegmentIds(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Map<StreamSegmentRecord, Long>> getSegmentsAtHead(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, name, context);
        return Futures.completeOn(stream.getSegmentsAtHead(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<List<StreamSegmentRecord>> getActiveSegments(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, name, context);
        return Futures.completeOn((CompletableFuture)stream.getState(true, context).thenComposeAsync(state -> {
            if (State.SEALED.equals(state)) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            return stream.getActiveSegments(context);
        }, executor), (Executor)executor);
    }

    @Override
    public CompletableFuture<List<StreamSegmentRecord>> getSegmentsInEpoch(String scope, String stream, int epoch, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream streamObj = this.getStream(scope, stream, context);
        return Futures.completeOn(streamObj.getSegmentsInEpoch(epoch, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Map<StreamSegmentRecord, List<Long>>> getSuccessors(String scope, String streamName, long segmentId, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, streamName, context);
        return Futures.completeOn(stream.getSuccessorsWithPredecessors(segmentId, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<List<StreamSegmentRecord>> getSegmentsBetweenStreamCuts(String scope, String streamName, Map<Long, Long> from, Map<Long, Long> to, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, streamName, context);
        return Futures.completeOn(stream.getSegmentsBetweenStreamCuts(from, to, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Boolean> isStreamCutValid(String scope, String streamName, Map<Long, Long> streamCut, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, streamName, context);
        return Futures.completeOn(stream.isStreamCutValid(streamCut, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> submitScale(String scope, String name, List<Long> sealedSegments, List<Map.Entry<Double, Double>> newRanges, long scaleTimestamp, VersionedMetadata<EpochTransitionRecord> record, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).submitScale(sealedSegments, newRanges, scaleTimestamp, record, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> getEpochTransition(String scope, String stream, OperationContext ctx, ScheduledExecutorService executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).getEpochTransition(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> resetEpochTransition(String scope, String name, VersionedMetadata<EpochTransitionRecord> record, OperationContext context, Executor executor) {
        OperationContext ctx = this.getOperationContext(context);
        return Futures.completeOn(this.getStream(scope, name, context).resetEpochTransition(record, ctx), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> startScale(String scope, String name, boolean isManualScale, VersionedMetadata<EpochTransitionRecord> record, VersionedMetadata<State> state, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).startScale(isManualScale, record, state, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> scaleCreateNewEpochs(String scope, String name, VersionedMetadata<EpochTransitionRecord> record, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).scaleCreateNewEpoch(record, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> scaleSegmentsSealed(String scope, String name, Map<Long, Long> sealedSegmentSizes, VersionedMetadata<EpochTransitionRecord> record, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        CompletableFuture future = Futures.completeOn(this.getStream(scope, name, context).scaleOldSegmentsSealed(sealedSegmentSizes, record, context), (Executor)executor);
        future.thenCompose(result -> CompletableFuture.allOf(new CompletableFuture[]{this.getActiveSegments(scope, name, context, executor).thenAccept(list -> StreamMetrics.reportActiveSegments(scope, name, list.size())), this.findNumSplitsMerges(scope, name, context, executor).thenAccept(simpleEntry -> StreamMetrics.reportSegmentSplitsAndMerges(scope, name, (Long)simpleEntry.getKey(), (Long)simpleEntry.getValue()))}));
        return future;
    }

    @Override
    public CompletableFuture<Void> completeScale(String scope, String name, VersionedMetadata<EpochTransitionRecord> record, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).completeScale(record, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> startRollingTxn(String scope, String stream, int activeEpoch, VersionedMetadata<CommittingTransactionsRecord> existing, OperationContext ctx, ScheduledExecutorService executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).startRollingTxn(activeEpoch, existing, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> rollingTxnCreateDuplicateEpochs(String scope, String name, Map<Long, Long> sealedTxnEpochSegments, long time, VersionedMetadata<CommittingTransactionsRecord> record, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).rollingTxnCreateDuplicateEpochs(sealedTxnEpochSegments, time, record, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> completeRollingTxn(String scope, String name, Map<Long, Long> sealedActiveEpochSegments, VersionedMetadata<CommittingTransactionsRecord> record, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        CompletableFuture future = Futures.completeOn(this.getStream(scope, name, context).completeRollingTxn(sealedActiveEpochSegments, record, context), (Executor)executor);
        future.thenCompose(result -> this.findNumSplitsMerges(scope, name, context, executor).thenAccept(simpleEntry -> StreamMetrics.reportSegmentSplitsAndMerges(scope, name, (Long)simpleEntry.getKey(), (Long)simpleEntry.getValue())));
        return future;
    }

    @Override
    public CompletableFuture<Void> addSubscriber(String scopeName, String streamName, String subscriber, long generation, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scopeName, streamName, context);
        return Futures.completeOn(stream.addSubscriber(subscriber, generation, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> deleteSubscriber(String scope, String name, String subscriber, long generation, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).deleteSubscriber(subscriber, generation, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> updateSubscriberStreamCut(String scope, String name, String subscriber, long generation, ImmutableMap<Long, Long> streamCut, VersionedMetadata<StreamSubscriber> previousRecord, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).updateSubscriberStreamCut(previousRecord, subscriber, generation, streamCut, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<StreamSubscriber>> getSubscriber(String scope, String name, String subscriber, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).getSubscriberRecord(subscriber, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<List<String>> listSubscribers(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).listSubscribers(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> addStreamCutToRetentionSet(String scope, String name, StreamCutRecord streamCut, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, name, context);
        return Futures.completeOn(stream.addStreamCutToRetentionSet(streamCut, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<RetentionSet> getRetentionSet(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, name, context);
        return Futures.completeOn(stream.getRetentionSet(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<StreamCutRecord> getStreamCutRecord(String scope, String name, StreamCutReferenceRecord reference, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, name, context);
        return Futures.completeOn(stream.getStreamCutRecord(reference, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> deleteStreamCutBefore(String scope, String name, StreamCutReferenceRecord streamCut, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, name, context);
        return Futures.completeOn(stream.deleteStreamCutBefore(streamCut, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Long> getSizeTillStreamCut(String scope, String name, Map<Long, Long> streamCut, Optional<StreamCutRecord> reference, OperationContext ctx, ScheduledExecutorService executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, name, context);
        return Futures.completeOn(stream.getSizeTillStreamCut(streamCut, reference, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<UUID> generateTransactionId(String scopeName, String streamName, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scopeName, streamName, context);
        CompletableFuture<Int96> nextFuture = this.getNextCounter();
        return Futures.completeOn((CompletableFuture)nextFuture.thenCompose(next -> stream.generateNewTxnId(next.getMsb(), next.getLsb(), context)), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedTransactionData> createTransaction(String scopeName, String streamName, UUID txnId, long lease, long maxExecutionTime, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scopeName, streamName, context);
        return Futures.completeOn(stream.createTransaction(txnId, lease, maxExecutionTime, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedTransactionData> pingTransaction(String scopeName, String streamName, VersionedTransactionData txData, long lease, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scopeName, streamName, context).pingTransaction(txData, lease, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedTransactionData> getTransactionData(String scopeName, String streamName, UUID txId, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scopeName, streamName, context).getTransactionData(txId, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<TxnStatus> transactionStatus(String scopeName, String streamName, UUID txId, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scopeName, streamName, context).checkTransactionStatus(txId, context), (Executor)executor);
    }

    @VisibleForTesting
    public CompletableFuture<TxnStatus> commitTransaction(String scope, String streamName, UUID txId, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, streamName, context);
        return Futures.completeOn(((PersistentStreamBase)stream).commitTransaction(txId, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<AbstractMap.SimpleEntry<TxnStatus, Integer>> sealTransaction(String scopeName, String streamName, UUID txId, boolean commit, Optional<Version> version, String writerId, long timestamp, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scopeName, streamName, context).sealTransaction(txId, commit, version, writerId, timestamp, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<TxnStatus> abortTransaction(String scope, String streamName, UUID txId, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scope, streamName, context);
        return Futures.completeOn(stream.abortTransaction(txId, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> addTxnToIndex(String hostId, TxnResource txn, Version version) {
        return this.hostTxnIndex.addEntity(hostId, this.getTxnResourceString(txn), Optional.ofNullable(version).orElse(this.getEmptyVersion()).toBytes());
    }

    @Override
    public CompletableFuture<Void> removeTxnFromIndex(String hostId, TxnResource txn, boolean deleteEmptyParent) {
        return this.hostTxnIndex.removeEntity(hostId, this.getTxnResourceString(txn), deleteEmptyParent);
    }

    @Override
    public CompletableFuture<Optional<TxnResource>> getRandomTxnFromIndex(String hostId) {
        return this.hostTxnIndex.getEntities(hostId).thenApply(list -> list != null && list.size() > 0 ? Optional.of(this.getTxnResource((String)list.get(RandomFactory.create().nextInt(list.size())))) : Optional.empty());
    }

    @Override
    public CompletableFuture<Version> getTxnVersionFromIndex(String hostId, TxnResource resource) {
        return this.hostTxnIndex.getEntityData(hostId, this.getTxnResourceString(resource)).thenApply(data -> Optional.ofNullable(data).map(this::parseVersionData).filter(x -> !x.equals(this.getEmptyVersion())).orElse(null));
    }

    @Override
    public CompletableFuture<Void> removeHostFromIndex(String hostId) {
        return this.hostTxnIndex.removeHost(hostId);
    }

    @Override
    public CompletableFuture<Set<String>> listHostsOwningTxn() {
        return this.hostTxnIndex.getHosts();
    }

    @Override
    public CompletableFuture<Map<String, ControllerEvent>> getPendingsTaskForHost(String hostId, int limit) {
        return this.hostTaskIndex.getEntities(hostId).thenCompose(list -> Futures.allOfWithResults(list.stream().limit(limit).collect(Collectors.toMap(id -> id, id -> this.getControllerTask(hostId, (String)id)))));
    }

    private CompletableFuture<ControllerEvent> getControllerTask(String hostId, String id) {
        return this.hostTaskIndex.getEntityData(hostId, id).thenApply(data -> this.controllerEventSerializer.fromByteBuffer(ByteBuffer.wrap(data)));
    }

    @Override
    public CompletableFuture<Void> removeHostFromTaskIndex(String hostId) {
        return this.hostTaskIndex.removeHost(hostId);
    }

    @Override
    public CompletableFuture<Set<String>> listHostsWithPendingTask() {
        return this.hostTaskIndex.getHosts();
    }

    @Override
    public CompletableFuture<Void> markCold(String scope, String stream, long segmentId, long timestamp, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).setColdMarker(segmentId, timestamp, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Boolean> isCold(String scope, String stream, long segmentId, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn((CompletableFuture)this.getStream(scope, stream, context).getColdMarker(segmentId, context).thenApply(marker -> marker != null && marker > System.currentTimeMillis()), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> removeMarker(String scope, String stream, long segmentId, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).removeColdMarker(segmentId, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Map<UUID, ActiveTxnRecord>> getActiveTxns(String scope, String stream, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).getActiveTxns(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<List<ScaleMetadata>> getScaleMetadata(String scope, String name, long from, long to, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, name, context).getScaleMetadata(from, to, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<EpochRecord> getActiveEpoch(String scope, String stream, OperationContext ctx, boolean ignoreCached, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).getActiveEpoch(ignoreCached, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<EpochRecord> getEpoch(String scope, String stream, int epoch, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).getEpochRecord(epoch, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Map.Entry<VersionedMetadata<CommittingTransactionsRecord>, List<VersionedTransactionData>>> startCommitTransactions(String scope, String stream, int limit, OperationContext ctx, ScheduledExecutorService executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).startCommittingTransactions(limit, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> getVersionedCommittingTransactionsRecord(String scope, String stream, OperationContext ctx, ScheduledExecutorService executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).getVersionedCommitTransactionsRecord(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> completeCommitTransactions(String scope, String stream, VersionedMetadata<CommittingTransactionsRecord> record, OperationContext ctx, ScheduledExecutorService executor, Map<String, TxnWriterMark> writerMarks) {
        OperationContext context = this.getOperationContext(ctx);
        Stream streamObj = this.getStream(scope, stream, context);
        return Futures.completeOn(streamObj.completeCommittingTransactions(record, context, writerMarks), (Executor)executor).thenAcceptAsync(result -> streamObj.getNumberOfOngoingTransactions(context).thenAccept(count -> TransactionMetrics.reportOpenTransactions(scope, stream, count.intValue())), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> createWaitingRequestIfAbsent(String scope, String stream, String processorName, OperationContext ctx, ScheduledExecutorService executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).createWaitingRequestIfAbsent(processorName, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<String> getWaitingRequestProcessor(String scope, String stream, OperationContext ctx, ScheduledExecutorService executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).getWaitingRequestProcessor(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> deleteWaitingRequestConditionally(String scope, String stream, String processorName, OperationContext ctx, ScheduledExecutorService executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).deleteWaitingRequestConditionally(processorName, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<WriterTimestampResponse> noteWriterMark(String scope, String stream, String writer, long timestamp, Map<Long, Long> position, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).noteWriterMark(writer, timestamp, position, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> shutdownWriter(String scope, String stream, String writer, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).shutdownWriter(writer, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> removeWriter(String scope, String stream, String writer, WriterMark writerMark, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).removeWriter(writer, writerMark, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<WriterMark> getWriterMark(String scope, String stream, String writer, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).getWriterMark(writer, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Map<String, WriterMark>> getAllWriterMarks(String scope, String stream, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, stream, context).getAllWriterMarks(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<HistoryTimeSeries> getHistoryTimeSeriesChunk(String scope, String streamName, int chunkNumber, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, streamName, context).getHistoryTimeSeriesChunk(chunkNumber, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<SealedSegmentsMapShard> getSealedSegmentSizeMapShard(String scope, String streamName, int shardNumber, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, streamName, context).getSealedSegmentSizeMapShard(shardNumber, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Integer> getSegmentSealedEpoch(String scope, String streamName, long segmentId, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, streamName, context).getSegmentSealedEpoch(segmentId, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<StreamCutComparison> compareStreamCut(String scope, String streamName, Map<Long, Long> streamCut1, Map<Long, Long> streamCut2, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, streamName, context).compareStreamCuts(streamCut1, streamCut2, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<StreamCutReferenceRecord> findStreamCutReferenceRecordBefore(String scope, String streamName, Map<Long, Long> streamCut, RetentionSet retentionSet, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getStream(scope, streamName, context).findStreamCutReferenceRecordBefore(streamCut, retentionSet, context), (Executor)executor);
    }

    protected Stream getStream(String scope, String name, OperationContext context) {
        if (context instanceof StreamOperationContext) {
            return ((StreamOperationContext)context).getStream();
        }
        Stream stream = (Stream)this.cache.getUnchecked((Object)new ImmutablePair((Object)scope, (Object)name));
        stream.refresh();
        return stream;
    }

    @VisibleForTesting
    void setStream(Stream stream) {
        this.cache.put((Object)new ImmutablePair((Object)stream.getScope(), (Object)stream.getName()), (Object)stream);
    }

    public Scope getScope(String scopeName, OperationContext context) {
        if (context != null) {
            if (context instanceof StreamOperationContext) {
                return ((StreamOperationContext)context).getScope();
            }
            if (context instanceof RGOperationContext) {
                return ((RGOperationContext)context).getScope();
            }
        }
        Scope scope = (Scope)this.scopeCache.getUnchecked((Object)scopeName);
        scope.refresh();
        return scope;
    }

    @Override
    public CompletableFuture<UUID> getReaderGroupId(String scopeName, String rgName, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getScope(scopeName, context).getReaderGroupId(rgName, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> startRGConfigUpdate(String scope, String name, ReaderGroupConfig configuration, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getReaderGroup(scope, name, context).startUpdateConfiguration(configuration, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> completeRGConfigUpdate(String scope, String name, VersionedMetadata<ReaderGroupConfigRecord> existing, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getReaderGroup(scope, name, context).completeUpdateConfiguration(existing, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<ReaderGroupState>> getVersionedReaderGroupState(String scope, String name, boolean ignoreCached, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getReaderGroup(scope, name, context).getVersionedState(context), (Executor)executor);
    }

    @Override
    public CompletableFuture<ReaderGroupState> getReaderGroupState(String scope, String name, boolean ignoreCached, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getReaderGroup(scope, name, context).getState(ignoreCached, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<VersionedMetadata<ReaderGroupConfigRecord>> getReaderGroupConfigRecord(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getReaderGroup(scope, name, context).getVersionedConfigurationRecord(context), (Executor)executor);
    }

    @Override
    public RGOperationContext createRGContext(String scope, String name, long requestId) {
        return new RGOperationContext(this.getScope(scope, null), this.getReaderGroup(scope, name, null), requestId);
    }

    protected ReaderGroup getReaderGroup(String scope, String name, OperationContext context) {
        if (context instanceof RGOperationContext) {
            return ((RGOperationContext)context).getReaderGroup();
        }
        ReaderGroup readerGroup = (ReaderGroup)this.rgCache.getUnchecked((Object)new ImmutablePair((Object)scope, (Object)name));
        readerGroup.refresh();
        return readerGroup;
    }

    @Override
    public CompletableFuture<Void> createReaderGroup(String scope, String rgName, ReaderGroupConfig configuration, long createTimestamp, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn((CompletableFuture)this.checkScopeExists(scope, context, executor).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.getReaderGroup(scope, rgName, context).create(configuration, createTimestamp, context);
            }
            return Futures.toVoid((CompletableFuture)Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, "scope does not exist")));
        }), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> deleteReaderGroup(String scopeName, String rgName, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return this.getReaderGroup(scopeName, rgName, context).delete(context);
    }

    @Override
    public CompletableFuture<VersionedMetadata<ReaderGroupState>> updateReaderGroupVersionedState(String scope, String name, ReaderGroupState state, VersionedMetadata<ReaderGroupState> previous, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(this.getReaderGroup(scope, name, context).updateVersionedState(previous, state, context), (Executor)executor);
    }

    private CompletableFuture<AbstractMap.SimpleEntry<Long, Long>> findNumSplitsMerges(String scopeName, String streamName, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        Stream stream = this.getStream(scopeName, streamName, context);
        return Futures.completeOn((CompletableFuture)stream.getActiveEpoch(true, context).thenCompose(x -> stream.getSplitMergeCountsTillEpoch((EpochRecord)x, context)), (Executor)executor);
    }

    OperationContext getOperationContext(OperationContext context) {
        return context != null ? context : new OperationContext(){
            private final long requestId;
            private final long operationStartTime;
            {
                this.requestId = AbstractStreamMetadataStore.this.requestIdGenerator.nextLong();
                this.operationStartTime = System.currentTimeMillis();
            }

            @Override
            public long getOperationStartTime() {
                return this.operationStartTime;
            }

            @Override
            public long getRequestId() {
                return this.requestId;
            }
        };
    }

    abstract CompletableFuture<Integer> getSafeStartingSegmentNumberFor(String var1, String var2, OperationContext var3, Executor var4);

    abstract CompletableFuture<Void> recordLastStreamSegment(String var1, String var2, int var3, OperationContext var4, Executor var5);

    abstract Stream newStream(String var1, String var2);

    abstract CompletableFuture<Int96> getNextCounter();

    private String getTxnResourceString(TxnResource txn) {
        return txn.toString(RESOURCE_PART_SEPARATOR);
    }

    private TxnResource getTxnResource(String str) {
        return TxnResource.parse(str, RESOURCE_PART_SEPARATOR);
    }

    String getScopedStreamName(String scope, String stream) {
        return String.format("%s/%s", scope, stream);
    }

    abstract Version getEmptyVersion();

    abstract Version parseVersionData(byte[] var1);

    abstract ReaderGroup newReaderGroup(String var1, String var2);

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HostIndex getHostTaskIndex() {
        return this.hostTaskIndex;
    }
}

