/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.store.client.StoreType;
import io.pravega.shared.NameUtils;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;

public interface BucketStore {
    public StoreType getStoreType();

    public int getBucketCount(ServiceType var1);

    public CompletableFuture<Set<String>> getStreamsForBucket(ServiceType var1, int var2, Executor var3);

    public CompletableFuture<Void> addStreamToBucketStore(ServiceType var1, String var2, String var3, Executor var4);

    public CompletableFuture<Void> removeStreamFromBucketStore(ServiceType var1, String var2, String var3, Executor var4);

    public static int getBucket(String scope, String stream, int bucketCount) {
        String scopedStreamName = BucketStore.getScopedStreamName(scope, stream);
        return (scopedStreamName.hashCode() & Integer.MAX_VALUE) % bucketCount;
    }

    public static String getScopedStreamName(String scope, String stream) {
        return NameUtils.getScopedStreamName((String)scope, (String)stream);
    }

    public static enum ServiceType {
        RetentionService("buckets"),
        WatermarkingService("watermarks");

        private final String name;

        private ServiceType(String name) {
            this.name = name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }
    }
}

