/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.store.VersionedMetadata;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class Cache {
    private static final int MAX_CACHE_SIZE = 10000;
    private static final int KEY_PARTITION_COUNT = 100;
    private final com.google.common.cache.Cache<CacheKey, CacheValue> cache;
    private final Object[] locks = new Object[100];

    public Cache() {
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(2L, TimeUnit.MINUTES).build();
        for (int i = 0; i < 100; ++i) {
            this.locks[i] = new Object();
        }
    }

    public VersionedMetadata<?> getCachedData(CacheKey key) {
        CacheValue value = (CacheValue)this.cache.getIfPresent((Object)key);
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    public VersionedMetadata<?> getCachedData(CacheKey key, long time) {
        CacheValue value = (CacheValue)this.cache.getIfPresent((Object)key);
        if (value != null && value.getTime() > time) {
            return value.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache(CacheKey key) {
        Object object = this.getLockObject(key);
        synchronized (object) {
            this.cache.invalidate((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(CacheKey cacheKey, VersionedMetadata<?> record, long time) {
        Preconditions.checkNotNull(record, (Object)"Null record cannot be put in cache");
        Object object = this.getLockObject(cacheKey);
        synchronized (object) {
            CacheValue existing = (CacheValue)this.cache.getIfPresent((Object)cacheKey);
            if (existing == null || record.getVersion().compareTo(existing.getValue().getVersion()) > 0) {
                this.cache.put((Object)cacheKey, (Object)new CacheValue(record, time));
            }
        }
    }

    private Object getLockObject(CacheKey key) {
        int lockIndex = Math.abs(key.hashCode() % 100);
        return this.locks[lockIndex];
    }

    static class CacheValue {
        private final VersionedMetadata<?> value;
        private final long time;

        @ConstructorProperties(value={"value", "time"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CacheValue(VersionedMetadata<?> value, long time) {
            this.value = value;
            this.time = time;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public VersionedMetadata<?> getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getTime() {
            return this.time;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheValue)) {
                return false;
            }
            CacheValue other = (CacheValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VersionedMetadata<?> this$value = this.getValue();
            VersionedMetadata<?> other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            return this.getTime() == other.getTime();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CacheValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VersionedMetadata<?> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Cache.CacheValue(value=" + this.getValue() + ", time=" + this.getTime() + ")";
        }
    }

    public static interface CacheKey {
    }
}

