/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.collect.ImmutableMap;
import io.pravega.controller.store.client.StoreType;
import io.pravega.controller.store.stream.BucketStore;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;

public class InMemoryBucketStore
implements BucketStore {
    private final ImmutableMap<BucketStore.ServiceType, Integer> bucketCountMap;
    private final ConcurrentMap<String, ConcurrentSkipListSet<String>> bucketedStreams;
    private final ConcurrentMap<String, BucketChangeListener> listeners;

    InMemoryBucketStore(ImmutableMap<BucketStore.ServiceType, Integer> bucketCountMap) {
        this.bucketCountMap = bucketCountMap;
        this.bucketedStreams = new ConcurrentHashMap<String, ConcurrentSkipListSet<String>>();
        this.listeners = new ConcurrentHashMap<String, BucketChangeListener>();
    }

    private String getBucketName(BucketStore.ServiceType serviceType, int bucket) {
        return serviceType.getName() + "/" + bucket;
    }

    @Override
    public StoreType getStoreType() {
        return StoreType.InMemory;
    }

    @Override
    public int getBucketCount(BucketStore.ServiceType serviceType) {
        return (Integer)this.bucketCountMap.get((Object)serviceType);
    }

    @Override
    public CompletableFuture<Set<String>> getStreamsForBucket(BucketStore.ServiceType serviceType, int bucket, Executor executor) {
        String bucketName = this.getBucketName(serviceType, bucket);
        if (this.bucketedStreams.containsKey(bucketName)) {
            return CompletableFuture.completedFuture(Collections.unmodifiableSet((Set)this.bucketedStreams.get(bucketName)));
        }
        return CompletableFuture.completedFuture(Collections.emptySet());
    }

    @Override
    public CompletableFuture<Void> addStreamToBucketStore(BucketStore.ServiceType serviceType, String scope, String stream, Executor executor) {
        int bucketCount = (Integer)this.bucketCountMap.get((Object)serviceType);
        int bucket = BucketStore.getBucket(scope, stream, bucketCount);
        String bucketName = this.getBucketName(serviceType, bucket);
        ConcurrentSkipListSet set = this.bucketedStreams.compute(bucketName, (x, y) -> {
            if (y == null) {
                return new ConcurrentSkipListSet();
            }
            return y;
        });
        String scopedStreamName = BucketStore.getScopedStreamName(scope, stream);
        set.add(scopedStreamName);
        this.listeners.computeIfPresent(bucketName, (b, listener) -> {
            listener.notify(scope, stream, true);
            return listener;
        });
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeStreamFromBucketStore(BucketStore.ServiceType serviceType, String scope, String stream, Executor executor) {
        int bucketCount = (Integer)this.bucketCountMap.get((Object)serviceType);
        int bucket = BucketStore.getBucket(scope, stream, bucketCount);
        String bucketName = this.getBucketName(serviceType, bucket);
        String scopedStreamName = BucketStore.getScopedStreamName(scope, stream);
        this.bucketedStreams.computeIfPresent(bucketName, (b, set) -> {
            set.remove(scopedStreamName);
            return set;
        });
        this.listeners.computeIfPresent(this.getBucketName(serviceType, bucket), (b, listener) -> {
            listener.notify(scope, stream, false);
            return listener;
        });
        return CompletableFuture.completedFuture(null);
    }

    public void registerBucketChangeListener(BucketStore.ServiceType serviceType, int bucketId, BucketChangeListener listener) {
        String bucketName = this.getBucketName(serviceType, bucketId);
        this.listeners.putIfAbsent(bucketName, listener);
    }

    public void unregisterBucketChangeListener(BucketStore.ServiceType serviceType, int bucketId) {
        String bucketName = this.getBucketName(serviceType, bucketId);
        this.listeners.remove(bucketName);
    }

    @FunctionalInterface
    public static interface BucketChangeListener {
        public void notify(String var1, String var2, boolean var3);
    }
}

