/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.AbstractReaderGroup;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ReaderGroupState;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.records.ReaderGroupConfigRecord;
import io.pravega.controller.store.stream.records.ReaderGroupStateRecord;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryReaderGroup
extends AbstractReaderGroup {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryReaderGroup.class);
    private final AtomicLong creationTime = new AtomicLong(Long.MIN_VALUE);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private VersionedMetadata<ReaderGroupConfigRecord> configuration;
    @GuardedBy(value="lock")
    private VersionedMetadata<ReaderGroupStateRecord> state;
    private final UUID readerGroupId;

    public InMemoryReaderGroup(String scopeName, String rgName, UUID rgId) {
        super(scopeName, rgName);
        this.readerGroupId = rgId;
    }

    public InMemoryReaderGroup(String scopeName, String rgName) {
        super(scopeName, rgName);
        this.readerGroupId = UUID.randomUUID();
    }

    public UUID getId() {
        return this.readerGroupId;
    }

    @Override
    CompletableFuture<Void> createMetadataTables(OperationContext context) {
        log.debug("InMemoryReaderGroup::createMetadataTables");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    CompletableFuture<Void> storeCreationTimeIfAbsent(long timestamp, OperationContext context) {
        this.creationTime.compareAndSet(Long.MIN_VALUE, timestamp);
        log.debug("InMemoryReaderGroup::storeCreationTimeIfAbsent");
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Void> createConfigurationIfAbsent(ReaderGroupConfig config, OperationContext context) {
        Preconditions.checkNotNull((Object)config);
        Object object = this.lock;
        synchronized (object) {
            if (this.configuration == null) {
                ReaderGroupConfigRecord configRecord = ReaderGroupConfigRecord.update(config, 0L, false);
                this.configuration = new VersionedMetadata<ReaderGroupConfigRecord>(configRecord, new Version.IntVersion(0));
                log.debug("InMemoryReaderGroup::createConfigurationIfAbsent");
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Void> createStateIfAbsent(OperationContext context) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == null) {
                ReaderGroupStateRecord stateRecord = ReaderGroupStateRecord.builder().state(ReaderGroupState.CREATING).build();
                this.state = new VersionedMetadata<ReaderGroupStateRecord>(stateRecord, new Version.IntVersion(0));
                log.debug("InMemoryReaderGroup::createStateIfAbsent");
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Version> setStateData(VersionedMetadata<ReaderGroupStateRecord> newState, OperationContext context) {
        Preconditions.checkNotNull(newState);
        CompletableFuture<Version> result = new CompletableFuture<Version>();
        Object object = this.lock;
        synchronized (object) {
            if (Objects.equals(this.state.getVersion(), newState.getVersion())) {
                this.state = this.updatedCopy(newState);
                result.complete(this.state.getVersion());
            } else {
                result.completeExceptionally(StoreException.create(StoreException.Type.WRITE_CONFLICT, this.getName()));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<VersionedMetadata<ReaderGroupStateRecord>> getStateData(boolean ignoreCached, OperationContext context) {
        log.debug("Inside getStateData - InMemoryStore");
        Object object = this.lock;
        synchronized (object) {
            if (this.state == null) {
                log.debug("stateData not found");
                return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, this.getName()));
            }
            log.debug("returning stateData");
            return CompletableFuture.completedFuture(this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<VersionedMetadata<ReaderGroupConfigRecord>> getConfigurationData(boolean ignoreCached, OperationContext context) {
        Object object = this.lock;
        synchronized (object) {
            if (this.configuration == null) {
                return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, this.getName()));
            }
            return CompletableFuture.completedFuture(this.configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Version> setConfigurationData(VersionedMetadata<ReaderGroupConfigRecord> newConfig, OperationContext context) {
        Preconditions.checkNotNull(newConfig);
        CompletableFuture<Version> result = new CompletableFuture<Version>();
        Object object = this.lock;
        synchronized (object) {
            if (this.configuration == null) {
                result.completeExceptionally(StoreException.create(StoreException.Type.DATA_NOT_FOUND, this.getName()));
            } else if (Objects.equals(this.configuration.getVersion(), newConfig.getVersion())) {
                this.configuration = this.updatedCopy(new VersionedMetadata<ReaderGroupConfigRecord>(newConfig.getObject(), this.configuration.getVersion()));
                result.complete(this.configuration.getVersion());
            } else {
                result.completeExceptionally(StoreException.create(StoreException.Type.WRITE_CONFLICT, this.getName()));
            }
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> delete(OperationContext context) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void refresh() {
    }

    private <T> VersionedMetadata<T> updatedCopy(VersionedMetadata<T> input) {
        return new VersionedMetadata<T>(input.getObject(), new Version.IntVersion(input.getVersion().asIntVersion().getIntValue() + 1));
    }
}

