/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.internal.LinkedTreeMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.RetentionPolicy;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.lang.AtomicInt96;
import io.pravega.common.lang.Int96;
import io.pravega.controller.store.InMemoryScope;
import io.pravega.controller.store.Scope;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.index.InMemoryHostIndex;
import io.pravega.controller.store.stream.AbstractStreamMetadataStore;
import io.pravega.controller.store.stream.CreateStreamResponse;
import io.pravega.controller.store.stream.InMemoryReaderGroup;
import io.pravega.controller.store.stream.InMemoryStream;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ReaderGroup;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.Stream;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryStreamMetadataStore
extends AbstractStreamMetadataStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryStreamMetadataStore.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    @GuardedBy(value="$lock")
    private final Map<String, InMemoryStream> streams = new HashMap<String, InMemoryStream>();
    @GuardedBy(value="$lock")
    private final Map<String, Integer> deletedStreams = new HashMap<String, Integer>();
    @GuardedBy(value="$lock")
    private final HashMap<String, InMemoryScope> scopes = new HashMap();
    private final AtomicInteger position = new AtomicInteger();
    @GuardedBy(value="$lock")
    private final LinkedTreeMap<String, Integer> orderedScopes = new LinkedTreeMap();
    @GuardedBy(value="$lock")
    private final Map<String, InMemoryReaderGroup> readerGroups = new HashMap<String, InMemoryReaderGroup>();
    @GuardedBy(value="$lock")
    private final Map<Integer, List<String>> bucketedStreams = new HashMap<Integer, List<String>>();
    @GuardedBy(value="$lock")
    private final Map<String, RetentionPolicy> streamPolicyMap = new HashMap<String, RetentionPolicy>();
    private final AtomicInt96 counter = new AtomicInt96();

    public InMemoryStreamMetadataStore() {
        super(new InMemoryHostIndex(), new InMemoryHostIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scopeExists(String scopeName) {
        Object object = this.$lock;
        synchronized (object) {
            return this.scopes.containsKey(scopeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Stream newStream(String scopeName, String name) {
        Object object = this.$lock;
        synchronized (object) {
            String key = this.scopedStreamName(scopeName, name);
            if (this.streams.containsKey(key)) {
                return this.streams.get(key);
            }
            return new InMemoryStream(scopeName, name);
        }
    }

    @Override
    CompletableFuture<Int96> getNextCounter() {
        return CompletableFuture.completedFuture(this.counter.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> checkScopeExists(String scope, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("InMemory checking if scope exists");
            return CompletableFuture.completedFuture(this.scopes.containsKey(scope));
        }
    }

    @Override
    Version getEmptyVersion() {
        return Version.IntVersion.EMPTY;
    }

    @Override
    Version parseVersionData(byte[] data) {
        return Version.IntVersion.fromBytes(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ReaderGroup newReaderGroup(String scope, String name) {
        Object object = this.$lock;
        synchronized (object) {
            String scopedRGName = this.scopedStreamName(scope, name);
            if (this.readerGroups.containsKey(scopedRGName)) {
                return this.readerGroups.get(scopedRGName);
            }
            return new InMemoryReaderGroup(scope, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Scope newScope(String scopeName) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.scopes.containsKey(scopeName)) {
                return this.scopes.get(scopeName);
            }
            return new InMemoryScope(scopeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<CreateStreamResponse> createStream(String scopeName, String streamName, StreamConfiguration configuration, long timeStamp, OperationContext ctx, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            OperationContext context = this.getOperationContext(ctx);
            if (this.scopes.containsKey(scopeName)) {
                InMemoryStream stream = (InMemoryStream)this.getStream(scopeName, streamName, context);
                return this.getSafeStartingSegmentNumberFor(scopeName, streamName, context, executor).thenCompose(startingSegmentNumber -> {
                    CompletableFuture<CreateStreamResponse> future = stream.create(configuration, timeStamp, (int)startingSegmentNumber, context);
                    return future.thenCompose(status -> {
                        this.streams.put(this.scopedStreamName(scopeName, streamName), stream);
                        return this.scopes.get(scopeName).addStreamToScope(streamName, context).thenApply(v -> status);
                    });
                });
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> checkStreamExists(String scopeName, String streamName, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            return CompletableFuture.completedFuture(this.streams.containsKey(this.scopedStreamName(scopeName, streamName)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Integer> getSafeStartingSegmentNumberFor(String scopeName, String streamName, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            Integer safeStartingSegmentNumber = this.deletedStreams.get(this.scopedStreamName(scopeName, streamName));
            return CompletableFuture.completedFuture(safeStartingSegmentNumber != null ? safeStartingSegmentNumber + 1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> deleteStream(String scopeName, String streamName, OperationContext ctx, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            OperationContext context = this.getOperationContext(ctx);
            String scopedStreamName = this.scopedStreamName(scopeName, streamName);
            if (this.scopes.containsKey(scopeName) && this.streams.containsKey(scopedStreamName)) {
                return ((CompletableFuture)((CompletableFuture)this.getCreationTime(scopeName, streamName, context, executor).thenCompose(time -> this.scopes.get(scopeName).removeStreamFromScope(streamName, context))).thenCompose(v -> super.deleteStream(scopeName, streamName, context, executor))).thenAccept(v -> this.streams.remove(scopedStreamName));
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, streamName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> startUpdateConfiguration(String scopeName, String streamName, StreamConfiguration configuration, OperationContext ctx, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            OperationContext context = this.getOperationContext(ctx);
            if (this.scopes.containsKey(scopeName)) {
                String scopeStreamName = this.scopedStreamName(scopeName, streamName);
                if (!this.streams.containsKey(scopeStreamName)) {
                    return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeStreamName));
                }
                return this.streams.get(scopeStreamName).startUpdateConfiguration(configuration, context);
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeName));
        }
    }

    @Override
    public CompletableFuture<Void> addStreamTagsToIndex(String scope, String name, StreamConfiguration config, OperationContext context, Executor executor) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeTagsFromIndex(String scope, String name, Set<String> tagsRemoved, OperationContext context, Executor executor) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> addReaderGroupToScope(String scopeName, String rgName, UUID readerGroupId, OperationContext context, Executor executor) {
        if (this.scopes.containsKey(scopeName)) {
            return Futures.toVoid(this.scopes.get(scopeName).addReaderGroupToScope(rgName, readerGroupId));
        }
        return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeName));
    }

    @Override
    public CompletableFuture<Void> createReaderGroup(String scope, String name, ReaderGroupConfig configuration, long createTimestamp, OperationContext context, Executor executor) {
        if (this.scopes.containsKey(scope)) {
            InMemoryReaderGroup readerGroup = (InMemoryReaderGroup)this.getReaderGroup(scope, name, context);
            this.readerGroups.put(this.scopedStreamName(scope, name), readerGroup);
            return readerGroup.create(configuration, createTimestamp, context);
        }
        return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scope));
    }

    @Override
    public CompletableFuture<Void> deleteReaderGroup(String scopeName, String rgName, OperationContext context, Executor executor) {
        String scopedRGName = this.scopedStreamName(scopeName, rgName);
        if (this.scopes.containsKey(scopeName) && this.readerGroups.containsKey(scopedRGName)) {
            this.readerGroups.remove(scopedRGName);
            return this.scopes.get(scopeName).removeReaderGroupFromScope(rgName);
        }
        return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, rgName));
    }

    @Override
    public CompletableFuture<Boolean> checkReaderGroupExists(String scopeName, String rgName, OperationContext context, Executor executor) {
        return Futures.completeOn(((InMemoryScope)this.getScope(scopeName, context)).checkReaderGroupExistsInScope(rgName), (Executor)executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Controller.CreateScopeStatus> createScope(String scopeName, OperationContext ctx, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            OperationContext context = this.getOperationContext(ctx);
            if (!this.scopes.containsKey(scopeName)) {
                InMemoryScope scope = (InMemoryScope)this.getScope(scopeName, context);
                return scope.createScope(context).thenApply(x -> {
                    this.scopes.put(scopeName, scope);
                    this.orderedScopes.put((Object)scopeName, (Object)this.position.incrementAndGet());
                    return Controller.CreateScopeStatus.newBuilder().setStatus(Controller.CreateScopeStatus.Status.SUCCESS).build();
                });
            }
            return CompletableFuture.completedFuture(Controller.CreateScopeStatus.newBuilder().setStatus(Controller.CreateScopeStatus.Status.SCOPE_EXISTS).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Controller.DeleteScopeStatus> deleteScope(String scopeName, OperationContext ctx, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            OperationContext context = this.getOperationContext(ctx);
            if (this.scopes.containsKey(scopeName)) {
                return this.scopes.get(scopeName).listStreamsInScope(context).thenCompose(streams -> {
                    if (streams.isEmpty()) {
                        return this.scopes.get(scopeName).deleteScope(context).thenApply(x -> {
                            this.scopes.remove(scopeName);
                            this.orderedScopes.remove((Object)scopeName);
                            return Controller.DeleteScopeStatus.newBuilder().setStatus(Controller.DeleteScopeStatus.Status.SUCCESS).build();
                        });
                    }
                    return CompletableFuture.completedFuture(Controller.DeleteScopeStatus.newBuilder().setStatus(Controller.DeleteScopeStatus.Status.SCOPE_NOT_EMPTY).build());
                });
            }
            return CompletableFuture.completedFuture(Controller.DeleteScopeStatus.newBuilder().setStatus(Controller.DeleteScopeStatus.Status.SCOPE_NOT_FOUND).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<String> getScopeConfiguration(String scopeName, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.scopes.containsKey(scopeName)) {
                return CompletableFuture.completedFuture(scopeName);
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<List<String>> listScopes(Executor executor, long requestId) {
        Object object = this.$lock;
        synchronized (object) {
            return CompletableFuture.completedFuture(new ArrayList<String>(this.scopes.keySet()));
        }
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listScopes(String continuationToken, int limit, Executor executor, long requestId) {
        ArrayList<String> result = new ArrayList<String>();
        String nextToken = continuationToken;
        int start = Strings.isNullOrEmpty((String)continuationToken) ? 0 : Integer.parseInt(continuationToken);
        for (Map.Entry x : this.orderedScopes.entrySet()) {
            if ((Integer)x.getValue() > start) {
                result.add((String)x.getKey());
                nextToken = ((Integer)x.getValue()).toString();
            }
            if (result.size() != limit) continue;
            break;
        }
        return CompletableFuture.completedFuture(new ImmutablePair(result, (Object)nextToken));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Map<String, StreamConfiguration>> listStreamsInScope(String scopeName, OperationContext ctx, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            OperationContext context = this.getOperationContext(ctx);
            InMemoryScope inMemoryScope = this.scopes.get(scopeName);
            if (inMemoryScope != null) {
                return inMemoryScope.listStreamsInScope(context).thenApply(streams -> {
                    HashMap<String, StreamConfiguration> result = new HashMap<String, StreamConfiguration>();
                    for (String stream : streams) {
                        State state = this.getState(scopeName, stream, true, null, executor).join();
                        StreamConfiguration configuration = (StreamConfiguration)Futures.exceptionallyExpecting(this.getConfiguration(scopeName, stream, null, executor), e -> e instanceof StoreException.DataNotFoundException, null).join();
                        if (configuration == null || state.equals((Object)State.CREATING) || state.equals((Object)State.UNKNOWN)) continue;
                        result.put(stream, configuration);
                    }
                    return result;
                });
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CompletableFuture<Void> recordLastStreamSegment(String scope, String stream, int lastActiveSegment, OperationContext context, Executor executor) {
        Object object = this.$lock;
        synchronized (object) {
            Integer oldLastActiveSegment = this.deletedStreams.put(this.getScopedStreamName(scope, stream), lastActiveSegment);
            Preconditions.checkArgument((oldLastActiveSegment == null || lastActiveSegment >= oldLastActiveSegment ? 1 : 0) != 0);
            log.debug("Recording last segment {} for stream {}/{} on deletion.", new Object[]{lastActiveSegment, scope, stream});
            return CompletableFuture.completedFuture(null);
        }
    }

    private String scopedStreamName(String scopeName, String streamName) {
        return scopeName + "/" + streamName;
    }

    @Override
    public void close() throws IOException {
    }

    @VisibleForTesting
    void addStreamObjToScope(String scopeName, String streamName) {
        InMemoryStream stream = (InMemoryStream)this.getStream(scopeName, streamName, null);
        this.streams.put(this.scopedStreamName(scopeName, streamName), stream);
        this.scopes.get(scopeName).addStreamToScope(streamName, null).join();
    }
}

