/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.common.util.CollectionHelpers;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.AbstractStreamMetadataStore;
import io.pravega.controller.store.stream.CreateStreamResponse;
import io.pravega.controller.store.stream.EpochTransitionOperationExceptions;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ScaleMetadata;
import io.pravega.controller.store.stream.Segment;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.Stream;
import io.pravega.controller.store.stream.StreamCutComparison;
import io.pravega.controller.store.stream.TxnStatus;
import io.pravega.controller.store.stream.TxnWriterMark;
import io.pravega.controller.store.stream.VersionedTransactionData;
import io.pravega.controller.store.stream.WriterTimestampResponse;
import io.pravega.controller.store.stream.ZkOrderedStore;
import io.pravega.controller.store.stream.records.ActiveTxnRecord;
import io.pravega.controller.store.stream.records.CommittingTransactionsRecord;
import io.pravega.controller.store.stream.records.CompletedTxnRecord;
import io.pravega.controller.store.stream.records.EpochRecord;
import io.pravega.controller.store.stream.records.EpochTransitionRecord;
import io.pravega.controller.store.stream.records.HistoryTimeSeries;
import io.pravega.controller.store.stream.records.HistoryTimeSeriesRecord;
import io.pravega.controller.store.stream.records.RecordHelper;
import io.pravega.controller.store.stream.records.RetentionSet;
import io.pravega.controller.store.stream.records.SealedSegmentsMapShard;
import io.pravega.controller.store.stream.records.StateRecord;
import io.pravega.controller.store.stream.records.StreamConfigurationRecord;
import io.pravega.controller.store.stream.records.StreamCutRecord;
import io.pravega.controller.store.stream.records.StreamCutReferenceRecord;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.controller.store.stream.records.StreamSubscriber;
import io.pravega.controller.store.stream.records.StreamTruncationRecord;
import io.pravega.controller.store.stream.records.WriterMark;
import io.pravega.shared.NameUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.LoggerFactory;

public abstract class PersistentStreamBase
implements Stream {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(PersistentStreamBase.class));
    private final String scope;
    private final String name;
    private final AtomicInteger historyChunkSize;
    private final AtomicInteger shardSize;

    PersistentStreamBase(String scope, String name, int historyChunkSize, int shardSize) {
        this.scope = scope;
        this.name = name;
        this.historyChunkSize = new AtomicInteger(historyChunkSize);
        this.shardSize = new AtomicInteger(shardSize);
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScopeName() {
        return this.scope;
    }

    @Override
    public CompletableFuture<CreateStreamResponse> create(StreamConfiguration configuration, long createTimestamp, int startingSegmentNumber, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.checkStreamExists(configuration, createTimestamp, startingSegmentNumber, context).thenCompose(createStreamResponse -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.createStreamMetadata(context).thenCompose(v -> this.storeCreationTimeIfAbsent(createStreamResponse.getTimestamp(), context))).thenCompose(v -> this.createConfigurationIfAbsent(StreamConfigurationRecord.complete(this.scope, this.name, createStreamResponse.getConfiguration()), context))).thenCompose(v -> this.createEpochTransitionIfAbsent(EpochTransitionRecord.EMPTY, context))).thenCompose(v -> this.createTruncationDataIfAbsent(StreamTruncationRecord.EMPTY, context))).thenCompose(v -> this.createCommitTxnRecordIfAbsent(CommittingTransactionsRecord.EMPTY, context))).thenCompose(v -> this.createStateIfAbsent(StateRecord.builder().state(State.CREATING).build(), context))).thenCompose(v -> this.createHistoryRecords(startingSegmentNumber, (CreateStreamResponse)createStreamResponse, context))).thenCompose(v -> this.createSubscribersRecordIfAbsent(context))).thenApply(v -> createStreamResponse));
    }

    private CompletionStage<Void> createHistoryRecords(int startingSegmentNumber, CreateStreamResponse createStreamResponse, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        int numSegments = createStreamResponse.getConfiguration().getScalingPolicy().getMinNumSegments();
        double keyRangeChunk = 1.0 / (double)numSegments;
        long creationTime = createStreamResponse.getTimestamp();
        ImmutableList.Builder builder = ImmutableList.builder();
        IntStream.range(0, numSegments).boxed().forEach(x -> builder.add((Object)this.newSegmentRecord(0, startingSegmentNumber + x, creationTime, (double)x.intValue() * keyRangeChunk, (double)(x + 1) * keyRangeChunk)));
        EpochRecord epoch0 = new EpochRecord(0, 0, (ImmutableList<StreamSegmentRecord>)builder.build(), creationTime, 0L, 0L);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.createEpochRecord(epoch0, context).thenCompose(r -> this.createHistoryChunk(epoch0, context))).thenCompose(r -> this.createSealedSegmentSizeMapShardIfAbsent(0, context))).thenCompose(r -> this.createRetentionSetDataIfAbsent(new RetentionSet((ImmutableList<StreamCutReferenceRecord>)ImmutableList.of()), context))).thenCompose(r -> this.createCurrentEpochRecordDataIfAbsent(epoch0, context));
    }

    private CompletionStage<Void> createHistoryChunk(EpochRecord epoch0, OperationContext context) {
        HistoryTimeSeriesRecord record = new HistoryTimeSeriesRecord(0, 0, (ImmutableList<StreamSegmentRecord>)ImmutableList.of(), epoch0.getSegments(), epoch0.getCreationTime());
        return this.createHistoryTimeSeriesChunk(0, record, context);
    }

    private CompletableFuture<Void> createHistoryTimeSeriesChunk(int chunkNumber, HistoryTimeSeriesRecord epoch, OperationContext context) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HistoryTimeSeries timeSeries = new HistoryTimeSeries((ImmutableList<HistoryTimeSeriesRecord>)builder.add((Object)epoch).build());
        return this.createHistoryTimeSeriesChunkDataIfAbsent(chunkNumber, timeSeries, context);
    }

    @Override
    public CompletableFuture<Void> delete(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.deleteStream(context);
    }

    @Override
    public CompletableFuture<Void> startTruncation(Map<Long, Long> streamCut, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getTruncationRecord(context).thenCompose(existing -> {
            Preconditions.checkNotNull((Object)existing);
            Preconditions.checkArgument((!((StreamTruncationRecord)existing.getObject()).isUpdating() ? 1 : 0) != 0);
            long mostRecent = this.getMostRecent(streamCut);
            long oldest = this.getOldest(streamCut);
            int epochLow = NameUtils.getEpoch((long)oldest);
            int epochHigh = NameUtils.getEpoch((long)mostRecent);
            return this.fetchEpochs(epochLow, epochHigh, true, context).thenCompose(epochs -> {
                boolean isValid = this.isStreamCutValidInternal(streamCut, epochLow, (List<EpochRecord>)epochs);
                Exceptions.checkArgument((boolean)isValid, (String)"streamCut", (String)"invalid stream cut", (Object[])new Object[0]);
                ImmutableMap<StreamSegmentRecord, Integer> span = this.computeStreamCutSpanInternal(streamCut, epochLow, epochHigh, (List<EpochRecord>)epochs);
                StreamTruncationRecord previous = (StreamTruncationRecord)existing.getObject();
                Exceptions.checkArgument((boolean)this.streamCutEqualOrAfter(streamCut, (Map<StreamSegmentRecord, Integer>)span, (Map<Long, Long>)previous.getStreamCut(), (Map<StreamSegmentRecord, Integer>)previous.getSpan()), (String)"StreamCut", (String)"Supplied streamcut is behind previous truncation point", (Object[])new Object[0]);
                return this.computeTruncationRecord(previous, streamCut, span, context).thenCompose(prop -> Futures.toVoid(this.setTruncationData(new VersionedMetadata<StreamTruncationRecord>((StreamTruncationRecord)prop, existing.getVersion()), context)));
            });
        });
    }

    private boolean streamCutEqualOrAfter(Map<Long, Long> cut1, Map<StreamSegmentRecord, Integer> span1, Map<Long, Long> cut2, Map<StreamSegmentRecord, Integer> span2) {
        return span1.entrySet().stream().allMatch(e1 -> span2.entrySet().stream().noneMatch(e2 -> ((StreamSegmentRecord)e2.getKey()).segmentId() == ((StreamSegmentRecord)e1.getKey()).segmentId() && (Long)cut1.get(((StreamSegmentRecord)e1.getKey()).segmentId()) < (Long)cut2.get(((StreamSegmentRecord)e2.getKey()).segmentId()) || ((StreamSegmentRecord)e2.getKey()).overlaps((StreamSegmentRecord)e1.getKey()) && (Integer)e1.getValue() < (Integer)e2.getValue()));
    }

    private CompletableFuture<StreamTruncationRecord> computeTruncationRecord(StreamTruncationRecord previous, Map<Long, Long> streamCut, ImmutableMap<StreamSegmentRecord, Integer> span, OperationContext context) {
        log.debug(context.getRequestId(), "computing truncation for stream {}/{}", new Object[]{this.scope, this.name});
        CompletableFuture<ImmutableMap<StreamSegmentRecord, Integer>> previousSpanFuture = previous.getSpan().isEmpty() ? this.getEpochRecord(0, context).thenApply(epoch -> this.convertToSpan((EpochRecord)epoch)) : CompletableFuture.completedFuture(previous.getSpan());
        return ((CompletableFuture)previousSpanFuture.thenCompose(spanFrom -> this.segmentsBetweenStreamCutSpans((Map<StreamSegmentRecord, Integer>)spanFrom, (Map<StreamSegmentRecord, Integer>)span, context))).thenCompose(segmentsBetween -> this.sizeBetweenStreamCuts((Map<Long, Long>)previous.getStreamCut(), streamCut, (Set<StreamSegmentRecord>)segmentsBetween, context).thenApply(sizeBetween -> {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            segmentsBetween.stream().map(StreamSegmentRecord::segmentId).filter(x -> !streamCut.containsKey(x)).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
            return new StreamTruncationRecord((ImmutableMap<Long, Long>)ImmutableMap.copyOf((Map)streamCut), span, previous.getDeletedSegments(), (ImmutableSet<Long>)builder.build(), previous.getSizeTill() + sizeBetween, true);
        }));
    }

    @Override
    public CompletableFuture<Void> completeTruncation(VersionedMetadata<StreamTruncationRecord> record, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        Preconditions.checkNotNull(record);
        Preconditions.checkArgument((boolean)record.getObject().isUpdating());
        StreamTruncationRecord current = record.getObject();
        if (current.isUpdating()) {
            StreamTruncationRecord completedProp = StreamTruncationRecord.complete(current);
            return Futures.toVoid(this.setTruncationData(new VersionedMetadata<StreamTruncationRecord>(completedProp, record.getVersion()), context));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<VersionedMetadata<StreamTruncationRecord>> getTruncationRecord(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getTruncationData(true, context).thenApply(data -> {
            StreamTruncationRecord truncationRecord = (StreamTruncationRecord)data.getObject();
            return new VersionedMetadata<StreamTruncationRecord>(truncationRecord, data.getVersion());
        });
    }

    @Override
    public CompletableFuture<StreamCutComparison> compareStreamCuts(Map<Long, Long> streamcut1, Map<Long, Long> streamcut2, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        LongSummaryStatistics stats1 = streamcut1.keySet().stream().collect(Collectors.summarizingLong(Long::longValue));
        LongSummaryStatistics stats2 = streamcut1.keySet().stream().collect(Collectors.summarizingLong(Long::longValue));
        if (stats1.getMax() < stats2.getMin()) {
            return CompletableFuture.completedFuture(StreamCutComparison.Before);
        }
        if (stats2.getMax() < stats1.getMin()) {
            return CompletableFuture.completedFuture(StreamCutComparison.EqualOrAfter);
        }
        CompletableFuture<ImmutableMap<StreamSegmentRecord, Integer>> span1Future = this.computeStreamCutSpan(streamcut1, context);
        CompletableFuture<ImmutableMap<StreamSegmentRecord, Integer>> span2Future = this.computeStreamCutSpan(streamcut2, context);
        return CompletableFuture.allOf(span1Future, span2Future).thenApply(v -> {
            ImmutableMap span1 = (ImmutableMap)span1Future.join();
            ImmutableMap span2 = (ImmutableMap)span2Future.join();
            boolean foundGt = false;
            boolean foundLt = false;
            for (Map.Entry e1 : span1.entrySet()) {
                for (Map.Entry e2 : span2.entrySet()) {
                    int comparison;
                    if (((StreamSegmentRecord)e2.getKey()).segmentId() == ((StreamSegmentRecord)e1.getKey()).segmentId()) {
                        comparison = Long.compare((Long)streamcut1.get(((StreamSegmentRecord)e1.getKey()).segmentId()), (Long)streamcut2.get(((StreamSegmentRecord)e2.getKey()).segmentId()));
                    } else {
                        if (!((StreamSegmentRecord)e2.getKey()).overlaps((StreamSegmentRecord)e1.getKey())) continue;
                        comparison = Long.compare(((StreamSegmentRecord)e1.getKey()).segmentId(), ((StreamSegmentRecord)e2.getKey()).segmentId());
                    }
                    boolean bl = !foundGt ? comparison > 0 : (foundGt = foundGt);
                    foundLt = !foundLt ? comparison < 0 : foundLt;
                }
            }
            if (foundGt) {
                if (foundLt) {
                    return StreamCutComparison.Overlaps;
                }
                return StreamCutComparison.EqualOrAfter;
            }
            if (foundLt) {
                return StreamCutComparison.Before;
            }
            return StreamCutComparison.EqualOrAfter;
        });
    }

    @Override
    public CompletableFuture<StreamCutReferenceRecord> findStreamCutReferenceRecordBefore(Map<Long, Long> streamCut, RetentionSet retentionSet, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        HashMap fetched = new HashMap();
        int size = retentionSet.getRetentionRecords().size();
        if (retentionSet.getRetentionRecords().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.computeStreamCutSpan(streamCut, context).thenCompose(span1 -> {
            fetched.put(streamCut.keySet(), span1);
            Function<StreamCutReferenceRecord, CompletableFuture> fn = refRecord -> this.getStreamCutRecord((StreamCutReferenceRecord)refRecord, context).thenCompose(record -> {
                ImmutableMap sc = (ImmutableMap)fetched.get(record.getStreamCut().keySet());
                CompletionStage<Object> future = sc != null ? CompletableFuture.completedFuture(sc) : this.computeStreamCutSpan(record.getStreamCut(), context).thenApply(span2 -> {
                    fetched.put(record.getStreamCut().keySet(), span2);
                    return span2;
                });
                return future.thenApply(span2 -> {
                    boolean compare = this.streamCutEqualOrAfter(streamCut, (Map<StreamSegmentRecord, Integer>)span1, record.getStreamCut(), (Map<StreamSegmentRecord, Integer>)span2);
                    if (compare) {
                        return 1;
                    }
                    return -1;
                });
            });
            return this.binarySearch(0, size - 1, index -> {
                StreamCutReferenceRecord refRecord = (StreamCutReferenceRecord)retentionSet.getRetentionRecords().get(index.intValue());
                return ((CompletableFuture)fn.apply(refRecord)).thenCompose(compared -> {
                    if (compared == 1) {
                        if (index < size - 1) {
                            StreamCutReferenceRecord next = (StreamCutReferenceRecord)retentionSet.getRetentionRecords().get(index + 1);
                            return ((CompletableFuture)fn.apply(next)).thenApply(r -> r == 1 ? 1 : 0);
                        }
                        return CompletableFuture.completedFuture(0);
                    }
                    return CompletableFuture.completedFuture(compared);
                });
            });
        })).thenApply(refIndex -> {
            if (refIndex == null) {
                return null;
            }
            return (StreamCutReferenceRecord)retentionSet.getRetentionRecords().get(refIndex.intValue());
        });
    }

    private CompletableFuture<Integer> binarySearch(int start, int end, Function<Integer, CompletableFuture<Integer>> find) {
        if (end >= start) {
            int mid = (end + start) / 2;
            return find.apply(mid).thenCompose(found -> {
                if (found < 0) {
                    return this.binarySearch(start, mid - 1, find);
                }
                if (found == 0) {
                    return CompletableFuture.completedFuture(mid);
                }
                return this.binarySearch(mid + 1, end, find);
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> startUpdateConfiguration(StreamConfiguration newConfiguration, OperationContext context) {
        return this.getVersionedConfigurationRecord(context).thenCompose(configRecord -> {
            Preconditions.checkArgument((!((StreamConfigurationRecord)configRecord.getObject()).isUpdating() ? 1 : 0) != 0);
            StreamConfiguration oldCfg = ((StreamConfigurationRecord)configRecord.getObject()).getStreamConfiguration();
            HashSet<String> currentTags = new HashSet<String>(oldCfg.getTags());
            currentTags.removeAll(newConfiguration.getTags());
            StreamConfigurationRecord update = StreamConfiguration.isTagOnlyChange((StreamConfiguration)oldCfg, (StreamConfiguration)newConfiguration) ? StreamConfigurationRecord.updateTag(this.scope, this.name, newConfiguration, currentTags) : StreamConfigurationRecord.update(this.scope, this.name, newConfiguration, currentTags);
            return Futures.toVoid(this.setConfigurationData(new VersionedMetadata<StreamConfigurationRecord>(update, configRecord.getVersion()), context));
        });
    }

    @Override
    public CompletableFuture<Void> completeUpdateConfiguration(VersionedMetadata<StreamConfigurationRecord> existing, OperationContext context) {
        StreamConfigurationRecord current = existing.getObject();
        Preconditions.checkNotNull((Object)current);
        if (current.isUpdating()) {
            StreamConfigurationRecord newProperty = StreamConfigurationRecord.complete(this.scope, this.name, current.getStreamConfiguration());
            log.debug(context.getRequestId(), "Completing update configuration for stream {}/{}", new Object[]{this.scope, this.name});
            return Futures.toVoid(this.setConfigurationData(new VersionedMetadata<StreamConfigurationRecord>(newProperty, existing.getVersion()), context));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<StreamConfiguration> getConfiguration(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getConfigurationData(false, context).thenApply(x -> ((StreamConfigurationRecord)x.getObject()).getStreamConfiguration());
    }

    @Override
    public CompletableFuture<VersionedMetadata<StreamConfigurationRecord>> getVersionedConfigurationRecord(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getConfigurationData(true, context).thenApply(data -> new VersionedMetadata<StreamConfigurationRecord>((StreamConfigurationRecord)data.getObject(), data.getVersion()));
    }

    @Override
    public CompletableFuture<Void> updateState(State state, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getStateData(true, context).thenCompose(currState -> {
            VersionedMetadata<State> currentState = new VersionedMetadata<State>(((StateRecord)currState.getObject()).getState(), currState.getVersion());
            return Futures.toVoid(this.updateVersionedState(currentState, state, context));
        });
    }

    @Override
    public CompletableFuture<VersionedMetadata<State>> getVersionedState(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getStateData(true, context).thenApply(x -> new VersionedMetadata<State>(((StateRecord)x.getObject()).getState(), x.getVersion()));
    }

    @Override
    public CompletableFuture<VersionedMetadata<State>> updateVersionedState(VersionedMetadata<State> previous, State newState, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        if (State.isTransitionAllowed(previous.getObject(), newState)) {
            return this.setStateData(new VersionedMetadata<StateRecord>(StateRecord.builder().state(newState).build(), previous.getVersion()), context).thenApply(updatedVersion -> new VersionedMetadata<State>(newState, (Version)updatedVersion));
        }
        return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.OPERATION_NOT_ALLOWED, "Stream: " + this.getName() + " State: " + newState.name() + " current state = " + (Object)((Object)previous.getObject())));
    }

    @Override
    public CompletableFuture<Void> updateSubscriberStreamCut(VersionedMetadata<StreamSubscriber> previous, String subscriber, long generation, ImmutableMap<Long, Long> streamCut, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.isStreamCutValidForTruncation((Map<Long, Long>)previous.getObject().getTruncationStreamCut(), (Map<Long, Long>)streamCut, context).thenCompose(isValid -> {
            if (isValid.booleanValue()) {
                return Futures.toVoid(this.setSubscriberData(new VersionedMetadata<StreamSubscriber>(new StreamSubscriber(subscriber, generation, streamCut, System.currentTimeMillis()), previous.getVersion()), context));
            }
            return Futures.failedFuture((Throwable)StoreException.create(StoreException.Type.OPERATION_NOT_ALLOWED, "New StreamCut is lower than the previous value."));
        });
    }

    @Override
    public CompletableFuture<State> getState(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getStateData(ignoreCached, context).thenApply(x -> ((StateRecord)x.getObject()).getState());
    }

    @Override
    public CompletableFuture<StreamSegmentRecord> getSegment(long segmentId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        int epoch = NameUtils.getEpoch((long)segmentId);
        return this.getEpochRecord(epoch, context).thenApply(epochRecord -> {
            Optional<StreamSegmentRecord> segmentRecord = epochRecord.getSegments().stream().filter(x -> x.segmentId() == segmentId).findAny();
            return segmentRecord.orElseThrow(() -> StoreException.create(StoreException.Type.DATA_NOT_FOUND, "segment not found in epoch"));
        });
    }

    @Override
    public CompletableFuture<List<ScaleMetadata>> getScaleMetadata(long from, long to, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        CompletableFuture<Integer> fromEpoch = this.findEpochAtTime(from, false, context);
        CompletableFuture<Integer> toEpoch = this.findEpochAtTime(to, false, context);
        CompletionStage records = CompletableFuture.allOf(fromEpoch, toEpoch).thenCompose(x -> this.fetchEpochs((Integer)fromEpoch.join(), (Integer)toEpoch.join(), false, context));
        return ((CompletableFuture)records).thenApply(this::mapToScaleMetadata);
    }

    private List<ScaleMetadata> mapToScaleMetadata(List<EpochRecord> epochRecords) {
        AtomicReference previous = new AtomicReference();
        return epochRecords.stream().map(record -> {
            long splits = 0L;
            long merges = 0L;
            ImmutableList<StreamSegmentRecord> segments = record.getSegments();
            if (previous.get() != null) {
                splits = this.findSegmentSplitsMerges((List)previous.get(), (List<StreamSegmentRecord>)segments);
                merges = this.findSegmentSplitsMerges((List<StreamSegmentRecord>)segments, (List)previous.get());
            }
            previous.set(segments);
            return new ScaleMetadata(record.getCreationTime(), this.transform((List<StreamSegmentRecord>)segments), splits, merges);
        }).collect(Collectors.toList());
    }

    private long findSegmentSplitsMerges(List<StreamSegmentRecord> referenceSegmentsList, List<StreamSegmentRecord> targetSegmentsList) {
        return referenceSegmentsList.stream().filter(segment -> targetSegmentsList.stream().filter(target -> target.overlaps((StreamSegmentRecord)segment)).count() > 1L).count();
    }

    @Override
    public CompletableFuture<Integer> getSegmentSealedEpoch(long segmentId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getSegmentSealedRecordData(segmentId, context).handle((x, e) -> {
            if (e != null) {
                if (Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException) {
                    return -1;
                }
                throw new CompletionException((Throwable)e);
            }
            return (Integer)x.getObject();
        });
    }

    @Override
    public CompletableFuture<Set<Long>> getAllSegmentIds(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        CompletionStage fromSpanFuture = this.getTruncationRecord(context).thenCompose(truncationRecord -> {
            if (((StreamTruncationRecord)truncationRecord.getObject()).equals(StreamTruncationRecord.EMPTY)) {
                return this.getEpochRecord(0, context).thenApply(this::convertToSpan);
            }
            return CompletableFuture.completedFuture(((StreamTruncationRecord)truncationRecord.getObject()).getSpan());
        });
        CompletionStage toSpanFuture = this.getActiveEpoch(true, context).thenApply(this::convertToSpan);
        return CompletableFuture.allOf(new CompletableFuture[]{fromSpanFuture, toSpanFuture}).thenCompose(arg_0 -> this.lambda$getAllSegmentIds$55((CompletableFuture)fromSpanFuture, (CompletableFuture)toSpanFuture, context, arg_0));
    }

    @Override
    public CompletableFuture<Map<StreamSegmentRecord, List<Long>>> getSuccessorsWithPredecessors(long segmentId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getSegmentSealedEpoch(segmentId, context).thenCompose(sealedEpoch -> {
            if (sealedEpoch < 0) {
                return this.getActiveEpoch(true, context).thenApply(activeSegments -> Collections.emptyMap());
            }
            CompletableFuture<EpochRecord> sealedEpochFuture = this.getEpochRecord((int)sealedEpoch, context);
            CompletableFuture<EpochRecord> previousEpochFuture = this.getEpochRecord(sealedEpoch - 1, context);
            return CompletableFuture.allOf(sealedEpochFuture, previousEpochFuture).thenApply(x -> {
                EpochRecord sealedEpochRecord = (EpochRecord)sealedEpochFuture.join();
                EpochRecord previousEpochRecord = (EpochRecord)previousEpochFuture.join();
                Optional<StreamSegmentRecord> segmentOpt = previousEpochRecord.getSegments().stream().filter(r -> r.segmentId() == segmentId).findAny();
                assert (segmentOpt.isPresent());
                StreamSegmentRecord segment = segmentOpt.get();
                List successors = sealedEpochRecord.getSegments().stream().filter(r -> r.overlaps(segment)).collect(Collectors.toList());
                return successors.stream().collect(Collectors.toMap(record -> record, z -> previousEpochRecord.getSegments().stream().filter(predecessor -> predecessor.overlaps((StreamSegmentRecord)z)).map(StreamSegmentRecord::segmentId).collect(Collectors.toList())));
            });
        });
    }

    private CompletableFuture<EpochRecord> getActiveEpochRecord(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getCurrentEpochRecordData(ignoreCached, context).thenApply(VersionedMetadata::getObject);
    }

    @Override
    public CompletableFuture<List<StreamSegmentRecord>> getActiveSegments(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.verifyLegalState(context).thenCompose(v -> this.getActiveEpochRecord(true, context).thenApply(EpochRecord::getSegments));
    }

    @Override
    public CompletableFuture<Map<StreamSegmentRecord, Long>> getSegmentsAtHead(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getTruncationRecord(context).thenCompose(truncationRecord -> {
            if (((StreamTruncationRecord)truncationRecord.getObject()).equals(StreamTruncationRecord.EMPTY)) {
                return this.getSegmentsInEpoch(0, context).thenApply(segments -> segments.stream().collect(Collectors.toMap(x -> x, x -> 0L)));
            }
            return CompletableFuture.completedFuture(((StreamTruncationRecord)truncationRecord.getObject()).getStreamCut().entrySet().stream().collect(Collectors.toMap(x -> ((StreamTruncationRecord)truncationRecord.getObject()).getSpan().keySet().stream().filter(y -> y.segmentId() == ((Long)x.getKey()).longValue()).findFirst().get(), Map.Entry::getValue)));
        });
    }

    @Override
    public CompletableFuture<List<StreamSegmentRecord>> getSegmentsInEpoch(int epoch, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getEpochRecord(epoch, context).thenApply(EpochRecord::getSegments);
    }

    @Override
    public CompletableFuture<List<StreamSegmentRecord>> getSegmentsBetweenStreamCuts(Map<Long, Long> from, Map<Long, Long> to, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.segmentsBetweenStreamCuts(from, to, context).thenApply(ArrayList::new);
    }

    private CompletableFuture<ImmutableSet<StreamSegmentRecord>> segmentsBetweenStreamCuts(Map<Long, Long> from, Map<Long, Long> to, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        CompletableFuture<ImmutableMap<StreamSegmentRecord, Integer>> spanFromFuture = from.isEmpty() ? this.getEpochRecord(0, context).thenApply(this::convertToSpan) : this.computeStreamCutSpan(from, context);
        CompletableFuture<ImmutableMap<StreamSegmentRecord, Integer>> spanToFuture = to.isEmpty() ? this.getActiveEpochRecord(true, context).thenApply(this::convertToSpan) : this.computeStreamCutSpan(to, context);
        return CompletableFuture.allOf(spanFromFuture, spanToFuture).thenCompose(x -> {
            if (!from.isEmpty() && !to.isEmpty()) {
                Preconditions.checkArgument((boolean)RecordHelper.streamCutComparator(to, (Map)spanToFuture.join(), from, (Map)spanFromFuture.join()));
            }
            return this.segmentsBetweenStreamCutSpans((Map)spanFromFuture.join(), (Map)spanToFuture.join(), context);
        });
    }

    @VisibleForTesting
    CompletableFuture<ImmutableSet<StreamSegmentRecord>> segmentsBetweenStreamCutSpans(Map<StreamSegmentRecord, Integer> spanFrom, Map<StreamSegmentRecord, Integer> spanTo, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        int toLow = Collections.min(spanTo.values());
        int toHigh = Collections.max(spanTo.values());
        int fromLow = Collections.min(spanFrom.values());
        int fromHigh = Collections.max(spanFrom.values());
        HashSet segments = new HashSet();
        return ((CompletableFuture)this.fetchEpochs(fromLow, toHigh, true, context).thenAccept(epochs -> epochs.forEach(epoch -> {
            if (epoch.getEpoch() >= fromHigh && epoch.getEpoch() <= toLow) {
                segments.addAll(epoch.getSegments());
            } else {
                epoch.getSegments().stream().filter(x -> !segments.contains(x)).forEach(segment -> {
                    boolean greaterThanFrom = spanFrom.keySet().stream().filter(x -> x.overlaps((StreamSegmentRecord)segment)).allMatch(x -> x.segmentId() <= segment.segmentId());
                    boolean lessThanTo = spanTo.keySet().stream().filter(x -> x.overlaps((StreamSegmentRecord)segment)).allMatch(x -> segment.segmentId() <= x.segmentId());
                    if (greaterThanFrom && lessThanTo) {
                        segments.add(segment);
                    }
                });
            }
        }))).thenApply(x -> ImmutableSet.copyOf((Collection)segments));
    }

    @VisibleForTesting
    CompletableFuture<Long> sizeBetweenStreamCuts(Map<Long, Long> streamCutFrom, Map<Long, Long> streamCutTo, Set<StreamSegmentRecord> segmentsInBetween, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        Map<Integer, List<StreamSegmentRecord>> shards = segmentsInBetween.stream().collect(Collectors.groupingBy(x -> this.getShardNumber(x.segmentId())));
        return ((CompletableFuture)Futures.allOfWithResults(shards.entrySet().stream().map(entry -> this.getSealedSegmentSizeMapShard((Integer)entry.getKey(), context).thenApply(shardMap -> ((List)entry.getValue()).stream().collect(Collectors.toMap(x -> x, x -> {
            if (shardMap.getSize(x.segmentId()) == null) {
                return Long.MIN_VALUE;
            }
            return shardMap.getSize(x.segmentId());
        })))).collect(Collectors.toList())).thenApply(listOfMap -> listOfMap.stream().flatMap(s -> s.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).thenApply(sizes -> {
            AtomicLong sizeTill = new AtomicLong(0L);
            sizes.forEach((segment, value) -> {
                if (streamCutTo.containsKey(segment.segmentId()) && streamCutFrom.containsKey(segment.segmentId())) {
                    long sizeFrom = Math.max((Long)streamCutTo.get(segment.segmentId()), 0L);
                    long sizeTo = Math.max((Long)streamCutFrom.get(segment.segmentId()), 0L);
                    sizeTill.addAndGet(sizeFrom - sizeTo);
                } else if (streamCutTo.containsKey(segment.segmentId())) {
                    long sizeFrom = Math.max((Long)streamCutTo.get(segment.segmentId()), 0L);
                    sizeTill.addAndGet(sizeFrom);
                } else if (streamCutFrom.containsKey(segment.segmentId())) {
                    long sizeTo = Math.max((Long)streamCutFrom.get(segment.segmentId()), 0L);
                    sizeTill.addAndGet(Math.max(value, 0L) - sizeTo);
                } else {
                    sizeTill.addAndGet(Math.max(value, 0L));
                }
            });
            return sizeTill.get();
        });
    }

    @VisibleForTesting
    CompletableFuture<ImmutableMap<StreamSegmentRecord, Integer>> computeStreamCutSpan(Map<Long, Long> streamCut, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        long mostRecent = this.getMostRecent(streamCut);
        long oldest = this.getOldest(streamCut);
        int epochLow = NameUtils.getEpoch((long)oldest);
        int epochHigh = NameUtils.getEpoch((long)mostRecent);
        return this.fetchEpochs(epochLow, epochHigh, true, context).thenApply(epochs -> this.computeStreamCutSpanInternal(streamCut, epochLow, epochHigh, (List<EpochRecord>)epochs));
    }

    private Long getMostRecent(Map<Long, Long> streamCut) {
        return (Long)streamCut.keySet().stream().max(Comparator.naturalOrder()).get();
    }

    private Long getOldest(Map<Long, Long> streamCut) {
        return (Long)streamCut.keySet().stream().min(Comparator.naturalOrder()).get();
    }

    private ImmutableMap<StreamSegmentRecord, Integer> computeStreamCutSpanInternal(Map<Long, Long> streamCut, int epochLow, int epochHigh, List<EpochRecord> epochs) {
        ArrayList<Long> toFind = new ArrayList<Long>(streamCut.keySet());
        ImmutableMap.Builder resultSet = ImmutableMap.builder();
        for (int i = epochHigh - epochLow; i >= 0 && !toFind.isEmpty(); --i) {
            EpochRecord epochRecord = epochs.get(i);
            Set<Long> epochSegments = epochRecord.getSegmentIds();
            List found = toFind.stream().filter(epochSegments::contains).collect(Collectors.toList());
            resultSet.putAll(found.stream().collect(Collectors.toMap(x -> epochRecord.getSegments().stream().filter(z -> z.segmentId() == x.longValue()).findFirst().get(), x -> epochRecord.getEpoch())));
            toFind.removeAll(epochSegments);
        }
        return resultSet.build();
    }

    @Override
    public CompletableFuture<Boolean> isStreamCutValid(Map<Long, Long> streamCut, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        long mostRecent = this.getMostRecent(streamCut);
        long oldest = this.getOldest(streamCut);
        int epochLow = NameUtils.getEpoch((long)oldest);
        int epochHigh = NameUtils.getEpoch((long)mostRecent);
        return this.fetchEpochs(epochLow, epochHigh, true, context).thenApply(epochs -> this.isStreamCutValidInternal(streamCut, epochLow, (List<EpochRecord>)epochs));
    }

    private boolean isStreamCutValidInternal(Map<Long, Long> streamCut, int epochLow, List<EpochRecord> epochs) {
        HashSet segmentsInStreamCut = new HashSet();
        HashSet futureSegment = new HashSet();
        boolean isValid = true;
        streamCut.forEach((key, value) -> {
            int epoch = NameUtils.getEpoch((long)key);
            int index = epoch - epochLow;
            EpochRecord epochRecord = (EpochRecord)epochs.get(index);
            StreamSegmentRecord segmentRecord = epochRecord.getSegment((long)key);
            if (value < 0L) {
                futureSegment.add(segmentRecord);
            } else {
                segmentsInStreamCut.add(segmentRecord);
            }
        });
        isValid = futureSegment.stream().allMatch(x -> segmentsInStreamCut.stream().filter(y -> y.overlaps((StreamSegmentRecord)x)).allMatch(y -> y.segmentId() < x.segmentId()));
        if (isValid) {
            double end2;
            List sorted = segmentsInStreamCut.stream().sorted(Comparator.comparingDouble(StreamSegmentRecord::getKeyStart)).collect(Collectors.toList());
            HashMap<Double, Double> missingRanges = new HashMap<Double, Double>();
            StreamSegmentRecord previous = (StreamSegmentRecord)sorted.get(0);
            BiFunction<Double, Double, Boolean> validate = (start, end) -> futureSegment.stream().anyMatch(x -> x.overlaps((double)start, (double)end));
            if (previous.getKeyStart() > 0.0) {
                double start2 = 0.0;
                end2 = previous.getKeyStart();
                missingRanges.put(start2, end2);
                isValid = validate.apply(start2, end2);
            }
            for (int i = 1; i < sorted.size(); ++i) {
                StreamSegmentRecord next = (StreamSegmentRecord)sorted.get(i);
                if (previous.getKeyEnd() < next.getKeyStart()) {
                    double start3 = previous.getKeyEnd();
                    double end3 = next.getKeyStart();
                    missingRanges.put(start3, end3);
                    isValid = validate.apply(start3, end3);
                    if (!isValid) {
                        break;
                    }
                } else if (previous.getKeyEnd() > next.getKeyStart()) {
                    isValid = false;
                    break;
                }
                previous = next;
            }
            if (previous.getKeyEnd() < 1.0) {
                double start4 = previous.getKeyEnd();
                end2 = 1.0;
                missingRanges.put(start4, end2);
                isValid = validate.apply(start4, end2);
            }
            if (isValid) {
                ArrayList toCheck = new ArrayList();
                HashSet<StreamSegmentRecord> fullyReadFrom = new HashSet<StreamSegmentRecord>();
                missingRanges.entrySet().forEach(x -> toCheck.addAll(this.findSegmentsForMissingRange((EpochRecord)epochs.get(0), (Map.Entry<Double, Double>)x)));
                while (!toCheck.isEmpty()) {
                    StreamSegmentRecord segmentRecord = (StreamSegmentRecord)toCheck.get(0);
                    if (!(fullyReadFrom.contains(segmentRecord) || segmentsInStreamCut.contains(segmentRecord) || futureSegment.contains(segmentRecord))) {
                        block2: for (StreamSegmentRecord s : segmentsInStreamCut) {
                            int index;
                            if (!s.overlaps(segmentRecord)) continue;
                            if (s.segmentId() < segmentRecord.segmentId()) {
                                if (!futureSegment.contains(segmentRecord)) {
                                    return false;
                                }
                                fullyReadFrom.add(segmentRecord);
                                continue;
                            }
                            fullyReadFrom.add(segmentRecord);
                            int segmentEpoch = NameUtils.getEpoch((long)segmentRecord.segmentId());
                            for (int i = index = segmentEpoch - epochLow; i < epochs.size(); ++i) {
                                if (epochs.get(i).containsSegment(segmentRecord.segmentId())) continue;
                                epochs.get(i).getSegments().forEach(x -> {
                                    if (x.overlaps(segmentRecord)) {
                                        toCheck.add(x);
                                    }
                                });
                                continue block2;
                            }
                        }
                    }
                    toCheck.remove(segmentRecord);
                }
            }
        }
        return isValid;
    }

    private List<StreamSegmentRecord> findSegmentsForMissingRange(EpochRecord epochRecord, Map.Entry<Double, Double> missingRange) {
        return epochRecord.getSegments().stream().filter(x -> x.overlaps((Double)missingRange.getKey(), (Double)missingRange.getValue())).collect(Collectors.toList());
    }

    private CompletableFuture<Boolean> isStreamCutValidForTruncation(Map<Long, Long> previousStreamCut, Map<Long, Long> streamCut, OperationContext context) {
        if (previousStreamCut.isEmpty()) {
            return this.isStreamCutValid(streamCut, context);
        }
        return this.isStreamCutValid(streamCut, context).thenCompose(isValidStreamCut -> {
            if (isValidStreamCut.booleanValue()) {
                CompletableFuture<ImmutableMap<StreamSegmentRecord, Integer>> span1 = this.computeStreamCutSpan(streamCut, context);
                CompletableFuture<ImmutableMap<StreamSegmentRecord, Integer>> span2 = this.computeStreamCutSpan(previousStreamCut, context);
                return CompletableFuture.allOf(span1, span2).thenApply(v -> {
                    ImmutableMap span = (ImmutableMap)span1.join();
                    ImmutableMap previousSpan = (ImmutableMap)span2.join();
                    return this.streamCutEqualOrAfter(streamCut, (Map<StreamSegmentRecord, Integer>)span, previousStreamCut, (Map<StreamSegmentRecord, Integer>)previousSpan);
                });
            }
            return CompletableFuture.completedFuture(false);
        });
    }

    @Override
    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> submitScale(List<Long> segmentsToSeal, List<Map.Entry<Double, Double>> newRanges, long scaleTimestamp, VersionedMetadata<EpochTransitionRecord> existing, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return ((CompletableFuture)this.verifyNotSealed(context).thenCompose(v -> {
            if (existing == null) {
                return this.getEpochTransition(context);
            }
            return CompletableFuture.completedFuture(existing);
        })).thenCompose(record -> this.getActiveEpochRecord(true, context).thenCompose(currentEpoch -> this.getConfiguration(context).thenCompose(config -> {
            if (!((EpochTransitionRecord)record.getObject()).equals(EpochTransitionRecord.EMPTY)) {
                if (!RecordHelper.verifyRecordMatchesInput(segmentsToSeal, newRanges, false, (EpochTransitionRecord)record.getObject())) {
                    log.debug(context.getRequestId(), "scale conflict, another scale operation is ongoing", new Object[0]);
                    throw new EpochTransitionOperationExceptions.ConflictException();
                }
                return CompletableFuture.completedFuture(record);
            }
            if (!RecordHelper.canScaleFor(segmentsToSeal, currentEpoch)) {
                return this.updateEpochTransitionNode(new VersionedMetadata<EpochTransitionRecord>(EpochTransitionRecord.EMPTY, record.getVersion()), context).thenApply(x -> {
                    log.warn(context.getRequestId(), "scale precondition failed {}", new Object[]{segmentsToSeal});
                    throw new EpochTransitionOperationExceptions.PreConditionFailureException();
                });
            }
            if (!RecordHelper.validateInputRange(segmentsToSeal, newRanges, currentEpoch)) {
                log.error(context.getRequestId(), "scale input invalid {} {}", new Object[]{segmentsToSeal, newRanges});
                throw new EpochTransitionOperationExceptions.InputInvalidException();
            }
            int numberOfSegmentsPostScale = currentEpoch.getSegments().size() - segmentsToSeal.size() + newRanges.size();
            if (numberOfSegmentsPostScale < config.getScalingPolicy().getMinNumSegments()) {
                log.warn(context.getRequestId(), "Scale cannot be performed as Min Segment Count will not hold {} {}", new Object[]{segmentsToSeal, newRanges});
                throw new EpochTransitionOperationExceptions.PreConditionFailureException();
            }
            EpochTransitionRecord epochTransition = RecordHelper.computeEpochTransition(currentEpoch, segmentsToSeal, newRanges, scaleTimestamp);
            return this.updateEpochTransitionNode(new VersionedMetadata<EpochTransitionRecord>(epochTransition, record.getVersion()), context).thenApply(version -> {
                log.info(context.getRequestId(), "scale for stream {}/{} accepted. Segments to seal = {}", new Object[]{this.scope, this.name, epochTransition.getSegmentsToSeal()});
                return new VersionedMetadata<EpochTransitionRecord>(epochTransition, (Version)version);
            });
        })));
    }

    private CompletableFuture<Void> verifyNotSealed(OperationContext context) {
        return this.getState(false, context).thenAccept(state -> {
            if (state.equals((Object)State.SEALING) || state.equals((Object)State.SEALED)) {
                throw StoreException.create(StoreException.Type.ILLEGAL_STATE, "Stream: " + this.getName() + " State: " + state.name());
            }
        });
    }

    @Override
    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> startScale(boolean isManualScale, VersionedMetadata<EpochTransitionRecord> record, VersionedMetadata<State> state, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        Preconditions.checkArgument((boolean)state.getObject().equals((Object)State.SCALING));
        return this.getCurrentEpochRecordData(true, context).thenCompose(currentEpoch -> {
            EpochRecord currentEpochRecord = (EpochRecord)currentEpoch.getObject();
            if (isManualScale) {
                return this.migrateManualScaleToNewEpoch(record, state, currentEpochRecord, context);
            }
            return this.discardInconsistentEpochTransition(record, state, currentEpochRecord, context);
        });
    }

    private CompletableFuture<VersionedMetadata<EpochTransitionRecord>> discardInconsistentEpochTransition(VersionedMetadata<EpochTransitionRecord> epochTransition, VersionedMetadata<State> state, EpochRecord currentEpoch, OperationContext context) {
        if (epochTransition.getObject().getNewEpoch() > currentEpoch.getEpoch()) {
            return CompletableFuture.completedFuture(epochTransition);
        }
        return ((CompletableFuture)this.updateEpochTransitionNode(new VersionedMetadata<EpochTransitionRecord>(EpochTransitionRecord.EMPTY, epochTransition.getVersion()), context).thenCompose(v -> this.updateVersionedState(state, State.ACTIVE, context))).thenApply(v -> {
            log.warn(context.getRequestId(), "Scale epoch transition record is inconsistent with VersionedMetadata in the table. {}", new Object[]{((EpochTransitionRecord)epochTransition.getObject()).getNewEpoch()});
            throw new IllegalStateException("Epoch transition record is inconsistent.");
        });
    }

    @Override
    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> scaleCreateNewEpoch(VersionedMetadata<EpochTransitionRecord> versionedMetadata, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getActiveEpochRecord(true, context).thenCompose(currentEpoch -> {
            if (currentEpoch.getEpoch() < ((EpochTransitionRecord)versionedMetadata.getObject()).getNewEpoch()) {
                EpochTransitionRecord epochTransition = (EpochTransitionRecord)versionedMetadata.getObject();
                long time = Math.max(epochTransition.getTime(), currentEpoch.getCreationTime() + 1L);
                ImmutableList.Builder newSegmentsBuilder = ImmutableList.builder();
                epochTransition.getNewSegmentsWithRange().forEach((key, value) -> newSegmentsBuilder.add((Object)this.newSegmentRecord((long)key, time, (Double)value.getKey(), (Double)value.getValue())));
                ImmutableList.Builder sealedSegmentsBuilder = ImmutableList.builder();
                epochTransition.getSegmentsToSeal().forEach(x -> sealedSegmentsBuilder.add((Object)currentEpoch.getSegment((long)x)));
                ImmutableList.Builder builder = ImmutableList.builder();
                currentEpoch.getSegments().forEach(x -> {
                    if (!epochTransition.getSegmentsToSeal().contains((Object)x.segmentId())) {
                        builder.add(x);
                    }
                });
                ImmutableList newSegments = newSegmentsBuilder.build();
                builder.addAll((Iterable)newSegments);
                ImmutableList newEpochSegments = builder.build();
                return this.getSplitMergeCountsTillEpoch((EpochRecord)currentEpoch, context).thenCompose(cumulativeSplitMergeCount -> {
                    EpochRecord epochRecord = new EpochRecord(epochTransition.getNewEpoch(), epochTransition.getNewEpoch(), (ImmutableList<StreamSegmentRecord>)newEpochSegments, time, this.getNewEpochSplitCount((Long)cumulativeSplitMergeCount.getKey(), currentEpoch.getSegments(), (ImmutableList<StreamSegmentRecord>)newEpochSegments), this.getNewEpochMergeCount((Long)cumulativeSplitMergeCount.getValue(), currentEpoch.getSegments(), (ImmutableList<StreamSegmentRecord>)newEpochSegments));
                    HistoryTimeSeriesRecord timeSeriesRecord = new HistoryTimeSeriesRecord(epochTransition.getNewEpoch(), epochTransition.getNewEpoch(), (ImmutableList<StreamSegmentRecord>)sealedSegmentsBuilder.build(), (ImmutableList<StreamSegmentRecord>)newSegments, epochRecord.getCreationTime());
                    return ((CompletableFuture)((CompletableFuture)this.createEpochRecord(epochRecord, context).thenCompose(x -> this.updateHistoryTimeSeries(timeSeriesRecord, context))).thenCompose(x -> this.createSegmentSealedEpochRecords((Collection<Long>)epochTransition.getSegmentsToSeal(), epochTransition.getNewEpoch(), context))).thenApply(x -> versionedMetadata);
                });
            }
            return CompletableFuture.completedFuture(versionedMetadata);
        });
    }

    @Override
    public CompletableFuture<AbstractMap.SimpleEntry<Long, Long>> getSplitMergeCountsTillEpoch(EpochRecord epochRecord, OperationContext context) {
        if (epochRecord.hasSplitMergeCounts()) {
            return CompletableFuture.completedFuture(new AbstractMap.SimpleEntry<Long, Long>(epochRecord.getSplits(), epochRecord.getMerges()));
        }
        return ((CompletableFuture)this.fetchEpochs(0, epochRecord.getEpoch(), true, context).thenApply(this::mapToScaleMetadata)).thenApply(scaleMetadataList -> {
            AtomicLong totalNumSplits = new AtomicLong(0L);
            AtomicLong totalNumMerges = new AtomicLong(0L);
            scaleMetadataList.forEach(x -> {
                totalNumMerges.addAndGet(x.getMerges());
                totalNumSplits.addAndGet(x.getSplits());
            });
            return new AbstractMap.SimpleEntry<Long, Long>(totalNumSplits.get(), totalNumMerges.get());
        });
    }

    private long getNewEpochSplitCount(long splitCountPrevEpoch, ImmutableList<StreamSegmentRecord> lastEpochSegments, ImmutableList<StreamSegmentRecord> newEpochSegments) {
        if (splitCountPrevEpoch == -1L) {
            return -1L;
        }
        return splitCountPrevEpoch + this.findSegmentSplitsMerges((List<StreamSegmentRecord>)lastEpochSegments, (List<StreamSegmentRecord>)newEpochSegments);
    }

    private long getNewEpochMergeCount(long mergeCountPrevEpoch, ImmutableList<StreamSegmentRecord> lastEpochSegments, ImmutableList<StreamSegmentRecord> newEpochSegments) {
        if (mergeCountPrevEpoch == -1L) {
            return -1L;
        }
        return mergeCountPrevEpoch + this.findSegmentSplitsMerges((List<StreamSegmentRecord>)newEpochSegments, (List<StreamSegmentRecord>)lastEpochSegments);
    }

    private CompletableFuture<Void> updateHistoryTimeSeries(HistoryTimeSeriesRecord record, OperationContext context) {
        boolean isFirst;
        int historyChunk = record.getEpoch() / this.historyChunkSize.get();
        boolean bl = isFirst = record.getEpoch() % this.historyChunkSize.get() == 0;
        if (isFirst) {
            return this.createHistoryTimeSeriesChunk(historyChunk, record, context);
        }
        return this.getHistoryTimeSeriesChunkData(historyChunk, true, context).thenCompose(x -> {
            HistoryTimeSeries historyChunkTimeSeries = (HistoryTimeSeries)x.getObject();
            if (historyChunkTimeSeries.getLatestRecord().getEpoch() < record.getEpoch()) {
                HistoryTimeSeries update = HistoryTimeSeries.addHistoryRecord(historyChunkTimeSeries, record);
                return Futures.toVoid(this.updateHistoryTimeSeriesChunkData(historyChunk, new VersionedMetadata<HistoryTimeSeries>(update, x.getVersion()), context));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<VersionedMetadata<EpochTransitionRecord>> migrateManualScaleToNewEpoch(VersionedMetadata<EpochTransitionRecord> versionedMetadata, VersionedMetadata<State> versionedState, EpochRecord currentEpoch, OperationContext context) {
        EpochTransitionRecord epochTransition = versionedMetadata.getObject();
        return this.getEpochRecord(epochTransition.getActiveEpoch(), context).thenCompose(epochRecordActiveEpoch -> {
            if (epochTransition.getActiveEpoch() == currentEpoch.getEpoch()) {
                return CompletableFuture.completedFuture(versionedMetadata);
            }
            if (currentEpoch.getEpoch() > epochTransition.getActiveEpoch() && currentEpoch.getReferenceEpoch() == epochRecordActiveEpoch.getReferenceEpoch()) {
                List<Long> duplicateSegmentsToSeal = epochTransition.getSegmentsToSeal().stream().map(seg -> NameUtils.computeSegmentId((int)NameUtils.getSegmentNumber((long)seg), (int)currentEpoch.getEpoch())).collect(Collectors.toList());
                EpochTransitionRecord updatedRecord = RecordHelper.computeEpochTransition(currentEpoch, duplicateSegmentsToSeal, Lists.newArrayList((Iterable)epochTransition.getNewSegmentsWithRange().values()), epochTransition.getTime());
                return this.updateEpochTransitionNode(new VersionedMetadata<EpochTransitionRecord>(updatedRecord, versionedMetadata.getVersion()), context).thenApply(v -> new VersionedMetadata<EpochTransitionRecord>(updatedRecord, (Version)v));
            }
            return ((CompletableFuture)this.updateEpochTransitionNode(new VersionedMetadata<EpochTransitionRecord>(EpochTransitionRecord.EMPTY, versionedMetadata.getVersion()), context).thenCompose(v -> this.updateVersionedState(versionedState, State.ACTIVE, context))).thenApply(v -> {
                log.warn(context.getRequestId(), "Scale epoch transition record is inconsistent with VersionedMetadata in the table. {}", new Object[]{epochTransition.getNewEpoch()});
                throw new IllegalStateException("Epoch transition record is inconsistent.");
            });
        });
    }

    @Override
    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> getEpochTransition(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getEpochTransitionNode(context).thenApply(x -> new VersionedMetadata<EpochTransitionRecord>((EpochTransitionRecord)x.getObject(), x.getVersion()));
    }

    @Override
    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> resetEpochTransition(VersionedMetadata<EpochTransitionRecord> record, OperationContext context) {
        Preconditions.checkNotNull(record);
        return this.updateEpochTransitionNode(new VersionedMetadata<EpochTransitionRecord>(EpochTransitionRecord.EMPTY, record.getVersion()), context).thenApply(v -> new VersionedMetadata<EpochTransitionRecord>(EpochTransitionRecord.EMPTY, (Version)v));
    }

    private CompletableFuture<Void> clearMarkers(Set<Long> segments, OperationContext context) {
        return Futures.toVoid((CompletableFuture)Futures.allOfWithResults(((java.util.stream.Stream)segments.stream().parallel()).map(x -> this.removeColdMarker((long)x, context)).collect(Collectors.toList())));
    }

    @Override
    public CompletableFuture<Void> scaleOldSegmentsSealed(Map<Long, Long> sealedSegmentSizes, VersionedMetadata<EpochTransitionRecord> record, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        EpochTransitionRecord epochTransition = record.getObject();
        return Futures.toVoid((CompletableFuture)((CompletableFuture)this.clearMarkers((Set<Long>)epochTransition.getSegmentsToSeal(), context).thenCompose(x -> this.updateSealedSegmentSizes(sealedSegmentSizes, context))).thenCompose(x -> this.updateCurrentEpochRecord(epochTransition.getNewEpoch(), context)));
    }

    @Override
    public CompletableFuture<Void> completeScale(VersionedMetadata<EpochTransitionRecord> record, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        Preconditions.checkNotNull(record);
        Preconditions.checkArgument((!record.getObject().equals(EpochTransitionRecord.EMPTY) ? 1 : 0) != 0);
        return Futures.toVoid(this.updateEpochTransitionNode(new VersionedMetadata<EpochTransitionRecord>(EpochTransitionRecord.EMPTY, record.getVersion()), context));
    }

    @Override
    public CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> startRollingTxn(int activeEpoch, VersionedMetadata<CommittingTransactionsRecord> existing, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        CommittingTransactionsRecord record = existing.getObject();
        if (record.isRollingTxnRecord()) {
            return CompletableFuture.completedFuture(existing);
        }
        CommittingTransactionsRecord update = record.createRollingTxnRecord(activeEpoch);
        return this.updateCommittingTxnRecord(new VersionedMetadata<CommittingTransactionsRecord>(update, existing.getVersion()), context).thenApply(version -> new VersionedMetadata<CommittingTransactionsRecord>(update, (Version)version));
    }

    @Override
    public CompletableFuture<Void> rollingTxnCreateDuplicateEpochs(Map<Long, Long> sealedTxnEpochSegments, long time, VersionedMetadata<CommittingTransactionsRecord> record, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        Preconditions.checkArgument((boolean)record.getObject().isRollingTxnRecord());
        CommittingTransactionsRecord committingTxnRecord = record.getObject();
        return this.getActiveEpoch(true, context).thenCompose(activeEpochRecord -> this.getEpochRecord(committingTxnRecord.getEpoch(), context).thenCompose(transactionEpochRecord -> {
            if (activeEpochRecord.getEpoch() > committingTxnRecord.getCurrentEpoch()) {
                log.debug(context.getRequestId(), "Duplicate Epochs {} already created. Ignore.", new Object[]{committingTxnRecord.getNewActiveEpoch()});
                return CompletableFuture.completedFuture(null);
            }
            long timeStamp = Math.max(activeEpochRecord.getCreationTime() + 1L, time);
            ImmutableList.Builder duplicateTxnSegmentsBuilder = ImmutableList.builder();
            transactionEpochRecord.getSegments().stream().forEach(x -> duplicateTxnSegmentsBuilder.add((Object)this.newSegmentRecord(NameUtils.computeSegmentId((int)NameUtils.getSegmentNumber((long)x.segmentId()), (int)committingTxnRecord.getNewTxnEpoch()), timeStamp, x.getKeyStart(), x.getKeyEnd())));
            ImmutableList.Builder duplicateActiveSegmentsBuilder = ImmutableList.builder();
            activeEpochRecord.getSegments().stream().forEach(x -> duplicateActiveSegmentsBuilder.add((Object)this.newSegmentRecord(NameUtils.computeSegmentId((int)NameUtils.getSegmentNumber((long)x.segmentId()), (int)committingTxnRecord.getNewActiveEpoch()), timeStamp + 1L, x.getKeyStart(), x.getKeyEnd())));
            CompletionStage txnEpochFuture = this.getSplitMergeCountsTillEpoch((EpochRecord)activeEpochRecord, context).thenCompose(txnSplitMergeCount -> {
                ImmutableList duplicateTxnEpochSegments = duplicateTxnSegmentsBuilder.build();
                EpochRecord duplicateTxnEpoch = new EpochRecord(committingTxnRecord.getNewTxnEpoch(), transactionEpochRecord.getReferenceEpoch(), (ImmutableList<StreamSegmentRecord>)duplicateTxnEpochSegments, timeStamp, this.getNewEpochSplitCount((Long)txnSplitMergeCount.getKey(), activeEpochRecord.getSegments(), (ImmutableList<StreamSegmentRecord>)duplicateTxnEpochSegments), this.getNewEpochMergeCount((Long)txnSplitMergeCount.getValue(), activeEpochRecord.getSegments(), (ImmutableList<StreamSegmentRecord>)duplicateTxnEpochSegments));
                return CompletableFuture.completedFuture(duplicateTxnEpoch);
            });
            CompletionStage activeEpochFuture = ((CompletableFuture)txnEpochFuture).thenCompose(previousEpoch -> this.getSplitMergeCountsTillEpoch((EpochRecord)previousEpoch, context).thenCompose(prevSplitMergeCounts -> {
                ImmutableList activeEpochSegments = duplicateActiveSegmentsBuilder.build();
                EpochRecord duplicateActiveEpoch = new EpochRecord(committingTxnRecord.getNewActiveEpoch(), activeEpochRecord.getReferenceEpoch(), (ImmutableList<StreamSegmentRecord>)activeEpochSegments, timeStamp + 1L, this.getNewEpochSplitCount((Long)prevSplitMergeCounts.getKey(), previousEpoch.getSegments(), (ImmutableList<StreamSegmentRecord>)activeEpochSegments), this.getNewEpochMergeCount((Long)prevSplitMergeCounts.getValue(), previousEpoch.getSegments(), (ImmutableList<StreamSegmentRecord>)activeEpochSegments));
                return CompletableFuture.completedFuture(duplicateActiveEpoch);
            }));
            return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{txnEpochFuture, activeEpochFuture}).thenCompose(arg_0 -> this.lambda$rollingTxnCreateDuplicateEpochs$148((CompletableFuture)txnEpochFuture, (CompletableFuture)activeEpochFuture, timeStamp, context, activeEpochRecord, arg_0))).thenCompose(r -> this.updateSealedSegmentSizes(sealedTxnEpochSegments, context));
        }));
    }

    @Override
    public CompletableFuture<Void> completeRollingTxn(Map<Long, Long> sealedActiveEpochSegments, VersionedMetadata<CommittingTransactionsRecord> versionedMetadata, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getActiveEpoch(true, context).thenCompose(activeEpochRecord -> {
            CommittingTransactionsRecord committingTxnRecord = (CommittingTransactionsRecord)versionedMetadata.getObject();
            int activeEpoch = committingTxnRecord.getCurrentEpoch();
            if (activeEpochRecord.getEpoch() == activeEpoch) {
                return ((CompletableFuture)this.updateSealedSegmentSizes(sealedActiveEpochSegments, context).thenCompose(x -> this.clearMarkers(sealedActiveEpochSegments.keySet(), context))).thenCompose(x -> this.updateCurrentEpochRecord(committingTxnRecord.getNewActiveEpoch(), context));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<UUID> generateNewTxnId(int msb32Bit, long lsb64Bit, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getActiveEpochRecord(true, context).thenApply(epochRecord -> RecordHelper.generateTxnId(epochRecord.getReferenceEpoch(), msb32Bit, lsb64Bit));
    }

    @Override
    public CompletableFuture<VersionedTransactionData> createTransaction(UUID txnId, long lease, long maxExecutionTime, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        long current = System.currentTimeMillis();
        long leaseTimestamp = current + lease;
        long maxExecTimestamp = current + maxExecutionTime;
        int epoch = RecordHelper.getTransactionEpoch(txnId);
        ActiveTxnRecord record = ActiveTxnRecord.builder().txnStatus(TxnStatus.OPEN).leaseExpiryTime(leaseTimestamp).txCreationTimestamp(current).maxExecutionExpiryTime(maxExecTimestamp).writerId(Optional.empty()).commitTime(Optional.empty()).commitOrder(Optional.empty()).build();
        return this.verifyNotSealed(context).thenCompose(v -> this.createNewTransaction(epoch, txnId, record, context).thenApply(version -> new VersionedTransactionData(epoch, txnId, (Version)version, TxnStatus.OPEN, current, maxExecTimestamp, "", Long.MIN_VALUE, Long.MIN_VALUE, (ImmutableMap<Long, Long>)ImmutableMap.of())));
    }

    @Override
    public CompletableFuture<VersionedTransactionData> pingTransaction(VersionedTransactionData txnData, long lease, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        int epoch = txnData.getEpoch();
        UUID txnId = txnData.getId();
        Version version = txnData.getVersion();
        long creationTime = txnData.getCreationTime();
        long maxExecutionExpiryTime = txnData.getMaxExecutionExpiryTime();
        TxnStatus status = txnData.getStatus();
        String writerId = txnData.getWriterId();
        long commitTime = txnData.getCommitTime();
        long position = txnData.getCommitOrder();
        ImmutableMap<Long, Long> commitOffsets = txnData.getCommitOffsets();
        ActiveTxnRecord newData = new ActiveTxnRecord(creationTime, System.currentTimeMillis() + lease, maxExecutionExpiryTime, status, writerId, commitTime, position, commitOffsets);
        VersionedMetadata<ActiveTxnRecord> data = new VersionedMetadata<ActiveTxnRecord>(newData, version);
        return this.updateActiveTx(epoch, txnId, data, context).thenApply(updatedVersion -> new VersionedTransactionData(epoch, txnId, (Version)updatedVersion, status, creationTime, maxExecutionExpiryTime, writerId, commitTime, position, commitOffsets));
    }

    @Override
    public CompletableFuture<VersionedTransactionData> getTransactionData(UUID txId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        int epoch = RecordHelper.getTransactionEpoch(txId);
        return this.getActiveTx(epoch, txId, context).thenApply(data -> {
            ActiveTxnRecord activeTxnRecord = (ActiveTxnRecord)data.getObject();
            return new VersionedTransactionData(epoch, txId, data.getVersion(), activeTxnRecord.getTxnStatus(), activeTxnRecord.getTxCreationTimestamp(), activeTxnRecord.getMaxExecutionExpiryTime(), activeTxnRecord.getWriterId(), activeTxnRecord.getCommitTime(), activeTxnRecord.getCommitOrder(), activeTxnRecord.getCommitOffsets());
        });
    }

    @Override
    public CompletableFuture<TxnStatus> checkTransactionStatus(UUID txId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        int epoch = RecordHelper.getTransactionEpoch(txId);
        return ((CompletableFuture)this.getActiveTx(epoch, txId, context).handle((ok, ex) -> {
            if (ex != null && Exceptions.unwrap((Throwable)ex) instanceof StoreException.DataNotFoundException) {
                return TxnStatus.UNKNOWN;
            }
            if (ex != null) {
                throw new CompletionException((Throwable)ex);
            }
            return ((ActiveTxnRecord)ok.getObject()).getTxnStatus();
        })).thenCompose(x -> {
            if (x.equals((Object)TxnStatus.UNKNOWN)) {
                return this.getCompletedTxnStatus(txId, context);
            }
            return CompletableFuture.completedFuture(x);
        });
    }

    private CompletableFuture<TxnStatus> getCompletedTxnStatus(UUID txId, OperationContext context) {
        return this.getCompletedTx(txId, context).handle((ok, ex) -> {
            if (ex != null && Exceptions.unwrap((Throwable)ex) instanceof StoreException.DataNotFoundException) {
                return TxnStatus.UNKNOWN;
            }
            if (ex != null) {
                throw new CompletionException((Throwable)ex);
            }
            return ((CompletedTxnRecord)ok.getObject()).getCompletionStatus();
        });
    }

    @Override
    public CompletableFuture<AbstractMap.SimpleEntry<TxnStatus, Integer>> sealTransaction(UUID txId, boolean commit, Optional<Version> version, String writerId, long timestamp, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        int epoch = RecordHelper.getTransactionEpoch(txId);
        return ((CompletableFuture)this.sealActiveTxn(epoch, txId, commit, version, writerId, timestamp, context).exceptionally(ex -> new AbstractMap.SimpleEntry<TxnStatus, Object>(this.handleDataNotFoundException((Throwable)ex), null))).thenCompose(pair -> {
            if (pair.getKey() == TxnStatus.UNKNOWN) {
                return this.validateCompletedTxn(txId, commit, context).thenApply(status -> new AbstractMap.SimpleEntry<TxnStatus, Object>((TxnStatus)((Object)((Object)status)), null));
            }
            return CompletableFuture.completedFuture(pair);
        });
    }

    private CompletableFuture<AbstractMap.SimpleEntry<TxnStatus, Integer>> sealActiveTxn(int epoch, UUID txId, boolean commit, Optional<Version> version, String writerId, long timestamp, OperationContext context) {
        return this.getActiveTx(epoch, txId, context).thenCompose(data -> {
            ActiveTxnRecord txnRecord = (ActiveTxnRecord)data.getObject();
            Version dataVersion = version.orElseGet(data::getVersion);
            TxnStatus status = txnRecord.getTxnStatus();
            switch (status) {
                case OPEN: {
                    return this.sealActiveTx(epoch, txId, commit, txnRecord, dataVersion, writerId, timestamp, context).thenApply(y -> new AbstractMap.SimpleEntry<TxnStatus, Integer>(commit ? TxnStatus.COMMITTING : TxnStatus.ABORTING, epoch));
                }
                case COMMITTING: 
                case COMMITTED: {
                    if (commit) {
                        return CompletableFuture.completedFuture(new AbstractMap.SimpleEntry<TxnStatus, Integer>(status, epoch));
                    }
                    throw StoreException.create(StoreException.Type.ILLEGAL_STATE, "Stream: " + this.getName() + " Transaction: " + txId.toString() + " State: " + status.name());
                }
                case ABORTING: 
                case ABORTED: {
                    if (commit) {
                        throw StoreException.create(StoreException.Type.ILLEGAL_STATE, "Stream: " + this.getName() + " Transaction: " + txId.toString() + " State: " + status.name());
                    }
                    return CompletableFuture.completedFuture(new AbstractMap.SimpleEntry<TxnStatus, Integer>(status, epoch));
                }
            }
            throw StoreException.create(StoreException.Type.DATA_NOT_FOUND, "Stream: " + this.getName() + " Transaction: " + txId.toString());
        });
    }

    private CompletableFuture<Version> sealActiveTx(int epoch, UUID txId, boolean commit, ActiveTxnRecord previous, Version version, String writerId, long timestamp, OperationContext context) {
        CompletionStage<Object> future = commit ? (!previous.getTxnStatus().equals((Object)TxnStatus.COMMITTING) ? this.addTxnToCommitOrder(txId, context).thenApply(position -> new ActiveTxnRecord(previous.getTxCreationTimestamp(), previous.getLeaseExpiryTime(), previous.getMaxExecutionExpiryTime(), TxnStatus.COMMITTING, writerId, timestamp, (long)position)) : CompletableFuture.completedFuture(previous)) : CompletableFuture.completedFuture(new ActiveTxnRecord(previous.getTxCreationTimestamp(), previous.getLeaseExpiryTime(), previous.getMaxExecutionExpiryTime(), TxnStatus.ABORTING));
        return future.thenCompose(updated -> {
            VersionedMetadata<ActiveTxnRecord> data = new VersionedMetadata<ActiveTxnRecord>((ActiveTxnRecord)updated, version);
            return this.updateActiveTx(epoch, txId, data, context);
        });
    }

    @Override
    public CompletableFuture<Void> recordCommitOffsets(UUID txnId, Map<Long, Long> commitOffsets, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        int epoch = RecordHelper.getTransactionEpoch(txnId);
        return Futures.exceptionallyExpecting((CompletableFuture)this.getActiveTx(epoch, txnId, context).thenCompose(txnRecord -> {
            ActiveTxnRecord activeTxnRecord = (ActiveTxnRecord)txnRecord.getObject();
            Preconditions.checkArgument((boolean)activeTxnRecord.getTxnStatus().equals((Object)TxnStatus.COMMITTING));
            if (activeTxnRecord.getCommitOffsets().isEmpty()) {
                ActiveTxnRecord updated = new ActiveTxnRecord(activeTxnRecord.getTxCreationTimestamp(), activeTxnRecord.getLeaseExpiryTime(), activeTxnRecord.getMaxExecutionExpiryTime(), TxnStatus.COMMITTING, activeTxnRecord.getWriterId(), activeTxnRecord.getCommitTime(), activeTxnRecord.getCommitOrder(), (ImmutableMap<Long, Long>)ImmutableMap.copyOf((Map)commitOffsets));
                return Futures.toVoid(this.updateActiveTx(epoch, txnId, new VersionedMetadata<ActiveTxnRecord>(updated, txnRecord.getVersion()), context));
            }
            return CompletableFuture.completedFuture(null);
        }), AbstractStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, null);
    }

    CompletableFuture<Void> generateMarksForTransactions(OperationContext context, Map<String, TxnWriterMark> writerMarks) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        Preconditions.checkArgument((writerMarks != null ? 1 : 0) != 0);
        List noteTimeFutures = writerMarks.entrySet().stream().map(x -> Futures.exceptionallyExpecting(this.noteWriterMark((String)x.getKey(), ((TxnWriterMark)x.getValue()).getTimestamp(), ((TxnWriterMark)x.getValue()).getPosition(), context), AbstractStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, null)).collect(Collectors.toList());
        return Futures.allOf(noteTimeFutures);
    }

    @VisibleForTesting
    public CompletableFuture<TxnStatus> commitTransaction(UUID txId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        int epoch = RecordHelper.getTransactionEpoch(txId);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.checkTransactionStatus(txId, context).thenApply(x -> {
            switch (x) {
                case COMMITTING: 
                case COMMITTED: {
                    return x;
                }
                case OPEN: 
                case ABORTING: 
                case ABORTED: {
                    throw StoreException.create(StoreException.Type.ILLEGAL_STATE, String.format("Stream: %s Transaction: %s State: %s", this.getName(), txId.toString(), x.toString()));
                }
            }
            throw StoreException.create(StoreException.Type.DATA_NOT_FOUND, String.format("Stream: %s Transaction: %s", this.getName(), txId.toString()));
        })).thenCompose(x -> {
            if (x.equals((Object)TxnStatus.COMMITTING)) {
                return this.createCompletedTxEntry(txId, new CompletedTxnRecord(System.currentTimeMillis(), TxnStatus.COMMITTED), context);
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(x -> this.removeActiveTxEntry(epoch, txId, context))).thenApply(x -> TxnStatus.COMMITTED);
    }

    @Override
    public CompletableFuture<TxnStatus> abortTransaction(UUID txId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        int epoch = RecordHelper.getTransactionEpoch(txId);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.checkTransactionStatus(txId, context).thenApply(x -> {
            switch (x) {
                case ABORTING: 
                case ABORTED: {
                    return x;
                }
                case COMMITTING: 
                case OPEN: 
                case COMMITTED: {
                    throw StoreException.create(StoreException.Type.ILLEGAL_STATE, "Stream: " + this.getName() + " Transaction: " + txId.toString() + " State: " + x.name());
                }
            }
            throw StoreException.create(StoreException.Type.DATA_NOT_FOUND, "Stream: " + this.getName() + " Transaction: " + txId.toString());
        })).thenCompose(x -> {
            if (x.equals((Object)TxnStatus.ABORTING)) {
                return this.createCompletedTxEntry(txId, new CompletedTxnRecord(System.currentTimeMillis(), TxnStatus.ABORTED), context);
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(y -> this.removeActiveTxEntry(epoch, txId, context))).thenApply(y -> TxnStatus.ABORTED);
    }

    private TxnStatus handleDataNotFoundException(Throwable ex) {
        if (Exceptions.unwrap((Throwable)ex) instanceof StoreException.DataNotFoundException) {
            return TxnStatus.UNKNOWN;
        }
        throw ex;
    }

    private CompletableFuture<TxnStatus> validateCompletedTxn(UUID txId, boolean commit, OperationContext context) {
        return this.getCompletedTxnStatus(txId, context).thenApply(status -> {
            if (commit && status == TxnStatus.COMMITTED || !commit && status == TxnStatus.ABORTED) {
                return status;
            }
            if (status == TxnStatus.UNKNOWN) {
                throw StoreException.create(StoreException.Type.DATA_NOT_FOUND, "Stream: " + this.getName() + " Transaction: " + txId.toString());
            }
            throw StoreException.create(StoreException.Type.ILLEGAL_STATE, "Stream: " + this.getName() + " Transaction: " + txId.toString() + " State: " + status.name());
        });
    }

    @Override
    public CompletableFuture<EpochRecord> getActiveEpoch(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getCurrentEpochRecordData(ignoreCached, context).thenApply(VersionedMetadata::getObject);
    }

    @Override
    public CompletableFuture<EpochRecord> getEpochRecord(int epoch, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getEpochRecordData(epoch, context).thenApply(VersionedMetadata::getObject);
    }

    @Override
    public CompletableFuture<Void> setColdMarker(long segmentId, long timestamp, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getMarkerData(segmentId, context).thenCompose(x -> {
            if (x != null) {
                VersionedMetadata<Long> data = new VersionedMetadata<Long>(timestamp, x.getVersion());
                return Futures.toVoid(this.updateMarkerData(segmentId, data, context));
            }
            return this.createMarkerData(segmentId, timestamp, context);
        });
    }

    @Override
    public CompletableFuture<Long> getColdMarker(long segmentId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getMarkerData(segmentId, context).thenApply(x -> x != null ? (Long)x.getObject() : 0L);
    }

    @Override
    public CompletableFuture<Void> removeColdMarker(long segmentId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.removeMarkerData(segmentId, context);
    }

    @Override
    public CompletableFuture<Long> getSizeTillStreamCut(Map<Long, Long> streamCut, Optional<StreamCutRecord> reference, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        Map<Long, Long> referenceStreamCut = reference.map(StreamCutRecord::getStreamCut).orElse(Collections.emptyMap());
        return this.segmentsBetweenStreamCuts(referenceStreamCut, streamCut, context).thenCompose(segmentsInBetween -> this.sizeBetweenStreamCuts(referenceStreamCut, streamCut, (Set<StreamSegmentRecord>)segmentsInBetween, context).thenApply(sizeBetween -> sizeBetween + reference.map(StreamCutRecord::getRecordingSize).orElse(0L)));
    }

    @Override
    public CompletableFuture<Void> addStreamCutToRetentionSet(StreamCutRecord record, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getRetentionSetData(context).thenCompose(data -> {
            RetentionSet retention = (RetentionSet)data.getObject();
            RetentionSet update = RetentionSet.addReferenceToStreamCutIfLatest(retention, record);
            return this.createStreamCutRecordData(record.getRecordingTime(), record, context).thenCompose(v -> Futures.toVoid(this.updateRetentionSetData(new VersionedMetadata<RetentionSet>(update, data.getVersion()), context)));
        });
    }

    @Override
    public CompletableFuture<RetentionSet> getRetentionSet(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getRetentionSetData(context).thenApply(VersionedMetadata::getObject);
    }

    @Override
    public CompletableFuture<StreamCutRecord> getStreamCutRecord(StreamCutReferenceRecord record, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getStreamCutRecordData(record.getRecordingTime(), context).thenApply(VersionedMetadata::getObject);
    }

    @Override
    public CompletableFuture<Void> deleteStreamCutBefore(StreamCutReferenceRecord record, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getRetentionSetData(context).thenCompose(data -> {
            RetentionSet retention = (RetentionSet)data.getObject();
            RetentionSet update = RetentionSet.removeStreamCutBefore(retention, record);
            List<StreamCutReferenceRecord> toRemove = retention.retentionRecordsBefore(record);
            return Futures.allOf((Collection)toRemove.stream().map(x -> this.deleteStreamCutRecordData(x.getRecordingTime(), context)).collect(Collectors.toList())).thenCompose(x -> Futures.toVoid(this.updateRetentionSetData(new VersionedMetadata<RetentionSet>(update, data.getVersion()), context)));
        });
    }

    @Override
    public CompletableFuture<Map.Entry<VersionedMetadata<CommittingTransactionsRecord>, List<VersionedTransactionData>>> startCommittingTransactions(int limit, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getVersionedCommitTransactionsRecord(context).thenCompose(versioned -> {
            if (((CommittingTransactionsRecord)versioned.getObject()).equals(CommittingTransactionsRecord.EMPTY)) {
                return this.getOrderedCommittingTxnInLowestEpoch(limit, context).thenCompose(list -> {
                    if (list.isEmpty()) {
                        LinkedList emptyTransactionData = new LinkedList();
                        return CompletableFuture.completedFuture(new AbstractMap.SimpleEntry((VersionedMetadata)versioned, emptyTransactionData));
                    }
                    ImmutableList.Builder txIdList = ImmutableList.builder();
                    list.forEach(x -> txIdList.add((Object)x.getId()));
                    List positions = list.stream().map(VersionedTransactionData::getCommitOrder).collect(Collectors.toList());
                    int epoch = RecordHelper.getTransactionEpoch(((VersionedTransactionData)list.get(0)).getId());
                    CommittingTransactionsRecord record = new CommittingTransactionsRecord(epoch, (ImmutableList<UUID>)txIdList.build());
                    return this.updateCommittingTxnRecord(new VersionedMetadata<CommittingTransactionsRecord>(record, versioned.getVersion()), context).thenCompose(version -> this.removeTxnsFromCommitOrder(positions, context).thenApply(v -> new AbstractMap.SimpleEntry<VersionedMetadata<CommittingTransactionsRecord>, List>(new VersionedMetadata<CommittingTransactionsRecord>(record, (Version)version), (List)list)));
                });
            }
            List<String> transactionsToCommit = ((CommittingTransactionsRecord)versioned.getObject()).getTransactionsToCommit().stream().map(UUID::toString).collect(Collectors.toList());
            return this.getVersionedTransactionRecords(((CommittingTransactionsRecord)versioned.getObject()).getEpoch(), transactionsToCommit, context).thenApply(x -> new AbstractMap.SimpleEntry<VersionedMetadata, List>((VersionedMetadata)versioned, (List)x));
        });
    }

    @Override
    public CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> getVersionedCommitTransactionsRecord(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation context cannot be null");
        return this.getCommitTxnRecord(context).thenApply(r -> new VersionedMetadata<CommittingTransactionsRecord>((CommittingTransactionsRecord)r.getObject(), r.getVersion()));
    }

    @Override
    public CompletableFuture<Void> completeCommittingTransactions(VersionedMetadata<CommittingTransactionsRecord> record, OperationContext context, Map<String, TxnWriterMark> writerMarks) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        CompletionStage<Void> future = this.generateMarksForTransactions(context, writerMarks);
        for (UUID txnId : record.getObject().getTransactionsToCommit()) {
            log.debug(context.getRequestId(), "Committing transaction {} on stream {}/{}", new Object[]{txnId, this.scope, this.name});
            future = future.thenCompose(x -> this.commitTransaction(txnId, context).thenAccept(done -> log.debug(context.getRequestId(), "transaction {} on stream {}/{} committed successfully", new Object[]{txnId, this.scope, this.name})));
        }
        return future.thenCompose(x -> Futures.toVoid(this.updateCommittingTxnRecord(new VersionedMetadata<CommittingTransactionsRecord>(CommittingTransactionsRecord.EMPTY, record.getVersion()), context)));
    }

    @Override
    public CompletableFuture<Void> createWaitingRequestIfAbsent(String processorName, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.createWaitingRequestNodeIfAbsent(processorName, context);
    }

    @Override
    public CompletableFuture<String> getWaitingRequestProcessor(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getWaitingRequestNode(context).handle((data, e) -> {
            if (e != null) {
                if (Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException) {
                    return null;
                }
                throw new CompletionException((Throwable)e);
            }
            return data;
        });
    }

    @Override
    public CompletableFuture<Void> deleteWaitingRequestConditionally(String processorName, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getWaitingRequestProcessor(context).thenCompose(waitingRequest -> {
            if (waitingRequest != null && waitingRequest.equals(processorName)) {
                return this.deleteWaitingRequestNode(context);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<WriterTimestampResponse> noteWriterMark(String writer, long timestamp, Map<Long, Long> position, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        ImmutableMap newPosition = ImmutableMap.copyOf(position);
        return Futures.exceptionallyExpecting(this.getWriterMarkRecord(writer, context), AbstractStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, null).thenCompose(record -> {
            if (record == null) {
                return ((CompletableFuture)this.createWriterMarkRecord(writer, timestamp, (ImmutableMap<Long, Long>)newPosition, context).exceptionally(e -> {
                    if (Exceptions.unwrap((Throwable)e) instanceof StoreException.DataExistsException) {
                        throw StoreException.create(StoreException.Type.WRITE_CONFLICT, "writer mark exists");
                    }
                    throw new CompletionException((Throwable)e);
                })).thenApply(v -> WriterTimestampResponse.SUCCESS);
            }
            if (((WriterMark)record.getObject()).getTimestamp() > timestamp) {
                return CompletableFuture.completedFuture(WriterTimestampResponse.INVALID_TIME);
            }
            if (!this.compareWriterPositions((Map<Long, Long>)((WriterMark)record.getObject()).getPosition(), (Map<Long, Long>)newPosition)) {
                return CompletableFuture.completedFuture(WriterTimestampResponse.INVALID_POSITION);
            }
            return this.updateWriterMarkRecord(writer, timestamp, (ImmutableMap<Long, Long>)newPosition, true, record.getVersion(), context).thenApply(v -> WriterTimestampResponse.SUCCESS);
        });
    }

    @Override
    public CompletableFuture<Void> shutdownWriter(String writer, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getWriterMarkRecord(writer, context).thenCompose(record -> this.updateWriterMarkRecord(writer, ((WriterMark)record.getObject()).getTimestamp(), ((WriterMark)record.getObject()).getPosition(), false, record.getVersion(), context));
    }

    @Override
    public CompletableFuture<Void> removeWriter(String writer, WriterMark writerMark, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return Futures.exceptionallyExpecting(this.getWriterMarkRecord(writer, context), AbstractStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, null).thenCompose(record -> {
            if (record == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (writerMark.equals(record.getObject())) {
                return this.removeWriterRecord(writer, record.getVersion(), context);
            }
            throw StoreException.create(StoreException.Type.WRITE_CONFLICT, "Writer mark supplied for removal doesn't match stored writer mark");
        });
    }

    @VisibleForTesting
    boolean compareWriterPositions(Map<Long, Long> position1, Map<Long, Long> position2) {
        boolean compareMaxes;
        long maxInPos2 = position2.keySet().stream().filter(position1::containsKey).max(Long::compare).orElse(Long.MIN_VALUE);
        long maxInPos1 = position1.keySet().stream().filter(position2::containsKey).max(Long::compare).orElse(Long.MIN_VALUE);
        boolean bl = compareMaxes = maxInPos2 >= maxInPos1;
        if (compareMaxes) {
            return position2.entrySet().stream().filter(x -> position1.containsKey(x.getKey())).allMatch(x -> (Long)x.getValue() >= (Long)position1.get(x.getKey()));
        }
        return false;
    }

    @Override
    public CompletableFuture<WriterMark> getWriterMark(String writer, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getWriterMarkRecord(writer, context).thenApply(VersionedMetadata::getObject);
    }

    protected CompletableFuture<List<VersionedTransactionData>> getOrderedCommittingTxnInLowestEpochHelper(ZkOrderedStore txnCommitOrderer, int limit, Executor executor, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return Futures.exceptionallyExpecting(txnCommitOrderer.getEntitiesWithPosition(this.getScope(), this.getName()), AbstractStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, Collections.emptyMap()).thenCompose(allTxns -> {
            Map<Integer, List<Map.Entry>> groupByEpoch = allTxns.entrySet().stream().collect(Collectors.groupingBy(x -> RecordHelper.getTransactionEpoch(UUID.fromString((String)x.getValue()))));
            Iterator iterator = groupByEpoch.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).iterator();
            ConcurrentSkipListSet toPurge = new ConcurrentSkipListSet();
            ConcurrentSkipListSet<VersionedTransactionData> transactionsData = new ConcurrentSkipListSet<VersionedTransactionData>(Comparator.comparingLong(VersionedTransactionData::getCommitOrder));
            return ((CompletableFuture)Futures.loop(() -> iterator.hasNext() && transactionsData.isEmpty(), () -> this.processTransactionsInEpoch((Map.Entry)iterator.next(), toPurge, transactionsData, limit, executor, context), (Executor)executor).thenCompose(v -> txnCommitOrderer.removeEntities(this.getScope(), this.getName(), toPurge))).thenApply(v -> transactionsData.stream().collect(Collectors.toList()));
        });
    }

    protected CompletableFuture<Map<Long, UUID>> getAllOrderedCommittingTxnsHelper(ZkOrderedStore txnCommitOrderer, OperationContext context) {
        return Futures.exceptionallyExpecting(txnCommitOrderer.getEntitiesWithPosition(this.getScope(), this.getName()), AbstractStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, Collections.emptyMap()).thenApply(map -> map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> UUID.fromString((String)x.getValue()))));
    }

    CompletableFuture<List<VersionedTransactionData>> getVersionedTransactionRecords(int epoch, List<String> txnIds, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return Futures.allOfWithResults(txnIds.stream().map(txnIdStr -> {
            UUID txnId = UUID.fromString(txnIdStr);
            return Futures.exceptionallyExpecting(this.getTransactionData(txnId, context), AbstractStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, (Object)VersionedTransactionData.EMPTY);
        }).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> processTransactionsInEpoch(Map.Entry<Integer, List<Map.Entry<Long, String>>> nextEpoch, ConcurrentSkipListSet<Long> toPurge, ConcurrentSkipListSet<VersionedTransactionData> transactionsMap, int limit, Executor executor, OperationContext context) {
        int epoch = nextEpoch.getKey();
        ArrayList orders = new ArrayList();
        ArrayList txnIds = new ArrayList();
        nextEpoch.getValue().stream().sorted(Comparator.comparingLong(Map.Entry::getKey)).forEach(x -> {
            orders.add((Long)x.getKey());
            txnIds.add((String)x.getValue());
        });
        AtomicInteger from = new AtomicInteger(0);
        AtomicInteger till = new AtomicInteger(Math.min(limit, txnIds.size()));
        return Futures.loop(() -> from.get() < txnIds.size() && transactionsMap.size() < limit, () -> this.getVersionedTransactionRecords(epoch, txnIds.subList(from.get(), till.get()), context).thenAccept(txns -> {
            block5: for (int i = 0; i < txns.size() && transactionsMap.size() < limit; ++i) {
                VersionedTransactionData txnRecord = (VersionedTransactionData)txns.get(i);
                int index = from.get() + i;
                UUID txnId = UUID.fromString((String)txnIds.get(index));
                long order = (Long)orders.get(index);
                switch (txnRecord.getStatus()) {
                    case COMMITTING: {
                        if (txnRecord.getCommitOrder() == order) {
                            transactionsMap.add(txnRecord);
                            continue block5;
                        }
                        log.debug(context.getRequestId(), "duplicate txn {} at position {}. removing {}", new Object[]{txnId, txnRecord.getCommitOrder(), order});
                        toPurge.add(order);
                        continue block5;
                    }
                    case OPEN: {
                        continue block5;
                    }
                    case COMMITTED: 
                    case ABORTING: 
                    case ABORTED: 
                    case UNKNOWN: {
                        log.debug(context.getRequestId(), "stale txn {} with status {}. removing {}", new Object[]{txnId, txnRecord.getStatus(), order});
                        toPurge.add(order);
                    }
                }
            }
            from.set(till.get());
            till.set(Math.min(from.get() + limit, txnIds.size()));
        }), (Executor)executor);
    }

    CompletableFuture<List<ActiveTxnRecord>> getTransactionRecords(int epoch, List<String> txnIds, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return Futures.allOfWithResults(txnIds.stream().map(txnIdStr -> {
            UUID txnId = UUID.fromString(txnIdStr);
            return Futures.exceptionallyExpecting((CompletableFuture)this.getActiveTx(epoch, txnId, context).thenApply(VersionedMetadata::getObject), AbstractStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, (Object)ActiveTxnRecord.EMPTY);
        }).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> verifyLegalState(OperationContext context) {
        return this.getState(false, context).thenApply(state -> {
            if (state == null || state.equals((Object)State.UNKNOWN) || state.equals((Object)State.CREATING)) {
                throw StoreException.create(StoreException.Type.ILLEGAL_STATE, "Stream: " + this.getName() + " State: " + state.name());
            }
            return null;
        });
    }

    private CompletableFuture<Void> createEpochRecord(EpochRecord epoch, OperationContext context) {
        return this.createEpochRecordDataIfAbsent(epoch.getEpoch(), epoch, context);
    }

    private CompletableFuture<Void> updateCurrentEpochRecord(int newActiveEpoch, OperationContext context) {
        return this.getEpochRecord(newActiveEpoch, context).thenCompose(epochRecord -> this.getCurrentEpochRecordData(true, context).thenCompose(currentEpochRecordData -> {
            EpochRecord existing = (EpochRecord)currentEpochRecordData.getObject();
            if (existing.getEpoch() < newActiveEpoch) {
                return Futures.toVoid(this.updateCurrentEpochRecordData(new VersionedMetadata<EpochRecord>((EpochRecord)epochRecord, currentEpochRecordData.getVersion()), context));
            }
            return CompletableFuture.completedFuture(null);
        }));
    }

    private CompletableFuture<Void> createSealedSegmentSizeMapShardIfAbsent(int shardNumber, OperationContext context) {
        SealedSegmentsMapShard shard = SealedSegmentsMapShard.builder().shardNumber(shardNumber).sealedSegmentsSizeMap(Collections.emptyMap()).build();
        return this.createSealedSegmentSizesMapShardDataIfAbsent(shardNumber, shard, context);
    }

    @Override
    public CompletableFuture<SealedSegmentsMapShard> getSealedSegmentSizeMapShard(int shard, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getSealedSegmentSizesMapShardData(shard, context).handle((r, e) -> {
            if (e != null) {
                if (Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException) {
                    return SealedSegmentsMapShard.builder().shardNumber(shard).sealedSegmentsSizeMap(Collections.emptyMap()).build();
                }
                throw new CompletionException((Throwable)e);
            }
            return (SealedSegmentsMapShard)r.getObject();
        });
    }

    private CompletableFuture<Void> updateSealedSegmentSizes(Map<Long, Long> sealedSegmentSizes, OperationContext context) {
        Map<Integer, List<Long>> shards = sealedSegmentSizes.keySet().stream().collect(Collectors.groupingBy(this::getShardNumber));
        return Futures.allOf((Collection)shards.entrySet().stream().map(x -> {
            int shard = (Integer)x.getKey();
            List segments = (List)x.getValue();
            return Futures.exceptionallyComposeExpecting(this.getSealedSegmentSizesMapShardData(shard, context), AbstractStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, () -> this.createSealedSegmentSizeMapShardIfAbsent(shard, context).thenCompose(v -> this.getSealedSegmentSizesMapShardData(shard, context))).thenCompose(mapShardData -> {
                SealedSegmentsMapShard mapShard = (SealedSegmentsMapShard)mapShardData.getObject();
                segments.forEach(z -> mapShard.addSealedSegmentSize((long)z, (Long)sealedSegmentSizes.get(z)));
                return this.updateSealedSegmentSizesMapShardData(shard, new VersionedMetadata<SealedSegmentsMapShard>(mapShard, mapShardData.getVersion()), context);
            });
        }).collect(Collectors.toList()));
    }

    private int getShardNumber(long segmentId) {
        return NameUtils.getEpoch((long)segmentId) / this.shardSize.get();
    }

    private ImmutableMap<StreamSegmentRecord, Integer> convertToSpan(EpochRecord epochRecord) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        epochRecord.getSegments().forEach(x -> builder.put(x, (Object)epochRecord.getEpoch()));
        return builder.build();
    }

    private Segment transform(StreamSegmentRecord segmentRecord) {
        return new Segment(segmentRecord.segmentId(), segmentRecord.getCreationTime(), segmentRecord.getKeyStart(), segmentRecord.getKeyEnd());
    }

    private List<Segment> transform(List<StreamSegmentRecord> segmentRecords) {
        return segmentRecords.stream().map(this::transform).collect(Collectors.toList());
    }

    @VisibleForTesting
    CompletableFuture<List<EpochRecord>> fetchEpochs(int fromEpoch, int toEpoch, boolean ignoreCache, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return ((CompletableFuture)((CompletableFuture)this.getActiveEpochRecord(ignoreCache, context).thenApply(currentEpoch -> currentEpoch.getEpoch() / this.historyChunkSize.get())).thenCompose(latestChunkNumber -> Futures.allOfWithResults(IntStream.range(fromEpoch / this.historyChunkSize.get(), toEpoch / this.historyChunkSize.get() + 1).mapToObj(i -> {
            int firstEpoch = Math.max(i * this.historyChunkSize.get(), fromEpoch);
            boolean ignoreCached = i >= latestChunkNumber;
            return this.getEpochsFromHistoryChunk(i, firstEpoch, toEpoch, ignoreCached, context);
        }).collect(Collectors.toList())))).thenApply(c -> c.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private CompletableFuture<List<EpochRecord>> getEpochsFromHistoryChunk(int chunk, int firstEpoch, int toEpoch, boolean ignoreCached, OperationContext context) {
        return this.getEpochRecord(firstEpoch, context).thenCompose(first -> this.getHistoryTimeSeriesChunk(chunk, ignoreCached, context).thenCompose(x -> {
            ArrayList<CompletableFuture<EpochRecord>> identity = new ArrayList<CompletableFuture<EpochRecord>>();
            identity.add(CompletableFuture.completedFuture(first));
            return Futures.allOfWithResults((List)x.getHistoryRecords().stream().filter(r -> r.getEpoch() > firstEpoch && r.getEpoch() <= toEpoch).reduce(identity, (r, s) -> {
                CompletableFuture<EpochRecord> next = this.newEpochRecord((CompletableFuture)r.get(r.size() - 1), s.getEpoch(), s.getReferenceEpoch(), (Collection<StreamSegmentRecord>)s.getSegmentsCreated(), s.getSegmentsSealed().stream().map(StreamSegmentRecord::segmentId).collect(Collectors.toList()), s.getScaleTime(), context);
                ArrayList<CompletableFuture<EpochRecord>> list = new ArrayList<CompletableFuture<EpochRecord>>((Collection<CompletableFuture<EpochRecord>>)r);
                list.add(next);
                return list;
            }, (r, s) -> {
                ArrayList list = new ArrayList(r);
                list.addAll(s);
                return list;
            }));
        }));
    }

    private CompletableFuture<EpochRecord> newEpochRecord(CompletableFuture<EpochRecord> lastRecordFuture, int epoch, int referenceEpoch, Collection<StreamSegmentRecord> createdSegments, Collection<Long> sealedSegments, long time, OperationContext context) {
        if (epoch == referenceEpoch) {
            return lastRecordFuture.thenApply(lastRecord -> {
                assert (lastRecord.getEpoch() == epoch - 1);
                ImmutableList.Builder segmentsBuilder = ImmutableList.builder();
                lastRecord.getSegments().forEach(segment -> {
                    if (!sealedSegments.contains(segment.segmentId())) {
                        segmentsBuilder.add(segment);
                    }
                });
                segmentsBuilder.addAll((Iterable)createdSegments);
                ImmutableList epochSegments = segmentsBuilder.build();
                if (!lastRecord.hasSplitMergeCounts()) {
                    return new EpochRecord(epoch, referenceEpoch, (ImmutableList<StreamSegmentRecord>)epochSegments, time, -1L, -1L);
                }
                return new EpochRecord(epoch, referenceEpoch, (ImmutableList<StreamSegmentRecord>)epochSegments, time, this.getNewEpochSplitCount(lastRecord.getSplits(), lastRecord.getSegments(), (ImmutableList<StreamSegmentRecord>)epochSegments), this.getNewEpochMergeCount(lastRecord.getMerges(), lastRecord.getSegments(), (ImmutableList<StreamSegmentRecord>)epochSegments));
            });
        }
        return this.getEpochRecord(epoch, context);
    }

    private StreamSegmentRecord newSegmentRecord(long segmentId, long time, Double low, Double high) {
        return this.newSegmentRecord(NameUtils.getEpoch((long)segmentId), NameUtils.getSegmentNumber((long)segmentId), time, low, high);
    }

    private StreamSegmentRecord newSegmentRecord(int epoch, int segmentNumber, long time, Double low, Double high) {
        return StreamSegmentRecord.builder().creationEpoch(epoch).segmentNumber(segmentNumber).creationTime(time).keyStart(low).keyEnd(high).build();
    }

    @VisibleForTesting
    CompletableFuture<Integer> findEpochAtTime(long timestamp, boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getActiveEpoch(ignoreCached, context).thenCompose(activeEpoch -> this.searchEpochAtTime(0, activeEpoch.getEpoch() / this.historyChunkSize.get(), x -> x == activeEpoch.getEpoch() / this.historyChunkSize.get(), timestamp, context).thenApply(epoch -> {
            if (epoch == -1) {
                if (timestamp > activeEpoch.getCreationTime()) {
                    return activeEpoch.getEpoch();
                }
                return 0;
            }
            return epoch;
        }));
    }

    private CompletableFuture<Integer> searchEpochAtTime(int lowest, int highest, Predicate<Integer> ignoreCached, long timestamp, OperationContext context) {
        int middle = (lowest + highest) / 2;
        if (lowest > highest) {
            return CompletableFuture.completedFuture(-1);
        }
        return this.getHistoryTimeSeriesChunk(middle, ignoreCached.test(middle), context).thenCompose(chunk -> {
            ImmutableList<HistoryTimeSeriesRecord> historyRecords = chunk.getHistoryRecords();
            long rangeLow = ((HistoryTimeSeriesRecord)historyRecords.get(0)).getScaleTime();
            long rangeHigh = ((HistoryTimeSeriesRecord)historyRecords.get(historyRecords.size() - 1)).getScaleTime();
            if (timestamp >= rangeLow && timestamp <= rangeHigh) {
                int index = CollectionHelpers.findGreatestLowerBound(historyRecords, x -> Long.compare(timestamp, x.getScaleTime()));
                assert (index >= 0);
                return CompletableFuture.completedFuture(((HistoryTimeSeriesRecord)historyRecords.get(index)).getEpoch());
            }
            if (timestamp < rangeLow) {
                return this.searchEpochAtTime(lowest, middle - 1, ignoreCached, timestamp, context);
            }
            return this.searchEpochAtTime(middle + 1, highest, ignoreCached, timestamp, context);
        });
    }

    @Override
    public CompletableFuture<HistoryTimeSeries> getHistoryTimeSeriesChunk(int chunkNumber, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getHistoryTimeSeriesChunk(chunkNumber, true, context);
    }

    private CompletableFuture<HistoryTimeSeries> getHistoryTimeSeriesChunk(int chunkNumber, boolean ignoreCached, OperationContext context) {
        return this.getHistoryTimeSeriesChunkData(chunkNumber, ignoreCached, context).thenCompose(x -> {
            HistoryTimeSeries timeSeries = (HistoryTimeSeries)x.getObject();
            if (!ignoreCached && timeSeries.getHistoryRecords().size() < this.historyChunkSize.get()) {
                return this.getHistoryTimeSeriesChunk(chunkNumber, true, context);
            }
            return CompletableFuture.completedFuture(timeSeries);
        });
    }

    abstract CompletableFuture<CreateStreamResponse> checkStreamExists(StreamConfiguration var1, long var2, int var4, OperationContext var5);

    abstract CompletableFuture<Void> createStreamMetadata(OperationContext var1);

    abstract CompletableFuture<Void> storeCreationTimeIfAbsent(long var1, OperationContext var3);

    abstract CompletableFuture<Void> deleteStream(OperationContext var1);

    abstract CompletableFuture<Void> createConfigurationIfAbsent(StreamConfigurationRecord var1, OperationContext var2);

    abstract CompletableFuture<Version> setConfigurationData(VersionedMetadata<StreamConfigurationRecord> var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<StreamConfigurationRecord>> getConfigurationData(boolean var1, OperationContext var2);

    abstract CompletableFuture<Void> createTruncationDataIfAbsent(StreamTruncationRecord var1, OperationContext var2);

    abstract CompletableFuture<Version> setTruncationData(VersionedMetadata<StreamTruncationRecord> var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<StreamTruncationRecord>> getTruncationData(boolean var1, OperationContext var2);

    abstract CompletableFuture<Void> createStateIfAbsent(StateRecord var1, OperationContext var2);

    abstract CompletableFuture<Version> setStateData(VersionedMetadata<StateRecord> var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<StateRecord>> getStateData(boolean var1, OperationContext var2);

    abstract CompletableFuture<Void> createSubscribersRecordIfAbsent(OperationContext var1);

    abstract CompletableFuture<Version> setSubscriberData(VersionedMetadata<StreamSubscriber> var1, OperationContext var2);

    abstract CompletableFuture<Void> createRetentionSetDataIfAbsent(RetentionSet var1, OperationContext var2);

    abstract CompletableFuture<Void> createStreamCutRecordData(long var1, StreamCutRecord var3, OperationContext var4);

    abstract CompletableFuture<VersionedMetadata<StreamCutRecord>> getStreamCutRecordData(long var1, OperationContext var3);

    abstract CompletableFuture<Void> deleteStreamCutRecordData(long var1, OperationContext var3);

    abstract CompletableFuture<Version> updateRetentionSetData(VersionedMetadata<RetentionSet> var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<RetentionSet>> getRetentionSetData(OperationContext var1);

    abstract CompletableFuture<Void> createHistoryTimeSeriesChunkDataIfAbsent(int var1, HistoryTimeSeries var2, OperationContext var3);

    abstract CompletableFuture<VersionedMetadata<HistoryTimeSeries>> getHistoryTimeSeriesChunkData(int var1, boolean var2, OperationContext var3);

    abstract CompletableFuture<Version> updateHistoryTimeSeriesChunkData(int var1, VersionedMetadata<HistoryTimeSeries> var2, OperationContext var3);

    abstract CompletableFuture<Void> createCurrentEpochRecordDataIfAbsent(EpochRecord var1, OperationContext var2);

    abstract CompletableFuture<Version> updateCurrentEpochRecordData(VersionedMetadata<EpochRecord> var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<EpochRecord>> getCurrentEpochRecordData(boolean var1, OperationContext var2);

    abstract CompletableFuture<Void> createEpochRecordDataIfAbsent(int var1, EpochRecord var2, OperationContext var3);

    abstract CompletableFuture<VersionedMetadata<EpochRecord>> getEpochRecordData(int var1, OperationContext var2);

    abstract CompletableFuture<Void> createSealedSegmentSizesMapShardDataIfAbsent(int var1, SealedSegmentsMapShard var2, OperationContext var3);

    abstract CompletableFuture<VersionedMetadata<SealedSegmentsMapShard>> getSealedSegmentSizesMapShardData(int var1, OperationContext var2);

    abstract CompletableFuture<Version> updateSealedSegmentSizesMapShardData(int var1, VersionedMetadata<SealedSegmentsMapShard> var2, OperationContext var3);

    abstract CompletableFuture<Void> createSegmentSealedEpochRecords(Collection<Long> var1, int var2, OperationContext var3);

    abstract CompletableFuture<VersionedMetadata<Integer>> getSegmentSealedRecordData(long var1, OperationContext var3);

    abstract CompletableFuture<Version> createNewTransaction(int var1, UUID var2, ActiveTxnRecord var3, OperationContext var4);

    abstract CompletableFuture<VersionedMetadata<ActiveTxnRecord>> getActiveTx(int var1, UUID var2, OperationContext var3);

    abstract CompletableFuture<Version> updateActiveTx(int var1, UUID var2, VersionedMetadata<ActiveTxnRecord> var3, OperationContext var4);

    abstract CompletableFuture<Long> addTxnToCommitOrder(UUID var1, OperationContext var2);

    abstract CompletableFuture<Void> removeTxnsFromCommitOrder(List<Long> var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<CompletedTxnRecord>> getCompletedTx(UUID var1, OperationContext var2);

    abstract CompletableFuture<Void> removeActiveTxEntry(int var1, UUID var2, OperationContext var3);

    abstract CompletableFuture<Void> createCompletedTxEntry(UUID var1, CompletedTxnRecord var2, OperationContext var3);

    abstract CompletableFuture<Map<UUID, ActiveTxnRecord>> getTxnInEpoch(int var1, OperationContext var2);

    abstract CompletableFuture<List<VersionedTransactionData>> getOrderedCommittingTxnInLowestEpoch(int var1, OperationContext var2);

    @VisibleForTesting
    abstract CompletableFuture<Map<Long, UUID>> getAllOrderedCommittingTxns(OperationContext var1);

    abstract CompletableFuture<Void> createMarkerData(long var1, long var3, OperationContext var5);

    abstract CompletableFuture<Version> updateMarkerData(long var1, VersionedMetadata<Long> var3, OperationContext var4);

    abstract CompletableFuture<Void> removeMarkerData(long var1, OperationContext var3);

    abstract CompletableFuture<VersionedMetadata<Long>> getMarkerData(long var1, OperationContext var3);

    abstract CompletableFuture<Void> createEpochTransitionIfAbsent(EpochTransitionRecord var1, OperationContext var2);

    abstract CompletableFuture<Version> updateEpochTransitionNode(VersionedMetadata<EpochTransitionRecord> var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<EpochTransitionRecord>> getEpochTransitionNode(OperationContext var1);

    abstract CompletableFuture<Void> createCommitTxnRecordIfAbsent(CommittingTransactionsRecord var1, OperationContext var2);

    abstract CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> getCommitTxnRecord(OperationContext var1);

    abstract CompletableFuture<Version> updateCommittingTxnRecord(VersionedMetadata<CommittingTransactionsRecord> var1, OperationContext var2);

    abstract CompletableFuture<Void> createWaitingRequestNodeIfAbsent(String var1, OperationContext var2);

    abstract CompletableFuture<String> getWaitingRequestNode(OperationContext var1);

    abstract CompletableFuture<Void> deleteWaitingRequestNode(OperationContext var1);

    abstract CompletableFuture<Void> createWriterMarkRecord(String var1, long var2, ImmutableMap<Long, Long> var4, OperationContext var5);

    abstract CompletableFuture<VersionedMetadata<WriterMark>> getWriterMarkRecord(String var1, OperationContext var2);

    abstract CompletableFuture<Void> updateWriterMarkRecord(String var1, long var2, ImmutableMap<Long, Long> var4, boolean var5, Version var6, OperationContext var7);

    abstract CompletableFuture<Void> removeWriterRecord(String var1, Version var2, OperationContext var3);

    private /* synthetic */ CompletionStage lambda$rollingTxnCreateDuplicateEpochs$148(CompletableFuture txnEpochFuture, CompletableFuture activeEpochFuture, long timeStamp, OperationContext context, EpochRecord activeEpochRecord, Void v) {
        EpochRecord duplicateTxnEpoch = (EpochRecord)txnEpochFuture.join();
        EpochRecord duplicateActiveEpoch = (EpochRecord)activeEpochFuture.join();
        HistoryTimeSeriesRecord timeSeriesRecordTxnEpoch = new HistoryTimeSeriesRecord(duplicateTxnEpoch.getEpoch(), duplicateTxnEpoch.getReferenceEpoch(), (ImmutableList<StreamSegmentRecord>)ImmutableList.of(), (ImmutableList<StreamSegmentRecord>)ImmutableList.of(), timeStamp);
        HistoryTimeSeriesRecord timeSeriesRecordActiveEpoch = new HistoryTimeSeriesRecord(duplicateActiveEpoch.getEpoch(), duplicateActiveEpoch.getReferenceEpoch(), (ImmutableList<StreamSegmentRecord>)ImmutableList.of(), (ImmutableList<StreamSegmentRecord>)ImmutableList.of(), timeStamp + 1L);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.createEpochRecord(duplicateTxnEpoch, context).thenCompose(x -> this.updateHistoryTimeSeries(timeSeriesRecordTxnEpoch, context))).thenCompose(x -> this.createEpochRecord(duplicateActiveEpoch, context))).thenCompose(x -> this.updateHistoryTimeSeries(timeSeriesRecordActiveEpoch, context))).thenCompose(x -> this.createSegmentSealedEpochRecords(activeEpochRecord.getSegments().stream().map(StreamSegmentRecord::segmentId).collect(Collectors.toList()), duplicateTxnEpoch.getEpoch(), context))).thenCompose(x -> this.createSegmentSealedEpochRecords(duplicateTxnEpoch.getSegments().stream().map(StreamSegmentRecord::segmentId).collect(Collectors.toList()), duplicateActiveEpoch.getEpoch(), context));
    }

    private /* synthetic */ CompletionStage lambda$getAllSegmentIds$55(CompletableFuture fromSpanFuture, CompletableFuture toSpanFuture, OperationContext context, Void v) {
        Map fromSpan = (Map)fromSpanFuture.join();
        Map toSpan = (Map)toSpanFuture.join();
        return this.segmentsBetweenStreamCutSpans(fromSpan, toSpan, context).thenApply(x -> x.stream().map(StreamSegmentRecord::segmentId).collect(Collectors.toSet()));
    }
}

