/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.store.PravegaTablesStoreHelper;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.AbstractReaderGroup;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ReaderGroupState;
import io.pravega.controller.store.stream.records.ReaderGroupConfigRecord;
import io.pravega.controller.store.stream.records.ReaderGroupStateRecord;
import io.pravega.shared.NameUtils;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.slf4j.LoggerFactory;

class PravegaTablesReaderGroup
extends AbstractReaderGroup {
    public static final String SEPARATOR = ".#.";
    private static final String READER_GROUPS_TABLE_IDENTIFIER = "_readergroups";
    private static final String METADATA_TABLE = "metadata.#.%s";
    private static final String CREATION_TIME_KEY = "creationTime";
    private static final String CONFIGURATION_KEY = "configuration";
    private static final String STATE_KEY = "state";
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(PravegaTablesReaderGroup.class));
    private final PravegaTablesStoreHelper storeHelper;
    private final BiFunction<Boolean, OperationContext, CompletableFuture<String>> readerGroupsInScopeTableNameSupplier;
    private final AtomicReference<String> idRef;

    @VisibleForTesting
    PravegaTablesReaderGroup(String scopeName, String rgName, PravegaTablesStoreHelper storeHelper, BiFunction<Boolean, OperationContext, CompletableFuture<String>> rgInScopeTableNameSupplier, ScheduledExecutorService executor) {
        super(scopeName, rgName);
        this.storeHelper = storeHelper;
        this.readerGroupsInScopeTableNameSupplier = rgInScopeTableNameSupplier;
        this.idRef = new AtomicReference<Object>(null);
    }

    private CompletableFuture<String> getId(OperationContext context) {
        String id = this.idRef.get();
        if (!Strings.isNullOrEmpty((String)id)) {
            return CompletableFuture.completedFuture(id);
        }
        return this.storeHelper.loadFromTableHandleStaleTableName(this.readerGroupsInScopeTableNameSupplier, this.getName(), PravegaTablesStoreHelper.BYTES_TO_UUID_FUNCTION, context).thenComposeAsync(data -> {
            this.idRef.compareAndSet(null, ((UUID)data.getObject()).toString());
            return this.getId(context);
        });
    }

    private CompletableFuture<String> getMetadataTable(OperationContext context) {
        return this.getId(context).thenApply(this::getMetadataTableName);
    }

    private String getMetadataTableName(String id) {
        return NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.getScope(), READER_GROUPS_TABLE_IDENTIFIER, this.getName(), String.format(METADATA_TABLE, id)});
    }

    @Override
    CompletableFuture<Void> createMetadataTables(OperationContext context) {
        return this.getId(context).thenCompose(id -> {
            String metadataTable = this.getMetadataTableName((String)id);
            return this.storeHelper.createTable(metadataTable, context.getRequestId()).thenAccept(v -> log.debug("reader group {}/{} metadata table {} created", new Object[]{this.getScope(), this.getName(), metadataTable}));
        });
    }

    @Override
    CompletableFuture<Void> storeCreationTimeIfAbsent(long creationTime, OperationContext context) {
        return Futures.toVoid((CompletableFuture)this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.addNewEntryIfAbsent((String)metadataTable, CREATION_TIME_KEY, creationTime, PravegaTablesStoreHelper.LONG_TO_BYTES_FUNCTION, context.getRequestId())));
    }

    @Override
    public CompletableFuture<Void> createConfigurationIfAbsent(ReaderGroupConfig configuration, OperationContext context) {
        ReaderGroupConfigRecord configRecord = ReaderGroupConfigRecord.update(configuration, 0L, false);
        return Futures.toVoid((CompletableFuture)this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.addNewEntryIfAbsent((String)metadataTable, CONFIGURATION_KEY, configRecord, ReaderGroupConfigRecord::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<Void> createStateIfAbsent(OperationContext context) {
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, STATE_KEY, ReaderGroupStateRecord.builder().state(ReaderGroupState.CREATING).build(), ReaderGroupStateRecord::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<Version> setStateData(VersionedMetadata<ReaderGroupStateRecord> state, OperationContext context) {
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, STATE_KEY, (ReaderGroupStateRecord)state.getObject(), ReaderGroupStateRecord::toBytes, state.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<ReaderGroupStateRecord>> getStateData(boolean ignoreCached, OperationContext context) {
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            if (ignoreCached) {
                this.storeHelper.invalidateCache((String)metadataTable, STATE_KEY);
            }
            return this.storeHelper.getCachedOrLoad((String)metadataTable, STATE_KEY, ReaderGroupStateRecord::fromBytes, ignoreCached ? context.getOperationStartTime() : 0L, context.getRequestId());
        });
    }

    @Override
    CompletableFuture<VersionedMetadata<ReaderGroupConfigRecord>> getConfigurationData(boolean ignoreCached, OperationContext context) {
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            if (ignoreCached) {
                this.storeHelper.invalidateCache((String)metadataTable, CONFIGURATION_KEY);
            }
            return this.storeHelper.getCachedOrLoad((String)metadataTable, CONFIGURATION_KEY, ReaderGroupConfigRecord::fromBytes, ignoreCached ? context.getOperationStartTime() : 0L, context.getRequestId());
        });
    }

    @Override
    public CompletableFuture<Void> delete(OperationContext context) {
        return this.getId(context).thenCompose(id -> this.storeHelper.deleteTable(this.getMetadataTableName((String)id), false, context.getRequestId()).thenCompose(v -> {
            this.idRef.set(null);
            return CompletableFuture.completedFuture(null);
        }));
    }

    @Override
    CompletableFuture<Version> setConfigurationData(VersionedMetadata<ReaderGroupConfigRecord> configuration, OperationContext context) {
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, CONFIGURATION_KEY, (ReaderGroupConfigRecord)configuration.getObject(), ReaderGroupConfigRecord::toBytes, configuration.getVersion(), context.getRequestId()));
    }

    @Override
    public void refresh() {
        this.idRef.set(null);
    }
}

