/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.store.PravegaTablesStoreHelper;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.AbstractStreamMetadataStore;
import io.pravega.controller.store.stream.CreateStreamResponse;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.PersistentStreamBase;
import io.pravega.controller.store.stream.PravegaTablesStreamMetadataStore;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.TxnStatus;
import io.pravega.controller.store.stream.TxnWriterMark;
import io.pravega.controller.store.stream.VersionedTransactionData;
import io.pravega.controller.store.stream.ZkOrderedStore;
import io.pravega.controller.store.stream.records.ActiveTxnRecord;
import io.pravega.controller.store.stream.records.CommittingTransactionsRecord;
import io.pravega.controller.store.stream.records.CompletedTxnRecord;
import io.pravega.controller.store.stream.records.EpochRecord;
import io.pravega.controller.store.stream.records.EpochTransitionRecord;
import io.pravega.controller.store.stream.records.HistoryTimeSeries;
import io.pravega.controller.store.stream.records.RetentionSet;
import io.pravega.controller.store.stream.records.SealedSegmentsMapShard;
import io.pravega.controller.store.stream.records.StateRecord;
import io.pravega.controller.store.stream.records.StreamConfigurationRecord;
import io.pravega.controller.store.stream.records.StreamCutRecord;
import io.pravega.controller.store.stream.records.StreamSubscriber;
import io.pravega.controller.store.stream.records.StreamTruncationRecord;
import io.pravega.controller.store.stream.records.Subscribers;
import io.pravega.controller.store.stream.records.WriterMark;
import io.pravega.shared.NameUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

class PravegaTablesStream
extends PersistentStreamBase {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(PravegaTablesStream.class));
    private static final String METADATA_TABLE = "metadata.#.%s";
    private static final String EPOCHS_WITH_TRANSACTIONS_TABLE = "epochsWithTransactions.#.%s";
    private static final String WRITERS_POSITIONS_TABLE = "writersPositions.#.%s";
    private static final String TRANSACTIONS_IN_EPOCH_TABLE_FORMAT = "transactionsInEpoch-%d.#.%s";
    private static final String CREATION_TIME_KEY = "creationTime";
    private static final String CONFIGURATION_KEY = "configuration";
    private static final String TRUNCATION_KEY = "truncation";
    private static final String STATE_KEY = "state";
    private static final String EPOCH_TRANSITION_KEY = "epochTransition";
    private static final String RETENTION_SET_KEY = "retention";
    private static final String RETENTION_STREAM_CUT_RECORD_KEY_FORMAT = "retentionCuts-%s";
    private static final String CURRENT_EPOCH_KEY = "currentEpochRecord";
    private static final String EPOCH_RECORD_KEY_FORMAT = "epochRecord-%d";
    private static final String HISTORY_TIMESERIES_CHUNK_FORMAT = "historyTimeSeriesChunk-%d";
    private static final String SEGMENTS_SEALED_SIZE_MAP_SHARD_FORMAT = "segmentsSealedSizeMapShard-%d";
    private static final String SEGMENT_SEALED_EPOCH_KEY_FORMAT = "segmentSealedEpochPath-%d";
    private static final String COMMITTING_TRANSACTIONS_RECORD_KEY = "committingTxns";
    private static final String SEGMENT_MARKER_PATH_FORMAT = "markers-%d";
    private static final String WAITING_REQUEST_PROCESSOR_PATH = "waitingRequestProcessor";
    private static final String STREAM_KEY_PREFIX = "Key.#.%s.#.%s.#.";
    private static final String COMPLETED_TRANSACTIONS_KEY_FORMAT = "Key.#.%s.#.%s.#./%s";
    private static final String SUBSCRIBER_KEY_PREFIX = "subscriber_";
    private static final String SUBSCRIBER_SET_KEY = "subscriberset";
    private static final VersionedMetadata<ActiveTxnRecord> NON_EXISTENT_TXN = new VersionedMetadata<ActiveTxnRecord>(ActiveTxnRecord.EMPTY, new Version.LongVersion(Long.MIN_VALUE));
    private final PravegaTablesStoreHelper storeHelper;
    private final Supplier<Integer> currentBatchSupplier;
    private final BiFunction<Boolean, OperationContext, CompletableFuture<String>> streamsInScopeTableNameSupplier;
    private final AtomicReference<String> idRef;
    private final ZkOrderedStore txnCommitOrderer;
    private final ScheduledExecutorService executor;

    @VisibleForTesting
    PravegaTablesStream(String scopeName, String streamName, PravegaTablesStoreHelper storeHelper, ZkOrderedStore txnCommitOrderer, Supplier<Integer> currentBatchSupplier, BiFunction<Boolean, OperationContext, CompletableFuture<String>> streamsInScopeTableNameSupplier, ScheduledExecutorService executor) {
        this(scopeName, streamName, storeHelper, txnCommitOrderer, currentBatchSupplier, 1000, 1000, streamsInScopeTableNameSupplier, executor);
    }

    @VisibleForTesting
    PravegaTablesStream(String scopeName, String streamName, PravegaTablesStoreHelper storeHelper, ZkOrderedStore txnCommitOrderer, Supplier<Integer> currentBatchSupplier, int chunkSize, int shardSize, BiFunction<Boolean, OperationContext, CompletableFuture<String>> streamsInScopeTableNameSupplier, ScheduledExecutorService executor) {
        super(scopeName, streamName, chunkSize, shardSize);
        this.storeHelper = storeHelper;
        this.txnCommitOrderer = txnCommitOrderer;
        this.currentBatchSupplier = currentBatchSupplier;
        this.streamsInScopeTableNameSupplier = streamsInScopeTableNameSupplier;
        this.idRef = new AtomicReference<Object>(null);
        this.executor = executor;
    }

    private CompletableFuture<String> getId(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String id = this.idRef.get();
        if (!Strings.isNullOrEmpty((String)id)) {
            return CompletableFuture.completedFuture(id);
        }
        return this.storeHelper.loadFromTableHandleStaleTableName(this.streamsInScopeTableNameSupplier, this.getName(), PravegaTablesStoreHelper.BYTES_TO_UUID_FUNCTION, context).thenComposeAsync(data -> {
            this.idRef.compareAndSet(null, ((UUID)data.getObject()).toString());
            return this.getId(context);
        });
    }

    private CompletableFuture<String> getMetadataTable(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getId(context).thenApply(this::getMetadataTableName);
    }

    private String getMetadataTableName(String id) {
        return NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.getScope(), this.getName(), String.format(METADATA_TABLE, id)});
    }

    private CompletableFuture<String> getEpochsWithTransactionsTable(OperationContext context) {
        return this.getId(context).thenApply(this::getEpochsWithTransactionsTableName);
    }

    private String getEpochsWithTransactionsTableName(String id) {
        return NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.getScope(), this.getName(), String.format(EPOCHS_WITH_TRANSACTIONS_TABLE, id)});
    }

    private CompletableFuture<String> getTransactionsInEpochTable(int epoch, OperationContext context) {
        return this.getId(context).thenApply(id -> this.getTransactionsInEpochTableName(epoch, (String)id));
    }

    private String getTransactionsInEpochTableName(int epoch, String id) {
        return NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.getScope(), this.getName(), String.format(TRANSACTIONS_IN_EPOCH_TABLE_FORMAT, epoch, id)});
    }

    private CompletableFuture<String> getWritersTable(OperationContext context) {
        return this.getId(context).thenApply(this::getWritersTableName);
    }

    private String getWritersTableName(String id) {
        return NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{this.getScope(), this.getName(), String.format(WRITERS_POSITIONS_TABLE, id)});
    }

    @Override
    public CompletableFuture<Void> completeCommittingTransactions(VersionedMetadata<CommittingTransactionsRecord> record, OperationContext context, Map<String, TxnWriterMark> writerMarks) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        long time = System.currentTimeMillis();
        ArrayList completedRecords = new ArrayList(record.getObject().getTransactionsToCommit().size());
        ArrayList txnIdStrings = new ArrayList(record.getObject().getTransactionsToCommit().size());
        record.getObject().getTransactionsToCommit().forEach(x -> {
            completedRecords.add(new AbstractMap.SimpleEntry<String, CompletedTxnRecord>(PravegaTablesStream.getCompletedTransactionKey(this.getScope(), this.getName(), x.toString()), new CompletedTxnRecord(time, TxnStatus.COMMITTED)));
            txnIdStrings.add(x.toString());
        });
        CompletionStage<Object> future = record.getObject().getTransactionsToCommit().size() == 0 ? CompletableFuture.completedFuture(null) : ((CompletableFuture)((CompletableFuture)this.generateMarksForTransactions(context, writerMarks).thenCompose(v -> this.createCompletedTxEntries(completedRecords, context))).thenCompose(x -> this.getTransactionsInEpochTable(((CommittingTransactionsRecord)record.getObject()).getEpoch(), context).thenCompose(table -> this.storeHelper.removeEntries((String)table, txnIdStrings, context.getRequestId())))).thenCompose(x -> this.tryRemoveOlderTransactionsInEpochTables(epoch -> epoch < ((CommittingTransactionsRecord)record.getObject()).getEpoch(), context));
        return future.thenCompose(x -> Futures.toVoid(this.updateCommittingTxnRecord(new VersionedMetadata<CommittingTransactionsRecord>(CommittingTransactionsRecord.EMPTY, record.getVersion()), context)));
    }

    @Override
    CompletableFuture<Void> createStreamMetadata(OperationContext context) {
        return this.getId(context).thenCompose(id -> {
            String metadataTable = this.getMetadataTableName((String)id);
            String epochWithTxnTable = this.getEpochsWithTransactionsTableName((String)id);
            String writersPositionsTable = this.getWritersTableName((String)id);
            return CompletableFuture.allOf(this.storeHelper.createTable(metadataTable, context.getRequestId()), this.storeHelper.createTable(epochWithTxnTable, context.getRequestId()), this.storeHelper.createTable(writersPositionsTable, context.getRequestId())).thenAccept(v -> log.debug(context.getRequestId(), "stream {}/{} metadata tables {}, {} & {} created", new Object[]{this.getScope(), this.getName(), metadataTable, epochWithTxnTable, writersPositionsTable}));
        });
    }

    @Override
    public CompletableFuture<CreateStreamResponse> checkStreamExists(StreamConfiguration configuration, long creationTime, int startingSegmentNumber, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.storeHelper.expectingDataNotFound(this.getCreationTime(context), null).thenCompose(storedCreationTime -> {
            if (storedCreationTime == null) {
                return CompletableFuture.completedFuture(new CreateStreamResponse(CreateStreamResponse.CreateStatus.NEW, configuration, creationTime, startingSegmentNumber));
            }
            return this.storeHelper.expectingDataNotFound(this.getConfiguration(context), null).thenCompose(config -> {
                if (config != null) {
                    return this.handleConfigExists((long)storedCreationTime, (StreamConfiguration)config, startingSegmentNumber, storedCreationTime == creationTime, context);
                }
                return CompletableFuture.completedFuture(new CreateStreamResponse(CreateStreamResponse.CreateStatus.NEW, configuration, (long)storedCreationTime, startingSegmentNumber));
            });
        });
    }

    private CompletableFuture<CreateStreamResponse> handleConfigExists(long creationTime, StreamConfiguration config, int startingSegmentNumber, boolean creationTimeMatched, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        CreateStreamResponse.CreateStatus status = creationTimeMatched ? CreateStreamResponse.CreateStatus.NEW : CreateStreamResponse.CreateStatus.EXISTS_CREATING;
        return this.storeHelper.expectingDataNotFound(this.getState(true, context), null).thenApply(state -> {
            if (state == null) {
                return new CreateStreamResponse(status, config, creationTime, startingSegmentNumber);
            }
            if (state.equals((Object)State.UNKNOWN) || state.equals((Object)State.CREATING)) {
                return new CreateStreamResponse(status, config, creationTime, startingSegmentNumber);
            }
            return new CreateStreamResponse(CreateStreamResponse.CreateStatus.EXISTS_ACTIVE, config, creationTime, startingSegmentNumber);
        });
    }

    @Override
    public CompletableFuture<Long> getCreationTime(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return ((CompletableFuture)this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.getCachedOrLoad((String)metadataTable, CREATION_TIME_KEY, PravegaTablesStoreHelper.BYTES_TO_LONG_FUNCTION, 0L, context.getRequestId()))).thenApply(VersionedMetadata::getObject);
    }

    @Override
    public CompletableFuture<Void> addSubscriber(String newSubscriber, long newGeneration, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return ((CompletableFuture)((CompletableFuture)this.createSubscribersRecordIfAbsent(context).thenCompose(y -> this.getSubscriberSetRecord(true, context))).thenCompose(subscriberSetRecord -> {
            if (!((Subscribers)subscriberSetRecord.getObject()).getSubscribers().contains((Object)newSubscriber)) {
                return this.getMetadataTable(context).thenCompose(metaTable -> {
                    Subscribers newSubscribers = Subscribers.add((Subscribers)subscriberSetRecord.getObject(), newSubscriber);
                    return this.storeHelper.updateEntry((String)metaTable, SUBSCRIBER_SET_KEY, newSubscribers, Subscribers::toBytes, subscriberSetRecord.getVersion(), context.getRequestId());
                });
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(v -> Futures.exceptionallyExpecting(this.getSubscriberRecord(newSubscriber, context), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, null).thenCompose(subscriberRecord -> {
            if (subscriberRecord == null) {
                StreamSubscriber newSubscriberRecord = new StreamSubscriber(newSubscriber, newGeneration, (ImmutableMap<Long, Long>)ImmutableMap.of(), System.currentTimeMillis());
                return Futures.toVoid((CompletableFuture)this.getMetadataTable(context).thenApply(metadataTable -> this.storeHelper.addNewEntryIfAbsent((String)metadataTable, this.getKeyForSubscriber(newSubscriber), newSubscriberRecord, StreamSubscriber::toBytes, context.getRequestId())));
            }
            if (((StreamSubscriber)subscriberRecord.getObject()).getGeneration() < newGeneration) {
                return Futures.toVoid(this.setSubscriberData(new VersionedMetadata<StreamSubscriber>(new StreamSubscriber(newSubscriber, newGeneration, ((StreamSubscriber)subscriberRecord.getObject()).getTruncationStreamCut(), System.currentTimeMillis()), subscriberRecord.getVersion()), context));
            }
            return CompletableFuture.completedFuture(null);
        }));
    }

    @Override
    public CompletableFuture<Void> createSubscribersRecordIfAbsent(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return Futures.exceptionallyExpecting(this.getSubscriberSetRecord(true, context), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, null).thenCompose(subscriberSetRecord -> {
            if (subscriberSetRecord == null) {
                return Futures.toVoid((CompletableFuture)this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.addNewEntryIfAbsent((String)metadataTable, SUBSCRIBER_SET_KEY, Subscribers.EMPTY_SET, Subscribers::toBytes, context.getRequestId())));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<VersionedMetadata<Subscribers>> getSubscriberSetRecord(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(table -> {
            if (ignoreCached) {
                this.unload((String)table, SUBSCRIBER_SET_KEY);
            }
            return this.storeHelper.getCachedOrLoad((String)table, SUBSCRIBER_SET_KEY, Subscribers::fromBytes, context.getOperationStartTime(), context.getRequestId());
        });
    }

    @Override
    CompletableFuture<Version> setSubscriberData(VersionedMetadata<StreamSubscriber> streamSubscriber, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, this.getKeyForSubscriber(((StreamSubscriber)streamSubscriber.getObject()).getSubscriber()), (StreamSubscriber)streamSubscriber.getObject(), StreamSubscriber::toBytes, streamSubscriber.getVersion(), context.getRequestId()));
    }

    @Override
    public CompletableFuture<Void> deleteSubscriber(String subscriber, long generation, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getSubscriberRecord(subscriber, context).thenCompose(subs -> {
            if (generation < ((StreamSubscriber)subs.getObject()).getGeneration()) {
                log.warn(context.getRequestId(), "skipped deleting subscriber {} due to generation mismatch", new Object[]{subscriber});
                return CompletableFuture.completedFuture(null);
            }
            return this.getMetadataTable(context).thenCompose(table -> ((CompletableFuture)this.storeHelper.removeEntry((String)table, this.getKeyForSubscriber(subscriber), context.getRequestId()).thenAccept(x -> this.storeHelper.invalidateCache((String)table, this.getKeyForSubscriber(subscriber)))).thenCompose(v -> this.getSubscriberSetRecord(true, context).thenCompose(subscriberSetRecord -> {
                if (((Subscribers)subscriberSetRecord.getObject()).getSubscribers().contains((Object)subscriber)) {
                    Subscribers subSet = Subscribers.remove((Subscribers)subscriberSetRecord.getObject(), subscriber);
                    return Futures.toVoid(this.storeHelper.updateEntry((String)table, SUBSCRIBER_SET_KEY, subSet, Subscribers::toBytes, subscriberSetRecord.getVersion(), context.getRequestId()));
                }
                return CompletableFuture.completedFuture(null);
            })));
        });
    }

    @Override
    public CompletableFuture<VersionedMetadata<StreamSubscriber>> getSubscriberRecord(String subscriber, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(table -> this.storeHelper.getCachedOrLoad((String)table, this.getKeyForSubscriber(subscriber), StreamSubscriber::fromBytes, context.getOperationStartTime(), context.getRequestId()));
    }

    @Override
    public CompletableFuture<List<String>> listSubscribers(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(table -> this.getSubscriberSetRecord(true, context).thenApply(subscribersSet -> ((Subscribers)subscribersSet.getObject()).getSubscribers().asList()));
    }

    @Override
    public CompletableFuture<Void> deleteStream(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getId(context).thenCompose(id -> this.storeHelper.expectingDataNotFound(this.tryRemoveOlderTransactionsInEpochTables(epoch -> true, context), null).thenCompose(v -> ((CompletableFuture)this.getEpochsWithTransactionsTable(context).thenCompose(epochWithTxnTable -> this.storeHelper.expectingDataNotFound(this.storeHelper.deleteTable((String)epochWithTxnTable, false, context.getRequestId()), null))).thenCompose(deleted -> this.storeHelper.deleteTable(this.getMetadataTableName((String)id), false, context.getRequestId()))));
    }

    @Override
    CompletableFuture<Void> createRetentionSetDataIfAbsent(RetentionSet data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, RETENTION_SET_KEY, data, RetentionSet::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<VersionedMetadata<RetentionSet>> getRetentionSetData(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.getCachedOrLoad((String)metadataTable, RETENTION_SET_KEY, RetentionSet::fromBytes, context.getOperationStartTime(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Version> updateRetentionSetData(VersionedMetadata<RetentionSet> retention, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, RETENTION_SET_KEY, (RetentionSet)retention.getObject(), RetentionSet::toBytes, retention.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> createStreamCutRecordData(long recordingTime, StreamCutRecord record, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(RETENTION_STREAM_CUT_RECORD_KEY_FORMAT, recordingTime);
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, key, record, StreamCutRecord::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<VersionedMetadata<StreamCutRecord>> getStreamCutRecordData(long recordingTime, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(RETENTION_STREAM_CUT_RECORD_KEY_FORMAT, recordingTime);
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.getCachedOrLoad((String)metadataTable, key, StreamCutRecord::fromBytes, 0L, context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> deleteStreamCutRecordData(long recordingTime, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(RETENTION_STREAM_CUT_RECORD_KEY_FORMAT, recordingTime);
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.removeEntry((String)metadataTable, key, context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> createHistoryTimeSeriesChunkDataIfAbsent(int chunkNumber, HistoryTimeSeries data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(HISTORY_TIMESERIES_CHUNK_FORMAT, chunkNumber);
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, key, data, HistoryTimeSeries::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<VersionedMetadata<HistoryTimeSeries>> getHistoryTimeSeriesChunkData(int chunkNumber, boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(HISTORY_TIMESERIES_CHUNK_FORMAT, chunkNumber);
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            if (ignoreCached) {
                this.unload((String)metadataTable, key);
            }
            return this.storeHelper.getCachedOrLoad((String)metadataTable, key, HistoryTimeSeries::fromBytes, context.getOperationStartTime(), context.getRequestId());
        });
    }

    @Override
    CompletableFuture<Version> updateHistoryTimeSeriesChunkData(int chunkNumber, VersionedMetadata<HistoryTimeSeries> data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(HISTORY_TIMESERIES_CHUNK_FORMAT, chunkNumber);
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, key, (HistoryTimeSeries)data.getObject(), HistoryTimeSeries::toBytes, data.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> createCurrentEpochRecordDataIfAbsent(EpochRecord data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, CURRENT_EPOCH_KEY, data.getEpoch(), PravegaTablesStoreHelper.INTEGER_TO_BYTES_FUNCTION, context.getRequestId())));
    }

    @Override
    CompletableFuture<Version> updateCurrentEpochRecordData(VersionedMetadata<EpochRecord> data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, CURRENT_EPOCH_KEY, ((EpochRecord)data.getObject()).getEpoch(), PravegaTablesStoreHelper.INTEGER_TO_BYTES_FUNCTION, data.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<EpochRecord>> getCurrentEpochRecordData(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            if (ignoreCached) {
                this.unload((String)metadataTable, CURRENT_EPOCH_KEY);
            }
            return this.storeHelper.getCachedOrLoad((String)metadataTable, CURRENT_EPOCH_KEY, PravegaTablesStoreHelper.BYTES_TO_INTEGER_FUNCTION, context.getOperationStartTime(), context.getRequestId()).thenCompose(versionedEpochNumber -> this.getEpochRecord((Integer)versionedEpochNumber.getObject(), context).thenApply(epochRecord -> new VersionedMetadata<EpochRecord>((EpochRecord)epochRecord, versionedEpochNumber.getVersion())));
        });
    }

    @Override
    CompletableFuture<Void> createEpochRecordDataIfAbsent(int epoch, EpochRecord data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(EPOCH_RECORD_KEY_FORMAT, epoch);
        return ((CompletableFuture)this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.addNewEntryIfAbsent((String)metadataTable, key, data, EpochRecord::toBytes, context.getRequestId()))).thenCompose(v -> {
            if (data.getEpoch() == data.getReferenceEpoch()) {
                return this.createTransactionsInEpochTable(epoch, context);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    CompletableFuture<VersionedMetadata<EpochRecord>> getEpochRecordData(int epoch, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            String key = String.format(EPOCH_RECORD_KEY_FORMAT, epoch);
            return this.storeHelper.getCachedOrLoad((String)metadataTable, key, EpochRecord::fromBytes, 0L, context.getRequestId());
        });
    }

    @Override
    CompletableFuture<Void> createSealedSegmentSizesMapShardDataIfAbsent(int shard, SealedSegmentsMapShard data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(SEGMENTS_SEALED_SIZE_MAP_SHARD_FORMAT, shard);
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, key, data, SealedSegmentsMapShard::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<VersionedMetadata<SealedSegmentsMapShard>> getSealedSegmentSizesMapShardData(int shard, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(SEGMENTS_SEALED_SIZE_MAP_SHARD_FORMAT, shard);
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.getCachedOrLoad((String)metadataTable, key, SealedSegmentsMapShard::fromBytes, context.getOperationStartTime(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Version> updateSealedSegmentSizesMapShardData(int shard, VersionedMetadata<SealedSegmentsMapShard> data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(SEGMENTS_SEALED_SIZE_MAP_SHARD_FORMAT, shard);
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, key, (SealedSegmentsMapShard)data.getObject(), SealedSegmentsMapShard::toBytes, data.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> createSegmentSealedEpochRecords(Collection<Long> segmentsToSeal, int epoch, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        ArrayList values = new ArrayList(segmentsToSeal.size());
        segmentsToSeal.forEach(x -> {
            String key = String.format(SEGMENT_SEALED_EPOCH_KEY_FORMAT, x);
            values.add(new AbstractMap.SimpleEntry<String, Integer>(key, epoch));
        });
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.addNewEntriesIfAbsent((String)metadataTable, values, PravegaTablesStoreHelper.INTEGER_TO_BYTES_FUNCTION, context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<Integer>> getSegmentSealedRecordData(long segmentId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(SEGMENT_SEALED_EPOCH_KEY_FORMAT, segmentId);
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.getCachedOrLoad((String)metadataTable, key, PravegaTablesStoreHelper.BYTES_TO_INTEGER_FUNCTION, 0L, context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> createEpochTransitionIfAbsent(EpochTransitionRecord epochTransition, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, EPOCH_TRANSITION_KEY, epochTransition, EpochTransitionRecord::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<Version> updateEpochTransitionNode(VersionedMetadata<EpochTransitionRecord> epochTransition, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, EPOCH_TRANSITION_KEY, (EpochTransitionRecord)epochTransition.getObject(), EpochTransitionRecord::toBytes, epochTransition.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<EpochTransitionRecord>> getEpochTransitionNode(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.getCachedOrLoad((String)metadataTable, EPOCH_TRANSITION_KEY, EpochTransitionRecord::fromBytes, context.getOperationStartTime(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> storeCreationTimeIfAbsent(long creationTime, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, CREATION_TIME_KEY, creationTime, PravegaTablesStoreHelper.LONG_TO_BYTES_FUNCTION, context.getRequestId())));
    }

    @Override
    public CompletableFuture<Void> createConfigurationIfAbsent(StreamConfigurationRecord configuration, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, CONFIGURATION_KEY, configuration, StreamConfigurationRecord::toBytes, context.getRequestId())));
    }

    @Override
    public CompletableFuture<Void> createStateIfAbsent(StateRecord state, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, STATE_KEY, state, StateRecord::toBytes, context.getRequestId())));
    }

    @Override
    public CompletableFuture<Void> createMarkerData(long segmentId, long timestamp, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(SEGMENT_MARKER_PATH_FORMAT, segmentId);
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, key, timestamp, PravegaTablesStoreHelper.LONG_TO_BYTES_FUNCTION, context.getRequestId())));
    }

    @Override
    CompletableFuture<Version> updateMarkerData(long segmentId, VersionedMetadata<Long> data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(SEGMENT_MARKER_PATH_FORMAT, segmentId);
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, key, (Long)data.getObject(), PravegaTablesStoreHelper.LONG_TO_BYTES_FUNCTION, data.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<Long>> getMarkerData(long segmentId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(SEGMENT_MARKER_PATH_FORMAT, segmentId);
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.expectingDataNotFound(this.storeHelper.getCachedOrLoad((String)metadataTable, key, PravegaTablesStoreHelper.BYTES_TO_LONG_FUNCTION, context.getOperationStartTime(), context.getRequestId()), null));
    }

    @Override
    CompletableFuture<Void> removeMarkerData(long segmentId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        String key = String.format(SEGMENT_MARKER_PATH_FORMAT, segmentId);
        return this.getMetadataTable(context).thenCompose(id -> this.storeHelper.removeEntry((String)id, key, context.getRequestId()));
    }

    @Override
    public CompletableFuture<Map<UUID, ActiveTxnRecord>> getActiveTxns(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return ((CompletableFuture)this.getEpochsWithTransactions(context).thenCompose(epochsWithTransactions -> Futures.allOfWithResults(epochsWithTransactions.stream().map(x -> this.getTxnInEpoch((int)x, context)).collect(Collectors.toList())))).thenApply(list -> {
            HashMap map = new HashMap();
            list.forEach(map::putAll);
            return map;
        });
    }

    private CompletableFuture<List<Integer>> getEpochsWithTransactions(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getEpochsWithTransactionsTable(context).thenCompose(epochWithTxnTable -> {
            ArrayList epochsWithTransactions = new ArrayList();
            return this.storeHelper.getAllKeys((String)epochWithTxnTable, context.getRequestId()).collectRemaining(x -> {
                epochsWithTransactions.add(Integer.parseInt(x));
                return true;
            }).thenApply(v -> epochsWithTransactions);
        });
    }

    @Override
    public CompletableFuture<Long> getNumberOfOngoingTransactions(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        ArrayList futures = new ArrayList();
        return this.getEpochsWithTransactionsTable(context).thenCompose(epochsWithTxn -> this.storeHelper.getAllKeys((String)epochsWithTxn, context.getRequestId()).forEachRemaining(x -> futures.add(this.getNumberOfOngoingTransactions(Integer.parseInt(x), context)), (Executor)this.executor).thenCompose(v -> Futures.allOfWithResults((List)futures).thenApply(list -> list.stream().reduce(0L, Long::sum))));
    }

    private CompletableFuture<Long> getNumberOfOngoingTransactions(int epoch, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        AtomicInteger count = new AtomicInteger(0);
        return this.getTransactionsInEpochTable(epoch, context).thenCompose(epochTableName -> this.storeHelper.getEntryCount((String)epochTableName, context.getRequestId()));
    }

    @Override
    public CompletableFuture<List<VersionedTransactionData>> getOrderedCommittingTxnInLowestEpoch(int limit, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return super.getOrderedCommittingTxnInLowestEpochHelper(this.txnCommitOrderer, limit, this.executor, context);
    }

    @Override
    @VisibleForTesting
    CompletableFuture<Map<Long, UUID>> getAllOrderedCommittingTxns(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return super.getAllOrderedCommittingTxnsHelper(this.txnCommitOrderer, context);
    }

    @Override
    CompletableFuture<List<ActiveTxnRecord>> getTransactionRecords(int epoch, List<String> txnIds, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getTransactionsInEpochTable(epoch, context).thenCompose(epochTxnTable -> this.storeHelper.getEntries((String)epochTxnTable, txnIds, ActiveTxnRecord::fromBytes, NON_EXISTENT_TXN, context.getRequestId()).thenApply(res -> {
            ArrayList<ActiveTxnRecord> list = new ArrayList<ActiveTxnRecord>();
            for (int i = 0; i < txnIds.size(); ++i) {
                VersionedMetadata txn = (VersionedMetadata)res.get(i);
                list.add((ActiveTxnRecord)txn.getObject());
            }
            return list;
        }));
    }

    @Override
    CompletableFuture<List<VersionedTransactionData>> getVersionedTransactionRecords(int epoch, List<String> txnIds, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getTransactionsInEpochTable(epoch, context).thenCompose(epochTxnTable -> this.storeHelper.getEntries((String)epochTxnTable, txnIds, ActiveTxnRecord::fromBytes, NON_EXISTENT_TXN, context.getRequestId()).thenApply(res -> {
            ArrayList<VersionedTransactionData> list = new ArrayList<VersionedTransactionData>();
            for (int i = 0; i < txnIds.size(); ++i) {
                VersionedMetadata txn = (VersionedMetadata)res.get(i);
                ActiveTxnRecord activeTxnRecord = (ActiveTxnRecord)txn.getObject();
                if (ActiveTxnRecord.EMPTY.equals(activeTxnRecord)) continue;
                VersionedTransactionData vdata = new VersionedTransactionData(epoch, UUID.fromString((String)txnIds.get(i)), txn.getVersion(), activeTxnRecord.getTxnStatus(), activeTxnRecord.getTxCreationTimestamp(), activeTxnRecord.getMaxExecutionExpiryTime(), activeTxnRecord.getWriterId(), activeTxnRecord.getCommitTime(), activeTxnRecord.getCommitOrder(), activeTxnRecord.getCommitOffsets());
                list.add(vdata);
            }
            return list;
        }));
    }

    @Override
    public CompletableFuture<Map<UUID, ActiveTxnRecord>> getTxnInEpoch(int epoch, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        ConcurrentHashMap result = new ConcurrentHashMap();
        return this.getTransactionsInEpochTable(epoch, context).thenCompose(tableName -> this.storeHelper.expectingDataNotFound(this.storeHelper.getAllEntries((String)tableName, ActiveTxnRecord::fromBytes, context.getRequestId()).collectRemaining(x -> {
            result.put((String)x.getKey(), (VersionedMetadata)x.getValue());
            return true;
        }).thenApply(v -> result.entrySet().stream().collect(Collectors.toMap(x -> UUID.fromString((String)x.getKey()), x -> (ActiveTxnRecord)((VersionedMetadata)x.getValue()).getObject()))), Collections.emptyMap()));
    }

    @Override
    public CompletableFuture<Version> createNewTransaction(int epoch, UUID txId, ActiveTxnRecord txnRecord, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getTransactionsInEpochTable(epoch, context).thenCompose(epochTable -> this.storeHelper.addNewEntryIfAbsent((String)epochTable, txId.toString(), txnRecord, ActiveTxnRecord::toBytes, context.getRequestId()));
    }

    private CompletableFuture<Void> createTransactionsInEpochTable(int epoch, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return ((CompletableFuture)this.getEpochsWithTransactionsTable(context).thenCompose(epochsWithTxnTable -> this.storeHelper.addNewEntryIfAbsent((String)epochsWithTxnTable, Integer.toString(epoch), new byte[0], x -> x, context.getRequestId()))).thenCompose(epochTxnEntryCreated -> this.getTransactionsInEpochTable(epoch, context).thenCompose(x -> this.storeHelper.createTable((String)x, context.getRequestId())));
    }

    @Override
    CompletableFuture<VersionedMetadata<ActiveTxnRecord>> getActiveTx(int epoch, UUID txId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getTransactionsInEpochTable(epoch, context).thenCompose(epochTxnTable -> this.storeHelper.getCachedOrLoad((String)epochTxnTable, txId.toString(), ActiveTxnRecord::fromBytes, context.getOperationStartTime(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Version> updateActiveTx(int epoch, UUID txId, VersionedMetadata<ActiveTxnRecord> data, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getTransactionsInEpochTable(epoch, context).thenCompose(epochTxnTable -> this.storeHelper.updateEntry((String)epochTxnTable, txId.toString(), (ActiveTxnRecord)data.getObject(), ActiveTxnRecord::toBytes, data.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Long> addTxnToCommitOrder(UUID txId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.txnCommitOrderer.addEntity(this.getScope(), this.getName(), txId.toString(), context.getRequestId());
    }

    @Override
    CompletableFuture<Void> removeTxnsFromCommitOrder(List<Long> orderedPositions, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.txnCommitOrderer.removeEntities(this.getScope(), this.getName(), orderedPositions);
    }

    @Override
    CompletableFuture<Void> removeActiveTxEntry(int epoch, UUID txId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return ((CompletableFuture)this.getTransactionsInEpochTable(epoch, context).thenCompose(epochTransactionsTableName -> this.storeHelper.removeEntry((String)epochTransactionsTableName, txId.toString(), context.getRequestId()))).thenCompose(v -> this.tryRemoveOlderTransactionsInEpochTables(e -> e < epoch, context));
    }

    private CompletableFuture<Void> tryRemoveOlderTransactionsInEpochTables(Predicate<Integer> epochPredicate, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getEpochsWithTransactions(context).thenCompose(list -> Futures.allOf((Collection)list.stream().filter(epochPredicate).map(x -> this.tryRemoveTransactionsInEpochTable((int)x, context)).collect(Collectors.toList())));
    }

    private CompletableFuture<Void> tryRemoveTransactionsInEpochTable(int epoch, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getTransactionsInEpochTable(epoch, context).thenCompose(epochTable -> ((CompletableFuture)this.storeHelper.deleteTable((String)epochTable, true, context.getRequestId()).handle((r, e) -> {
            if (e != null) {
                if (PravegaTablesStreamMetadataStore.DATA_NOT_FOUND_PREDICATE.test(e)) {
                    return true;
                }
                if (AbstractStreamMetadataStore.DATA_NOT_EMPTY_PREDICATE.test((Throwable)e)) {
                    return false;
                }
                throw new CompletionException((Throwable)e);
            }
            return true;
        })).thenCompose(deleted -> {
            if (deleted.booleanValue()) {
                return this.getEpochsWithTransactionsTable(context).thenCompose(table -> this.storeHelper.removeEntry((String)table, Integer.toString(epoch), context.getRequestId()));
            }
            return CompletableFuture.completedFuture(null);
        }));
    }

    @Override
    CompletableFuture<Void> createCompletedTxEntry(UUID txId, CompletedTxnRecord complete, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.createCompletedTxEntries(Collections.singletonList(new AbstractMap.SimpleEntry<String, CompletedTxnRecord>(PravegaTablesStream.getCompletedTransactionKey(this.getScope(), this.getName(), txId.toString()), complete)), context);
    }

    private CompletableFuture<Void> createCompletedTxEntries(List<Map.Entry<String, CompletedTxnRecord>> complete, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        Integer batch = this.currentBatchSupplier.get();
        String tableName = PravegaTablesStream.getCompletedTransactionsBatchTableName(batch);
        return Futures.toVoid((CompletableFuture)Futures.exceptionallyComposeExpecting(this.storeHelper.addNewEntriesIfAbsent(tableName, complete, CompletedTxnRecord::toBytes, context.getRequestId()), (Predicate)PravegaTablesStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, () -> this.tryCreateBatchTable(batch, context).thenCompose(v -> this.storeHelper.addNewEntriesIfAbsent(tableName, complete, CompletedTxnRecord::toBytes, context.getRequestId())))).exceptionally(e -> {
            throw new CompletionException((Throwable)e);
        });
    }

    @VisibleForTesting
    static String getCompletedTransactionKey(String scope, String stream, String txnId) {
        return String.format(COMPLETED_TRANSACTIONS_KEY_FORMAT, scope, stream, txnId);
    }

    @VisibleForTesting
    static String getCompletedTransactionsBatchTableName(int batch) {
        return NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{String.format("completedTransactionsBatch-%d", batch)});
    }

    private CompletableFuture<Void> tryCreateBatchTable(int batch, OperationContext context) {
        String batchTable = PravegaTablesStream.getCompletedTransactionsBatchTableName(batch);
        return Futures.exceptionallyComposeExpecting(this.storeHelper.addNewEntryIfAbsent(PravegaTablesStreamMetadataStore.COMPLETED_TRANSACTIONS_BATCHES_TABLE, Integer.toString(batch), new byte[0], x -> x, context.getRequestId()), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataContainerNotFoundException, () -> ((CompletableFuture)this.storeHelper.createTable(PravegaTablesStreamMetadataStore.COMPLETED_TRANSACTIONS_BATCHES_TABLE, context.getRequestId()).thenAccept(v -> log.debug(context.getRequestId(), "batches root table {} created", new Object[]{PravegaTablesStreamMetadataStore.COMPLETED_TRANSACTIONS_BATCHES_TABLE}))).thenCompose(v -> this.storeHelper.addNewEntryIfAbsent(PravegaTablesStreamMetadataStore.COMPLETED_TRANSACTIONS_BATCHES_TABLE, Integer.toString(batch), new byte[0], x -> x, context.getRequestId()))).thenCompose(v -> this.storeHelper.createTable(batchTable, context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<CompletedTxnRecord>> getCompletedTx(UUID txId, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        ArrayList batches = new ArrayList();
        return ((CompletableFuture)this.storeHelper.getAllKeys(PravegaTablesStreamMetadataStore.COMPLETED_TRANSACTIONS_BATCHES_TABLE, context.getRequestId()).collectRemaining(x -> {
            batches.add(Integer.parseInt(x));
            return true;
        }).thenCompose(v -> Futures.allOfWithResults(batches.stream().map(batch -> {
            String table = PravegaTablesStream.getCompletedTransactionsBatchTableName(batch);
            String key = PravegaTablesStream.getCompletedTransactionKey(this.getScope(), this.getName(), txId.toString());
            return this.storeHelper.expectingDataNotFound(this.storeHelper.getCachedOrLoad(table, key, CompletedTxnRecord::fromBytes, 0L, context.getRequestId()), null);
        }).collect(Collectors.toList())))).thenCompose(result -> {
            Optional<VersionedMetadata> any = result.stream().filter(Objects::nonNull).findFirst();
            if (any.isPresent()) {
                return CompletableFuture.completedFuture(any.get());
            }
            throw StoreException.create(StoreException.Type.DATA_NOT_FOUND, "Completed Txn not found");
        });
    }

    @Override
    public CompletableFuture<Void> createTruncationDataIfAbsent(StreamTruncationRecord truncationRecord, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, TRUNCATION_KEY, truncationRecord, StreamTruncationRecord::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<Version> setTruncationData(VersionedMetadata<StreamTruncationRecord> truncationRecord, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, TRUNCATION_KEY, (StreamTruncationRecord)truncationRecord.getObject(), StreamTruncationRecord::toBytes, truncationRecord.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<StreamTruncationRecord>> getTruncationData(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            if (ignoreCached) {
                this.unload((String)metadataTable, TRUNCATION_KEY);
            }
            return this.storeHelper.getCachedOrLoad((String)metadataTable, TRUNCATION_KEY, StreamTruncationRecord::fromBytes, context.getOperationStartTime(), context.getRequestId());
        });
    }

    @Override
    CompletableFuture<Version> setConfigurationData(VersionedMetadata<StreamConfigurationRecord> configuration, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, CONFIGURATION_KEY, (StreamConfigurationRecord)configuration.getObject(), StreamConfigurationRecord::toBytes, configuration.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<StreamConfigurationRecord>> getConfigurationData(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            if (ignoreCached) {
                this.unload((String)metadataTable, CONFIGURATION_KEY);
            }
            return this.storeHelper.getCachedOrLoad((String)metadataTable, CONFIGURATION_KEY, StreamConfigurationRecord::fromBytes, context.getOperationStartTime(), context.getRequestId());
        });
    }

    @Override
    CompletableFuture<Version> setStateData(VersionedMetadata<StateRecord> state, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, STATE_KEY, (StateRecord)state.getObject(), StateRecord::toBytes, state.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<StateRecord>> getStateData(boolean ignoreCached, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> {
            if (ignoreCached) {
                this.unload((String)metadataTable, STATE_KEY);
            }
            return this.storeHelper.getCachedOrLoad((String)metadataTable, STATE_KEY, StateRecord::fromBytes, context.getOperationStartTime(), context.getRequestId());
        });
    }

    @Override
    CompletableFuture<Void> createCommitTxnRecordIfAbsent(CommittingTransactionsRecord committingTxns, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, COMMITTING_TRANSACTIONS_RECORD_KEY, committingTxns, CommittingTransactionsRecord::toBytes, context.getRequestId())));
    }

    @Override
    CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> getCommitTxnRecord(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.getCachedOrLoad((String)metadataTable, COMMITTING_TRANSACTIONS_RECORD_KEY, CommittingTransactionsRecord::fromBytes, context.getOperationStartTime(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Version> updateCommittingTxnRecord(VersionedMetadata<CommittingTransactionsRecord> update, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.updateEntry((String)metadataTable, COMMITTING_TRANSACTIONS_RECORD_KEY, (CommittingTransactionsRecord)update.getObject(), CommittingTransactionsRecord::toBytes, update.getVersion(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> createWaitingRequestNodeIfAbsent(String waitingRequestProcessor, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> Futures.toVoid(this.storeHelper.addNewEntryIfAbsent((String)metadataTable, WAITING_REQUEST_PROCESSOR_PATH, waitingRequestProcessor, x -> x.getBytes(StandardCharsets.UTF_8), context.getRequestId())));
    }

    @Override
    CompletableFuture<String> getWaitingRequestNode(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return ((CompletableFuture)this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.getCachedOrLoad((String)metadataTable, WAITING_REQUEST_PROCESSOR_PATH, x -> StandardCharsets.UTF_8.decode(ByteBuffer.wrap(x)).toString(), System.currentTimeMillis(), context.getRequestId()))).thenApply(VersionedMetadata::getObject);
    }

    @Override
    CompletableFuture<Void> deleteWaitingRequestNode(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getMetadataTable(context).thenCompose(metadataTable -> this.storeHelper.removeEntry((String)metadataTable, WAITING_REQUEST_PROCESSOR_PATH, context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> createWriterMarkRecord(String writer, long timestamp, ImmutableMap<Long, Long> position, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        WriterMark mark = new WriterMark(timestamp, position);
        return Futures.toVoid((CompletableFuture)this.getWritersTable(context).thenCompose(table -> this.storeHelper.addNewEntry((String)table, writer, mark, WriterMark::toBytes, context.getRequestId())));
    }

    @Override
    public CompletableFuture<Void> removeWriterRecord(String writer, Version version, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getWritersTable(context).thenCompose(table -> this.storeHelper.removeEntry((String)table, writer, version, context.getRequestId()));
    }

    @Override
    CompletableFuture<VersionedMetadata<WriterMark>> getWriterMarkRecord(String writer, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        return this.getWritersTable(context).thenCompose(table -> this.storeHelper.getCachedOrLoad((String)table, writer, WriterMark::fromBytes, context.getOperationStartTime(), context.getRequestId()));
    }

    @Override
    CompletableFuture<Void> updateWriterMarkRecord(String writer, long timestamp, ImmutableMap<Long, Long> position, boolean isAlive, Version version, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        WriterMark mark = new WriterMark(timestamp, position, isAlive);
        return Futures.toVoid((CompletableFuture)this.getWritersTable(context).thenCompose(table -> this.storeHelper.updateEntry((String)table, writer, mark, WriterMark::toBytes, version, context.getRequestId())));
    }

    @Override
    public CompletableFuture<Map<String, WriterMark>> getAllWriterMarks(OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context cannot be null");
        ConcurrentHashMap result = new ConcurrentHashMap();
        return ((CompletableFuture)this.getWritersTable(context).thenCompose(table -> this.storeHelper.getAllEntries((String)table, WriterMark::fromBytes, context.getRequestId()).collectRemaining(x -> {
            result.put((String)x.getKey(), (WriterMark)((VersionedMetadata)x.getValue()).getObject());
            return true;
        }))).thenApply(v -> result);
    }

    @Override
    public void refresh() {
        this.idRef.set(null);
    }

    private String getKeyForSubscriber(String subscriber) {
        return SUBSCRIBER_KEY_PREFIX + subscriber;
    }

    private void unload(String tableName, String key) {
        this.storeHelper.invalidateCache(tableName, key);
    }
}

