/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.lang.Int96;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.server.SegmentHelper;
import io.pravega.controller.server.security.auth.GrpcAuthHelper;
import io.pravega.controller.store.PravegaTablesScope;
import io.pravega.controller.store.PravegaTablesStoreHelper;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.ZKStoreHelper;
import io.pravega.controller.store.index.ZKHostIndex;
import io.pravega.controller.store.stream.AbstractStreamMetadataStore;
import io.pravega.controller.store.stream.CreateStreamResponse;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.PravegaTablesReaderGroup;
import io.pravega.controller.store.stream.PravegaTablesStream;
import io.pravega.controller.store.stream.ScopeOperationContext;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.StreamOperationContext;
import io.pravega.controller.store.stream.ZKGarbageCollector;
import io.pravega.controller.store.stream.ZkInt96Counter;
import io.pravega.controller.store.stream.ZkOrderedStore;
import io.pravega.controller.util.Config;
import io.pravega.shared.NameUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.LoggerFactory;

public class PravegaTablesStreamMetadataStore
extends AbstractStreamMetadataStore {
    public static final String SEPARATOR = ".#.";
    public static final String SCOPES_TABLE = NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{"scopes"});
    static final String DELETED_STREAMS_TABLE = NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{"deletedStreams"});
    static final String COMPLETED_TRANSACTIONS_BATCHES_TABLE = NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{"completedTransactionsBatches"});
    static final String COMPLETED_TRANSACTIONS_BATCH_TABLE_FORMAT = "completedTransactionsBatch-%d";
    private static final String COMPLETED_TXN_GC_NAME = "completedTxnGC";
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(PravegaTablesStreamMetadataStore.class));
    private final ZkInt96Counter counter;
    private final AtomicReference<ZKGarbageCollector> completedTxnGCRef;
    private final ZKGarbageCollector completedTxnGC;
    @VisibleForTesting
    private final PravegaTablesStoreHelper storeHelper;
    private final ZkOrderedStore orderer;
    private final ScheduledExecutorService executor;

    @VisibleForTesting
    PravegaTablesStreamMetadataStore(SegmentHelper segmentHelper, CuratorFramework client, ScheduledExecutorService executor, GrpcAuthHelper authHelper) {
        this(segmentHelper, client, executor, Duration.ofHours(Config.COMPLETED_TRANSACTION_TTL_IN_HOURS), authHelper);
    }

    @VisibleForTesting
    PravegaTablesStreamMetadataStore(SegmentHelper segmentHelper, CuratorFramework curatorClient, ScheduledExecutorService executor, Duration gcPeriod, GrpcAuthHelper authHelper) {
        super(new ZKHostIndex(curatorClient, "/hostTxnIndex", executor), new ZKHostIndex(curatorClient, "/hostRequestIndex", executor));
        ZKStoreHelper zkStoreHelper = new ZKStoreHelper(curatorClient, executor);
        this.orderer = new ZkOrderedStore("txnCommitOrderer", zkStoreHelper, executor);
        this.completedTxnGC = new ZKGarbageCollector(COMPLETED_TXN_GC_NAME, zkStoreHelper, this::gcCompletedTxn, gcPeriod);
        this.completedTxnGC.startAsync();
        this.completedTxnGC.awaitRunning();
        this.completedTxnGCRef = new AtomicReference<ZKGarbageCollector>(this.completedTxnGC);
        this.counter = new ZkInt96Counter(zkStoreHelper);
        this.storeHelper = new PravegaTablesStoreHelper(segmentHelper, authHelper, executor);
        this.executor = executor;
    }

    @VisibleForTesting
    public PravegaTablesStreamMetadataStore(CuratorFramework curatorClient, ScheduledExecutorService executor, Duration gcPeriod, PravegaTablesStoreHelper helper) {
        super(new ZKHostIndex(curatorClient, "/hostTxnIndex", executor), new ZKHostIndex(curatorClient, "/hostRequestIndex", executor));
        ZKStoreHelper zkStoreHelper = new ZKStoreHelper(curatorClient, executor);
        this.orderer = new ZkOrderedStore("txnCommitOrderer", zkStoreHelper, executor);
        this.completedTxnGC = new ZKGarbageCollector(COMPLETED_TXN_GC_NAME, zkStoreHelper, this::gcCompletedTxn, gcPeriod);
        this.completedTxnGC.startAsync();
        this.completedTxnGC.awaitRunning();
        this.completedTxnGCRef = new AtomicReference<ZKGarbageCollector>(this.completedTxnGC);
        this.counter = new ZkInt96Counter(zkStoreHelper);
        this.storeHelper = helper;
        this.executor = executor;
    }

    @Override
    public OperationContext createScopeContext(String scopeName, long requestId) {
        PravegaTablesScope scope = this.newScope(scopeName);
        return new ScopeOperationContext(scope, requestId);
    }

    @Override
    public OperationContext createStreamContext(String scopeName, String streamName, long requestId) {
        PravegaTablesScope scope = this.newScope(scopeName);
        PravegaTablesStream stream = new PravegaTablesStream(scopeName, streamName, this.storeHelper, this.orderer, this.completedTxnGCRef.get()::getLatestBatch, scope::getStreamsInScopeTableName, this.executor);
        return new StreamOperationContext(scope, stream, requestId);
    }

    @VisibleForTesting
    CompletableFuture<Void> gcCompletedTxn() {
        ArrayList batches = new ArrayList();
        OperationContext context = this.getOperationContext(null);
        return Futures.completeOn(this.storeHelper.expectingDataNotFound(((CompletableFuture)this.storeHelper.getAllKeys(COMPLETED_TRANSACTIONS_BATCHES_TABLE, context.getRequestId()).collectRemaining(batches::add).thenApply(v -> this.findStaleBatches(batches))).thenCompose(toDeleteList -> {
            log.debug(context.getRequestId(), "deleting batches {} on new scheme", new Object[]{toDeleteList});
            return Futures.allOf((Collection)toDeleteList.stream().map(toDelete -> {
                String table = NameUtils.getQualifiedTableName((String)"_system", (String[])new String[]{String.format(COMPLETED_TRANSACTIONS_BATCH_TABLE_FORMAT, Long.parseLong(toDelete))});
                return this.storeHelper.deleteTable(table, false, context.getRequestId());
            }).collect(Collectors.toList())).thenCompose(v -> this.storeHelper.removeEntries(COMPLETED_TRANSACTIONS_BATCHES_TABLE, (Collection<String>)toDeleteList, context.getRequestId()));
        }), null), (Executor)this.executor);
    }

    @VisibleForTesting
    List<String> findStaleBatches(List<String> batches) {
        if (batches.size() > 2) {
            int biggestIndex = Integer.MIN_VALUE;
            int secondIndex = Integer.MIN_VALUE;
            long biggest = Long.MIN_VALUE;
            long second = Long.MIN_VALUE;
            for (int i = 0; i < batches.size(); ++i) {
                long element = Long.parseLong(batches.get(i));
                if (element > biggest) {
                    secondIndex = biggestIndex;
                    second = biggest;
                    biggest = element;
                    biggestIndex = i;
                    continue;
                }
                if (element <= second) continue;
                secondIndex = i;
                second = element;
            }
            ArrayList<String> list = new ArrayList<String>(batches);
            list.remove(biggestIndex);
            if (biggestIndex < secondIndex) {
                list.remove(secondIndex - 1);
            } else {
                list.remove(secondIndex);
            }
            return list;
        }
        return new ArrayList<String>();
    }

    @VisibleForTesting
    void setCompletedTxnGCRef(ZKGarbageCollector garbageCollector) {
        this.completedTxnGCRef.set(garbageCollector);
    }

    @Override
    PravegaTablesStream newStream(String scope, String name) {
        return new PravegaTablesStream(scope, name, this.storeHelper, this.orderer, this.completedTxnGCRef.get()::getLatestBatch, (x, y) -> ((PravegaTablesScope)this.getScope(scope, (OperationContext)y)).getStreamsInScopeTableName((boolean)x, (OperationContext)y), this.executor);
    }

    @Override
    CompletableFuture<Int96> getNextCounter() {
        return Futures.completeOn(this.counter.getNextCounter(), (Executor)this.executor);
    }

    @Override
    public CompletableFuture<Boolean> checkScopeExists(String scope, OperationContext context, Executor executor) {
        long requestId = this.getOperationContext(context).getRequestId();
        return Futures.completeOn(this.storeHelper.expectingDataNotFound(this.storeHelper.getEntry(SCOPES_TABLE, scope, x -> x, requestId).thenApply(v -> true), false), (Executor)executor);
    }

    @Override
    public CompletableFuture<CreateStreamResponse> createStream(String scope, String name, StreamConfiguration configuration, long createTimestamp, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn((CompletableFuture)((PravegaTablesScope)this.getScope(scope, context)).addStreamToScope(name, context).thenCompose(id -> super.createStream(scope, name, configuration, createTimestamp, context, executor)), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> deleteStream(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn((CompletableFuture)super.deleteStream(scope, name, context, executor).thenCompose(status -> ((PravegaTablesScope)this.getScope(scope, context)).removeStreamFromScope(name, context).thenApply(v -> status)), (Executor)executor);
    }

    @Override
    Version getEmptyVersion() {
        return Version.LongVersion.EMPTY;
    }

    @Override
    Version parseVersionData(byte[] data) {
        return Version.IntVersion.fromBytes(data);
    }

    @Override
    PravegaTablesScope newScope(String scopeName) {
        return new PravegaTablesScope(scopeName, this.storeHelper);
    }

    @Override
    public CompletableFuture<String> getScopeConfiguration(String scopeName, OperationContext context, Executor executor) {
        long requestId = this.getOperationContext(context).getRequestId();
        return Futures.completeOn((CompletableFuture)this.storeHelper.getEntry(SCOPES_TABLE, scopeName, x -> x, requestId).thenApply(x -> scopeName), (Executor)executor);
    }

    @Override
    public CompletableFuture<List<String>> listScopes(Executor executor, long requestId) {
        ArrayList scopes = new ArrayList();
        return Futures.completeOn((CompletableFuture)Futures.exceptionallyComposeExpecting((CompletableFuture)this.storeHelper.getAllKeys(SCOPES_TABLE, requestId).collectRemaining(scopes::add).thenApply(v -> scopes), (Predicate)DATA_NOT_FOUND_PREDICATE, () -> this.storeHelper.createTable(SCOPES_TABLE, requestId).thenApply(v -> Collections.emptyList())), (Executor)executor);
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listScopes(String continuationToken, int limit, Executor executor, long requestId) {
        return Futures.completeOn((CompletableFuture)Futures.exceptionallyComposeExpecting((CompletableFuture)this.storeHelper.getKeysPaginated(SCOPES_TABLE, Unpooled.wrappedBuffer((byte[])Base64.getDecoder().decode(continuationToken)), limit, requestId).thenApply(result -> new ImmutablePair((Object)((List)result.getValue()), (Object)Base64.getEncoder().encodeToString(((ByteBuf)result.getKey()).array()))), (Predicate)DATA_NOT_FOUND_PREDICATE, () -> this.storeHelper.createTable(SCOPES_TABLE, requestId).thenApply(v -> ImmutablePair.of(Collections.emptyList(), (Object)continuationToken))), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> addStreamTagsToIndex(String scope, String streamName, StreamConfiguration config, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        if (streamName.startsWith("_") || config.getTags().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return Futures.completeOn(((PravegaTablesScope)this.getScope(scope, context)).addTagsUnderScope(streamName, config.getTags(), context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> removeTagsFromIndex(String scope, String streamName, Set<String> tagsRemoved, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        if (streamName.startsWith("_") || tagsRemoved.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return Futures.completeOn(((PravegaTablesScope)this.getScope(scope, context)).removeTagsUnderScope(streamName, tagsRemoved, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Boolean> checkStreamExists(String scopeName, String streamName, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(((PravegaTablesScope)this.getScope(scopeName, context)).checkStreamExistsInScope(streamName, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Boolean> checkReaderGroupExists(String scopeName, String rgName, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(((PravegaTablesScope)this.getScope(scopeName, context)).checkReaderGroupExistsInScope(rgName, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Integer> getSafeStartingSegmentNumberFor(String scopeName, String streamName, OperationContext context, Executor executor) {
        long requestId = this.getOperationContext(context).getRequestId();
        return Futures.completeOn((CompletableFuture)this.storeHelper.getEntry(DELETED_STREAMS_TABLE, this.getScopedStreamName(scopeName, streamName), PravegaTablesStoreHelper.BYTES_TO_INTEGER_FUNCTION, requestId).handle((data, ex) -> {
            if (ex == null) {
                return (Integer)data.getObject() + 1;
            }
            if (Exceptions.unwrap((Throwable)ex) instanceof StoreException.DataNotFoundException) {
                return 0;
            }
            log.warn(context.getRequestId(), "Problem found while getting a safe starting segment number for {}.", new Object[]{this.getScopedStreamName(scopeName, streamName), ex});
            throw new CompletionException((Throwable)ex);
        }), (Executor)executor);
    }

    @Override
    CompletableFuture<Void> recordLastStreamSegment(String scope, String stream, int lastActiveSegment, OperationContext ctx, Executor executor) {
        String key = this.getScopedStreamName(scope, stream);
        OperationContext context = this.getOperationContext(ctx);
        long requestId = this.getOperationContext(context).getRequestId();
        return Futures.completeOn((CompletableFuture)Futures.handleCompose(this.storeHelper.getEntry(DELETED_STREAMS_TABLE, key, PravegaTablesStoreHelper.BYTES_TO_INTEGER_FUNCTION, requestId), (r, e) -> {
            if (e != null) {
                Throwable unwrap = Exceptions.unwrap((Throwable)e);
                if (unwrap instanceof StoreException.DataContainerNotFoundException) {
                    return this.storeHelper.createTable(DELETED_STREAMS_TABLE, requestId).thenApply(v -> null);
                }
                if (unwrap instanceof StoreException.DataNotFoundException) {
                    return CompletableFuture.completedFuture(null);
                }
                throw new CompletionException(unwrap);
            }
            return CompletableFuture.completedFuture(r);
        }).thenCompose(existing -> {
            log.debug(context.getRequestId(), "Recording last segment {} for stream {}/{} on deletion.", new Object[]{lastActiveSegment, scope, stream});
            if (existing != null) {
                int oldLastActiveSegment = (Integer)existing.getObject();
                Preconditions.checkArgument((lastActiveSegment >= oldLastActiveSegment ? 1 : 0) != 0, (String)"Old last active segment ({}) for {}/{} is higher than current one {}.", (Object)oldLastActiveSegment, (Object)scope, (Object)stream, (Object)lastActiveSegment);
                return Futures.toVoid(this.storeHelper.updateEntry(DELETED_STREAMS_TABLE, key, lastActiveSegment, PravegaTablesStoreHelper.INTEGER_TO_BYTES_FUNCTION, existing.getVersion(), requestId));
            }
            return Futures.toVoid(this.storeHelper.addNewEntryIfAbsent(DELETED_STREAMS_TABLE, key, lastActiveSegment, PravegaTablesStoreHelper.INTEGER_TO_BYTES_FUNCTION, requestId));
        }), (Executor)executor);
    }

    @Override
    public void close() {
        this.completedTxnGC.stopAsync();
        this.completedTxnGC.awaitTerminated();
    }

    @Override
    PravegaTablesReaderGroup newReaderGroup(String scope, String rgName) {
        return new PravegaTablesReaderGroup(scope, rgName, this.storeHelper, (x, y) -> ((PravegaTablesScope)this.getScope(scope, null)).getReaderGroupsInScopeTableName((boolean)x, (OperationContext)y), this.executor);
    }

    @Override
    public CompletableFuture<Void> addReaderGroupToScope(String scope, String name, UUID readerGroupId, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn(((PravegaTablesScope)this.getScope(scope, context)).addReaderGroupToScope(name, readerGroupId, context), (Executor)executor);
    }

    @Override
    public CompletableFuture<Void> deleteReaderGroup(String scope, String name, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        return Futures.completeOn((CompletableFuture)super.deleteReaderGroup(scope, name, context, executor).thenCompose(status -> ((PravegaTablesScope)this.getScope(scope, context)).removeReaderGroupFromScope(name, context).thenApply(v -> status)), (Executor)executor);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    PravegaTablesStoreHelper getStoreHelper() {
        return this.storeHelper;
    }
}

