/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;

public enum ReaderGroupState {
    UNKNOWN,
    CREATING,
    DELETING,
    ACTIVE;


    public static boolean isTransitionAllowed(ReaderGroupState currentState, ReaderGroupState newState) {
        return StateTransitions.valueOf((String)currentState.name()).transitions.contains((Object)newState);
    }

    private static enum StateTransitions {
        UNKNOWN(UNKNOWN, CREATING),
        CREATING(CREATING, ACTIVE, DELETING),
        ACTIVE(ACTIVE, DELETING),
        DELETING(DELETING);

        private final Set<ReaderGroupState> transitions;

        private StateTransitions(ReaderGroupState ... states) {
            this.transitions = Sets.immutableEnumSet(Arrays.asList(states));
        }
    }
}

