/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shared.NameUtils;
import java.beans.ConstructorProperties;
import java.util.AbstractMap;
import lombok.Generated;

public class Segment {
    private final int number;
    private final int epoch;
    private final long start;
    private final double keyStart;
    private final double keyEnd;

    public Segment(long segmentId, long start, double keyStart, double keyEnd) {
        this.number = NameUtils.getSegmentNumber((long)segmentId);
        this.epoch = NameUtils.getEpoch((long)segmentId);
        this.start = start;
        this.keyStart = keyStart;
        this.keyEnd = keyEnd;
    }

    public long segmentId() {
        return NameUtils.computeSegmentId((int)this.number, (int)this.epoch);
    }

    public boolean overlaps(Segment segment) {
        return segment.getKeyEnd() > this.keyStart && segment.getKeyStart() < this.keyEnd;
    }

    public boolean overlaps(double keyStart, double keyEnd) {
        return keyEnd > this.keyStart && keyStart < this.keyEnd;
    }

    public static boolean overlaps(AbstractMap.SimpleEntry<Double, Double> first, AbstractMap.SimpleEntry<Double, Double> second) {
        return second.getValue() > first.getKey() && second.getKey() < first.getValue();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getNumber() {
        return this.number;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEpoch() {
        return this.epoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getStart() {
        return this.start;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getKeyStart() {
        return this.keyStart;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public double getKeyEnd() {
        return this.keyEnd;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumber() != other.getNumber()) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (Double.compare(this.getKeyStart(), other.getKeyStart()) != 0) {
            return false;
        }
        return Double.compare(this.getKeyEnd(), other.getKeyEnd()) == 0;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Segment;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumber();
        result = result * 59 + this.getEpoch();
        long $start = this.getStart();
        result = result * 59 + (int)($start >>> 32 ^ $start);
        long $keyStart = Double.doubleToLongBits(this.getKeyStart());
        result = result * 59 + (int)($keyStart >>> 32 ^ $keyStart);
        long $keyEnd = Double.doubleToLongBits(this.getKeyEnd());
        result = result * 59 + (int)($keyEnd >>> 32 ^ $keyEnd);
        return result;
    }

    @ConstructorProperties(value={"number", "epoch", "start", "keyStart", "keyEnd"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Segment(int number, int epoch, long start, double keyStart, double keyEnd) {
        this.number = number;
        this.epoch = epoch;
        this.start = start;
        this.keyStart = keyStart;
        this.keyEnd = keyEnd;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Segment(number=" + this.getNumber() + ", epoch=" + this.getEpoch() + ", start=" + this.getStart() + ", keyStart=" + this.getKeyStart() + ", keyEnd=" + this.getKeyEnd() + ")";
    }
}

