/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.collect.ImmutableMap;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.CreateStreamResponse;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ScaleMetadata;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StreamCutComparison;
import io.pravega.controller.store.stream.TxnStatus;
import io.pravega.controller.store.stream.TxnWriterMark;
import io.pravega.controller.store.stream.VersionedTransactionData;
import io.pravega.controller.store.stream.WriterTimestampResponse;
import io.pravega.controller.store.stream.records.ActiveTxnRecord;
import io.pravega.controller.store.stream.records.CommittingTransactionsRecord;
import io.pravega.controller.store.stream.records.EpochRecord;
import io.pravega.controller.store.stream.records.EpochTransitionRecord;
import io.pravega.controller.store.stream.records.HistoryTimeSeries;
import io.pravega.controller.store.stream.records.RetentionSet;
import io.pravega.controller.store.stream.records.SealedSegmentsMapShard;
import io.pravega.controller.store.stream.records.StreamConfigurationRecord;
import io.pravega.controller.store.stream.records.StreamCutRecord;
import io.pravega.controller.store.stream.records.StreamCutReferenceRecord;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.controller.store.stream.records.StreamSubscriber;
import io.pravega.controller.store.stream.records.StreamTruncationRecord;
import io.pravega.controller.store.stream.records.WriterMark;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

interface Stream {
    public String getScope();

    public String getName();

    public String getScopeName();

    public CompletableFuture<CreateStreamResponse> create(StreamConfiguration var1, long var2, int var4, OperationContext var5);

    public CompletableFuture<Void> delete(OperationContext var1);

    public CompletableFuture<Long> getCreationTime(OperationContext var1);

    public CompletableFuture<Void> startUpdateConfiguration(StreamConfiguration var1, OperationContext var2);

    public CompletableFuture<Void> completeUpdateConfiguration(VersionedMetadata<StreamConfigurationRecord> var1, OperationContext var2);

    public CompletableFuture<StreamConfiguration> getConfiguration(OperationContext var1);

    public CompletableFuture<VersionedMetadata<StreamConfigurationRecord>> getVersionedConfigurationRecord(OperationContext var1);

    public CompletableFuture<Void> addSubscriber(String var1, long var2, OperationContext var4);

    public CompletableFuture<VersionedMetadata<StreamSubscriber>> getSubscriberRecord(String var1, OperationContext var2);

    public CompletableFuture<List<String>> listSubscribers(OperationContext var1);

    public CompletableFuture<Void> updateSubscriberStreamCut(VersionedMetadata<StreamSubscriber> var1, String var2, long var3, ImmutableMap<Long, Long> var5, OperationContext var6);

    public CompletableFuture<Void> deleteSubscriber(String var1, long var2, OperationContext var4);

    public CompletableFuture<Void> startTruncation(Map<Long, Long> var1, OperationContext var2);

    public CompletableFuture<Void> completeTruncation(VersionedMetadata<StreamTruncationRecord> var1, OperationContext var2);

    public CompletableFuture<VersionedMetadata<StreamTruncationRecord>> getTruncationRecord(OperationContext var1);

    public CompletableFuture<VersionedMetadata<State>> getVersionedState(OperationContext var1);

    public CompletableFuture<Void> updateState(State var1, OperationContext var2);

    public CompletableFuture<VersionedMetadata<State>> updateVersionedState(VersionedMetadata<State> var1, State var2, OperationContext var3);

    public CompletableFuture<State> getState(boolean var1, OperationContext var2);

    public CompletableFuture<StreamSegmentRecord> getSegment(long var1, OperationContext var3);

    public CompletableFuture<Set<Long>> getAllSegmentIds(OperationContext var1);

    public CompletableFuture<List<ScaleMetadata>> getScaleMetadata(long var1, long var3, OperationContext var5);

    public CompletableFuture<Map<StreamSegmentRecord, List<Long>>> getSuccessorsWithPredecessors(long var1, OperationContext var3);

    public CompletableFuture<List<StreamSegmentRecord>> getSegmentsBetweenStreamCuts(Map<Long, Long> var1, Map<Long, Long> var2, OperationContext var3);

    public CompletableFuture<Boolean> isStreamCutValid(Map<Long, Long> var1, OperationContext var2);

    public CompletableFuture<List<StreamSegmentRecord>> getActiveSegments(OperationContext var1);

    public CompletableFuture<Map<StreamSegmentRecord, Long>> getSegmentsAtHead(OperationContext var1);

    public CompletableFuture<List<StreamSegmentRecord>> getSegmentsInEpoch(int var1, OperationContext var2);

    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> getEpochTransition(OperationContext var1);

    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> resetEpochTransition(VersionedMetadata<EpochTransitionRecord> var1, OperationContext var2);

    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> submitScale(List<Long> var1, List<Map.Entry<Double, Double>> var2, long var3, VersionedMetadata<EpochTransitionRecord> var5, OperationContext var6);

    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> startScale(boolean var1, VersionedMetadata<EpochTransitionRecord> var2, VersionedMetadata<State> var3, OperationContext var4);

    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> scaleCreateNewEpoch(VersionedMetadata<EpochTransitionRecord> var1, OperationContext var2);

    public CompletableFuture<Void> scaleOldSegmentsSealed(Map<Long, Long> var1, VersionedMetadata<EpochTransitionRecord> var2, OperationContext var3);

    public CompletableFuture<Void> completeScale(VersionedMetadata<EpochTransitionRecord> var1, OperationContext var2);

    public CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> startRollingTxn(int var1, VersionedMetadata<CommittingTransactionsRecord> var2, OperationContext var3);

    public CompletableFuture<Void> rollingTxnCreateDuplicateEpochs(Map<Long, Long> var1, long var2, VersionedMetadata<CommittingTransactionsRecord> var4, OperationContext var5);

    public CompletableFuture<Void> completeRollingTxn(Map<Long, Long> var1, VersionedMetadata<CommittingTransactionsRecord> var2, OperationContext var3);

    public CompletableFuture<Void> setColdMarker(long var1, long var3, OperationContext var5);

    public CompletableFuture<Long> getColdMarker(long var1, OperationContext var3);

    public CompletableFuture<Void> removeColdMarker(long var1, OperationContext var3);

    public CompletableFuture<UUID> generateNewTxnId(int var1, long var2, OperationContext var4);

    public CompletableFuture<VersionedTransactionData> createTransaction(UUID var1, long var2, long var4, OperationContext var6);

    public CompletableFuture<VersionedTransactionData> pingTransaction(VersionedTransactionData var1, long var2, OperationContext var4);

    public CompletableFuture<VersionedTransactionData> getTransactionData(UUID var1, OperationContext var2);

    public CompletableFuture<AbstractMap.SimpleEntry<TxnStatus, Integer>> sealTransaction(UUID var1, boolean var2, Optional<Version> var3, String var4, long var5, OperationContext var7);

    public CompletableFuture<TxnStatus> checkTransactionStatus(UUID var1, OperationContext var2);

    public CompletableFuture<TxnStatus> abortTransaction(UUID var1, OperationContext var2);

    public CompletableFuture<Long> getNumberOfOngoingTransactions(OperationContext var1);

    public CompletableFuture<Map<UUID, ActiveTxnRecord>> getActiveTxns(OperationContext var1);

    public CompletableFuture<EpochRecord> getActiveEpoch(boolean var1, OperationContext var2);

    public CompletableFuture<EpochRecord> getEpochRecord(int var1, OperationContext var2);

    public CompletableFuture<Long> getSizeTillStreamCut(Map<Long, Long> var1, Optional<StreamCutRecord> var2, OperationContext var3);

    public CompletableFuture<Void> addStreamCutToRetentionSet(StreamCutRecord var1, OperationContext var2);

    public CompletableFuture<RetentionSet> getRetentionSet(OperationContext var1);

    public CompletableFuture<StreamCutRecord> getStreamCutRecord(StreamCutReferenceRecord var1, OperationContext var2);

    public CompletableFuture<Void> deleteStreamCutBefore(StreamCutReferenceRecord var1, OperationContext var2);

    public CompletableFuture<Map.Entry<VersionedMetadata<CommittingTransactionsRecord>, List<VersionedTransactionData>>> startCommittingTransactions(int var1, OperationContext var2);

    public CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> getVersionedCommitTransactionsRecord(OperationContext var1);

    public CompletableFuture<Void> completeCommittingTransactions(VersionedMetadata<CommittingTransactionsRecord> var1, OperationContext var2, Map<String, TxnWriterMark> var3);

    public CompletableFuture<Void> recordCommitOffsets(UUID var1, Map<Long, Long> var2, OperationContext var3);

    public CompletableFuture<Void> createWaitingRequestIfAbsent(String var1, OperationContext var2);

    public CompletableFuture<String> getWaitingRequestProcessor(OperationContext var1);

    public CompletableFuture<Void> deleteWaitingRequestConditionally(String var1, OperationContext var2);

    public CompletableFuture<WriterTimestampResponse> noteWriterMark(String var1, long var2, Map<Long, Long> var4, OperationContext var5);

    public CompletableFuture<Void> shutdownWriter(String var1, OperationContext var2);

    public CompletableFuture<Void> removeWriter(String var1, WriterMark var2, OperationContext var3);

    public CompletableFuture<WriterMark> getWriterMark(String var1, OperationContext var2);

    public CompletableFuture<Map<String, WriterMark>> getAllWriterMarks(OperationContext var1);

    public void refresh();

    public CompletableFuture<HistoryTimeSeries> getHistoryTimeSeriesChunk(int var1, OperationContext var2);

    public CompletableFuture<SealedSegmentsMapShard> getSealedSegmentSizeMapShard(int var1, OperationContext var2);

    public CompletableFuture<Integer> getSegmentSealedEpoch(long var1, OperationContext var3);

    public CompletableFuture<StreamCutComparison> compareStreamCuts(Map<Long, Long> var1, Map<Long, Long> var2, OperationContext var3);

    public CompletableFuture<StreamCutReferenceRecord> findStreamCutReferenceRecordBefore(Map<Long, Long> var1, RetentionSet var2, OperationContext var3);

    public CompletableFuture<AbstractMap.SimpleEntry<Long, Long>> getSplitMergeCountsTillEpoch(EpochRecord var1, OperationContext var2);
}

