/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.pravega.controller.server.SegmentHelper;
import io.pravega.controller.server.security.auth.GrpcAuthHelper;
import io.pravega.controller.store.client.StoreClient;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.InMemoryBucketStore;
import io.pravega.controller.store.stream.InMemoryStreamMetadataStore;
import io.pravega.controller.store.stream.PravegaTablesStreamMetadataStore;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.ZKStreamMetadataStore;
import io.pravega.controller.store.stream.ZookeeperBucketStore;
import io.pravega.controller.util.Config;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.curator.framework.CuratorFramework;

public class StreamStoreFactory {
    public static final ImmutableMap<BucketStore.ServiceType, Integer> BUCKET_COUNT_MAP = ImmutableMap.of((Object)((Object)BucketStore.ServiceType.RetentionService), (Object)Config.RETENTION_BUCKET_COUNT, (Object)((Object)BucketStore.ServiceType.WatermarkingService), (Object)Config.WATERMARKING_BUCKET_COUNT);

    public static StreamMetadataStore createStore(StoreClient storeClient, SegmentHelper segmentHelper, GrpcAuthHelper authHelper, ScheduledExecutorService executor) {
        switch (storeClient.getType()) {
            case InMemory: {
                return new InMemoryStreamMetadataStore();
            }
            case Zookeeper: {
                return new ZKStreamMetadataStore((CuratorFramework)storeClient.getClient(), executor);
            }
            case PravegaTable: {
                return new PravegaTablesStreamMetadataStore(segmentHelper, (CuratorFramework)storeClient.getClient(), executor, authHelper);
            }
        }
        throw new NotImplementedException(storeClient.getType().toString());
    }

    @VisibleForTesting
    public static StreamMetadataStore createPravegaTablesStore(SegmentHelper segmentHelper, GrpcAuthHelper authHelper, CuratorFramework client, ScheduledExecutorService executor) {
        return new PravegaTablesStreamMetadataStore(segmentHelper, client, executor, authHelper);
    }

    @VisibleForTesting
    public static StreamMetadataStore createZKStore(CuratorFramework client, ScheduledExecutorService executor) {
        return new ZKStreamMetadataStore(client, executor);
    }

    @VisibleForTesting
    public static StreamMetadataStore createInMemoryStore() {
        return new InMemoryStreamMetadataStore();
    }

    public static BucketStore createBucketStore(StoreClient storeClient, Executor executor) {
        switch (storeClient.getType()) {
            case InMemory: {
                return StreamStoreFactory.createInMemoryBucketStore();
            }
            case Zookeeper: 
            case PravegaTable: {
                return StreamStoreFactory.createZKBucketStore((CuratorFramework)storeClient.getClient(), executor);
            }
        }
        throw new NotImplementedException(storeClient.getType().toString());
    }

    @VisibleForTesting
    public static BucketStore createZKBucketStore(CuratorFramework client, Executor executor) {
        return StreamStoreFactory.createZKBucketStore(BUCKET_COUNT_MAP, client, executor);
    }

    @VisibleForTesting
    public static BucketStore createZKBucketStore(ImmutableMap<BucketStore.ServiceType, Integer> map, CuratorFramework client, Executor executor) {
        return new ZookeeperBucketStore(map, client, executor);
    }

    @VisibleForTesting
    public static BucketStore createInMemoryBucketStore() {
        return StreamStoreFactory.createInMemoryBucketStore(BUCKET_COUNT_MAP);
    }

    @VisibleForTesting
    public static BucketStore createInMemoryBucketStore(ImmutableMap<BucketStore.ServiceType, Integer> map) {
        return new InMemoryBucketStore(map);
    }
}

