/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.lang.Int96;
import io.pravega.common.tracing.TagLogger;
import io.pravega.common.util.BitConverter;
import io.pravega.controller.store.Version;
import io.pravega.controller.store.ZKScope;
import io.pravega.controller.store.ZKStoreHelper;
import io.pravega.controller.store.index.ZKHostIndex;
import io.pravega.controller.store.stream.AbstractStreamMetadataStore;
import io.pravega.controller.store.stream.CreateStreamResponse;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ReaderGroup;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.ZKGarbageCollector;
import io.pravega.controller.store.stream.ZKStream;
import io.pravega.controller.store.stream.ZkInt96Counter;
import io.pravega.controller.store.stream.ZkOrderedStore;
import io.pravega.controller.util.Config;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.ZKPaths;
import org.slf4j.LoggerFactory;

public class ZKStreamMetadataStore
extends AbstractStreamMetadataStore
implements AutoCloseable {
    @VisibleForTesting
    static final String SCOPE_ROOT_PATH = "/store";
    static final String DELETED_STREAMS_PATH = "/lastActiveStreamSegment/%s";
    private static final String TRANSACTION_ROOT_PATH = "/transactions";
    private static final String COMPLETED_TXN_GC_NAME = "completedTxnGC";
    static final String ACTIVE_TX_ROOT_PATH = "/transactions/activeTx";
    static final String COMPLETED_TX_ROOT_PATH = "/transactions/completedTx";
    static final String COMPLETED_TX_BATCH_ROOT_PATH = "/transactions/completedTx/batches";
    static final String COMPLETED_TX_BATCH_PATH = "/transactions/completedTx/batches/%d";
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(ZKStreamMetadataStore.class));
    @VisibleForTesting
    private ZKStoreHelper storeHelper;
    private final ZkOrderedStore orderer;
    private final ZKGarbageCollector completedTxnGC;
    private final ZkInt96Counter counter;
    private final Executor executor;

    @VisibleForTesting
    ZKStreamMetadataStore(CuratorFramework client, Executor executor) {
        this(client, executor, Duration.ofHours(Config.COMPLETED_TRANSACTION_TTL_IN_HOURS));
    }

    @VisibleForTesting
    ZKStreamMetadataStore(CuratorFramework client, Executor executor, Duration gcPeriod) {
        super(new ZKHostIndex(client, "/hostTxnIndex", executor), new ZKHostIndex(client, "/hostRequestIndex", executor));
        this.storeHelper = new ZKStoreHelper(client, executor);
        this.orderer = new ZkOrderedStore("txnCommitOrderer", this.storeHelper, executor);
        this.completedTxnGC = new ZKGarbageCollector(COMPLETED_TXN_GC_NAME, this.storeHelper, this::gcCompletedTxn, gcPeriod);
        this.completedTxnGC.startAsync();
        this.completedTxnGC.awaitRunning();
        this.counter = new ZkInt96Counter(this.storeHelper);
        this.executor = executor;
    }

    private CompletableFuture<Void> gcCompletedTxn() {
        return ((CompletableFuture)this.storeHelper.getChildren(COMPLETED_TX_BATCH_ROOT_PATH).thenApply(children -> {
            List list = children.stream().map(Long::parseLong).sorted().collect(Collectors.toList());
            if (list.size() > 2) {
                return list.subList(0, list.size() - 2);
            }
            return new ArrayList();
        })).thenCompose(toDeleteList -> {
            log.debug("deleting batches {} on new scheme", toDeleteList);
            return Futures.allOf((Collection)toDeleteList.stream().map(toDelete -> this.storeHelper.deleteTree(String.format(COMPLETED_TX_BATCH_PATH, toDelete))).collect(Collectors.toList()));
        });
    }

    @Override
    ZKStream newStream(String scopeName, String name) {
        return new ZKStream(scopeName, name, this.storeHelper, this.completedTxnGC::getLatestBatch, this.executor, this.orderer);
    }

    @Override
    CompletableFuture<Int96> getNextCounter() {
        return this.counter.getNextCounter();
    }

    @Override
    public CompletableFuture<Boolean> checkScopeExists(String scope, OperationContext context, Executor executor) {
        String scopePath = ZKPaths.makePath((String)SCOPE_ROOT_PATH, (String)scope);
        return this.storeHelper.checkExists(scopePath);
    }

    @Override
    Version getEmptyVersion() {
        return Version.IntVersion.EMPTY;
    }

    @Override
    Version parseVersionData(byte[] data) {
        return Version.IntVersion.fromBytes(data);
    }

    @Override
    ReaderGroup newReaderGroup(String scope, String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    ZKScope newScope(String scopeName) {
        return new ZKScope(scopeName, this.storeHelper);
    }

    @Override
    public CompletableFuture<String> getScopeConfiguration(String scopeName, OperationContext context, Executor executor) {
        return this.storeHelper.checkExists(String.format("/store/%s", scopeName)).thenApply(scopeExists -> {
            if (scopeExists.booleanValue()) {
                return scopeName;
            }
            throw StoreException.create(StoreException.Type.DATA_NOT_FOUND, scopeName);
        });
    }

    @Override
    public CompletableFuture<List<String>> listScopes(Executor executor, long requestId) {
        return this.storeHelper.getChildren(SCOPE_ROOT_PATH).thenApply(children -> children.stream().filter(x -> !x.equals("_streamsinscope")).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listScopes(String continuationToken, int limit, Executor executor, long requestId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> addStreamTagsToIndex(String scope, String name, StreamConfiguration config, OperationContext context, Executor executor) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> removeTagsFromIndex(String scope, String name, Set<String> tagsRemoved, OperationContext context, Executor executor) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> addReaderGroupToScope(String scopeName, String rgName, UUID readerGroupId, OperationContext context, Executor executor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Boolean> checkReaderGroupExists(String scope, String rgName, OperationContext context, Executor executor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<UUID> getReaderGroupId(String scopeName, String rgName, OperationContext context, Executor executor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<CreateStreamResponse> createStream(String scope, String name, StreamConfiguration configuration, long createTimestamp, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        ZKScope zkScope = (ZKScope)this.getScope(scope, context);
        ZKStream zkStream = (ZKStream)this.getStream(scope, name, context);
        return super.createStream(scope, name, configuration, createTimestamp, context, executor).thenCompose(status -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)zkScope.getNextStreamPosition().thenCompose(zkStream::createStreamPositionNodeIfAbsent)).thenCompose(v -> zkStream.getStreamPosition())).thenCompose(id -> zkScope.addStreamToScope(name, (int)id))).thenApply(x -> status));
    }

    @Override
    public CompletableFuture<Boolean> checkStreamExists(String scopeName, String streamName, OperationContext context, Executor executor) {
        ZKStream stream = (ZKStream)this.getStream(scopeName, streamName, context);
        return this.storeHelper.checkExists(stream.getStreamPath());
    }

    @Override
    public CompletableFuture<Integer> getSafeStartingSegmentNumberFor(String scopeName, String streamName, OperationContext context, Executor executor) {
        long requestId = this.getOperationContext(context).getRequestId();
        return this.storeHelper.getData(String.format(DELETED_STREAMS_PATH, this.getScopedStreamName(scopeName, streamName)), x -> BitConverter.readInt((byte[])x, (int)0)).handleAsync((data, ex) -> {
            if (ex == null) {
                return (Integer)data.getObject() + 1;
            }
            if (ex instanceof StoreException.DataNotFoundException) {
                return 0;
            }
            log.warn(requestId, "Problem found while getting a safe starting segment number for {}.", new Object[]{this.getScopedStreamName(scopeName, streamName), ex});
            throw new CompletionException((Throwable)ex);
        });
    }

    @Override
    CompletableFuture<Void> recordLastStreamSegment(String scope, String stream, int lastActiveSegment, OperationContext ctx, Executor executor) {
        OperationContext context = this.getOperationContext(ctx);
        String deletePath = String.format(DELETED_STREAMS_PATH, this.getScopedStreamName(scope, stream));
        byte[] maxSegmentNumberBytes = new byte[4];
        BitConverter.writeInt((byte[])maxSegmentNumberBytes, (int)0, (int)lastActiveSegment);
        return ((CompletableFuture)this.storeHelper.getData(deletePath, x -> BitConverter.readInt((byte[])x, (int)0)).exceptionally(e -> {
            if (e instanceof StoreException.DataNotFoundException) {
                return null;
            }
            throw new CompletionException((Throwable)e);
        })).thenCompose(data -> {
            log.debug(context.getRequestId(), "Recording last segment {} for stream {}/{} on deletion.", new Object[]{lastActiveSegment, scope, stream});
            if (data == null) {
                return Futures.toVoid(this.storeHelper.createZNodeIfNotExist(deletePath, maxSegmentNumberBytes));
            }
            int oldLastActiveSegment = (Integer)data.getObject();
            Preconditions.checkArgument((lastActiveSegment >= oldLastActiveSegment ? 1 : 0) != 0, (String)"Old last active segment ({}) for {}/{} is higher than current one {}.", (Object)oldLastActiveSegment, (Object)scope, (Object)stream, (Object)lastActiveSegment);
            return Futures.toVoid(this.storeHelper.setData(deletePath, maxSegmentNumberBytes, data.getVersion()));
        });
    }

    @Override
    public CompletableFuture<Void> deleteStream(String scope, String name, OperationContext context, Executor executor) {
        ZKScope zkScope = (ZKScope)this.getScope(scope, context);
        ZKStream zkStream = (ZKStream)this.getStream(scope, name, context);
        return Futures.exceptionallyExpecting((CompletableFuture)zkStream.getStreamPosition().thenCompose(id -> zkScope.removeStreamFromScope(name, (int)id)), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, null).thenCompose(v -> super.deleteStream(scope, name, context, executor));
    }

    @VisibleForTesting
    public void setStoreHelperForTesting(ZKStoreHelper storeHelper) {
        this.storeHelper = storeHelper;
    }

    @Override
    public void close() {
        this.completedTxnGC.stopAsync();
        this.completedTxnGC.awaitTerminated();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    ZKStoreHelper getStoreHelper() {
        return this.storeHelper;
    }
}

