/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.lang.AtomicInt96;
import io.pravega.common.lang.Int96;
import io.pravega.controller.store.ZKStoreHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkInt96Counter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZkInt96Counter.class);
    @VisibleForTesting
    static final int COUNTER_RANGE = 10000;
    @VisibleForTesting
    static final String COUNTER_PATH = "/counter";
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final AtomicInt96 limit;
    @GuardedBy(value="lock")
    private final AtomicInt96 counter = new AtomicInt96();
    @GuardedBy(value="lock")
    private CompletableFuture<Void> refreshFutureRef = null;
    private ZKStoreHelper storeHelper;

    public ZkInt96Counter(ZKStoreHelper storeHelper) {
        this.limit = new AtomicInt96();
        this.storeHelper = storeHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Int96> getNextCounter() {
        CompletionStage<Object> future;
        Object object = this.lock;
        synchronized (object) {
            Int96 next = this.counter.incrementAndGet();
            future = next.compareTo(this.limit.get()) > 0 ? this.refreshRangeIfNeeded().thenCompose(x -> this.getNextCounter()) : CompletableFuture.completedFuture(next);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    CompletableFuture<Void> refreshRangeIfNeeded() {
        CompletableFuture<Void> refreshFuture;
        Object object = this.lock;
        synchronized (object) {
            refreshFuture = this.refreshFutureRef;
            if (this.refreshFutureRef == null) {
                if (this.counter.get().compareTo(this.limit.get()) >= 0) {
                    log.info("Refreshing counter range. Current counter is {}. Current limit is {}", (Object)this.counter.get(), (Object)this.limit.get());
                    refreshFuture = this.refreshFutureRef = this.getRefreshFuture().exceptionally(e -> {
                        Object object = this.lock;
                        synchronized (object) {
                            this.refreshFutureRef = null;
                        }
                        log.warn("Exception thrown while trying to refresh transaction counter range", e);
                        throw new CompletionException((Throwable)e);
                    });
                } else {
                    refreshFuture = CompletableFuture.completedFuture(null);
                }
            }
        }
        return refreshFuture;
    }

    @VisibleForTesting
    CompletableFuture<Void> getRefreshFuture() {
        return this.storeHelper.createZNodeIfNotExist(COUNTER_PATH, Int96.ZERO.toBytes()).thenCompose(v -> this.storeHelper.getData(COUNTER_PATH, Int96::fromBytes).thenCompose(data -> {
            Int96 previous = (Int96)data.getObject();
            Int96 nextLimit = previous.add(10000);
            return this.storeHelper.setData(COUNTER_PATH, nextLimit.toBytes(), data.getVersion()).thenAccept(x -> {
                Object object = this.lock;
                synchronized (object) {
                    this.counter.set(previous.getMsb(), previous.getLsb());
                    this.limit.set(nextLimit.getMsb(), nextLimit.getLsb());
                    this.refreshFutureRef = null;
                    log.info("Refreshed counter range. Current counter is {}. Current limit is {}", (Object)this.counter.get(), (Object)this.limit.get());
                }
            });
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setCounterAndLimitForTesting(int counterMsb, long counterLsb, int limitMsb, long limitLsb) {
        Object object = this.lock;
        synchronized (object) {
            this.limit.set(limitMsb, limitLsb);
            this.counter.set(counterMsb, counterLsb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Int96 getLimitForTesting() {
        Object object = this.lock;
        synchronized (object) {
            return this.limit.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Int96 getCounterForTesting() {
        Object object = this.lock;
        synchronized (object) {
            return this.counter.get();
        }
    }
}

