/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.store.ZKStoreHelper;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.ZKStreamMetadataStore;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.curator.utils.ZKPaths;
import org.slf4j.LoggerFactory;

class ZkOrderedStore {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(ZkOrderedStore.class));
    private static final String COLLECTIONS_NODE = "collections";
    private static final String SEALED_NODE = "sealed";
    private static final String ENTITIES_NODE = "entities";
    private static final String POSITION_NODE = "pos";
    private final ZKStoreHelper storeHelper;
    private final String ordererName;
    private final Executor executor;
    private final int rollOverAfter;

    ZkOrderedStore(String ordererName, ZKStoreHelper storeHelper, Executor executor) {
        this(ordererName, storeHelper, executor, 1932735276);
    }

    @VisibleForTesting
    ZkOrderedStore(String ordererName, ZKStoreHelper storeHelper, Executor executor, int rollOverAfter) {
        this.ordererName = ordererName;
        this.storeHelper = storeHelper;
        this.executor = executor;
        this.rollOverAfter = rollOverAfter;
    }

    CompletableFuture<Long> addEntity(String scope, String stream, String entity, long requestId) {
        return ((CompletableFuture)this.getLatestCollection(scope, stream).thenCompose(latestcollectionNum -> this.storeHelper.createPersistentSequentialZNode(this.getEntitySequentialPath(scope, stream, (Integer)latestcollectionNum), entity.getBytes(Charsets.UTF_8)).thenCompose(positionPath -> {
            int position = this.getPositionFromPath((String)positionPath);
            if (position > this.rollOverAfter) {
                return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.storeHelper.deletePath((String)positionPath, false).thenCompose(v -> this.storeHelper.createZNodeIfNotExist(this.getCollectionSealedPath(scope, stream, (Integer)latestcollectionNum)))).thenCompose(v -> this.storeHelper.createPersistentSequentialZNode(this.getEntitySequentialPath(scope, stream, latestcollectionNum + 1), entity.getBytes(Charsets.UTF_8)))).thenApply(newPositionPath -> Position.toLong(latestcollectionNum + 1, this.getPositionFromPath((String)newPositionPath)))).thenCompose(orderedPosition -> this.tryDeleteSealedCollection(scope, stream, (Integer)latestcollectionNum).thenApply(v -> orderedPosition));
            }
            return CompletableFuture.completedFuture(Position.toLong(latestcollectionNum, position));
        }))).whenComplete((r, e) -> {
            if (e != null) {
                log.error(requestId, "error encountered while trying to add entity {} for stream {}/{}", new Object[]{entity, scope, stream, e});
            } else {
                log.debug(requestId, "entity {} added for stream {}/{} at position {}", new Object[]{entity, scope, stream, r});
            }
        });
    }

    CompletableFuture<Void> removeEntities(String scope, String stream, Collection<Long> entities) {
        Set<Integer> collections = entities.stream().collect(Collectors.groupingBy(x -> new Position((long)x.longValue()).collectionNumber)).keySet();
        return ((CompletableFuture)Futures.allOf((Collection)entities.stream().map(entity -> this.storeHelper.deletePath(this.getEntityPath(scope, stream, (long)entity), false)).collect(Collectors.toList())).thenCompose(v -> Futures.allOf((Collection)collections.stream().map(collectionNum -> this.isSealed(scope, stream, (int)collectionNum).thenCompose(sealed -> {
            if (sealed.booleanValue()) {
                return this.tryDeleteSealedCollection(scope, stream, (Integer)collectionNum);
            }
            return CompletableFuture.completedFuture(null);
        })).collect(Collectors.toList())))).whenComplete((r, e) -> {
            if (e != null) {
                log.error("error encountered while trying to remove entity positions {} for stream {}/{}", new Object[]{entities, scope, stream, e});
            } else {
                log.debug("entities at positions {} removed for stream {}/{}", new Object[]{entities, scope, stream});
            }
        });
    }

    CompletableFuture<Map<Long, String>> getEntitiesWithPosition(String scope, String stream) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        String collectionsPath = this.getCollectionsPath(scope, stream);
        return this.storeHelper.sync(collectionsPath).thenCompose(z -> ((CompletableFuture)((CompletableFuture)Futures.exceptionallyExpecting(this.storeHelper.getChildren(collectionsPath), (Predicate)ZKStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, Collections.emptyList()).thenCompose(children -> {
            List iterable = children.stream().map(Integer::parseInt).collect(Collectors.toList());
            return Futures.loop(iterable, collectionNumber -> ((CompletableFuture)Futures.exceptionallyExpecting(this.storeHelper.getChildren(this.getEntitiesPath(scope, stream, (Integer)collectionNumber)), (Predicate)ZKStreamMetadataStore.DATA_NOT_FOUND_PREDICATE, Collections.emptyList()).thenCompose(entities -> Futures.allOf((Collection)entities.stream().map(x -> {
                int pos = this.getPositionFromPath((String)x);
                return this.storeHelper.getData(this.getEntityPath(scope, stream, (int)collectionNumber, pos), m -> new String((byte[])m, Charsets.UTF_8)).thenAccept(r -> result.put(Position.toLong(collectionNumber, pos), (String)r.getObject()));
            }).collect(Collectors.toList())))).thenApply(v -> true), (Executor)this.executor);
        })).thenApply(v -> result)).whenComplete((r, e) -> {
            if (e != null) {
                log.error("error encountered while trying to retrieve entities for stream {}/{}", new Object[]{scope, stream, e});
            } else {
                log.debug("entities at positions {} retrieved for stream {}/{}", new Object[]{r, scope, stream});
            }
        }));
    }

    private String getStreamPath(String scope, String stream) {
        String scopePath = ZKPaths.makePath((String)this.ordererName, (String)scope);
        return ZKPaths.makePath((String)scopePath, (String)stream);
    }

    private String getCollectionsPath(String scope, String stream) {
        return ZKPaths.makePath((String)this.getStreamPath(scope, stream), (String)COLLECTIONS_NODE);
    }

    private String getCollectionPath(String scope, String stream, int collectionNum) {
        return ZKPaths.makePath((String)this.getCollectionsPath(scope, stream), (String)Integer.toString(collectionNum));
    }

    private String getCollectionSealedPath(String scope, String stream, Integer collectionNum) {
        return ZKPaths.makePath((String)this.getCollectionPath(scope, stream, collectionNum), (String)SEALED_NODE);
    }

    private String getEntitiesPath(String scope, String stream, Integer collectionNum) {
        return ZKPaths.makePath((String)this.getCollectionPath(scope, stream, collectionNum), (String)ENTITIES_NODE);
    }

    private String getEntitySequentialPath(String scope, String stream, Integer collectionNum) {
        return ZKPaths.makePath((String)this.getEntitiesPath(scope, stream, collectionNum), (String)POSITION_NODE);
    }

    private String getEntityPath(String scope, String stream, int collectionNumber, int position) {
        return String.format("%s%010d", this.getEntitySequentialPath(scope, stream, collectionNumber), position);
    }

    private String getEntityPath(String scope, String stream, long entity) {
        Position position = new Position(entity);
        return this.getEntityPath(scope, stream, position.collectionNumber, position.positionInCollection);
    }

    private int getPositionFromPath(String name) {
        return Integer.parseInt(name.substring(name.length() - 10));
    }

    private CompletableFuture<Integer> getLatestCollection(String scope, String stream) {
        return this.storeHelper.getChildren(this.getCollectionsPath(scope, stream)).thenCompose(children -> {
            int latestcollectionNum = children.stream().mapToInt(Integer::parseInt).max().orElse(0);
            return this.storeHelper.checkExists(this.getCollectionSealedPath(scope, stream, latestcollectionNum)).thenCompose(sealed -> {
                if (sealed.booleanValue()) {
                    return this.storeHelper.createZNodeIfNotExist(this.getCollectionPath(scope, stream, latestcollectionNum + 1)).thenApply(v -> latestcollectionNum + 1);
                }
                return CompletableFuture.completedFuture(latestcollectionNum);
            });
        });
    }

    private CompletableFuture<Void> tryDeleteSealedCollection(String scope, String stream, Integer collectionNum) {
        return ((CompletableFuture)this.getLatestCollection(scope, stream).thenCompose(latestcollectionNum -> this.storeHelper.getChildren(this.getEntitiesPath(scope, stream, collectionNum)).thenCompose(entitiesPos -> {
            String entitiesPath = this.getEntitiesPath(scope, stream, collectionNum);
            return Futures.allOf((Collection)entitiesPos.stream().filter(pos -> this.getPositionFromPath((String)pos) > this.rollOverAfter).map(pos -> this.storeHelper.deletePath(ZKPaths.makePath((String)entitiesPath, (String)pos), false)).collect(Collectors.toList()));
        }))).thenCompose(x -> Futures.exceptionallyExpecting((CompletableFuture)this.storeHelper.deletePath(this.getEntitiesPath(scope, stream, collectionNum), false).thenCompose(v -> this.storeHelper.deleteTree(this.getCollectionPath(scope, stream, collectionNum))), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotEmptyException, null));
    }

    @VisibleForTesting
    CompletableFuture<Boolean> isSealed(String scope, String stream, int collectionNum) {
        return Futures.exceptionallyExpecting((CompletableFuture)this.storeHelper.getData(this.getCollectionSealedPath(scope, stream, collectionNum), x -> x).thenApply(v -> true), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)false);
    }

    @VisibleForTesting
    CompletableFuture<Boolean> isDeleted(String scope, String stream, int collectionNum) {
        return Futures.exceptionallyExpecting((CompletableFuture)this.storeHelper.getData(this.getCollectionPath(scope, stream, collectionNum), x -> x).thenApply(v -> false), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)true);
    }

    @VisibleForTesting
    CompletableFuture<Boolean> positionExists(String scope, String stream, long position) {
        return Futures.exceptionallyExpecting((CompletableFuture)this.storeHelper.getData(this.getEntityPath(scope, stream, position), x -> x).thenApply(v -> true), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)false);
    }

    @VisibleForTesting
    static class Position {
        private final int collectionNumber;
        private final int positionInCollection;

        public Position(long position) {
            this.collectionNumber = (int)(position >> 32);
            this.positionInCollection = (int)position;
        }

        static long toLong(int collectionNumber, int positionInCollection) {
            return (long)collectionNumber << 32 | (long)positionInCollection & 0xFFFFFFFFL;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getCollectionNumber() {
            return this.collectionNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int getPositionInCollection() {
            return this.positionInCollection;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Position)) {
                return false;
            }
            Position other = (Position)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCollectionNumber() != other.getCollectionNumber()) {
                return false;
            }
            return this.getPositionInCollection() == other.getPositionInCollection();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Position;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCollectionNumber();
            result = result * 59 + this.getPositionInCollection();
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ZkOrderedStore.Position(collectionNumber=" + this.getCollectionNumber() + ", positionInCollection=" + this.getPositionInCollection() + ")";
        }

        @ConstructorProperties(value={"collectionNumber", "positionInCollection"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Position(int collectionNumber, int positionInCollection) {
            this.collectionNumber = collectionNumber;
            this.positionInCollection = positionInCollection;
        }
    }
}

