/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.controller.store.stream.TxnStatus;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveTxnRecord {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActiveTxnRecord.class);
    public static final ActiveTxnRecord EMPTY = ActiveTxnRecord.builder().txCreationTimestamp(Long.MIN_VALUE).leaseExpiryTime(Long.MIN_VALUE).maxExecutionExpiryTime(Long.MIN_VALUE).txnStatus(TxnStatus.UNKNOWN).writerId(Optional.empty()).commitTime(Optional.empty()).commitOrder(Optional.empty()).commitOffsets((ImmutableMap<Long, Long>)ImmutableMap.of()).build();
    public static final ActiveTxnRecordSerializer SERIALIZER = new ActiveTxnRecordSerializer();
    private final long txCreationTimestamp;
    private final long leaseExpiryTime;
    private final long maxExecutionExpiryTime;
    private final TxnStatus txnStatus;
    private final Optional<String> writerId;
    private final Optional<Long> commitTime;
    private final Optional<Long> commitOrder;
    private final ImmutableMap<Long, Long> commitOffsets;

    public ActiveTxnRecord(long txCreationTimestamp, long leaseExpiryTime, long maxExecutionExpiryTime, TxnStatus txnStatus) {
        this.txCreationTimestamp = txCreationTimestamp;
        this.leaseExpiryTime = leaseExpiryTime;
        this.maxExecutionExpiryTime = maxExecutionExpiryTime;
        this.txnStatus = txnStatus;
        this.writerId = Optional.empty();
        this.commitTime = Optional.empty();
        this.commitOrder = Optional.empty();
        this.commitOffsets = ImmutableMap.of();
    }

    public ActiveTxnRecord(long txCreationTimestamp, long leaseExpiryTime, long maxExecutionExpiryTime, TxnStatus txnStatus, String writerId, long commitTime, long commitOrder) {
        this(txCreationTimestamp, leaseExpiryTime, maxExecutionExpiryTime, txnStatus, writerId, commitTime, commitOrder, (ImmutableMap<Long, Long>)ImmutableMap.of());
    }

    public ActiveTxnRecord(long txCreationTimestamp, long leaseExpiryTime, long maxExecutionExpiryTime, TxnStatus txnStatus, String writerId, long commitTime, long commitOrder, ImmutableMap<Long, Long> commitOffsets) {
        this.txCreationTimestamp = txCreationTimestamp;
        this.leaseExpiryTime = leaseExpiryTime;
        this.maxExecutionExpiryTime = maxExecutionExpiryTime;
        this.txnStatus = txnStatus;
        this.writerId = Optional.ofNullable(writerId);
        this.commitTime = Optional.of(commitTime);
        this.commitOrder = Optional.of(commitOrder);
        this.commitOffsets = commitOffsets;
    }

    public String getWriterId() {
        return this.writerId.orElse("");
    }

    public long getCommitTime() {
        return this.commitTime.orElse(Long.MIN_VALUE);
    }

    public long getCommitOrder() {
        return this.commitOrder.orElse(Long.MIN_VALUE);
    }

    public static ActiveTxnRecord fromBytes(byte[] data) {
        return (ActiveTxnRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ActiveTxnRecordBuilder builder() {
        return new ActiveTxnRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTxCreationTimestamp() {
        return this.txCreationTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getLeaseExpiryTime() {
        return this.leaseExpiryTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMaxExecutionExpiryTime() {
        return this.maxExecutionExpiryTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TxnStatus getTxnStatus() {
        return this.txnStatus;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableMap<Long, Long> getCommitOffsets() {
        return this.commitOffsets;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActiveTxnRecord)) {
            return false;
        }
        ActiveTxnRecord other = (ActiveTxnRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTxCreationTimestamp() != other.getTxCreationTimestamp()) {
            return false;
        }
        if (this.getLeaseExpiryTime() != other.getLeaseExpiryTime()) {
            return false;
        }
        if (this.getMaxExecutionExpiryTime() != other.getMaxExecutionExpiryTime()) {
            return false;
        }
        TxnStatus this$txnStatus = this.getTxnStatus();
        TxnStatus other$txnStatus = other.getTxnStatus();
        if (this$txnStatus == null ? other$txnStatus != null : !((Object)((Object)this$txnStatus)).equals((Object)other$txnStatus)) {
            return false;
        }
        String this$writerId = this.getWriterId();
        String other$writerId = other.getWriterId();
        if (this$writerId == null ? other$writerId != null : !this$writerId.equals(other$writerId)) {
            return false;
        }
        if (this.getCommitTime() != other.getCommitTime()) {
            return false;
        }
        if (this.getCommitOrder() != other.getCommitOrder()) {
            return false;
        }
        ImmutableMap<Long, Long> this$commitOffsets = this.getCommitOffsets();
        ImmutableMap<Long, Long> other$commitOffsets = other.getCommitOffsets();
        return !(this$commitOffsets == null ? other$commitOffsets != null : !this$commitOffsets.equals(other$commitOffsets));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActiveTxnRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $txCreationTimestamp = this.getTxCreationTimestamp();
        result = result * 59 + (int)($txCreationTimestamp >>> 32 ^ $txCreationTimestamp);
        long $leaseExpiryTime = this.getLeaseExpiryTime();
        result = result * 59 + (int)($leaseExpiryTime >>> 32 ^ $leaseExpiryTime);
        long $maxExecutionExpiryTime = this.getMaxExecutionExpiryTime();
        result = result * 59 + (int)($maxExecutionExpiryTime >>> 32 ^ $maxExecutionExpiryTime);
        TxnStatus $txnStatus = this.getTxnStatus();
        result = result * 59 + ($txnStatus == null ? 43 : ((Object)((Object)$txnStatus)).hashCode());
        String $writerId = this.getWriterId();
        result = result * 59 + ($writerId == null ? 43 : $writerId.hashCode());
        long $commitTime = this.getCommitTime();
        result = result * 59 + (int)($commitTime >>> 32 ^ $commitTime);
        long $commitOrder = this.getCommitOrder();
        result = result * 59 + (int)($commitOrder >>> 32 ^ $commitOrder);
        ImmutableMap<Long, Long> $commitOffsets = this.getCommitOffsets();
        result = result * 59 + ($commitOffsets == null ? 43 : $commitOffsets.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ActiveTxnRecord(txCreationTimestamp=" + this.getTxCreationTimestamp() + ", leaseExpiryTime=" + this.getLeaseExpiryTime() + ", maxExecutionExpiryTime=" + this.getMaxExecutionExpiryTime() + ", txnStatus=" + this.getTxnStatus() + ", writerId=" + this.getWriterId() + ", commitTime=" + this.getCommitTime() + ", commitOrder=" + this.getCommitOrder() + ", commitOffsets=" + this.getCommitOffsets() + ")";
    }

    @ConstructorProperties(value={"txCreationTimestamp", "leaseExpiryTime", "maxExecutionExpiryTime", "txnStatus", "writerId", "commitTime", "commitOrder", "commitOffsets"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ActiveTxnRecord(long txCreationTimestamp, long leaseExpiryTime, long maxExecutionExpiryTime, TxnStatus txnStatus, Optional<String> writerId, Optional<Long> commitTime, Optional<Long> commitOrder, ImmutableMap<Long, Long> commitOffsets) {
        this.txCreationTimestamp = txCreationTimestamp;
        this.leaseExpiryTime = leaseExpiryTime;
        this.maxExecutionExpiryTime = maxExecutionExpiryTime;
        this.txnStatus = txnStatus;
        this.writerId = writerId;
        this.commitTime = commitTime;
        this.commitOrder = commitOrder;
        this.commitOffsets = commitOffsets;
    }

    private static class ActiveTxnRecordSerializer
    extends VersionedSerializer.WithBuilder<ActiveTxnRecord, ActiveTxnRecordBuilder> {
        private ActiveTxnRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01).revision(2, this::write02, this::read02);
        }

        private void read00(RevisionDataInput revisionDataInput, ActiveTxnRecordBuilder activeTxnRecordBuilder) throws IOException {
            activeTxnRecordBuilder.txCreationTimestamp(revisionDataInput.readLong()).leaseExpiryTime(revisionDataInput.readLong()).maxExecutionExpiryTime(revisionDataInput.readLong()).txnStatus(TxnStatus.values()[revisionDataInput.readCompactInt()]);
        }

        private void write00(ActiveTxnRecord activeTxnRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(activeTxnRecord.getTxCreationTimestamp());
            revisionDataOutput.writeLong(activeTxnRecord.getLeaseExpiryTime());
            revisionDataOutput.writeLong(activeTxnRecord.getMaxExecutionExpiryTime());
            revisionDataOutput.writeCompactInt(activeTxnRecord.getTxnStatus().ordinal());
        }

        private void read01(RevisionDataInput revisionDataInput, ActiveTxnRecordBuilder activeTxnRecordBuilder) throws IOException {
            activeTxnRecordBuilder.writerId(Optional.of(revisionDataInput.readUTF())).commitTime(Optional.of(revisionDataInput.readLong())).commitOrder(Optional.of(revisionDataInput.readLong()));
        }

        private void write01(ActiveTxnRecord activeTxnRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeUTF(activeTxnRecord.getWriterId());
            revisionDataOutput.writeLong(activeTxnRecord.getCommitTime());
            revisionDataOutput.writeLong(activeTxnRecord.getCommitOrder());
        }

        private void read02(RevisionDataInput revisionDataInput, ActiveTxnRecordBuilder activeTxnRecordBuilder) throws IOException {
            ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
            revisionDataInput.readMap(DataInput::readLong, DataInput::readLong, mapBuilder);
            activeTxnRecordBuilder.commitOffsets((ImmutableMap<Long, Long>)mapBuilder.build());
        }

        private void write02(ActiveTxnRecord activeTxnRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeMap(activeTxnRecord.commitOffsets, DataOutput::writeLong, DataOutput::writeLong);
        }

        protected ActiveTxnRecordBuilder newBuilder() {
            return ActiveTxnRecord.builder();
        }
    }

    public static class ActiveTxnRecordBuilder
    implements ObjectBuilder<ActiveTxnRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long txCreationTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long leaseExpiryTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long maxExecutionExpiryTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private TxnStatus txnStatus;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Optional<Long> commitOrder;
        private Optional<String> writerId = Optional.empty();
        private Optional<Long> commitTime = Optional.empty();
        private ImmutableMap<Long, Long> commitOffsets = ImmutableMap.of();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ActiveTxnRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ActiveTxnRecordBuilder txCreationTimestamp(long txCreationTimestamp) {
            this.txCreationTimestamp = txCreationTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ActiveTxnRecordBuilder leaseExpiryTime(long leaseExpiryTime) {
            this.leaseExpiryTime = leaseExpiryTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ActiveTxnRecordBuilder maxExecutionExpiryTime(long maxExecutionExpiryTime) {
            this.maxExecutionExpiryTime = maxExecutionExpiryTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ActiveTxnRecordBuilder txnStatus(TxnStatus txnStatus) {
            this.txnStatus = txnStatus;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ActiveTxnRecordBuilder writerId(Optional<String> writerId) {
            this.writerId = writerId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ActiveTxnRecordBuilder commitTime(Optional<Long> commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ActiveTxnRecordBuilder commitOrder(Optional<Long> commitOrder) {
            this.commitOrder = commitOrder;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ActiveTxnRecordBuilder commitOffsets(ImmutableMap<Long, Long> commitOffsets) {
            this.commitOffsets = commitOffsets;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ActiveTxnRecord build() {
            return new ActiveTxnRecord(this.txCreationTimestamp, this.leaseExpiryTime, this.maxExecutionExpiryTime, this.txnStatus, this.writerId, this.commitTime, this.commitOrder, this.commitOffsets);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ActiveTxnRecord.ActiveTxnRecordBuilder(txCreationTimestamp=" + this.txCreationTimestamp + ", leaseExpiryTime=" + this.leaseExpiryTime + ", maxExecutionExpiryTime=" + this.maxExecutionExpiryTime + ", txnStatus=" + this.txnStatus + ", writerId=" + this.writerId + ", commitTime=" + this.commitTime + ", commitOrder=" + this.commitOrder + ", commitOffsets=" + this.commitOffsets + ")";
        }
    }
}

