/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

public class CommittingTransactionsRecord {
    public static final CommitTransactionsRecordSerializer SERIALIZER = new CommitTransactionsRecordSerializer();
    public static final CommittingTransactionsRecord EMPTY = CommittingTransactionsRecord.builder().epoch(Integer.MIN_VALUE).transactionsToCommit((ImmutableList<UUID>)ImmutableList.of()).activeEpoch(Optional.empty()).build();
    private final int epoch;
    private final ImmutableList<UUID> transactionsToCommit;
    private Optional<Integer> activeEpoch;

    public CommittingTransactionsRecord(int epoch, @NonNull ImmutableList<UUID> transactionsToCommit) {
        this(epoch, transactionsToCommit, Optional.empty());
        if (transactionsToCommit == null) {
            throw new NullPointerException("transactionsToCommit is marked non-null but is null");
        }
    }

    public CommittingTransactionsRecord(int epoch, @NonNull ImmutableList<UUID> transactionsToCommit, int activeEpoch) {
        this(epoch, transactionsToCommit, Optional.of(activeEpoch));
        if (transactionsToCommit == null) {
            throw new NullPointerException("transactionsToCommit is marked non-null but is null");
        }
    }

    private CommittingTransactionsRecord(int epoch, @NonNull ImmutableList<UUID> transactionsToCommit, Optional<Integer> activeEpoch) {
        if (transactionsToCommit == null) {
            throw new NullPointerException("transactionsToCommit is marked non-null but is null");
        }
        this.epoch = epoch;
        this.transactionsToCommit = transactionsToCommit;
        this.activeEpoch = activeEpoch;
    }

    public static CommittingTransactionsRecord fromBytes(byte[] data) {
        return (CommittingTransactionsRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    public CommittingTransactionsRecord createRollingTxnRecord(int activeEpoch) {
        Preconditions.checkState((!this.activeEpoch.isPresent() ? 1 : 0) != 0);
        return new CommittingTransactionsRecord(this.epoch, this.transactionsToCommit, activeEpoch);
    }

    public boolean isRollingTxnRecord() {
        return this.activeEpoch.isPresent();
    }

    public int getCurrentEpoch() {
        Preconditions.checkState((boolean)this.activeEpoch.isPresent());
        return this.activeEpoch.get();
    }

    public int getNewTxnEpoch() {
        Preconditions.checkState((boolean)this.activeEpoch.isPresent());
        return this.activeEpoch.get() + 1;
    }

    public int getNewActiveEpoch() {
        Preconditions.checkState((boolean)this.activeEpoch.isPresent());
        return this.activeEpoch.get() + 2;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static CommittingTransactionsRecordBuilder builder() {
        return new CommittingTransactionsRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEpoch() {
        return this.epoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableList<UUID> getTransactionsToCommit() {
        return this.transactionsToCommit;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setActiveEpoch(Optional<Integer> activeEpoch) {
        this.activeEpoch = activeEpoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommittingTransactionsRecord)) {
            return false;
        }
        CommittingTransactionsRecord other = (CommittingTransactionsRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        ImmutableList<UUID> this$transactionsToCommit = this.getTransactionsToCommit();
        ImmutableList<UUID> other$transactionsToCommit = other.getTransactionsToCommit();
        if (this$transactionsToCommit == null ? other$transactionsToCommit != null : !this$transactionsToCommit.equals(other$transactionsToCommit)) {
            return false;
        }
        Optional<Integer> this$activeEpoch = this.getActiveEpoch();
        Optional<Integer> other$activeEpoch = other.getActiveEpoch();
        return !(this$activeEpoch == null ? other$activeEpoch != null : !((Object)this$activeEpoch).equals(other$activeEpoch));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommittingTransactionsRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEpoch();
        ImmutableList<UUID> $transactionsToCommit = this.getTransactionsToCommit();
        result = result * 59 + ($transactionsToCommit == null ? 43 : $transactionsToCommit.hashCode());
        Optional<Integer> $activeEpoch = this.getActiveEpoch();
        result = result * 59 + ($activeEpoch == null ? 43 : ((Object)$activeEpoch).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CommittingTransactionsRecord(epoch=" + this.getEpoch() + ", transactionsToCommit=" + this.getTransactionsToCommit() + ", activeEpoch=" + this.getActiveEpoch() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Optional<Integer> getActiveEpoch() {
        return this.activeEpoch;
    }

    private static class CommitTransactionsRecordSerializer
    extends VersionedSerializer.WithBuilder<CommittingTransactionsRecord, CommittingTransactionsRecordBuilder> {
        private CommitTransactionsRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, CommittingTransactionsRecordBuilder builder) throws IOException {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            builder.epoch(revisionDataInput.readInt());
            revisionDataInput.readCollection(RevisionDataInput::readUUID, (ImmutableCollection.Builder)listBuilder);
            builder.transactionsToCommit((ImmutableList<UUID>)listBuilder.build());
            int read = revisionDataInput.readInt();
            if (read == Integer.MIN_VALUE) {
                builder.activeEpoch(Optional.empty());
            } else {
                builder.activeEpoch(Optional.of(read));
            }
        }

        private void write00(CommittingTransactionsRecord record, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeInt(record.getEpoch());
            revisionDataOutput.writeCollection(record.getTransactionsToCommit(), RevisionDataOutput::writeUUID);
            revisionDataOutput.writeInt(record.getActiveEpoch().orElse(Integer.MIN_VALUE).intValue());
        }

        protected CommittingTransactionsRecordBuilder newBuilder() {
            return CommittingTransactionsRecord.builder();
        }
    }

    private static class CommittingTransactionsRecordBuilder
    implements ObjectBuilder<CommittingTransactionsRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int epoch;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableList<UUID> transactionsToCommit;
        private Optional<Integer> activeEpoch = Optional.empty();

        @SuppressFBWarnings(justification="generated code")
        @Generated
        CommittingTransactionsRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CommittingTransactionsRecordBuilder epoch(int epoch) {
            this.epoch = epoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CommittingTransactionsRecordBuilder transactionsToCommit(@NonNull ImmutableList<UUID> transactionsToCommit) {
            if (transactionsToCommit == null) {
                throw new NullPointerException("transactionsToCommit is marked non-null but is null");
            }
            this.transactionsToCommit = transactionsToCommit;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CommittingTransactionsRecordBuilder activeEpoch(Optional<Integer> activeEpoch) {
            this.activeEpoch = activeEpoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CommittingTransactionsRecord build() {
            return new CommittingTransactionsRecord(this.epoch, this.transactionsToCommit, this.activeEpoch);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "CommittingTransactionsRecord.CommittingTransactionsRecordBuilder(epoch=" + this.epoch + ", transactionsToCommit=" + this.transactionsToCommit + ", activeEpoch=" + this.activeEpoch + ")";
        }
    }
}

