/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class EpochRecord {
    public static final EpochRecordSerializer SERIALIZER = new EpochRecordSerializer();
    public static final long DEFAULT_COUNT_VALUE = -1L;
    private final int epoch;
    private final int referenceEpoch;
    private final ImmutableList<StreamSegmentRecord> segments;
    private final long creationTime;
    private final Map<Long, StreamSegmentRecord> segmentMap;
    private final long splits;
    private final long merges;

    public EpochRecord(int epoch, int referenceEpoch, @NonNull ImmutableList<StreamSegmentRecord> segments, long creationTime, long splits, long merges) {
        if (segments == null) {
            throw new NullPointerException("segments is marked non-null but is null");
        }
        this.epoch = epoch;
        this.referenceEpoch = referenceEpoch;
        this.segments = segments;
        this.creationTime = creationTime;
        this.segmentMap = segments.stream().collect(Collectors.toMap(StreamSegmentRecord::segmentId, x -> x));
        this.splits = splits;
        this.merges = merges;
    }

    public boolean hasSplitMergeCounts() {
        return this.getSplits() != -1L && this.getMerges() != -1L;
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    public boolean isDuplicate() {
        return this.epoch != this.referenceEpoch;
    }

    public static EpochRecord fromBytes(byte[] record) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(record, 0, record.length);
        return (EpochRecord)SERIALIZER.deserialize(inputStream);
    }

    public Set<Long> getSegmentIds() {
        return this.segmentMap.keySet();
    }

    public StreamSegmentRecord getSegment(long segmentId) {
        return this.segmentMap.get(segmentId);
    }

    public boolean containsSegment(long segmentId) {
        return this.segmentMap.containsKey(segmentId);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static EpochRecordBuilder builder() {
        return new EpochRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEpoch() {
        return this.epoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getReferenceEpoch() {
        return this.referenceEpoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableList<StreamSegmentRecord> getSegments() {
        return this.segments;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getCreationTime() {
        return this.creationTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getSplits() {
        return this.splits;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getMerges() {
        return this.merges;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EpochRecord)) {
            return false;
        }
        EpochRecord other = (EpochRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getReferenceEpoch() != other.getReferenceEpoch()) {
            return false;
        }
        ImmutableList<StreamSegmentRecord> this$segments = this.getSegments();
        ImmutableList<StreamSegmentRecord> other$segments = other.getSegments();
        if (this$segments == null ? other$segments != null : !this$segments.equals(other$segments)) {
            return false;
        }
        if (this.getCreationTime() != other.getCreationTime()) {
            return false;
        }
        Map<Long, StreamSegmentRecord> this$segmentMap = this.getSegmentMap();
        Map<Long, StreamSegmentRecord> other$segmentMap = other.getSegmentMap();
        if (this$segmentMap == null ? other$segmentMap != null : !((Object)this$segmentMap).equals(other$segmentMap)) {
            return false;
        }
        if (this.getSplits() != other.getSplits()) {
            return false;
        }
        return this.getMerges() == other.getMerges();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EpochRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEpoch();
        result = result * 59 + this.getReferenceEpoch();
        ImmutableList<StreamSegmentRecord> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : $segments.hashCode());
        long $creationTime = this.getCreationTime();
        result = result * 59 + (int)($creationTime >>> 32 ^ $creationTime);
        Map<Long, StreamSegmentRecord> $segmentMap = this.getSegmentMap();
        result = result * 59 + ($segmentMap == null ? 43 : ((Object)$segmentMap).hashCode());
        long $splits = this.getSplits();
        result = result * 59 + (int)($splits >>> 32 ^ $splits);
        long $merges = this.getMerges();
        result = result * 59 + (int)($merges >>> 32 ^ $merges);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "EpochRecord(epoch=" + this.getEpoch() + ", referenceEpoch=" + this.getReferenceEpoch() + ", segments=" + this.getSegments() + ", creationTime=" + this.getCreationTime() + ", segmentMap=" + this.getSegmentMap() + ", splits=" + this.getSplits() + ", merges=" + this.getMerges() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Map<Long, StreamSegmentRecord> getSegmentMap() {
        return this.segmentMap;
    }

    private static class EpochRecordSerializer
    extends VersionedSerializer.WithBuilder<EpochRecord, EpochRecordBuilder> {
        private EpochRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01);
        }

        private void read00(RevisionDataInput revisionDataInput, EpochRecordBuilder builder) throws IOException {
            builder.epoch(revisionDataInput.readInt()).referenceEpoch(revisionDataInput.readInt());
            ImmutableList.Builder segmentsBuilder = ImmutableList.builder();
            revisionDataInput.readCollection(arg_0 -> ((StreamSegmentRecord.StreamSegmentRecordSerializer)StreamSegmentRecord.SERIALIZER).deserialize(arg_0), (ImmutableCollection.Builder)segmentsBuilder);
            builder.segments((ImmutableList<StreamSegmentRecord>)segmentsBuilder.build()).creationTime(revisionDataInput.readLong());
        }

        private void write00(EpochRecord history, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeInt(history.getEpoch());
            revisionDataOutput.writeInt(history.getReferenceEpoch());
            revisionDataOutput.writeCollection(history.getSegments(), (arg_0, arg_1) -> ((StreamSegmentRecord.StreamSegmentRecordSerializer)StreamSegmentRecord.SERIALIZER).serialize(arg_0, arg_1));
            revisionDataOutput.writeLong(history.getCreationTime());
        }

        private void read01(RevisionDataInput revisionDataInput, EpochRecordBuilder builder) throws IOException {
            builder.splits(revisionDataInput.readLong()).merges(revisionDataInput.readLong());
        }

        private void write01(EpochRecord epochRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(epochRecord.getSplits());
            revisionDataOutput.writeLong(epochRecord.getMerges());
        }

        protected EpochRecordBuilder newBuilder() {
            return EpochRecord.builder();
        }
    }

    private static class EpochRecordBuilder
    implements ObjectBuilder<EpochRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int epoch;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int referenceEpoch;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableList<StreamSegmentRecord> segments;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long creationTime;
        private long splits = -1L;
        private long merges = -1L;

        private EpochRecordBuilder splits(long splitCount) {
            this.splits = splitCount;
            return this;
        }

        private EpochRecordBuilder merges(long mergeCount) {
            this.merges = mergeCount;
            return this;
        }

        public EpochRecord build() {
            return new EpochRecord(this.epoch, this.referenceEpoch, this.segments, this.creationTime, this.splits, this.merges);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        EpochRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EpochRecordBuilder epoch(int epoch) {
            this.epoch = epoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EpochRecordBuilder referenceEpoch(int referenceEpoch) {
            this.referenceEpoch = referenceEpoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EpochRecordBuilder segments(@NonNull ImmutableList<StreamSegmentRecord> segments) {
            if (segments == null) {
                throw new NullPointerException("segments is marked non-null but is null");
            }
            this.segments = segments;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EpochRecordBuilder creationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "EpochRecord.EpochRecordBuilder(epoch=" + this.epoch + ", referenceEpoch=" + this.referenceEpoch + ", segments=" + this.segments + ", creationTime=" + this.creationTime + ", splits=" + this.splits + ", merges=" + this.merges + ")";
        }
    }
}

