/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.controller.store.stream.records.HistoryTimeSeriesRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;

public class HistoryTimeSeries {
    public static final HistoryTimeSeriesSerializer SERIALIZER = new HistoryTimeSeriesSerializer();
    public static final int HISTORY_CHUNK_SIZE = 1000;
    private final ImmutableList<HistoryTimeSeriesRecord> historyRecords;

    public HistoryTimeSeries(@NonNull ImmutableList<HistoryTimeSeriesRecord> historyRecords) {
        if (historyRecords == null) {
            throw new NullPointerException("historyRecords is marked non-null but is null");
        }
        this.historyRecords = historyRecords;
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    public static HistoryTimeSeries fromBytes(byte[] record) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(record, 0, record.length);
        return (HistoryTimeSeries)SERIALIZER.deserialize(inputStream);
    }

    public HistoryTimeSeriesRecord getLatestRecord() {
        return (HistoryTimeSeriesRecord)this.historyRecords.get(this.historyRecords.size() - 1);
    }

    public static HistoryTimeSeries addHistoryRecord(HistoryTimeSeries series, HistoryTimeSeriesRecord record) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ImmutableList<HistoryTimeSeriesRecord> list = series.historyRecords;
        listBuilder.addAll(list);
        if (((HistoryTimeSeriesRecord)list.get(list.size() - 1)).getEpoch() == record.getEpoch() - 1) {
            listBuilder.add((Object)record);
        } else if (((HistoryTimeSeriesRecord)list.get(list.size() - 1)).getEpoch() != record.getEpoch()) {
            throw new IllegalArgumentException("new epoch record is not continuous");
        }
        return new HistoryTimeSeries((ImmutableList<HistoryTimeSeriesRecord>)listBuilder.build());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static HistoryTimeSeriesBuilder builder() {
        return new HistoryTimeSeriesBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableList<HistoryTimeSeriesRecord> getHistoryRecords() {
        return this.historyRecords;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryTimeSeries)) {
            return false;
        }
        HistoryTimeSeries other = (HistoryTimeSeries)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableList<HistoryTimeSeriesRecord> this$historyRecords = this.getHistoryRecords();
        ImmutableList<HistoryTimeSeriesRecord> other$historyRecords = other.getHistoryRecords();
        return !(this$historyRecords == null ? other$historyRecords != null : !this$historyRecords.equals(other$historyRecords));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HistoryTimeSeries;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableList<HistoryTimeSeriesRecord> $historyRecords = this.getHistoryRecords();
        result = result * 59 + ($historyRecords == null ? 43 : $historyRecords.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "HistoryTimeSeries(historyRecords=" + this.getHistoryRecords() + ")";
    }

    private static class HistoryTimeSeriesSerializer
    extends VersionedSerializer.WithBuilder<HistoryTimeSeries, HistoryTimeSeriesBuilder> {
        private HistoryTimeSeriesSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, HistoryTimeSeriesBuilder builder) throws IOException {
            ImmutableList.Builder historyBuilder = ImmutableList.builder();
            revisionDataInput.readCollection(arg_0 -> ((HistoryTimeSeriesRecord.HistoryTimeSeriesRecordSerializer)HistoryTimeSeriesRecord.SERIALIZER).deserialize(arg_0), (ImmutableCollection.Builder)historyBuilder);
            builder.historyRecords((ImmutableList<HistoryTimeSeriesRecord>)historyBuilder.build());
        }

        private void write00(HistoryTimeSeries history, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeCollection(history.getHistoryRecords(), (arg_0, arg_1) -> ((HistoryTimeSeriesRecord.HistoryTimeSeriesRecordSerializer)HistoryTimeSeriesRecord.SERIALIZER).serialize(arg_0, arg_1));
        }

        protected HistoryTimeSeriesBuilder newBuilder() {
            return HistoryTimeSeries.builder();
        }
    }

    private static class HistoryTimeSeriesBuilder
    implements ObjectBuilder<HistoryTimeSeries> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableList<HistoryTimeSeriesRecord> historyRecords;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        HistoryTimeSeriesBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HistoryTimeSeriesBuilder historyRecords(@NonNull ImmutableList<HistoryTimeSeriesRecord> historyRecords) {
            if (historyRecords == null) {
                throw new NullPointerException("historyRecords is marked non-null but is null");
            }
            this.historyRecords = historyRecords;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HistoryTimeSeries build() {
            return new HistoryTimeSeries(this.historyRecords);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "HistoryTimeSeries.HistoryTimeSeriesBuilder(historyRecords=" + this.historyRecords + ")";
        }
    }
}

