/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;

public class HistoryTimeSeriesRecord {
    public static final HistoryTimeSeriesRecordSerializer SERIALIZER = new HistoryTimeSeriesRecordSerializer();
    private final int epoch;
    private final int referenceEpoch;
    private final ImmutableList<StreamSegmentRecord> segmentsSealed;
    private final ImmutableList<StreamSegmentRecord> segmentsCreated;
    private final long scaleTime;

    public HistoryTimeSeriesRecord(int epoch, int referenceEpoch, @NonNull ImmutableList<StreamSegmentRecord> segmentsSealed, @NonNull ImmutableList<StreamSegmentRecord> segmentsCreated, long creationTime) {
        if (segmentsSealed == null) {
            throw new NullPointerException("segmentsSealed is marked non-null but is null");
        }
        if (segmentsCreated == null) {
            throw new NullPointerException("segmentsCreated is marked non-null but is null");
        }
        if (epoch == referenceEpoch) {
            if (epoch != 0) {
                Exceptions.checkNotNullOrEmpty(segmentsSealed, (String)"segments sealed");
            }
            Exceptions.checkNotNullOrEmpty(segmentsCreated, (String)"segments created");
        } else {
            Exceptions.checkArgument((segmentsSealed == null || segmentsSealed.isEmpty() ? 1 : 0) != 0, (String)"sealed segments", (String)"should be null for duplicate epoch", (Object[])new Object[0]);
            Exceptions.checkArgument((segmentsCreated == null || segmentsCreated.isEmpty() ? 1 : 0) != 0, (String)"created segments", (String)"should be null for duplicate epoch", (Object[])new Object[0]);
        }
        this.epoch = epoch;
        this.referenceEpoch = referenceEpoch;
        this.segmentsSealed = segmentsSealed;
        this.segmentsCreated = segmentsCreated;
        this.scaleTime = creationTime;
    }

    HistoryTimeSeriesRecord(int epoch, int referenceEpoch, long creationTime) {
        this(epoch, referenceEpoch, (ImmutableList<StreamSegmentRecord>)ImmutableList.of(), (ImmutableList<StreamSegmentRecord>)ImmutableList.of(), creationTime);
    }

    public boolean isDuplicate() {
        return this.epoch != this.referenceEpoch;
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    public static HistoryTimeSeriesRecord fromBytes(byte[] record) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(record, 0, record.length);
        return (HistoryTimeSeriesRecord)SERIALIZER.deserialize(inputStream);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static HistoryTimeSeriesRecordBuilder builder() {
        return new HistoryTimeSeriesRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableList<StreamSegmentRecord> getSegmentsSealed() {
        return this.segmentsSealed;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableList<StreamSegmentRecord> getSegmentsCreated() {
        return this.segmentsCreated;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryTimeSeriesRecord)) {
            return false;
        }
        HistoryTimeSeriesRecord other = (HistoryTimeSeriesRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEpoch() != other.getEpoch()) {
            return false;
        }
        if (this.getReferenceEpoch() != other.getReferenceEpoch()) {
            return false;
        }
        ImmutableList<StreamSegmentRecord> this$segmentsSealed = this.getSegmentsSealed();
        ImmutableList<StreamSegmentRecord> other$segmentsSealed = other.getSegmentsSealed();
        if (this$segmentsSealed == null ? other$segmentsSealed != null : !this$segmentsSealed.equals(other$segmentsSealed)) {
            return false;
        }
        ImmutableList<StreamSegmentRecord> this$segmentsCreated = this.getSegmentsCreated();
        ImmutableList<StreamSegmentRecord> other$segmentsCreated = other.getSegmentsCreated();
        if (this$segmentsCreated == null ? other$segmentsCreated != null : !this$segmentsCreated.equals(other$segmentsCreated)) {
            return false;
        }
        return this.getScaleTime() == other.getScaleTime();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HistoryTimeSeriesRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEpoch();
        result = result * 59 + this.getReferenceEpoch();
        ImmutableList<StreamSegmentRecord> $segmentsSealed = this.getSegmentsSealed();
        result = result * 59 + ($segmentsSealed == null ? 43 : $segmentsSealed.hashCode());
        ImmutableList<StreamSegmentRecord> $segmentsCreated = this.getSegmentsCreated();
        result = result * 59 + ($segmentsCreated == null ? 43 : $segmentsCreated.hashCode());
        long $scaleTime = this.getScaleTime();
        result = result * 59 + (int)($scaleTime >>> 32 ^ $scaleTime);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "HistoryTimeSeriesRecord(epoch=" + this.getEpoch() + ", referenceEpoch=" + this.getReferenceEpoch() + ", segmentsSealed=" + this.getSegmentsSealed() + ", segmentsCreated=" + this.getSegmentsCreated() + ", scaleTime=" + this.getScaleTime() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEpoch() {
        return this.epoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getReferenceEpoch() {
        return this.referenceEpoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getScaleTime() {
        return this.scaleTime;
    }

    static class HistoryTimeSeriesRecordSerializer
    extends VersionedSerializer.WithBuilder<HistoryTimeSeriesRecord, HistoryTimeSeriesRecordBuilder> {
        HistoryTimeSeriesRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, HistoryTimeSeriesRecordBuilder builder) throws IOException {
            builder.epoch(revisionDataInput.readInt()).referenceEpoch(revisionDataInput.readInt());
            ImmutableList.Builder sealedSegmentsBuilders = ImmutableList.builder();
            revisionDataInput.readCollection(arg_0 -> ((StreamSegmentRecord.StreamSegmentRecordSerializer)StreamSegmentRecord.SERIALIZER).deserialize(arg_0), (ImmutableCollection.Builder)sealedSegmentsBuilders);
            builder.segmentsSealed((ImmutableList<StreamSegmentRecord>)sealedSegmentsBuilders.build());
            ImmutableList.Builder segmentsCreatedBuilder = ImmutableList.builder();
            revisionDataInput.readCollection(arg_0 -> ((StreamSegmentRecord.StreamSegmentRecordSerializer)StreamSegmentRecord.SERIALIZER).deserialize(arg_0), (ImmutableCollection.Builder)segmentsCreatedBuilder);
            builder.segmentsCreated((ImmutableList<StreamSegmentRecord>)segmentsCreatedBuilder.build());
            builder.creationTime(revisionDataInput.readLong());
        }

        private void write00(HistoryTimeSeriesRecord history, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeInt(history.getEpoch());
            revisionDataOutput.writeInt(history.getReferenceEpoch());
            revisionDataOutput.writeCollection(history.getSegmentsSealed(), (arg_0, arg_1) -> ((StreamSegmentRecord.StreamSegmentRecordSerializer)StreamSegmentRecord.SERIALIZER).serialize(arg_0, arg_1));
            revisionDataOutput.writeCollection(history.getSegmentsCreated(), (arg_0, arg_1) -> ((StreamSegmentRecord.StreamSegmentRecordSerializer)StreamSegmentRecord.SERIALIZER).serialize(arg_0, arg_1));
            revisionDataOutput.writeLong(history.getScaleTime());
        }

        protected HistoryTimeSeriesRecordBuilder newBuilder() {
            return HistoryTimeSeriesRecord.builder();
        }
    }

    private static class HistoryTimeSeriesRecordBuilder
    implements ObjectBuilder<HistoryTimeSeriesRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int epoch;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int referenceEpoch;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableList<StreamSegmentRecord> segmentsSealed;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableList<StreamSegmentRecord> segmentsCreated;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long creationTime;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        HistoryTimeSeriesRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HistoryTimeSeriesRecordBuilder epoch(int epoch) {
            this.epoch = epoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HistoryTimeSeriesRecordBuilder referenceEpoch(int referenceEpoch) {
            this.referenceEpoch = referenceEpoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HistoryTimeSeriesRecordBuilder segmentsSealed(@NonNull ImmutableList<StreamSegmentRecord> segmentsSealed) {
            if (segmentsSealed == null) {
                throw new NullPointerException("segmentsSealed is marked non-null but is null");
            }
            this.segmentsSealed = segmentsSealed;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HistoryTimeSeriesRecordBuilder segmentsCreated(@NonNull ImmutableList<StreamSegmentRecord> segmentsCreated) {
            if (segmentsCreated == null) {
                throw new NullPointerException("segmentsCreated is marked non-null but is null");
            }
            this.segmentsCreated = segmentsCreated;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HistoryTimeSeriesRecordBuilder creationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public HistoryTimeSeriesRecord build() {
            return new HistoryTimeSeriesRecord(this.epoch, this.referenceEpoch, this.segmentsSealed, this.segmentsCreated, this.creationTime);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "HistoryTimeSeriesRecord.HistoryTimeSeriesRecordBuilder(epoch=" + this.epoch + ", referenceEpoch=" + this.referenceEpoch + ", segmentsSealed=" + this.segmentsSealed + ", segmentsCreated=" + this.segmentsCreated + ", creationTime=" + this.creationTime + ")";
        }
    }
}

