/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.control.impl.ModelHelper;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.RGStreamCutRecord;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderGroupConfigRecord {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReaderGroupConfigRecord.class);
    public static final ConfigurationRecordSerializer SERIALIZER = new ConfigurationRecordSerializer();
    private final long groupRefreshTimeMillis;
    private final long automaticCheckpointIntervalMillis;
    private final int maxOutstandingCheckpointRequest;
    private final int retentionTypeOrdinal;
    private final long generation;
    private final Map<String, RGStreamCutRecord> startingStreamCuts;
    private final Map<String, RGStreamCutRecord> endingStreamCuts;
    private final boolean updating;

    public static ReaderGroupConfigRecord update(ReaderGroupConfig rgConfig, long generation, boolean isUpdating) {
        Map<String, RGStreamCutRecord> startStreamCuts = rgConfig.getStartingStreamCuts().entrySet().stream().collect(Collectors.toMap(e -> ((Stream)e.getKey()).getScopedName(), e -> new RGStreamCutRecord(ModelHelper.getStreamCutMap((StreamCut)((StreamCut)e.getValue())))));
        Map<String, RGStreamCutRecord> endStreamCuts = rgConfig.getEndingStreamCuts().entrySet().stream().collect(Collectors.toMap(e -> ((Stream)e.getKey()).getScopedName(), e -> new RGStreamCutRecord(ModelHelper.getStreamCutMap((StreamCut)((StreamCut)e.getValue())))));
        return ReaderGroupConfigRecord.builder().generation(generation).groupRefreshTimeMillis(rgConfig.getGroupRefreshTimeMillis()).automaticCheckpointIntervalMillis(rgConfig.getAutomaticCheckpointIntervalMillis()).maxOutstandingCheckpointRequest(rgConfig.getMaxOutstandingCheckpointRequest()).retentionTypeOrdinal(rgConfig.getRetentionType().ordinal()).startingStreamCuts(startStreamCuts).endingStreamCuts(endStreamCuts).updating(isUpdating).build();
    }

    public static ReaderGroupConfigRecord complete(ReaderGroupConfigRecord rgConfigRecord) {
        return ReaderGroupConfigRecord.builder().generation(rgConfigRecord.getGeneration()).groupRefreshTimeMillis(rgConfigRecord.getGroupRefreshTimeMillis()).automaticCheckpointIntervalMillis(rgConfigRecord.getAutomaticCheckpointIntervalMillis()).maxOutstandingCheckpointRequest(rgConfigRecord.getMaxOutstandingCheckpointRequest()).retentionTypeOrdinal(rgConfigRecord.getRetentionTypeOrdinal()).startingStreamCuts(rgConfigRecord.getStartingStreamCuts()).endingStreamCuts(rgConfigRecord.getEndingStreamCuts()).updating(false).build();
    }

    public static ReaderGroupConfigRecord fromBytes(byte[] data) {
        return (ReaderGroupConfigRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ReaderGroupConfigRecordBuilder builder() {
        return new ReaderGroupConfigRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getGroupRefreshTimeMillis() {
        return this.groupRefreshTimeMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getAutomaticCheckpointIntervalMillis() {
        return this.automaticCheckpointIntervalMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxOutstandingCheckpointRequest() {
        return this.maxOutstandingCheckpointRequest;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRetentionTypeOrdinal() {
        return this.retentionTypeOrdinal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getGeneration() {
        return this.generation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, RGStreamCutRecord> getStartingStreamCuts() {
        return this.startingStreamCuts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, RGStreamCutRecord> getEndingStreamCuts() {
        return this.endingStreamCuts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isUpdating() {
        return this.updating;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReaderGroupConfigRecord)) {
            return false;
        }
        ReaderGroupConfigRecord other = (ReaderGroupConfigRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGroupRefreshTimeMillis() != other.getGroupRefreshTimeMillis()) {
            return false;
        }
        if (this.getAutomaticCheckpointIntervalMillis() != other.getAutomaticCheckpointIntervalMillis()) {
            return false;
        }
        if (this.getMaxOutstandingCheckpointRequest() != other.getMaxOutstandingCheckpointRequest()) {
            return false;
        }
        if (this.getRetentionTypeOrdinal() != other.getRetentionTypeOrdinal()) {
            return false;
        }
        if (this.getGeneration() != other.getGeneration()) {
            return false;
        }
        Map<String, RGStreamCutRecord> this$startingStreamCuts = this.getStartingStreamCuts();
        Map<String, RGStreamCutRecord> other$startingStreamCuts = other.getStartingStreamCuts();
        if (this$startingStreamCuts == null ? other$startingStreamCuts != null : !((Object)this$startingStreamCuts).equals(other$startingStreamCuts)) {
            return false;
        }
        Map<String, RGStreamCutRecord> this$endingStreamCuts = this.getEndingStreamCuts();
        Map<String, RGStreamCutRecord> other$endingStreamCuts = other.getEndingStreamCuts();
        if (this$endingStreamCuts == null ? other$endingStreamCuts != null : !((Object)this$endingStreamCuts).equals(other$endingStreamCuts)) {
            return false;
        }
        return this.isUpdating() == other.isUpdating();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReaderGroupConfigRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $groupRefreshTimeMillis = this.getGroupRefreshTimeMillis();
        result = result * 59 + (int)($groupRefreshTimeMillis >>> 32 ^ $groupRefreshTimeMillis);
        long $automaticCheckpointIntervalMillis = this.getAutomaticCheckpointIntervalMillis();
        result = result * 59 + (int)($automaticCheckpointIntervalMillis >>> 32 ^ $automaticCheckpointIntervalMillis);
        result = result * 59 + this.getMaxOutstandingCheckpointRequest();
        result = result * 59 + this.getRetentionTypeOrdinal();
        long $generation = this.getGeneration();
        result = result * 59 + (int)($generation >>> 32 ^ $generation);
        Map<String, RGStreamCutRecord> $startingStreamCuts = this.getStartingStreamCuts();
        result = result * 59 + ($startingStreamCuts == null ? 43 : ((Object)$startingStreamCuts).hashCode());
        Map<String, RGStreamCutRecord> $endingStreamCuts = this.getEndingStreamCuts();
        result = result * 59 + ($endingStreamCuts == null ? 43 : ((Object)$endingStreamCuts).hashCode());
        result = result * 59 + (this.isUpdating() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ReaderGroupConfigRecord(groupRefreshTimeMillis=" + this.getGroupRefreshTimeMillis() + ", automaticCheckpointIntervalMillis=" + this.getAutomaticCheckpointIntervalMillis() + ", maxOutstandingCheckpointRequest=" + this.getMaxOutstandingCheckpointRequest() + ", retentionTypeOrdinal=" + this.getRetentionTypeOrdinal() + ", generation=" + this.getGeneration() + ", startingStreamCuts=" + this.getStartingStreamCuts() + ", endingStreamCuts=" + this.getEndingStreamCuts() + ", updating=" + this.isUpdating() + ")";
    }

    @ConstructorProperties(value={"groupRefreshTimeMillis", "automaticCheckpointIntervalMillis", "maxOutstandingCheckpointRequest", "retentionTypeOrdinal", "generation", "startingStreamCuts", "endingStreamCuts", "updating"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReaderGroupConfigRecord(long groupRefreshTimeMillis, long automaticCheckpointIntervalMillis, int maxOutstandingCheckpointRequest, int retentionTypeOrdinal, long generation, Map<String, RGStreamCutRecord> startingStreamCuts, Map<String, RGStreamCutRecord> endingStreamCuts, boolean updating) {
        this.groupRefreshTimeMillis = groupRefreshTimeMillis;
        this.automaticCheckpointIntervalMillis = automaticCheckpointIntervalMillis;
        this.maxOutstandingCheckpointRequest = maxOutstandingCheckpointRequest;
        this.retentionTypeOrdinal = retentionTypeOrdinal;
        this.generation = generation;
        this.startingStreamCuts = startingStreamCuts;
        this.endingStreamCuts = endingStreamCuts;
        this.updating = updating;
    }

    private static class ConfigurationRecordSerializer
    extends VersionedSerializer.WithBuilder<ReaderGroupConfigRecord, ReaderGroupConfigRecordBuilder> {
        private ConfigurationRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        protected void beforeSerialization(ReaderGroupConfigRecord configurationRecord) {
            Preconditions.checkNotNull((Object)configurationRecord);
            Preconditions.checkNotNull(configurationRecord.startingStreamCuts);
            Preconditions.checkNotNull(configurationRecord.endingStreamCuts);
        }

        private void read00(RevisionDataInput revisionDataInput, ReaderGroupConfigRecordBuilder configurationRecordBuilder) throws IOException {
            configurationRecordBuilder.groupRefreshTimeMillis(revisionDataInput.readLong());
            configurationRecordBuilder.automaticCheckpointIntervalMillis(revisionDataInput.readLong());
            configurationRecordBuilder.maxOutstandingCheckpointRequest(revisionDataInput.readInt());
            configurationRecordBuilder.retentionTypeOrdinal(revisionDataInput.readCompactInt());
            configurationRecordBuilder.generation(revisionDataInput.readLong());
            ImmutableMap.Builder startStreamCutBuilder = ImmutableMap.builder();
            revisionDataInput.readMap(DataInput::readUTF, arg_0 -> ((RGStreamCutRecord.RGStreamCutRecordSerializer)RGStreamCutRecord.SERIALIZER).deserialize(arg_0), startStreamCutBuilder);
            configurationRecordBuilder.startingStreamCuts((Map<String, RGStreamCutRecord>)startStreamCutBuilder.build());
            ImmutableMap.Builder endStreamCutBuilder = ImmutableMap.builder();
            revisionDataInput.readMap(DataInput::readUTF, arg_0 -> ((RGStreamCutRecord.RGStreamCutRecordSerializer)RGStreamCutRecord.SERIALIZER).deserialize(arg_0), endStreamCutBuilder);
            configurationRecordBuilder.endingStreamCuts((Map<String, RGStreamCutRecord>)endStreamCutBuilder.build());
            configurationRecordBuilder.updating(revisionDataInput.readBoolean());
        }

        private void write00(ReaderGroupConfigRecord rgConfigurationRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(rgConfigurationRecord.groupRefreshTimeMillis);
            revisionDataOutput.writeLong(rgConfigurationRecord.automaticCheckpointIntervalMillis);
            revisionDataOutput.writeInt(rgConfigurationRecord.maxOutstandingCheckpointRequest);
            revisionDataOutput.writeCompactInt(rgConfigurationRecord.retentionTypeOrdinal);
            revisionDataOutput.writeLong(rgConfigurationRecord.generation);
            revisionDataOutput.writeMap(rgConfigurationRecord.startingStreamCuts, DataOutput::writeUTF, (arg_0, arg_1) -> ((RGStreamCutRecord.RGStreamCutRecordSerializer)RGStreamCutRecord.SERIALIZER).serialize(arg_0, arg_1));
            revisionDataOutput.writeMap(rgConfigurationRecord.endingStreamCuts, DataOutput::writeUTF, (arg_0, arg_1) -> ((RGStreamCutRecord.RGStreamCutRecordSerializer)RGStreamCutRecord.SERIALIZER).serialize(arg_0, arg_1));
            revisionDataOutput.writeBoolean(rgConfigurationRecord.isUpdating());
        }

        protected ReaderGroupConfigRecordBuilder newBuilder() {
            return ReaderGroupConfigRecord.builder();
        }
    }

    public static class ReaderGroupConfigRecordBuilder
    implements ObjectBuilder<ReaderGroupConfigRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long groupRefreshTimeMillis;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long automaticCheckpointIntervalMillis;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxOutstandingCheckpointRequest;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int retentionTypeOrdinal;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long generation;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, RGStreamCutRecord> startingStreamCuts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, RGStreamCutRecord> endingStreamCuts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean updating;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ReaderGroupConfigRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigRecordBuilder groupRefreshTimeMillis(long groupRefreshTimeMillis) {
            this.groupRefreshTimeMillis = groupRefreshTimeMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigRecordBuilder automaticCheckpointIntervalMillis(long automaticCheckpointIntervalMillis) {
            this.automaticCheckpointIntervalMillis = automaticCheckpointIntervalMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigRecordBuilder maxOutstandingCheckpointRequest(int maxOutstandingCheckpointRequest) {
            this.maxOutstandingCheckpointRequest = maxOutstandingCheckpointRequest;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigRecordBuilder retentionTypeOrdinal(int retentionTypeOrdinal) {
            this.retentionTypeOrdinal = retentionTypeOrdinal;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigRecordBuilder generation(long generation) {
            this.generation = generation;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigRecordBuilder startingStreamCuts(Map<String, RGStreamCutRecord> startingStreamCuts) {
            this.startingStreamCuts = startingStreamCuts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigRecordBuilder endingStreamCuts(Map<String, RGStreamCutRecord> endingStreamCuts) {
            this.endingStreamCuts = endingStreamCuts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigRecordBuilder updating(boolean updating) {
            this.updating = updating;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReaderGroupConfigRecord build() {
            return new ReaderGroupConfigRecord(this.groupRefreshTimeMillis, this.automaticCheckpointIntervalMillis, this.maxOutstandingCheckpointRequest, this.retentionTypeOrdinal, this.generation, this.startingStreamCuts, this.endingStreamCuts, this.updating);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ReaderGroupConfigRecord.ReaderGroupConfigRecordBuilder(groupRefreshTimeMillis=" + this.groupRefreshTimeMillis + ", automaticCheckpointIntervalMillis=" + this.automaticCheckpointIntervalMillis + ", maxOutstandingCheckpointRequest=" + this.maxOutstandingCheckpointRequest + ", retentionTypeOrdinal=" + this.retentionTypeOrdinal + ", generation=" + this.generation + ", startingStreamCuts=" + this.startingStreamCuts + ", endingStreamCuts=" + this.endingStreamCuts + ", updating=" + this.updating + ")";
        }
    }
}

