/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.controller.store.stream.records.StreamCutReferenceRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCutRecord {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamCutRecord.class);
    public static final RetentionStreamCutRecordSerializer SERIALIZER = new RetentionStreamCutRecordSerializer();
    final long recordingTime;
    final long recordingSize;
    final ImmutableMap<Long, Long> streamCut;

    public StreamCutRecord(long recordingTime, long recordingSize, @NonNull ImmutableMap<Long, Long> streamCut) {
        if (streamCut == null) {
            throw new NullPointerException("streamCut is marked non-null but is null");
        }
        this.recordingTime = recordingTime;
        this.recordingSize = recordingSize;
        this.streamCut = streamCut;
    }

    public StreamCutReferenceRecord getReferenceRecord() {
        return new StreamCutReferenceRecord(this.recordingTime, this.recordingSize);
    }

    public Map<Long, Long> getStreamCut() {
        return Collections.unmodifiableMap(this.streamCut);
    }

    public static StreamCutRecord fromBytes(byte[] data) {
        return (StreamCutRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static StreamCutRecordBuilder builder() {
        return new StreamCutRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRecordingTime() {
        return this.recordingTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRecordingSize() {
        return this.recordingSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamCutRecord)) {
            return false;
        }
        StreamCutRecord other = (StreamCutRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRecordingTime() != other.getRecordingTime()) {
            return false;
        }
        if (this.getRecordingSize() != other.getRecordingSize()) {
            return false;
        }
        Map<Long, Long> this$streamCut = this.getStreamCut();
        Map<Long, Long> other$streamCut = other.getStreamCut();
        return !(this$streamCut == null ? other$streamCut != null : !((Object)this$streamCut).equals(other$streamCut));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StreamCutRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $recordingTime = this.getRecordingTime();
        result = result * 59 + (int)($recordingTime >>> 32 ^ $recordingTime);
        long $recordingSize = this.getRecordingSize();
        result = result * 59 + (int)($recordingSize >>> 32 ^ $recordingSize);
        Map<Long, Long> $streamCut = this.getStreamCut();
        result = result * 59 + ($streamCut == null ? 43 : ((Object)$streamCut).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "StreamCutRecord(recordingTime=" + this.getRecordingTime() + ", recordingSize=" + this.getRecordingSize() + ", streamCut=" + this.getStreamCut() + ")";
    }

    public static class RetentionStreamCutRecordSerializer
    extends VersionedSerializer.WithBuilder<StreamCutRecord, StreamCutRecordBuilder> {
        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, StreamCutRecordBuilder streamCutRecordBuilder) throws IOException {
            streamCutRecordBuilder.recordingTime(revisionDataInput.readLong()).recordingSize(revisionDataInput.readLong());
            ImmutableMap.Builder streamCutBuilder = ImmutableMap.builder();
            revisionDataInput.readMap(DataInput::readLong, DataInput::readLong, streamCutBuilder);
            streamCutRecordBuilder.streamCut((ImmutableMap<Long, Long>)streamCutBuilder.build());
        }

        private void write00(StreamCutRecord streamCutRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(streamCutRecord.getRecordingTime());
            revisionDataOutput.writeLong(streamCutRecord.getRecordingSize());
            revisionDataOutput.writeMap(streamCutRecord.getStreamCut(), DataOutput::writeLong, DataOutput::writeLong);
        }

        protected StreamCutRecordBuilder newBuilder() {
            return StreamCutRecord.builder();
        }
    }

    private static class StreamCutRecordBuilder
    implements ObjectBuilder<StreamCutRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long recordingTime;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long recordingSize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableMap<Long, Long> streamCut;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        StreamCutRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamCutRecordBuilder recordingTime(long recordingTime) {
            this.recordingTime = recordingTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamCutRecordBuilder recordingSize(long recordingSize) {
            this.recordingSize = recordingSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamCutRecordBuilder streamCut(@NonNull ImmutableMap<Long, Long> streamCut) {
            if (streamCut == null) {
                throw new NullPointerException("streamCut is marked non-null but is null");
            }
            this.streamCut = streamCut;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamCutRecord build() {
            return new StreamCutRecord(this.recordingTime, this.recordingSize, this.streamCut);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "StreamCutRecord.StreamCutRecordBuilder(recordingTime=" + this.recordingTime + ", recordingSize=" + this.recordingSize + ", streamCut=" + this.streamCut + ")";
        }
    }
}

