/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamSubscriber {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamSubscriber.class);
    public static final StreamSubscriberSerializer SERIALIZER = new StreamSubscriberSerializer();
    private final String subscriber;
    private final long generation;
    private final ImmutableMap<Long, Long> truncationStreamCut;
    private final long updateTime;

    public StreamSubscriber(@NonNull String subscriber, long generation, @NonNull ImmutableMap<Long, Long> truncationStreamCut, long updationTime) {
        if (subscriber == null) {
            throw new NullPointerException("subscriber is marked non-null but is null");
        }
        if (truncationStreamCut == null) {
            throw new NullPointerException("truncationStreamCut is marked non-null but is null");
        }
        this.subscriber = subscriber;
        this.generation = generation;
        this.truncationStreamCut = truncationStreamCut;
        this.updateTime = updationTime;
    }

    public static StreamSubscriber fromBytes(byte[] record) {
        return (StreamSubscriber)SERIALIZER.deserialize(record);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static StreamSubscriberBuilder builder() {
        return new StreamSubscriberBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSubscriber() {
        return this.subscriber;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getGeneration() {
        return this.generation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableMap<Long, Long> getTruncationStreamCut() {
        return this.truncationStreamCut;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamSubscriber)) {
            return false;
        }
        StreamSubscriber other = (StreamSubscriber)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$subscriber = this.getSubscriber();
        String other$subscriber = other.getSubscriber();
        if (this$subscriber == null ? other$subscriber != null : !this$subscriber.equals(other$subscriber)) {
            return false;
        }
        if (this.getGeneration() != other.getGeneration()) {
            return false;
        }
        ImmutableMap<Long, Long> this$truncationStreamCut = this.getTruncationStreamCut();
        ImmutableMap<Long, Long> other$truncationStreamCut = other.getTruncationStreamCut();
        if (this$truncationStreamCut == null ? other$truncationStreamCut != null : !this$truncationStreamCut.equals(other$truncationStreamCut)) {
            return false;
        }
        return this.getUpdateTime() == other.getUpdateTime();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StreamSubscriber;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subscriber = this.getSubscriber();
        result = result * 59 + ($subscriber == null ? 43 : $subscriber.hashCode());
        long $generation = this.getGeneration();
        result = result * 59 + (int)($generation >>> 32 ^ $generation);
        ImmutableMap<Long, Long> $truncationStreamCut = this.getTruncationStreamCut();
        result = result * 59 + ($truncationStreamCut == null ? 43 : $truncationStreamCut.hashCode());
        long $updateTime = this.getUpdateTime();
        result = result * 59 + (int)($updateTime >>> 32 ^ $updateTime);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "StreamSubscriber(subscriber=" + this.getSubscriber() + ", generation=" + this.getGeneration() + ", truncationStreamCut=" + this.getTruncationStreamCut() + ", updateTime=" + this.getUpdateTime() + ")";
    }

    private static class StreamSubscriberSerializer
    extends VersionedSerializer.WithBuilder<StreamSubscriber, StreamSubscriberBuilder> {
        private StreamSubscriberSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, StreamSubscriberBuilder recordBuilder) throws IOException {
            recordBuilder.subscriber(revisionDataInput.readUTF());
            recordBuilder.generation(revisionDataInput.readLong());
            recordBuilder.updationTime(revisionDataInput.readLong());
            ImmutableMap.Builder streamCutBuilder = ImmutableMap.builder();
            revisionDataInput.readMap(DataInput::readLong, DataInput::readLong, streamCutBuilder);
            recordBuilder.truncationStreamCut((ImmutableMap<Long, Long>)streamCutBuilder.build());
        }

        private void write00(StreamSubscriber subscriberRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeUTF(subscriberRecord.getSubscriber());
            revisionDataOutput.writeLong(subscriberRecord.getGeneration());
            revisionDataOutput.writeLong(subscriberRecord.getUpdateTime());
            revisionDataOutput.writeMap(subscriberRecord.getTruncationStreamCut(), DataOutput::writeLong, DataOutput::writeLong);
        }

        protected StreamSubscriberBuilder newBuilder() {
            return StreamSubscriber.builder();
        }
    }

    private static class StreamSubscriberBuilder
    implements ObjectBuilder<StreamSubscriber> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String subscriber;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long generation;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableMap<Long, Long> truncationStreamCut;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long updationTime;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        StreamSubscriberBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSubscriberBuilder subscriber(@NonNull String subscriber) {
            if (subscriber == null) {
                throw new NullPointerException("subscriber is marked non-null but is null");
            }
            this.subscriber = subscriber;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSubscriberBuilder generation(long generation) {
            this.generation = generation;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSubscriberBuilder truncationStreamCut(@NonNull ImmutableMap<Long, Long> truncationStreamCut) {
            if (truncationStreamCut == null) {
                throw new NullPointerException("truncationStreamCut is marked non-null but is null");
            }
            this.truncationStreamCut = truncationStreamCut;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSubscriberBuilder updationTime(long updationTime) {
            this.updationTime = updationTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSubscriber build() {
            return new StreamSubscriber(this.subscriber, this.generation, this.truncationStreamCut, this.updationTime);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "StreamSubscriber.StreamSubscriberBuilder(subscriber=" + this.subscriber + ", generation=" + this.generation + ", truncationStreamCut=" + this.truncationStreamCut + ", updationTime=" + this.updationTime + ")";
        }
    }
}

