/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscribers {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Subscribers.class);
    public static final Subscribers EMPTY_SET = new Subscribers((ImmutableSet<String>)ImmutableSet.of());
    public static final SubscriberSetSerializer SERIALIZER = new SubscriberSetSerializer();
    private final ImmutableSet<String> subscribers;

    public Subscribers(@NonNull ImmutableSet<String> subscribers) {
        if (subscribers == null) {
            throw new NullPointerException("subscribers is marked non-null but is null");
        }
        this.subscribers = subscribers;
    }

    public static Subscribers add(@NonNull Subscribers subscriberSet, @NonNull String subscriber) {
        if (subscriberSet == null) {
            throw new NullPointerException("subscriberSet is marked non-null but is null");
        }
        if (subscriber == null) {
            throw new NullPointerException("subscriber is marked non-null but is null");
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(subscriberSet.subscribers);
        builder.add((Object)subscriber);
        return new Subscribers((ImmutableSet<String>)builder.build());
    }

    public static Subscribers remove(@NonNull Subscribers subscriberSet, @NonNull String subscriber) {
        if (subscriberSet == null) {
            throw new NullPointerException("subscriberSet is marked non-null but is null");
        }
        if (subscriber == null) {
            throw new NullPointerException("subscriber is marked non-null but is null");
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        subscriberSet.getSubscribers().forEach(s -> {
            if (!s.equals(subscriber)) {
                builder.add(s);
            }
        });
        return new Subscribers((ImmutableSet<String>)builder.build());
    }

    public static Subscribers fromBytes(byte[] data) {
        return (Subscribers)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SubscribersBuilder builder() {
        return new SubscribersBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscribers)) {
            return false;
        }
        Subscribers other = (Subscribers)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableSet<String> this$subscribers = this.getSubscribers();
        ImmutableSet<String> other$subscribers = other.getSubscribers();
        return !(this$subscribers == null ? other$subscribers != null : !this$subscribers.equals(other$subscribers));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Subscribers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableSet<String> $subscribers = this.getSubscribers();
        result = result * 59 + ($subscribers == null ? 43 : $subscribers.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Subscribers(subscribers=" + this.getSubscribers() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ImmutableSet<String> getSubscribers() {
        return this.subscribers;
    }

    private static class SubscriberSetSerializer
    extends VersionedSerializer.WithBuilder<Subscribers, SubscribersBuilder> {
        private SubscriberSetSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, SubscribersBuilder recordBuilder) throws IOException {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            revisionDataInput.readCollection(DataInput::readUTF, (ImmutableCollection.Builder)builder);
            recordBuilder.subscribers((ImmutableSet<String>)builder.build());
        }

        private void write00(Subscribers subscribersRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeCollection(subscribersRecord.getSubscribers(), DataOutput::writeUTF);
        }

        protected SubscribersBuilder newBuilder() {
            return Subscribers.builder();
        }
    }

    private static class SubscribersBuilder
    implements ObjectBuilder<Subscribers> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableSet<String> subscribers;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscribersBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscribersBuilder subscribers(@NonNull ImmutableSet<String> subscribers) {
            if (subscribers == null) {
                throw new NullPointerException("subscribers is marked non-null but is null");
            }
            this.subscribers = subscribers;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Subscribers build() {
            return new Subscribers(this.subscribers);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Subscribers.SubscribersBuilder(subscribers=" + this.subscribers + ")";
        }
    }
}

