/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.ByteBufferOutputStream;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import lombok.Generated;

public class TagRecord {
    private static final TagRecordSerializer SERIALIZER = new TagRecordSerializer();
    private final String tagName;
    private final Set<String> streams;

    public static TagRecord fromBytes(byte[] data) {
        return (TagRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        byte[] bytes = SERIALIZER.serialize(this).getCopy();
        assert (bytes.length < 1040384) : "TagRecord is greater than the TableSegment Maximum value length";
        return SERIALIZER.serialize(this).getCopy();
    }

    private static ByteArraySegment compressArrayOption(Set<String> tags) throws IOException {
        ByteBufferOutputStream baos = new ByteBufferOutputStream();
        DataOutputStream dout = new DataOutputStream(new DeflaterOutputStream((OutputStream)baos));
        for (String t : tags) {
            dout.writeUTF(t);
        }
        dout.flush();
        dout.close();
        return baos.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> decompressArrayOption(byte[] compressed) throws IOException {
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(compressed));
        DataInputStream din = new DataInputStream(in);
        try {
            ArrayList<String> tags = new ArrayList<String>();
            try {
                while (true) {
                    tags.add(din.readUTF());
                }
            }
            catch (EOFException e) {
                ArrayList<String> arrayList = tags;
                return arrayList;
            }
        }
        finally {
            if (Collections.singletonList(din).get(0) != null) {
                din.close();
            }
        }
    }

    @ConstructorProperties(value={"tagName", "streams"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    TagRecord(String tagName, Set<String> streams) {
        this.tagName = tagName;
        this.streams = streams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static TagRecordBuilder builder() {
        return new TagRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TagRecordBuilder toBuilder() {
        TagRecordBuilder builder = new TagRecordBuilder().tagName(this.tagName);
        if (this.streams != null) {
            builder.streams(this.streams);
        }
        return builder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTagName() {
        return this.tagName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<String> getStreams() {
        return this.streams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagRecord)) {
            return false;
        }
        TagRecord other = (TagRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        Set<String> this$streams = this.getStreams();
        Set<String> other$streams = other.getStreams();
        return !(this$streams == null ? other$streams != null : !((Object)this$streams).equals(other$streams));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TagRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        Set<String> $streams = this.getStreams();
        result = result * 59 + ($streams == null ? 43 : ((Object)$streams).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "TagRecord(tagName=" + this.getTagName() + ", streams=" + this.getStreams() + ")";
    }

    private static class TagRecordSerializer
    extends VersionedSerializer.WithBuilder<TagRecord, TagRecordBuilder> {
        private TagRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        protected void beforeSerialization(TagRecord streamConfigurationRecord) {
            Preconditions.checkNotNull((Object)streamConfigurationRecord);
            Preconditions.checkNotNull((Object)streamConfigurationRecord.getTagName());
        }

        private void read00(RevisionDataInput revisionDataInput, TagRecordBuilder configurationRecordBuilder) throws IOException {
            configurationRecordBuilder.tagName(revisionDataInput.readUTF());
            configurationRecordBuilder.streams(TagRecord.decompressArrayOption(revisionDataInput.readArray()));
        }

        private void write00(TagRecord streamConfigurationRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeUTF(streamConfigurationRecord.getTagName());
            revisionDataOutput.writeBuffer((BufferView)TagRecord.compressArrayOption(streamConfigurationRecord.getStreams()));
        }

        protected TagRecordBuilder newBuilder() {
            return TagRecord.builder();
        }
    }

    public static class TagRecordBuilder
    implements ObjectBuilder<TagRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String tagName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<String> streams;

        public TagRecordBuilder removeStream(String stream) {
            this.streams.remove(stream);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        TagRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TagRecordBuilder tagName(String tagName) {
            this.tagName = tagName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TagRecordBuilder stream(String stream) {
            if (this.streams == null) {
                this.streams = new ArrayList();
            }
            this.streams.add(stream);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TagRecordBuilder streams(Collection<? extends String> streams) {
            if (streams == null) {
                throw new NullPointerException("streams cannot be null");
            }
            if (this.streams == null) {
                this.streams = new ArrayList();
            }
            this.streams.addAll(streams);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TagRecordBuilder clearStreams() {
            if (this.streams != null) {
                this.streams.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TagRecord build() {
            Set<String> streams;
            switch (this.streams == null ? 0 : this.streams.size()) {
                case 0: {
                    streams = Collections.emptySet();
                    break;
                }
                case 1: {
                    streams = Collections.singleton(this.streams.get(0));
                    break;
                }
                default: {
                    streams = new LinkedHashSet(this.streams.size() < 0x40000000 ? 1 + this.streams.size() + (this.streams.size() - 3) / 3 : Integer.MAX_VALUE);
                    streams.addAll(this.streams);
                    streams = Collections.unmodifiableSet(streams);
                }
            }
            return new TagRecord(this.tagName, streams);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "TagRecord.TagRecordBuilder(tagName=" + this.tagName + ", streams=" + this.streams + ")";
        }
    }
}

