/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.task;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.store.index.InMemoryHostIndex;
import io.pravega.controller.store.task.AbstractTaskMetadataStore;
import io.pravega.controller.store.task.LockData;
import io.pravega.controller.store.task.LockFailedException;
import io.pravega.controller.store.task.Resource;
import io.pravega.controller.store.task.UnlockFailedException;
import io.pravega.controller.task.TaskData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryTaskMetadataStore
extends AbstractTaskMetadataStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryTaskMetadataStore.class);
    @GuardedBy(value="lockTable")
    private final Map<Resource, LockData> lockTable = new HashMap<Resource, LockData>();

    InMemoryTaskMetadataStore(ScheduledExecutorService executor) {
        super(new InMemoryHostIndex(), executor);
    }

    @Override
    Void acquireLock(Resource resource, TaskData taskData, String owner, String threadId) {
        Map<Resource, LockData> map = this.lockTable;
        synchronized (map) {
            if (!this.lockTable.containsKey(resource)) {
                LockData lockData = new LockData(owner, threadId, taskData.serialize());
                this.lockTable.put(resource, lockData);
                return null;
            }
            throw new LockFailedException(resource.getString());
        }
    }

    @Override
    Void transferLock(Resource resource, String owner, String threadId, String oldOwner, String oldThreadId) {
        Map<Resource, LockData> map = this.lockTable;
        synchronized (map) {
            LockData lockData = this.lockTable.get(resource);
            if (lockData != null && lockData.isOwnedBy(oldOwner, oldThreadId)) {
                LockData newLockData = new LockData(owner, threadId, lockData.getTaskData());
                this.lockTable.put(resource, newLockData);
                return null;
            }
            throw new LockFailedException(resource.getString());
        }
    }

    @Override
    Void removeLock(Resource resource, String owner, String tag) {
        Map<Resource, LockData> map = this.lockTable;
        synchronized (map) {
            if (!this.lockTable.containsKey(resource)) {
                log.debug("removeLock on {} completed; resource was not locked", (Object)resource);
                return null;
            }
            LockData lockData = this.lockTable.get(resource);
            if (lockData != null && lockData.isOwnedBy(owner, tag)) {
                this.lockTable.remove(resource);
                return null;
            }
            throw new UnlockFailedException(resource.getString());
        }
    }

    @Override
    public CompletableFuture<Optional<TaskData>> getTask(Resource resource, String owner, String tag) {
        return CompletableFuture.supplyAsync(() -> {
            Preconditions.checkNotNull((Object)resource);
            Preconditions.checkNotNull((Object)owner);
            Preconditions.checkNotNull((Object)tag);
            Map<Resource, LockData> map = this.lockTable;
            synchronized (map) {
                LockData lockData = this.lockTable.get(resource);
                if (lockData == null) {
                    return Optional.empty();
                }
                if (lockData.isOwnedBy(owner, tag)) {
                    return Optional.of(TaskData.deserialize(lockData.getTaskData()));
                }
                log.debug(String.format("Resource %s not owned by (%s, %s)", resource.getString(), owner, tag));
                return Optional.empty();
            }
        }, this.executor);
    }
}

