/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.task;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.controller.store.client.StoreClient;
import io.pravega.controller.store.task.InMemoryTaskMetadataStore;
import io.pravega.controller.store.task.TaskMetadataStore;
import io.pravega.controller.store.task.ZKTaskMetadataStore;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.curator.framework.CuratorFramework;

public class TaskStoreFactory {
    public static TaskMetadataStore createStore(StoreClient storeClient, ScheduledExecutorService executor) {
        switch (storeClient.getType()) {
            case Zookeeper: 
            case PravegaTable: {
                return new ZKTaskMetadataStore((CuratorFramework)storeClient.getClient(), executor);
            }
            case InMemory: {
                return new InMemoryTaskMetadataStore(executor);
            }
        }
        throw new NotImplementedException(storeClient.getType().toString());
    }

    @VisibleForTesting
    public static TaskMetadataStore createZKStore(CuratorFramework client, ScheduledExecutorService executor) {
        return new ZKTaskMetadataStore(client, executor);
    }

    @VisibleForTesting
    public static TaskMetadataStore createInMemoryStore(ScheduledExecutorService executor) {
        return new InMemoryTaskMetadataStore(executor);
    }
}

