/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.task;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.server.eventProcessor.requesthandlers.TaskExceptions;
import io.pravega.controller.store.index.HostIndex;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.util.RetryHelper;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.ControllerEventSerializer;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHelper
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventHelper.class);
    private static final long COMPLETION_TIMEOUT_MILLIS = Duration.ofMinutes(2L).toMillis();
    private final CompletableFuture<Void> writerInitFuture = new CompletableFuture();
    private final AtomicReference<EventStreamWriter<ControllerEvent>> requestEventWriterRef = new AtomicReference();
    private final ScheduledExecutorService executor;
    private final ScheduledExecutorService eventExecutor;
    private final String hostId;
    private final HostIndex hostTaskIndex;
    private final ControllerEventSerializer controllerEventSerializer = new ControllerEventSerializer();
    private final AtomicLong completionTimeoutMillis = new AtomicLong(COMPLETION_TIMEOUT_MILLIS);

    public EventHelper(EventStreamWriter<ControllerEvent> requestEventWriter, ScheduledExecutorService executor, ScheduledExecutorService eventExecutor, String hostId, HostIndex hostIndex) {
        this.executor = executor;
        this.eventExecutor = eventExecutor;
        this.hostId = hostId;
        this.hostTaskIndex = hostIndex;
        this.requestEventWriterRef.set(requestEventWriter);
        this.writerInitFuture.complete(null);
    }

    @VisibleForTesting
    public EventHelper(ScheduledExecutorService executor, String hostId, HostIndex hostIndex) {
        this.executor = executor;
        this.eventExecutor = executor;
        this.hostId = hostId;
        this.hostTaskIndex = hostIndex;
        this.writerInitFuture.complete(null);
    }

    @VisibleForTesting
    public void setRequestEventWriter(EventStreamWriter<ControllerEvent> requestEventWriter) {
        EventStreamWriter<ControllerEvent> oldWriter = this.requestEventWriterRef.getAndSet(requestEventWriter);
        if (oldWriter != null) {
            oldWriter.close();
        }
        this.writerInitFuture.complete(null);
    }

    @VisibleForTesting
    public void setCompletionTimeoutMillis(long timeoutMillis) {
        this.completionTimeoutMillis.set(timeoutMillis);
    }

    public <T> CompletableFuture<T> addIndexAndSubmitTask(ControllerEvent event, Supplier<CompletableFuture<T>> futureSupplier) {
        String id = UUID.randomUUID().toString();
        return this.addRequestToIndex(this.hostId, id, event).thenCompose(v -> Futures.handleCompose((CompletableFuture)((CompletableFuture)futureSupplier.get()), (r, e) -> {
            if (e == null || Exceptions.unwrap((Throwable)e) instanceof StoreException.StoreConnectionException || Exceptions.unwrap((Throwable)e) instanceof StoreException.WriteConflictException) {
                return ((CompletableFuture)RetryHelper.withIndefiniteRetriesAsync(() -> this.writeEvent(event), ex -> log.warn("writing event failed with {}", (Object)ex.getMessage()), this.executor).thenCompose(z -> this.removeTaskFromIndex(this.hostId, id))).thenApply(vd -> {
                    if (e != null) {
                        throw new CompletionException((Throwable)e);
                    }
                    log.info("Successfully submitted event {}", (Object)event.getClass().getName());
                    return r;
                });
            }
            throw new CompletionException((Throwable)e);
        }));
    }

    public CompletableFuture<Void> checkDone(Supplier<CompletableFuture<Boolean>> condition) {
        return this.checkDone(condition, 100L);
    }

    public CompletableFuture<Void> checkDone(Supplier<CompletableFuture<Boolean>> condition, long delay) {
        AtomicBoolean isDone = new AtomicBoolean(false);
        return RetryHelper.loopWithTimeout(() -> !isDone.get(), () -> ((CompletableFuture)condition.get()).thenAccept(isDone::set), delay, 5000L, this.completionTimeoutMillis.get(), this.executor);
    }

    public CompletableFuture<Void> writeEvent(ControllerEvent event) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.writerInitFuture.thenComposeAsync(v -> this.requestEventWriterRef.get().writeEvent(event.getKey(), (Object)event), (Executor)this.eventExecutor)).whenComplete((r, e) -> {
            if (e != null) {
                log.warn("exception while posting event {} {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                if (e instanceof TaskExceptions.ProcessingDisabledException) {
                    result.completeExceptionally((Throwable)e);
                } else {
                    result.completeExceptionally(new TaskExceptions.PostEventException("Failed to post event", (Throwable)e));
                }
            } else {
                log.info("event posted successfully");
                result.complete(null);
            }
        });
        return result;
    }

    public CompletableFuture<Void> addRequestToIndex(String hostId, String id, ControllerEvent task) {
        return this.hostTaskIndex.addEntity(hostId, id, this.controllerEventSerializer.toByteBuffer(task).array());
    }

    public CompletableFuture<Void> removeTaskFromIndex(String hostId, String id) {
        return this.hostTaskIndex.removeEntity(hostId, id, true);
    }

    @Override
    public void close() {
        EventStreamWriter<ControllerEvent> writer;
        if (!this.writerInitFuture.isDone()) {
            this.writerInitFuture.cancel(true);
        }
        if ((writer = this.requestEventWriterRef.get()) != null) {
            writer.close();
        }
    }
}

