/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.task.KeyValueTable;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.EventStreamClientFactory;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.controller.retryable.RetryableException;
import io.pravega.controller.server.SegmentHelper;
import io.pravega.controller.server.eventProcessor.ControllerEventProcessors;
import io.pravega.controller.server.security.auth.GrpcAuthHelper;
import io.pravega.controller.store.kvtable.AbstractKVTableMetadataStore;
import io.pravega.controller.store.kvtable.KVTOperationContext;
import io.pravega.controller.store.kvtable.KVTableMetadataStore;
import io.pravega.controller.store.kvtable.KVTableState;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.controller.task.EventHelper;
import io.pravega.controller.task.Stream.TaskStepsRetryHelper;
import io.pravega.controller.util.RetryHelper;
import io.pravega.shared.NameUtils;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.kvtable.CreateTableEvent;
import io.pravega.shared.controller.event.kvtable.DeleteTableEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.LoggerFactory;

public class TableMetadataTasks
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(TableMetadataTasks.class));
    private static final int NUM_RETRIES = 10;
    private final KVTableMetadataStore kvtMetadataStore;
    private final SegmentHelper segmentHelper;
    private final ScheduledExecutorService executor;
    private final ScheduledExecutorService eventExecutor;
    private final String hostId;
    private final GrpcAuthHelper authHelper;
    private EventHelper eventHelper;

    public TableMetadataTasks(KVTableMetadataStore kvtMetadataStore, SegmentHelper segmentHelper, ScheduledExecutorService executor, ScheduledExecutorService eventExecutor, String hostId, GrpcAuthHelper authHelper) {
        this.kvtMetadataStore = kvtMetadataStore;
        this.segmentHelper = segmentHelper;
        this.executor = executor;
        this.eventExecutor = eventExecutor;
        this.hostId = hostId;
        this.authHelper = authHelper;
    }

    @VisibleForTesting
    public TableMetadataTasks(KVTableMetadataStore kvtMetadataStore, SegmentHelper segmentHelper, ScheduledExecutorService executor, ScheduledExecutorService eventExecutor, String hostId, GrpcAuthHelper authHelper, EventHelper helper) {
        this.kvtMetadataStore = kvtMetadataStore;
        this.segmentHelper = segmentHelper;
        this.executor = executor;
        this.eventExecutor = eventExecutor;
        this.hostId = hostId;
        this.authHelper = authHelper;
        this.eventHelper = helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeStreamWriters(EventStreamClientFactory clientFactory, String streamName) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.eventHelper != null) {
                this.eventHelper.close();
            }
            this.eventHelper = new EventHelper((EventStreamWriter<ControllerEvent>)clientFactory.createEventWriter(streamName, ControllerEventProcessors.CONTROLLER_EVENT_SERIALIZER, EventWriterConfig.builder().enableConnectionPooling(true).retryAttempts(Integer.MAX_VALUE).build()), this.executor, this.eventExecutor, this.hostId, ((AbstractKVTableMetadataStore)this.kvtMetadataStore).getHostTaskIndex());
        }
    }

    public CompletableFuture<Controller.CreateKeyValueTableStatus.Status> createKeyValueTable(String scope, String kvtName, KeyValueTableConfiguration kvtConfig, long createTimestamp, long requestId) {
        KVTOperationContext context = this.kvtMetadataStore.createContext(scope, kvtName, requestId);
        return RetryHelper.withRetriesAsync(() -> this.kvtMetadataStore.checkScopeExists(scope, context, this.executor).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(Controller.CreateKeyValueTableStatus.Status.SCOPE_NOT_FOUND);
            }
            return Futures.exceptionallyExpecting(this.kvtMetadataStore.getState(scope, kvtName, true, context, this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)((Object)KVTableState.UNKNOWN)).thenCompose(state -> {
                if (state.equals((Object)KVTableState.UNKNOWN) || state.equals((Object)KVTableState.CREATING)) {
                    UUID id = this.kvtMetadataStore.newScope(scope).newId();
                    CreateTableEvent event = new CreateTableEvent(scope, kvtName, kvtConfig.getPartitionCount(), kvtConfig.getPrimaryKeyLength(), kvtConfig.getSecondaryKeyLength(), createTimestamp, requestId, id, kvtConfig.getRolloverSizeBytes());
                    return this.eventHelper.addIndexAndSubmitTask((ControllerEvent)event, () -> this.kvtMetadataStore.createEntryForKVTable(scope, kvtName, id, context, this.executor)).thenCompose(x -> this.isCreateProcessed(scope, kvtName, kvtConfig, createTimestamp, this.executor, context));
                }
                return this.isCreateProcessed(scope, kvtName, kvtConfig, createTimestamp, this.executor, context);
            });
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, 10, this.executor);
    }

    public CompletableFuture<Controller.DeleteKVTableStatus.Status> deleteKeyValueTable(String scope, String kvtName, long requestId) {
        KVTOperationContext context = this.kvtMetadataStore.createContext(scope, kvtName, requestId);
        return RetryHelper.withRetriesAsync(() -> Futures.exceptionallyExpecting(this.kvtMetadataStore.getState(scope, kvtName, false, context, this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)((Object)KVTableState.UNKNOWN)).thenCompose(state -> {
            if (KVTableState.UNKNOWN.equals(state)) {
                return CompletableFuture.completedFuture(Controller.DeleteKVTableStatus.Status.TABLE_NOT_FOUND);
            }
            return this.kvtMetadataStore.getKVTable(scope, kvtName, context).getId(context).thenCompose(id -> {
                DeleteTableEvent deleteEvent = new DeleteTableEvent(scope, kvtName, requestId, UUID.fromString(id));
                return ((CompletableFuture)this.eventHelper.addIndexAndSubmitTask((ControllerEvent)deleteEvent, () -> this.kvtMetadataStore.setState(scope, kvtName, KVTableState.DELETING, context, this.executor)).thenCompose(x -> this.eventHelper.checkDone(() -> this.isDeleted(scope, kvtName, context)))).thenApply(y -> Controller.DeleteKVTableStatus.Status.SUCCESS);
            });
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, 10, this.executor);
    }

    public CompletableFuture<Void> deleteSegments(String scope, String kvt, Set<Long> segmentsToDelete, String delegationToken, long requestId) {
        log.debug(requestId, "{}/{} deleting {} segments", new Object[]{scope, kvt, segmentsToDelete.size()});
        return Futures.allOf((Collection)((Stream)segmentsToDelete.stream().parallel()).map(segment -> this.deleteSegment(scope, kvt, (long)segment, delegationToken, requestId)).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> deleteSegment(String scope, String kvt, long segmentId, String delegationToken, long requestId) {
        String qualifiedTableSegmentName = NameUtils.getQualifiedTableSegmentName((String)scope, (String)kvt, (long)segmentId);
        log.debug(requestId, "Deleting segment {} with Id {}", new Object[]{qualifiedTableSegmentName, segmentId});
        return Futures.toVoid(TaskStepsRetryHelper.withRetries(() -> this.segmentHelper.deleteTableSegment(qualifiedTableSegmentName, false, delegationToken, requestId), this.executor));
    }

    @VisibleForTesting
    CompletableFuture<Boolean> isDeleted(String scope, String kvtName, OperationContext context) {
        return Futures.exceptionallyExpecting(this.kvtMetadataStore.getState(scope, kvtName, true, context, this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)((Object)KVTableState.UNKNOWN)).thenCompose(state -> {
            if (state.equals((Object)KVTableState.UNKNOWN)) {
                return CompletableFuture.completedFuture(Boolean.TRUE);
            }
            return CompletableFuture.completedFuture(Boolean.FALSE);
        });
    }

    private CompletableFuture<Controller.CreateKeyValueTableStatus.Status> isCreateProcessed(String scope, String kvtName, KeyValueTableConfiguration kvtConfig, long createTimestamp, Executor executor, OperationContext context) {
        return ((CompletableFuture)this.eventHelper.checkDone(() -> this.isCreated(scope, kvtName, executor, context)).thenCompose(y -> this.isSameCreateRequest(scope, kvtName, kvtConfig, createTimestamp, executor, context))).thenCompose(same -> {
            if (same.booleanValue()) {
                return CompletableFuture.completedFuture(Controller.CreateKeyValueTableStatus.Status.SUCCESS);
            }
            return CompletableFuture.completedFuture(Controller.CreateKeyValueTableStatus.Status.TABLE_EXISTS);
        });
    }

    private CompletableFuture<Boolean> isCreated(String scope, String kvtName, Executor executor, OperationContext context) {
        return Futures.exceptionallyExpecting(this.kvtMetadataStore.getState(scope, kvtName, true, context, executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)((Object)KVTableState.UNKNOWN)).thenApply(state -> {
            log.debug(context.getRequestId(), "KVTable State is {}", new Object[]{state.toString()});
            return state.equals((Object)KVTableState.ACTIVE);
        });
    }

    private CompletableFuture<Boolean> isSameCreateRequest(String requestScopeName, String requestKVTName, KeyValueTableConfiguration requestKVTConfig, long requestCreateTimestamp, Executor executor, OperationContext context) {
        return this.kvtMetadataStore.getCreationTime(requestScopeName, requestKVTName, context, executor).thenCompose(creationTime -> {
            if (creationTime == requestCreateTimestamp) {
                return this.kvtMetadataStore.getConfiguration(requestScopeName, requestKVTName, context, executor).thenCompose(cfg -> {
                    if (cfg.getPartitionCount() == requestKVTConfig.getPartitionCount()) {
                        return CompletableFuture.completedFuture(Boolean.TRUE);
                    }
                    return CompletableFuture.completedFuture(Boolean.FALSE);
                });
            }
            return CompletableFuture.completedFuture(Boolean.FALSE);
        });
    }

    public String retrieveDelegationToken() {
        return this.authHelper.retrieveMasterToken();
    }

    public CompletableFuture<Void> createNewSegments(String scope, String kvt, List<Long> segmentIds, int keyLength, long requestId, long rolloverSizeBytes) {
        return Futures.toVoid((CompletableFuture)Futures.allOfWithResults(((Stream)segmentIds.stream().parallel()).map(segment -> this.createNewSegment(scope, kvt, (long)segment, keyLength, this.retrieveDelegationToken(), requestId, rolloverSizeBytes)).collect(Collectors.toList())));
    }

    private CompletableFuture<Void> createNewSegment(String scope, String kvt, long segmentId, int keyLength, String controllerToken, long requestId, long rolloverSizeBytes) {
        String qualifiedTableSegmentName = NameUtils.getQualifiedTableSegmentName((String)scope, (String)kvt, (long)segmentId);
        log.debug("Creating segment {}", (Object)qualifiedTableSegmentName);
        return Futures.toVoid(TaskStepsRetryHelper.withRetries(() -> this.segmentHelper.createTableSegment(qualifiedTableSegmentName, controllerToken, requestId, false, keyLength, rolloverSizeBytes), this.executor));
    }

    @Override
    public void close() {
        if (this.eventHelper != null) {
            this.eventHelper.close();
        }
    }
}

