/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.task.Stream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.pravega.client.EventStreamClientFactory;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.RetentionPolicy;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.StreamCut;
import io.pravega.common.Exceptions;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.tracing.TagLogger;
import io.pravega.common.util.RetriesExhaustedException;
import io.pravega.controller.metrics.StreamMetrics;
import io.pravega.controller.metrics.TransactionMetrics;
import io.pravega.controller.retryable.RetryableException;
import io.pravega.controller.server.SegmentHelper;
import io.pravega.controller.server.eventProcessor.ControllerEventProcessors;
import io.pravega.controller.server.rest.ModelHelper;
import io.pravega.controller.server.security.auth.GrpcAuthHelper;
import io.pravega.controller.store.VersionedMetadata;
import io.pravega.controller.store.stream.AbstractStreamMetadataStore;
import io.pravega.controller.store.stream.BucketStore;
import io.pravega.controller.store.stream.CreateStreamResponse;
import io.pravega.controller.store.stream.EpochTransitionOperationExceptions;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ReaderGroupState;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.StreamMetadataStore;
import io.pravega.controller.store.stream.records.EpochRecord;
import io.pravega.controller.store.stream.records.EpochTransitionRecord;
import io.pravega.controller.store.stream.records.ReaderGroupConfigRecord;
import io.pravega.controller.store.stream.records.RetentionSet;
import io.pravega.controller.store.stream.records.StreamConfigurationRecord;
import io.pravega.controller.store.stream.records.StreamCutRecord;
import io.pravega.controller.store.stream.records.StreamCutReferenceRecord;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.controller.store.stream.records.StreamSubscriber;
import io.pravega.controller.store.stream.records.StreamTruncationRecord;
import io.pravega.controller.store.task.LockFailedException;
import io.pravega.controller.store.task.Resource;
import io.pravega.controller.store.task.TaskMetadataStore;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.controller.task.EventHelper;
import io.pravega.controller.task.Stream.TaskStepsRetryHelper;
import io.pravega.controller.task.Task;
import io.pravega.controller.task.TaskBase;
import io.pravega.controller.util.Config;
import io.pravega.controller.util.RetryHelper;
import io.pravega.shared.NameUtils;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.CreateReaderGroupEvent;
import io.pravega.shared.controller.event.DeleteReaderGroupEvent;
import io.pravega.shared.controller.event.DeleteStreamEvent;
import io.pravega.shared.controller.event.RGStreamCutRecord;
import io.pravega.shared.controller.event.ScaleOpEvent;
import io.pravega.shared.controller.event.SealStreamEvent;
import io.pravega.shared.controller.event.TruncateStreamEvent;
import io.pravega.shared.controller.event.UpdateReaderGroupEvent;
import io.pravega.shared.controller.event.UpdateStreamEvent;
import io.pravega.shared.protocol.netty.WireCommands;
import java.io.Serializable;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.LoggerFactory;

public class StreamMetadataTasks
extends TaskBase {
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(StreamMetadataTasks.class));
    private static final int SUBSCRIBER_OPERATION_RETRIES = 10;
    private static final int READER_GROUP_OPERATION_MAX_RETRIES = 10;
    private static final long READER_GROUP_SEGMENT_ROLLOVER_SIZE_BYTES = 0x400000L;
    private final AtomicLong retentionFrequencyMillis;
    private final StreamMetadataStore streamMetadataStore;
    private final BucketStore bucketStore;
    private final SegmentHelper segmentHelper;
    private final GrpcAuthHelper authHelper;
    private final ScheduledExecutorService eventExecutor;
    private final CompletableFuture<EventHelper> eventHelperFuture;
    private final AtomicReference<Supplier<Long>> retentionClock;
    private final Random requestIdGenerator = new Random();
    @GuardedBy(value="lock")
    private EventHelper eventHelper = null;
    @GuardedBy(value="lock")
    private boolean toSetEventHelper = true;
    private final Object lock = new Object();

    public StreamMetadataTasks(StreamMetadataStore streamMetadataStore, BucketStore bucketStore, TaskMetadataStore taskMetadataStore, SegmentHelper segmentHelper, ScheduledExecutorService executor, ScheduledExecutorService eventExecutor, String hostId, GrpcAuthHelper authHelper, long retentionFrequencyMillis) {
        this(streamMetadataStore, bucketStore, taskMetadataStore, segmentHelper, executor, eventExecutor, new TaskBase.Context(hostId), authHelper);
        this.retentionFrequencyMillis.set(retentionFrequencyMillis);
    }

    @VisibleForTesting
    public StreamMetadataTasks(StreamMetadataStore streamMetadataStore, BucketStore bucketStore, TaskMetadataStore taskMetadataStore, SegmentHelper segmentHelper, ScheduledExecutorService executor, String hostId, GrpcAuthHelper authHelper) {
        this(streamMetadataStore, bucketStore, taskMetadataStore, segmentHelper, executor, executor, new TaskBase.Context(hostId), authHelper);
    }

    @VisibleForTesting
    public StreamMetadataTasks(StreamMetadataStore streamMetadataStore, BucketStore bucketStore, TaskMetadataStore taskMetadataStore, SegmentHelper segmentHelper, ScheduledExecutorService executor, String hostId, GrpcAuthHelper authHelper, EventHelper helper) {
        this(streamMetadataStore, bucketStore, taskMetadataStore, segmentHelper, executor, executor, new TaskBase.Context(hostId), authHelper);
        this.eventHelperFuture.complete(helper);
    }

    private StreamMetadataTasks(StreamMetadataStore streamMetadataStore, BucketStore bucketStore, TaskMetadataStore taskMetadataStore, SegmentHelper segmentHelper, ScheduledExecutorService executor, ScheduledExecutorService eventExecutor, TaskBase.Context context, GrpcAuthHelper authHelper) {
        super(taskMetadataStore, executor, context);
        this.eventExecutor = eventExecutor;
        this.streamMetadataStore = streamMetadataStore;
        this.bucketStore = bucketStore;
        this.segmentHelper = segmentHelper;
        this.authHelper = authHelper;
        this.retentionFrequencyMillis = new AtomicLong(Duration.ofMinutes(Config.MINIMUM_RETENTION_FREQUENCY_IN_MINUTES).toMillis());
        this.retentionClock = new AtomicReference<Supplier<Long>>(System::currentTimeMillis);
        this.eventHelperFuture = new CompletableFuture();
        this.setReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeStreamWriters(EventStreamClientFactory clientFactory, String streamName) {
        EventHelper e = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.toSetEventHelper) {
                this.eventHelper = new EventHelper((EventStreamWriter<ControllerEvent>)clientFactory.createEventWriter(streamName, ControllerEventProcessors.CONTROLLER_EVENT_SERIALIZER, EventWriterConfig.builder().enableConnectionPooling(true).retryAttempts(Integer.MAX_VALUE).build()), this.executor, this.eventExecutor, this.context.getHostId(), ((AbstractStreamMetadataStore)this.streamMetadataStore).getHostTaskIndex());
                this.toSetEventHelper = false;
                e = this.eventHelper;
            }
        }
        if (e != null) {
            this.eventHelperFuture.complete(e);
        }
    }

    public CompletableFuture<Controller.CreateStreamStatus.Status> createRGStream(String scope, String stream, StreamConfiguration config, long createTimestamp, int numOfRetries, long requestId) {
        Preconditions.checkNotNull((Object)config, (Object)"streamConfig");
        Preconditions.checkArgument((createTimestamp >= 0L ? 1 : 0) != 0);
        NameUtils.validateStreamName((String)stream);
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        return Futures.exceptionallyExpecting(this.streamMetadataStore.getState(scope, stream, true, context, this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)((Object)State.UNKNOWN)).thenCompose(state -> {
            if (state.equals((Object)State.UNKNOWN) || state.equals((Object)State.CREATING)) {
                log.debug(requestId, "Creating StateSynchronizer Stream {}", new Object[]{stream});
                return this.createStreamRetryOnLockFailure(scope, stream, config, createTimestamp, numOfRetries, requestId);
            }
            return CompletableFuture.completedFuture(Controller.CreateStreamStatus.Status.STREAM_EXISTS);
        });
    }

    public CompletableFuture<Controller.CreateStreamStatus.Status> createStreamRetryOnLockFailure(String scope, String stream, StreamConfiguration config, long createTimestamp, int numOfRetries, long requestId) {
        return RetryHelper.withRetriesAsync(() -> this.createStream(scope, stream, config, createTimestamp, requestId), e -> Exceptions.unwrap((Throwable)e) instanceof LockFailedException, numOfRetries, this.executor).exceptionally(e -> {
            log.warn(requestId, "createStream threw exception {}", new Object[]{e.getCause().getMessage()});
            Throwable unwrap = Exceptions.unwrap((Throwable)e);
            if (unwrap instanceof RetriesExhaustedException) {
                throw new CompletionException(unwrap.getCause());
            }
            throw new CompletionException(unwrap);
        });
    }

    public CompletableFuture<Controller.ReaderGroupConfigResponse> getReaderGroupConfig(String scope, String rgName, long requestId) {
        OperationContext context = this.streamMetadataStore.createRGContext(scope, rgName, requestId);
        return RetryHelper.withRetriesAsync(() -> this.streamMetadataStore.checkReaderGroupExists(scope, rgName, context, this.executor).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(Controller.ReaderGroupConfigResponse.newBuilder().setConfig(Controller.ReaderGroupConfiguration.getDefaultInstance()).setStatus(Controller.ReaderGroupConfigResponse.Status.RG_NOT_FOUND).build());
            }
            return this.streamMetadataStore.getReaderGroupId(scope, rgName, context, this.executor).thenCompose(rgId -> this.streamMetadataStore.getReaderGroupConfigRecord(scope, rgName, context, this.executor).thenApply(configRecord -> Controller.ReaderGroupConfigResponse.newBuilder().setConfig(this.getRGConfigurationFromRecord(scope, rgName, (ReaderGroupConfigRecord)configRecord.getObject(), rgId.toString())).setStatus(Controller.ReaderGroupConfigResponse.Status.SUCCESS).build()));
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, 10, this.executor);
    }

    private Controller.ReaderGroupConfiguration getRGConfigurationFromRecord(String scope, String rgName, ReaderGroupConfigRecord record, String readerGroupId) {
        List startStreamCuts = record.getStartingStreamCuts().entrySet().stream().map(e -> Controller.StreamCut.newBuilder().setStreamInfo(Controller.StreamInfo.newBuilder().setStream(io.pravega.client.stream.Stream.of((String)((String)e.getKey())).getStreamName()).setScope(io.pravega.client.stream.Stream.of((String)((String)e.getKey())).getScope()).build()).putAllCut(((RGStreamCutRecord)e.getValue()).getStreamCut()).build()).collect(Collectors.toList());
        List endStreamCuts = record.getEndingStreamCuts().entrySet().stream().map(e -> Controller.StreamCut.newBuilder().setStreamInfo(Controller.StreamInfo.newBuilder().setStream(io.pravega.client.stream.Stream.of((String)((String)e.getKey())).getStreamName()).setScope(io.pravega.client.stream.Stream.of((String)((String)e.getKey())).getScope()).build()).putAllCut(((RGStreamCutRecord)e.getValue()).getStreamCut()).build()).collect(Collectors.toList());
        return Controller.ReaderGroupConfiguration.newBuilder().setScope(scope).setReaderGroupName(rgName).setGroupRefreshTimeMillis(record.getGroupRefreshTimeMillis()).setAutomaticCheckpointIntervalMillis(record.getAutomaticCheckpointIntervalMillis()).setMaxOutstandingCheckpointRequest(record.getMaxOutstandingCheckpointRequest()).setRetentionType(record.getRetentionTypeOrdinal()).setGeneration(record.getGeneration()).addAllStartingStreamCuts(startStreamCuts).addAllEndingStreamCuts(endStreamCuts).setReaderGroupId(readerGroupId).build();
    }

    public CompletableFuture<Controller.CreateReaderGroupResponse> createReaderGroup(String scope, String rgName, ReaderGroupConfig config, long createTimestamp, long requestId) {
        OperationContext context = this.streamMetadataStore.createRGContext(scope, rgName, requestId);
        return RetryHelper.withRetriesAsync(() -> this.streamMetadataStore.checkScopeExists(scope, context, this.executor).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(Controller.CreateReaderGroupResponse.newBuilder().setStatus(Controller.CreateReaderGroupResponse.Status.SCOPE_NOT_FOUND).build());
            }
            return this.isRGCreationComplete(scope, rgName, context).thenCompose(complete -> {
                if (!complete.booleanValue()) {
                    return this.validateReaderGroupId(config).thenCompose(conf -> this.eventHelperFuture.thenCompose(eventHelper -> eventHelper.addIndexAndSubmitTask((ControllerEvent)this.buildCreateRGEvent(scope, rgName, (ReaderGroupConfig)conf, requestId, createTimestamp), () -> this.streamMetadataStore.addReaderGroupToScope(scope, rgName, conf.getReaderGroupId(), context, this.executor)).thenCompose(x -> eventHelper.checkDone(() -> this.isRGCreated(scope, rgName, context)).thenCompose(done -> this.buildCreateSuccessResponse(scope, rgName, context)))));
                }
                return this.buildCreateSuccessResponse(scope, rgName, context);
            });
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, 10, this.executor);
    }

    private CompletableFuture<ReaderGroupConfig> validateReaderGroupId(ReaderGroupConfig config) {
        if (ReaderGroupConfig.DEFAULT_UUID.equals(config.getReaderGroupId())) {
            return CompletableFuture.completedFuture(ReaderGroupConfig.cloneConfig((ReaderGroupConfig)config, (UUID)UUID.randomUUID(), (long)0L));
        }
        return CompletableFuture.completedFuture(config);
    }

    public CompletableFuture<Boolean> isRGCreationComplete(String scope, String rgName, OperationContext context) {
        return Futures.exceptionallyExpecting(this.streamMetadataStore.getReaderGroupState(scope, rgName, true, context, this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)((Object)ReaderGroupState.UNKNOWN)).thenCompose(state -> {
            if (state.equals((Object)ReaderGroupState.UNKNOWN) || state.equals((Object)ReaderGroupState.CREATING)) {
                return CompletableFuture.completedFuture(Boolean.FALSE);
            }
            return CompletableFuture.completedFuture(Boolean.TRUE);
        });
    }

    private CompletableFuture<Controller.CreateReaderGroupResponse> buildCreateSuccessResponse(String scope, String rgName, OperationContext context) {
        return this.streamMetadataStore.getReaderGroupId(scope, rgName, context, this.executor).thenCompose(rgId -> this.streamMetadataStore.getReaderGroupConfigRecord(scope, rgName, context, this.executor).thenApply(cfgRecord -> Controller.CreateReaderGroupResponse.newBuilder().setConfig(ModelHelper.encodeReaderGroupConfigRecord(scope, rgName, (ReaderGroupConfigRecord)cfgRecord.getObject(), rgId)).setStatus(Controller.CreateReaderGroupResponse.Status.SUCCESS).build()));
    }

    private CreateReaderGroupEvent buildCreateRGEvent(String scope, String rgName, ReaderGroupConfig config, long requestId, long createTimestamp) {
        Map<String, RGStreamCutRecord> startStreamCuts = config.getStartingStreamCuts().entrySet().stream().collect(Collectors.toMap(e -> ((io.pravega.client.stream.Stream)e.getKey()).getScopedName(), e -> new RGStreamCutRecord(ImmutableMap.copyOf((Map)io.pravega.client.control.impl.ModelHelper.getStreamCutMap((StreamCut)((StreamCut)e.getValue()))))));
        Map<String, RGStreamCutRecord> endStreamCuts = config.getEndingStreamCuts().entrySet().stream().collect(Collectors.toMap(e -> ((io.pravega.client.stream.Stream)e.getKey()).getScopedName(), e -> new RGStreamCutRecord(ImmutableMap.copyOf((Map)io.pravega.client.control.impl.ModelHelper.getStreamCutMap((StreamCut)((StreamCut)e.getValue()))))));
        return new CreateReaderGroupEvent(requestId, scope, rgName, config.getGroupRefreshTimeMillis(), config.getAutomaticCheckpointIntervalMillis(), config.getMaxOutstandingCheckpointRequest(), config.getRetentionType().ordinal(), config.getGeneration(), config.getReaderGroupId(), startStreamCuts, endStreamCuts, createTimestamp);
    }

    public CompletableFuture<Controller.CreateReaderGroupResponse.Status> createReaderGroupTasks(String scope, String readerGroup, ReaderGroupConfig config, long createTimestamp, long requestId) {
        OperationContext context = this.streamMetadataStore.createRGContext(scope, readerGroup, requestId);
        return this.createReaderGroupTasks(scope, readerGroup, config, createTimestamp, context);
    }

    public CompletableFuture<Controller.CreateReaderGroupResponse.Status> createReaderGroupTasks(String scope, String readerGroup, ReaderGroupConfig config, long createTimestamp, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"operation context not null");
        return ((CompletableFuture)((CompletableFuture)this.streamMetadataStore.createReaderGroup(scope, readerGroup, config, createTimestamp, context, this.executor).thenCompose(v -> {
            if (!ReaderGroupConfig.StreamDataRetention.NONE.equals((Object)config.getRetentionType())) {
                String scopedRGName = NameUtils.getScopedReaderGroupName((String)scope, (String)readerGroup);
                Iterator streamIter = config.getStartingStreamCuts().keySet().stream().map(io.pravega.client.stream.Stream::getScopedName).iterator();
                return Futures.loop(streamIter::hasNext, () -> {
                    io.pravega.client.stream.Stream stream = io.pravega.client.stream.Stream.of((String)((String)streamIter.next()));
                    return this.streamMetadataStore.addSubscriber(stream.getScope(), stream.getStreamName(), scopedRGName, config.getGeneration(), context, this.executor);
                }, (Executor)this.executor);
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(x -> this.createRGStream(scope, NameUtils.getStreamForReaderGroup((String)readerGroup), StreamConfiguration.builder().scalingPolicy(ScalingPolicy.fixed((int)1)).rolloverSizeBytes(0x400000L).build(), System.currentTimeMillis(), 10, this.getRequestId(context)).thenCompose(createStatus -> {
            if (createStatus.equals((Object)Controller.CreateStreamStatus.Status.STREAM_EXISTS) || createStatus.equals((Object)Controller.CreateStreamStatus.Status.SUCCESS)) {
                return ((CompletableFuture)this.streamMetadataStore.getVersionedReaderGroupState(scope, readerGroup, true, context, this.executor).thenCompose(newstate -> this.streamMetadataStore.updateReaderGroupVersionedState(scope, readerGroup, ReaderGroupState.ACTIVE, (VersionedMetadata<ReaderGroupState>)newstate, context, this.executor))).thenApply(v1 -> Controller.CreateReaderGroupResponse.Status.SUCCESS);
            }
            return Futures.failedFuture((Throwable)new IllegalStateException(String.format("Error creating StateSynchronizer Stream for Reader Group %s: %s", readerGroup, createStatus.toString())));
        }))).exceptionally(ex -> {
            log.warn(this.getRequestId(context), "Error creating StateSynchronizer Stream:{} for Reader Group: {}. Exception: {} ", new Object[]{NameUtils.getStreamForReaderGroup((String)readerGroup), readerGroup, ex.getMessage()});
            Throwable cause = Exceptions.unwrap((Throwable)ex);
            throw new CompletionException(cause);
        });
    }

    public CompletableFuture<Controller.CreateReaderGroupResponse> createReaderGroupInternal(String scope, String rgName, ReaderGroupConfig config, long createTimestamp, long requestId) {
        Preconditions.checkNotNull((Object)scope, (Object)"ReaderGroup scope is null");
        Preconditions.checkNotNull((Object)rgName, (Object)"ReaderGroup name is null");
        Preconditions.checkNotNull((Object)config, (Object)"ReaderGroup config is null");
        Preconditions.checkArgument((createTimestamp >= 0L ? 1 : 0) != 0);
        try {
            NameUtils.validateReaderGroupName((String)rgName);
        }
        catch (IllegalArgumentException | NullPointerException e2) {
            return CompletableFuture.completedFuture(Controller.CreateReaderGroupResponse.newBuilder().setStatus(Controller.CreateReaderGroupResponse.Status.INVALID_RG_NAME).build());
        }
        OperationContext context = this.streamMetadataStore.createRGContext(scope, rgName, requestId);
        return RetryHelper.withRetriesAsync(() -> this.streamMetadataStore.checkScopeExists(scope, context, this.executor).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(Controller.CreateReaderGroupResponse.newBuilder().setStatus(Controller.CreateReaderGroupResponse.Status.SCOPE_NOT_FOUND).build());
            }
            return this.isRGCreationComplete(scope, rgName, context).thenCompose(complete -> {
                if (!complete.booleanValue()) {
                    return this.validateReaderGroupId(config).thenCompose(conf -> ((CompletableFuture)this.streamMetadataStore.addReaderGroupToScope(scope, rgName, conf.getReaderGroupId(), context, this.executor).thenCompose(x -> this.createReaderGroupTasks(scope, rgName, (ReaderGroupConfig)conf, createTimestamp, context))).thenCompose(status -> {
                        if (Controller.CreateReaderGroupResponse.Status.SUCCESS.equals(status)) {
                            return this.buildCreateSuccessResponse(scope, rgName, context);
                        }
                        return CompletableFuture.completedFuture(Controller.CreateReaderGroupResponse.newBuilder().setStatus(status).build());
                    }));
                }
                return this.buildCreateSuccessResponse(scope, rgName, context);
            });
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, 10, this.executor);
    }

    private CompletableFuture<Boolean> isRGCreated(String scope, String rgName, OperationContext context) {
        return Futures.exceptionallyExpecting(this.streamMetadataStore.getReaderGroupState(scope, rgName, true, context, this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)((Object)ReaderGroupState.UNKNOWN)).thenApply(state -> {
            log.debug(context.getRequestId(), "ReaderGroup State is {}", new Object[]{state.toString()});
            return ReaderGroupState.ACTIVE.equals(state);
        });
    }

    public CompletableFuture<Controller.UpdateReaderGroupResponse> updateReaderGroup(String scope, String rgName, ReaderGroupConfig config, long requestId) {
        OperationContext context = this.streamMetadataStore.createRGContext(scope, rgName, requestId);
        return RetryHelper.withRetriesAsync(() -> this.streamMetadataStore.checkReaderGroupExists(scope, rgName, context, this.executor).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                Controller.UpdateReaderGroupResponse response = Controller.UpdateReaderGroupResponse.newBuilder().setStatus(Controller.UpdateReaderGroupResponse.Status.RG_NOT_FOUND).setGeneration(config.getGeneration()).build();
                return CompletableFuture.completedFuture(response);
            }
            return this.streamMetadataStore.getReaderGroupConfigRecord(scope, rgName, context, this.executor).thenCompose(rgConfigRecord -> {
                if (((ReaderGroupConfigRecord)rgConfigRecord.getObject()).getGeneration() != config.getGeneration()) {
                    Controller.UpdateReaderGroupResponse response = Controller.UpdateReaderGroupResponse.newBuilder().setStatus(Controller.UpdateReaderGroupResponse.Status.INVALID_CONFIG).setGeneration(config.getGeneration()).build();
                    return CompletableFuture.completedFuture(response);
                }
                if (!((ReaderGroupConfigRecord)rgConfigRecord.getObject()).isUpdating()) {
                    return this.streamMetadataStore.getReaderGroupId(scope, rgName, context, this.executor).thenCompose(rgId -> {
                        if (!config.getReaderGroupId().equals(rgId)) {
                            Controller.UpdateReaderGroupResponse response = Controller.UpdateReaderGroupResponse.newBuilder().setStatus(Controller.UpdateReaderGroupResponse.Status.INVALID_CONFIG).setGeneration(config.getGeneration()).build();
                            return CompletableFuture.completedFuture(response);
                        }
                        ImmutableSet<String> removeStreams = this.getStreamsToBeUnsubscribed((ReaderGroupConfigRecord)rgConfigRecord.getObject(), config);
                        boolean isTransition = this.isTransitionToOrFromSubscriber((ReaderGroupConfigRecord)rgConfigRecord.getObject(), config);
                        UpdateReaderGroupEvent event = new UpdateReaderGroupEvent(scope, rgName, requestId, rgId, ((ReaderGroupConfigRecord)rgConfigRecord.getObject()).getGeneration() + 1L, isTransition, removeStreams);
                        return this.eventHelperFuture.thenCompose(eventHelper -> eventHelper.addIndexAndSubmitTask((ControllerEvent)event, () -> this.streamMetadataStore.startRGConfigUpdate(scope, rgName, config, context, this.executor)).thenCompose(x -> eventHelper.checkDone(() -> this.isRGUpdated(scope, rgName, this.executor, context)).thenCompose(y -> this.streamMetadataStore.getReaderGroupConfigRecord(scope, rgName, context, this.executor).thenApply(configRecord -> {
                            Controller.UpdateReaderGroupResponse response = Controller.UpdateReaderGroupResponse.newBuilder().setStatus(Controller.UpdateReaderGroupResponse.Status.SUCCESS).setGeneration(((ReaderGroupConfigRecord)configRecord.getObject()).getGeneration()).build();
                            return response;
                        }))));
                    });
                }
                log.error(requestId, "Reader group config update failed as another update was in progress.", new Object[0]);
                Controller.UpdateReaderGroupResponse response = Controller.UpdateReaderGroupResponse.newBuilder().setStatus(Controller.UpdateReaderGroupResponse.Status.FAILURE).setGeneration(config.getGeneration()).build();
                return CompletableFuture.completedFuture(response);
            });
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, 10, this.executor);
    }

    private boolean isTransitionToOrFromSubscriber(ReaderGroupConfigRecord currentConfig, ReaderGroupConfig newConfig) {
        return !ReaderGroupConfig.StreamDataRetention.NONE.equals((Object)ReaderGroupConfig.StreamDataRetention.values()[currentConfig.getRetentionTypeOrdinal()]) || !ReaderGroupConfig.StreamDataRetention.NONE.equals((Object)newConfig.getRetentionType());
    }

    private ImmutableSet<String> getStreamsToBeUnsubscribed(ReaderGroupConfigRecord currentConfig, ReaderGroupConfig newConfig) {
        if (this.isNonSubscriberToSubscriberTransition(currentConfig, newConfig)) {
            return ImmutableSet.of();
        }
        if (this.isSubscriberToNonSubscriberTransition(currentConfig, newConfig)) {
            ImmutableSet.Builder streamsToBeUnsubscribedBuilder = ImmutableSet.builder();
            currentConfig.getStartingStreamCuts().keySet().forEach(arg_0 -> ((ImmutableSet.Builder)streamsToBeUnsubscribedBuilder).add(arg_0));
            return streamsToBeUnsubscribedBuilder.build();
        }
        Set<String> currentConfigStreams = currentConfig.getStartingStreamCuts().keySet();
        Set newConfigStreams = newConfig.getStartingStreamCuts().keySet().stream().map(io.pravega.client.stream.Stream::getScopedName).collect(Collectors.toSet());
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        currentConfigStreams.stream().filter(s -> !newConfigStreams.contains(s)).forEach(arg_0 -> ((ImmutableSet.Builder)setBuilder).add(arg_0));
        return setBuilder.build();
    }

    private boolean isNonSubscriberToSubscriberTransition(ReaderGroupConfigRecord currentConfig, ReaderGroupConfig newConfig) {
        return ReaderGroupConfig.StreamDataRetention.NONE.equals((Object)ReaderGroupConfig.StreamDataRetention.values()[currentConfig.getRetentionTypeOrdinal()]) && !ReaderGroupConfig.StreamDataRetention.NONE.equals((Object)newConfig.getRetentionType());
    }

    private boolean isSubscriberToNonSubscriberTransition(ReaderGroupConfigRecord currentConfig, ReaderGroupConfig newConfig) {
        return !ReaderGroupConfig.StreamDataRetention.NONE.equals((Object)ReaderGroupConfig.StreamDataRetention.values()[currentConfig.getRetentionTypeOrdinal()]) && ReaderGroupConfig.StreamDataRetention.NONE.equals((Object)newConfig.getRetentionType());
    }

    private CompletableFuture<Boolean> isRGUpdated(String scope, String rgName, Executor executor, OperationContext context) {
        return this.streamMetadataStore.getReaderGroupConfigRecord(scope, rgName, context, executor).thenCompose(rgConfigRecord -> {
            log.debug(context.getRequestId(), "Is ReaderGroup Config update complete ? {}", new Object[]{((ReaderGroupConfigRecord)rgConfigRecord.getObject()).isUpdating()});
            return CompletableFuture.completedFuture(!((ReaderGroupConfigRecord)rgConfigRecord.getObject()).isUpdating());
        });
    }

    public CompletableFuture<Controller.DeleteReaderGroupStatus.Status> deleteReaderGroup(String scope, String rgName, String readerGroupId, long requestId) {
        OperationContext context = this.streamMetadataStore.createRGContext(scope, rgName, requestId);
        return RetryHelper.withRetriesAsync(() -> this.streamMetadataStore.checkReaderGroupExists(scope, rgName, context, this.executor).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(Controller.DeleteReaderGroupStatus.Status.RG_NOT_FOUND);
            }
            return this.streamMetadataStore.getReaderGroupId(scope, rgName, context, this.executor).thenCompose(rgId -> {
                if (!rgId.equals(UUID.fromString(readerGroupId))) {
                    return CompletableFuture.completedFuture(Controller.DeleteReaderGroupStatus.Status.RG_NOT_FOUND);
                }
                return this.eventHelperFuture.thenCompose(eventHelper -> this.streamMetadataStore.getReaderGroupConfigRecord(scope, rgName, context, this.executor).thenCompose(configRecord -> this.streamMetadataStore.getVersionedReaderGroupState(scope, rgName, true, context, this.executor).thenCompose(versionedState -> eventHelper.addIndexAndSubmitTask((ControllerEvent)new DeleteReaderGroupEvent(scope, rgName, requestId, rgId), () -> this.startReaderGroupDelete(scope, rgName, (VersionedMetadata<ReaderGroupState>)versionedState, context)).thenCompose(x -> eventHelper.checkDone(() -> this.isRGDeleted(scope, rgName, context)).thenApply(done -> Controller.DeleteReaderGroupStatus.Status.SUCCESS)))));
            });
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, 10, this.executor);
    }

    private CompletableFuture<Boolean> isRGDeleted(String scope, String rgName, OperationContext context) {
        return this.streamMetadataStore.checkReaderGroupExists(scope, rgName, context, this.executor).thenApply(exists -> exists == false);
    }

    private CompletableFuture<Void> startReaderGroupDelete(String scope, String rgName, VersionedMetadata<ReaderGroupState> currentState, OperationContext context) {
        return Futures.toVoid(this.streamMetadataStore.updateReaderGroupVersionedState(scope, rgName, ReaderGroupState.DELETING, currentState, context, this.executor));
    }

    @Task(name="createStream", version="1.0", resource="{scope}/{stream}")
    public CompletableFuture<Controller.CreateStreamStatus.Status> createStream(String scope, String stream, StreamConfiguration config, long createTimestamp, long requestId) {
        log.debug(requestId, "createStream with resource called.", new Object[0]);
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        return this.execute(new Resource(scope, stream), new Serializable[]{scope, stream, config, Long.valueOf(createTimestamp), Long.valueOf(requestId)}, () -> this.createStreamBody(scope, stream, config, createTimestamp, context));
    }

    public CompletableFuture<Controller.UpdateStreamStatus.Status> updateStream(String scope, String stream, StreamConfiguration newConfig, long requestId) {
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        return ((CompletableFuture)this.streamMetadataStore.getConfigurationRecord(scope, stream, context, this.executor).thenCompose(configProperty -> {
            if (!((StreamConfigurationRecord)configProperty.getObject()).isUpdating()) {
                return this.eventHelperFuture.thenCompose(eventHelper -> eventHelper.addIndexAndSubmitTask((ControllerEvent)new UpdateStreamEvent(scope, stream, requestId), () -> this.streamMetadataStore.startUpdateConfiguration(scope, stream, newConfig, context, this.executor)).thenCompose(x -> eventHelper.checkDone(() -> this.isUpdated(scope, stream, newConfig, context)).thenApply(y -> Controller.UpdateStreamStatus.Status.SUCCESS)));
            }
            log.error(requestId, "Another update in progress for {}/{}", new Object[]{scope, stream});
            return CompletableFuture.completedFuture(Controller.UpdateStreamStatus.Status.FAILURE);
        })).exceptionally(ex -> {
            String message = "Exception updating stream configuration {}";
            return this.handleUpdateStreamError((Throwable)ex, requestId, "Exception updating stream configuration {}", NameUtils.getScopedStreamName((String)scope, (String)stream));
        });
    }

    @VisibleForTesting
    CompletableFuture<Boolean> isUpdated(String scope, String stream, StreamConfiguration newConfig, OperationContext context) {
        CompletableFuture<State> stateFuture = this.streamMetadataStore.getState(scope, stream, true, context, this.executor);
        CompletionStage configPropertyFuture = this.streamMetadataStore.getConfigurationRecord(scope, stream, context, this.executor).thenApply(VersionedMetadata::getObject);
        return CompletableFuture.allOf(new CompletableFuture[]{stateFuture, configPropertyFuture}).thenApply(arg_0 -> StreamMetadataTasks.lambda$isUpdated$79(stateFuture, (CompletableFuture)configPropertyFuture, newConfig, arg_0));
    }

    public CompletableFuture<Controller.SubscribersResponse> listSubscribers(String scope, String stream, long requestId) {
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        return this.streamMetadataStore.checkStreamExists(scope, stream, context, this.executor).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(Controller.SubscribersResponse.newBuilder().setStatus(Controller.SubscribersResponse.Status.STREAM_NOT_FOUND).build());
            }
            return ((CompletableFuture)this.streamMetadataStore.listSubscribers(scope, stream, context, this.executor).thenApply(result -> Controller.SubscribersResponse.newBuilder().setStatus(Controller.SubscribersResponse.Status.SUCCESS).addAllSubscribers((Iterable)result).build())).exceptionally(ex -> {
                log.error(requestId, "Exception trying to get list of subscribers for Stream {}. Cause {}", new Object[]{NameUtils.getScopedStreamName((String)scope, (String)stream), ex});
                Throwable cause = Exceptions.unwrap((Throwable)ex);
                if (cause instanceof TimeoutException) {
                    throw new CompletionException(cause);
                }
                return Controller.SubscribersResponse.newBuilder().setStatus(Controller.SubscribersResponse.Status.FAILURE).build();
            });
        });
    }

    public CompletableFuture<Controller.UpdateSubscriberStatus.Status> updateSubscriberStreamCut(String scope, String stream, String subscriber, String readerGroupId, long generation, ImmutableMap<Long, Long> truncationStreamCut, long requestId) {
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        return RetryHelper.withRetriesAsync(() -> this.streamMetadataStore.checkStreamExists(scope, stream, context, this.executor).thenCompose(exists -> {
            if (!exists.booleanValue()) {
                return CompletableFuture.completedFuture(Controller.UpdateSubscriberStatus.Status.STREAM_NOT_FOUND);
            }
            return Futures.exceptionallyExpecting(this.streamMetadataStore.getSubscriber(scope, stream, subscriber, context, this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, null).thenCompose(subscriberRecord -> {
                if (subscriberRecord == null) {
                    return CompletableFuture.completedFuture(Controller.UpdateSubscriberStatus.Status.SUBSCRIBER_NOT_FOUND);
                }
                List subscriberScopedName = NameUtils.extractScopedNameTokens((String)subscriber);
                return this.streamMetadataStore.getReaderGroupId((String)subscriberScopedName.get(0), (String)subscriberScopedName.get(1), context, this.executor).thenCompose(rgId -> {
                    if (!rgId.equals(UUID.fromString(readerGroupId))) {
                        return CompletableFuture.completedFuture(Controller.UpdateSubscriberStatus.Status.SUBSCRIBER_NOT_FOUND);
                    }
                    if (((StreamSubscriber)subscriberRecord.getObject()).getGeneration() != generation) {
                        return CompletableFuture.completedFuture(Controller.UpdateSubscriberStatus.Status.GENERATION_MISMATCH);
                    }
                    return ((CompletableFuture)this.streamMetadataStore.updateSubscriberStreamCut(scope, stream, subscriber, generation, truncationStreamCut, (VersionedMetadata<StreamSubscriber>)subscriberRecord, context, this.executor).thenApply(x -> Controller.UpdateSubscriberStatus.Status.SUCCESS)).exceptionally(ex -> {
                        log.error(requestId, "Exception updating StreamCut for Subscriber {} on Stream {}. Cause:{}", new Object[]{subscriber, NameUtils.getScopedStreamName((String)scope, (String)stream), ex});
                        Throwable cause = Exceptions.unwrap((Throwable)ex);
                        if (cause instanceof StoreException.OperationNotAllowedException) {
                            return Controller.UpdateSubscriberStatus.Status.STREAM_CUT_NOT_VALID;
                        }
                        if (cause instanceof TimeoutException) {
                            throw new CompletionException(cause);
                        }
                        return Controller.UpdateSubscriberStatus.Status.FAILURE;
                    });
                });
            });
        }), e -> Exceptions.unwrap((Throwable)e) instanceof RetryableException, 10, this.executor);
    }

    public CompletableFuture<Void> retention(String scope, String stream, RetentionPolicy policy, long recordingTime, OperationContext contextOpt, String delegationToken) {
        Preconditions.checkNotNull((Object)policy);
        OperationContext context = contextOpt != null ? contextOpt : this.streamMetadataStore.createStreamContext(scope, stream, this.requestIdGenerator.nextLong());
        return ((CompletableFuture)this.streamMetadataStore.getRetentionSet(scope, stream, context, this.executor).thenCompose(retentionSet -> {
            StreamCutReferenceRecord latestCut = retentionSet.getLatest();
            return this.generateStreamCutIfRequired(scope, stream, latestCut, recordingTime, context, delegationToken).thenCompose(newRecord -> this.truncate(scope, stream, policy, context, (RetentionSet)retentionSet, (StreamCutRecord)newRecord));
        })).thenAccept(x -> StreamMetrics.reportRetentionEvent(scope, stream));
    }

    private CompletableFuture<StreamCutRecord> generateStreamCutIfRequired(String scope, String stream, StreamCutReferenceRecord previous, long recordingTime, OperationContext context, String delegationToken) {
        if (previous == null || recordingTime - previous.getRecordingTime() > this.retentionFrequencyMillis.get()) {
            return Futures.exceptionallyComposeExpecting(previous == null ? CompletableFuture.completedFuture(null) : this.streamMetadataStore.getStreamCutRecord(scope, stream, previous, context, this.executor), e -> e instanceof StoreException.DataNotFoundException, () -> null).thenCompose(previousRecord -> this.generateStreamCut(scope, stream, (StreamCutRecord)previousRecord, context, delegationToken).thenCompose(newRecord -> this.streamMetadataStore.addStreamCutToRetentionSet(scope, stream, (StreamCutRecord)newRecord, context, this.executor).thenApply(x -> {
                log.debug(context.getRequestId(), "New streamCut generated for stream {}/{}", new Object[]{scope, stream});
                return newRecord;
            })));
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> truncate(String scope, String stream, RetentionPolicy policy, OperationContext context, RetentionSet retentionSet, StreamCutRecord newRecord) {
        RetentionSet updatedRetentionSet = newRecord == null ? retentionSet : RetentionSet.addReferenceToStreamCutIfLatest(retentionSet, newRecord);
        return this.truncateInternal(scope, stream, context, policy, updatedRetentionSet);
    }

    private CompletableFuture<Void> truncateInternal(String scope, String stream, OperationContext context, RetentionPolicy policy, RetentionSet retentionSet) {
        long requestId = context.getRequestId();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.streamMetadataStore.listSubscribers(scope, stream, context, this.executor).thenCompose(list -> Futures.allOfWithResults(list.stream().map(x -> this.streamMetadataStore.getSubscriber(scope, stream, (String)x, context, this.executor)).collect(Collectors.toList())))).thenCompose(subscribers -> Futures.allOfWithResults(subscribers.stream().map(x -> {
            ImmutableSet entries = ((StreamSubscriber)x.getObject()).getTruncationStreamCut().entrySet();
            return Futures.keysAllOfWithResults(entries.stream().collect(Collectors.toMap(y -> this.streamMetadataStore.getSegment(scope, stream, (Long)y.getKey(), context, this.executor), Map.Entry::getValue)));
        }).collect(Collectors.toList())))).thenApply(this::computeSubscribersLowerBound)).thenCompose(lowerBound -> {
            CompletableFuture<Map<Long, Long>> toTruncateAt = policy.getRetentionType().equals((Object)RetentionPolicy.RetentionType.SIZE) ? this.getTruncationStreamCutBySizeLimit(scope, stream, context, policy, retentionSet, (Map<Long, Long>)lowerBound) : this.getTruncationStreamCutByTimeLimit(scope, stream, context, policy, retentionSet, (Map<Long, Long>)lowerBound);
            return toTruncateAt.thenCompose(truncationStreamCut -> {
                if (truncationStreamCut == null || truncationStreamCut.isEmpty()) {
                    log.debug(context.getRequestId(), "no truncation record could be compute that satisfied retention policy", new Object[0]);
                    return CompletableFuture.completedFuture(null);
                }
                return ((CompletableFuture)this.startTruncation(scope, stream, (Map<Long, Long>)truncationStreamCut, context).thenCompose(started -> {
                    if (started.booleanValue()) {
                        return this.streamMetadataStore.findStreamCutReferenceRecordBefore(scope, stream, (Map<Long, Long>)truncationStreamCut, retentionSet, context, this.executor).thenCompose(ref -> {
                            if (ref != null) {
                                return this.streamMetadataStore.deleteStreamCutBefore(scope, stream, (StreamCutReferenceRecord)ref, context, this.executor);
                            }
                            return CompletableFuture.completedFuture(null);
                        });
                    }
                    throw new RuntimeException("Could not start truncation");
                })).exceptionally(e -> {
                    if (Exceptions.unwrap((Throwable)e) instanceof IllegalArgumentException) {
                        log.debug(requestId, "Cannot truncate at given streamCut because it intersects with existing truncation point", new Object[0]);
                        return null;
                    }
                    throw new CompletionException((Throwable)e);
                });
            });
        });
    }

    private CompletableFuture<Map<Long, Long>> getTruncationStreamCutBySizeLimit(String scope, String stream, OperationContext context, RetentionPolicy policy, RetentionSet retentionSet, Map<Long, Long> lowerBound) {
        long currentSize = retentionSet.getLatest().getRecordingSize();
        Map.Entry<StreamCutReferenceRecord, StreamCutReferenceRecord> limits = this.getBoundStreamCuts(policy, retentionSet, x -> currentSize - x.getRecordingSize());
        if (lowerBound == null || lowerBound.isEmpty()) {
            return Optional.ofNullable(limits.getValue()).map(x -> this.streamMetadataStore.getStreamCutRecord(scope, stream, (StreamCutReferenceRecord)x, context, this.executor).thenApply(StreamCutRecord::getStreamCut)).orElse(CompletableFuture.completedFuture(null));
        }
        return this.streamMetadataStore.getSizeTillStreamCut(scope, stream, lowerBound, Optional.empty(), context, this.executor).thenCompose(sizeTillLB -> {
            long retainedSizeLB = currentSize - sizeTillLB;
            if (retainedSizeLB < policy.getRetentionParam()) {
                return Optional.ofNullable((StreamCutReferenceRecord)limits.getValue()).map(x -> this.streamMetadataStore.getStreamCutRecord(scope, stream, (StreamCutReferenceRecord)limits.getValue(), context, this.executor).thenCompose(limitMin -> this.streamMetadataStore.compareStreamCut(scope, stream, limitMin.getStreamCut(), lowerBound, context, this.executor).thenCompose(compareWithMin -> {
                    switch (compareWithMin) {
                        case Before: {
                            return CompletableFuture.completedFuture(limitMin.getStreamCut());
                        }
                    }
                    return this.getStreamcutBeforeLowerbound(scope, stream, context, retentionSet, lowerBound);
                }))).orElse(CompletableFuture.completedFuture(null));
            }
            if (retainedSizeLB < policy.getRetentionMax()) {
                return CompletableFuture.completedFuture(lowerBound);
            }
            return Optional.ofNullable((StreamCutReferenceRecord)limits.getKey()).filter(x -> currentSize - x.getRecordingSize() < retainedSizeLB).map(x -> this.streamMetadataStore.getStreamCutRecord(scope, stream, (StreamCutReferenceRecord)x, context, this.executor).thenApply(StreamCutRecord::getStreamCut)).orElse(CompletableFuture.completedFuture(lowerBound));
        });
    }

    private CompletableFuture<Map<Long, Long>> getTruncationStreamCutByTimeLimit(String scope, String stream, OperationContext context, RetentionPolicy policy, RetentionSet retentionSet, Map<Long, Long> lowerBound) {
        CompletableFuture<Object> limitMinFuture;
        long currentTime = this.retentionClock.get().get();
        Map.Entry<StreamCutReferenceRecord, StreamCutReferenceRecord> limits = this.getBoundStreamCuts(policy, retentionSet, x -> currentTime - x.getRecordingTime());
        CompletableFuture<Object> completableFuture = limitMinFuture = limits.getValue() == null ? CompletableFuture.completedFuture(null) : this.streamMetadataStore.getStreamCutRecord(scope, stream, limits.getValue(), context, this.executor);
        if (lowerBound == null || lowerBound.isEmpty()) {
            return limitMinFuture.thenApply(min -> Optional.ofNullable(min).map(StreamCutRecord::getStreamCut).orElse(null));
        }
        Optional<StreamCutReferenceRecord> maxBoundRef = retentionSet.getRetentionRecords().stream().filter(x -> currentTime - x.getRecordingTime() >= policy.getRetentionMax()).max(Comparator.comparingLong(StreamCutReferenceRecord::getRecordingTime));
        CompletableFuture<Object> limitMaxFuture = limits.getKey() == null ? CompletableFuture.completedFuture(null) : this.streamMetadataStore.getStreamCutRecord(scope, stream, limits.getKey(), context, this.executor);
        CompletableFuture<Object> maxBoundFuture = maxBoundRef.map(x -> this.streamMetadataStore.getStreamCutRecord(scope, stream, (StreamCutReferenceRecord)x, context, this.executor)).orElse(CompletableFuture.completedFuture(null));
        return CompletableFuture.allOf(limitMaxFuture, limitMinFuture, maxBoundFuture).thenCompose(v -> {
            StreamCutRecord limitMax = (StreamCutRecord)limitMaxFuture.join();
            StreamCutRecord limitMin = (StreamCutRecord)limitMinFuture.join();
            StreamCutRecord maxBound = (StreamCutRecord)maxBoundFuture.join();
            if (limitMin != null) {
                return this.streamMetadataStore.compareStreamCut(scope, stream, limitMin.getStreamCut(), lowerBound, context, this.executor).thenCompose(compareWithMin -> {
                    switch (compareWithMin) {
                        case EqualOrAfter: {
                            return this.truncateAtLowerBoundOrMax(scope, stream, context, lowerBound, limitMax, maxBound);
                        }
                        case Overlaps: {
                            return this.getStreamcutBeforeLowerbound(scope, stream, context, retentionSet, lowerBound);
                        }
                        case Before: {
                            return CompletableFuture.completedFuture(limitMin.getStreamCut());
                        }
                    }
                    throw new IllegalArgumentException("Invalid Compare streamcut response");
                });
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<Map<Long, Long>> truncateAtLowerBoundOrMax(String scope, String stream, OperationContext context, Map<Long, Long> lowerBound, StreamCutRecord limitMax, StreamCutRecord maxBound) {
        if (maxBound == null) {
            return CompletableFuture.completedFuture(lowerBound);
        }
        return this.streamMetadataStore.compareStreamCut(scope, stream, lowerBound, maxBound.getStreamCut(), context, this.executor).thenCompose(compareWithMax -> {
            switch (compareWithMax) {
                case EqualOrAfter: {
                    return CompletableFuture.completedFuture(lowerBound);
                }
                case Before: {
                    return CompletableFuture.completedFuture(limitMax.getStreamCut());
                }
            }
            return CompletableFuture.completedFuture(maxBound.getStreamCut());
        });
    }

    private CompletableFuture<Map<Long, Long>> getStreamcutBeforeLowerbound(String scope, String stream, OperationContext context, RetentionSet retentionSet, Map<Long, Long> lowerBound) {
        return this.streamMetadataStore.findStreamCutReferenceRecordBefore(scope, stream, lowerBound, retentionSet, context, this.executor).thenCompose(refRecord -> Optional.ofNullable(refRecord).map(ref -> this.streamMetadataStore.getStreamCutRecord(scope, stream, (StreamCutReferenceRecord)ref, context, this.executor).thenApply(StreamCutRecord::getStreamCut)).orElse(CompletableFuture.completedFuture(null)));
    }

    private Map<Long, Long> computeSubscribersLowerBound(List<Map<StreamSegmentRecord, Long>> subscribers) {
        HashMap lowerBound = new HashMap();
        subscribers.forEach(streamCut -> streamCut.forEach((segment, offset) -> {
            if (lowerBound.containsKey(segment)) {
                if ((Long)lowerBound.get(segment) > offset) {
                    lowerBound.put(segment, offset);
                }
            } else {
                HashMap predecessors = new HashMap();
                HashMap<StreamSegmentRecord, Long> successors = new HashMap<StreamSegmentRecord, Long>();
                lowerBound.forEach((s, o) -> {
                    if (s.overlaps((StreamSegmentRecord)segment)) {
                        if (s.segmentId() < segment.segmentId()) {
                            predecessors.put(s, o);
                        } else {
                            successors.put((StreamSegmentRecord)s, (Long)o);
                        }
                    }
                });
                if (successors.isEmpty() && predecessors.isEmpty()) {
                    lowerBound.put(segment, offset);
                } else if (offset < 0L) {
                    TreeMap<Double, Double> range = new TreeMap<Double, Double>();
                    predecessors.keySet().forEach(x -> range.put(x.getKeyStart(), x.getKeyEnd()));
                    if (!this.checkCoverage(segment.getKeyStart(), segment.getKeyEnd(), range)) {
                        lowerBound.put(segment, offset);
                    }
                } else if (predecessors.isEmpty()) {
                    lowerBound.put(segment, offset);
                    successors.forEach((s, o) -> {
                        if (o >= 0L) {
                            lowerBound.remove(s);
                        } else {
                            TreeMap<Double, Double> range = new TreeMap<Double, Double>();
                            lowerBound.keySet().forEach(x -> {
                                if (x.overlaps((StreamSegmentRecord)s) && x.segmentId() < s.segmentId()) {
                                    range.put(x.getKeyStart(), x.getKeyEnd());
                                }
                            });
                            if (this.checkCoverage(s.getKeyStart(), s.getKeyEnd(), range)) {
                                lowerBound.remove(s);
                            }
                        }
                    });
                }
            }
        }));
        return lowerBound.entrySet().stream().collect(Collectors.toMap(x -> ((StreamSegmentRecord)x.getKey()).segmentId(), Map.Entry::getValue));
    }

    private boolean checkCoverage(double keyStart, double keyEnd, TreeMap<Double, Double> range) {
        AtomicReference<Double> previous = new AtomicReference<Double>();
        AtomicReference<Double> toCheckStart = new AtomicReference<Double>(keyStart);
        AtomicBoolean covered = new AtomicBoolean(true);
        for (Map.Entry<Double, Double> entry : range.entrySet()) {
            if (toCheckStart.get() >= keyEnd) {
                covered.set(true);
                break;
            }
            if (previous.get() == null) {
                previous.set(entry.getValue());
                if (keyStart < entry.getKey()) {
                    covered.set(false);
                    break;
                }
                toCheckStart.set(entry.getValue());
                continue;
            }
            if ((Double)previous.get() < entry.getKey()) {
                if (!StreamSegmentRecord.overlaps(new AbstractMap.SimpleEntry<Double, Double>((Double)previous.get(), entry.getKey()), new AbstractMap.SimpleEntry<Double, Double>(toCheckStart.get(), keyEnd))) continue;
                covered.set(false);
                break;
            }
            toCheckStart.set(Math.max((Double)previous.get(), entry.getValue()));
        }
        covered.compareAndSet(true, toCheckStart.get() >= keyEnd);
        return covered.get();
    }

    private Map.Entry<StreamCutReferenceRecord, StreamCutReferenceRecord> getBoundStreamCuts(RetentionPolicy policy, RetentionSet retentionSet, Function<StreamCutReferenceRecord, Long> delta) {
        AtomicReference<StreamCutReferenceRecord> max = new AtomicReference<StreamCutReferenceRecord>();
        AtomicReference min = new AtomicReference();
        AtomicLong maxSoFar = new AtomicLong(Long.MIN_VALUE);
        AtomicLong minSoFar = new AtomicLong(Long.MAX_VALUE);
        retentionSet.getRetentionRecords().forEach(x -> {
            long value = (Long)delta.apply((StreamCutReferenceRecord)x);
            if (value >= policy.getRetentionParam() && value <= policy.getRetentionMax() && value > maxSoFar.get()) {
                max.set((StreamCutReferenceRecord)x);
                maxSoFar.set(value);
            }
            if (value >= policy.getRetentionParam() && value < minSoFar.get()) {
                min.set(x);
                minSoFar.set(value);
            }
        });
        if (max.get() == null) {
            max.set((StreamCutReferenceRecord)min.get());
        }
        return new AbstractMap.SimpleEntry<StreamCutReferenceRecord, StreamCutReferenceRecord>((StreamCutReferenceRecord)max.get(), (StreamCutReferenceRecord)min.get());
    }

    public CompletableFuture<StreamCutRecord> generateStreamCut(String scope, String stream, StreamCutRecord previous, OperationContext contextOpt, String delegationToken) {
        OperationContext context = contextOpt != null ? contextOpt : this.streamMetadataStore.createStreamContext(scope, stream, this.requestIdGenerator.nextLong());
        return ((CompletableFuture)this.streamMetadataStore.getActiveSegments(scope, stream, context, this.executor).thenCompose(activeSegments -> Futures.allOfWithResults(((Stream)activeSegments.stream().parallel()).collect(Collectors.toMap(x -> x, x -> this.getSegmentOffset(scope, stream, x.segmentId(), delegationToken, context.getRequestId())))))).thenCompose(map -> {
            long generationTime = this.retentionClock.get().get();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            map.forEach((key, value) -> builder.put((Object)key.segmentId(), value));
            ImmutableMap streamCutMap = builder.build();
            return this.streamMetadataStore.getSizeTillStreamCut(scope, stream, (Map<Long, Long>)streamCutMap, Optional.ofNullable(previous), context, this.executor).thenApply(sizeTill -> new StreamCutRecord(generationTime, (long)sizeTill, (ImmutableMap<Long, Long>)streamCutMap));
        });
    }

    public CompletableFuture<Controller.UpdateStreamStatus.Status> truncateStream(String scope, String stream, Map<Long, Long> streamCut, long requestId) {
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        return ((CompletableFuture)this.eventHelperFuture.thenCompose(eventHelper -> this.startTruncation(scope, stream, streamCut, context).thenCompose(truncationStarted -> {
            if (truncationStarted.booleanValue()) {
                return eventHelper.checkDone(() -> this.isTruncated(scope, stream, streamCut, context), 1000L).thenApply(y -> Controller.UpdateStreamStatus.Status.SUCCESS);
            }
            log.error(requestId, "Unable to start truncation for {}/{}", new Object[]{scope, stream});
            return CompletableFuture.completedFuture(Controller.UpdateStreamStatus.Status.FAILURE);
        }))).exceptionally(ex -> {
            String message = "Exception thrown in trying to truncate stream";
            return this.handleUpdateStreamError((Throwable)ex, requestId, "Exception thrown in trying to truncate stream", NameUtils.getScopedStreamName((String)scope, (String)stream));
        });
    }

    public CompletableFuture<Boolean> startTruncation(String scope, String stream, Map<Long, Long> streamCut, OperationContext contextOpt) {
        OperationContext context = contextOpt != null ? contextOpt : this.streamMetadataStore.createStreamContext(scope, stream, this.requestIdGenerator.nextLong());
        long requestId = context.getRequestId();
        return this.streamMetadataStore.getTruncationRecord(scope, stream, context, this.executor).thenCompose(property -> {
            if (!((StreamTruncationRecord)property.getObject()).isUpdating()) {
                return this.eventHelperFuture.thenCompose(eventHelper -> eventHelper.addIndexAndSubmitTask((ControllerEvent)new TruncateStreamEvent(scope, stream, requestId), () -> this.streamMetadataStore.startTruncation(scope, stream, streamCut, context, this.executor)).thenApply(x -> {
                    log.debug(requestId, "Started truncation request for stream {}/{}", new Object[]{scope, stream});
                    return true;
                }));
            }
            log.error(requestId, "Another truncation in progress for {}/{}", new Object[]{scope, stream});
            return CompletableFuture.completedFuture(false);
        });
    }

    @VisibleForTesting
    CompletableFuture<Boolean> isTruncated(String scope, String stream, Map<Long, Long> streamCut, OperationContext context) {
        CompletableFuture<State> stateFuture = this.streamMetadataStore.getState(scope, stream, true, context, this.executor);
        CompletionStage configPropertyFuture = this.streamMetadataStore.getTruncationRecord(scope, stream, context, this.executor).thenApply(VersionedMetadata::getObject);
        return CompletableFuture.allOf(new CompletableFuture[]{stateFuture, configPropertyFuture}).thenApply(arg_0 -> StreamMetadataTasks.lambda$isTruncated$149(stateFuture, (CompletableFuture)configPropertyFuture, streamCut, arg_0));
    }

    public CompletableFuture<Controller.UpdateStreamStatus.Status> sealStream(String scope, String stream, long requestId) {
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        return this.sealStream(scope, stream, context);
    }

    public CompletableFuture<Controller.UpdateStreamStatus.Status> sealStream(String scope, String stream, OperationContext context) {
        return this.sealStream(scope, stream, context, 10);
    }

    @VisibleForTesting
    CompletableFuture<Controller.UpdateStreamStatus.Status> sealStream(String scope, String stream, OperationContext context, int retryCount) {
        long requestId = context.getRequestId();
        SealStreamEvent event = new SealStreamEvent(scope, stream, requestId);
        return ((CompletableFuture)this.eventHelperFuture.thenCompose(eventHelper -> eventHelper.addIndexAndSubmitTask((ControllerEvent)event, () -> RetryHelper.withRetriesAsync(() -> this.streamMetadataStore.getVersionedState(scope, stream, context, this.executor).thenCompose(state -> {
            if (((State)((Object)((Object)((Object)((Object)((Object)state.getObject())))))).equals((Object)State.SEALED)) {
                return CompletableFuture.completedFuture(state);
            }
            return this.streamMetadataStore.updateVersionedState(scope, stream, State.SEALING, (VersionedMetadata<State>)state, context, this.executor);
        }), RetryHelper.RETRYABLE_PREDICATE.or(e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.OperationNotAllowedException), retryCount, this.executor)).thenCompose(result -> {
            if (((State)((Object)((Object)((Object)result.getObject())))).equals((Object)State.SEALED) || ((State)((Object)((Object)((Object)result.getObject())))).equals((Object)State.SEALING)) {
                return eventHelper.checkDone(() -> this.isSealed(scope, stream, context)).thenApply(x -> Controller.UpdateStreamStatus.Status.SUCCESS);
            }
            return CompletableFuture.completedFuture(Controller.UpdateStreamStatus.Status.FAILURE);
        }))).exceptionally(ex -> {
            String message = "Exception thrown in trying to notify sealed segments.";
            return this.handleUpdateStreamError((Throwable)ex, requestId, "Exception thrown in trying to notify sealed segments.", NameUtils.getScopedStreamName((String)scope, (String)stream));
        });
    }

    private CompletableFuture<Boolean> isSealed(String scope, String stream, OperationContext context) {
        return this.streamMetadataStore.getState(scope, stream, true, context, this.executor).thenApply(state -> state.equals((Object)State.SEALED));
    }

    public CompletableFuture<Controller.DeleteStreamStatus.Status> deleteStream(String scope, String stream, long requestId) {
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        return this.deleteStream(scope, stream, context);
    }

    public CompletableFuture<Controller.DeleteStreamStatus.Status> deleteStream(String scope, String stream, OperationContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"Operation Context is null");
        long requestId = context.getRequestId();
        return ((CompletableFuture)this.eventHelperFuture.thenCompose(eventHelper -> ((CompletableFuture)Futures.exceptionallyExpecting(this.streamMetadataStore.getState(scope, stream, false, context, this.executor), e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException, (Object)((Object)State.UNKNOWN)).thenCompose(state -> {
            block5: {
                block4: {
                    if (State.SEALED.equals(state)) break block4;
                    if (!State.CREATING.equals(state)) break block5;
                }
                return ((CompletableFuture)((CompletableFuture)this.streamMetadataStore.getCreationTime(scope, stream, context, this.executor).thenApply(time -> new DeleteStreamEvent(scope, stream, requestId, time.longValue()))).thenCompose(eventHelper::writeEvent)).thenApply(x -> true);
            }
            if (State.UNKNOWN.equals(state)) {
                return ((CompletableFuture)this.streamMetadataStore.deleteStream(scope, stream, context, this.executor).exceptionally(e -> {
                    throw new CompletionException((Throwable)e);
                })).thenApply(v -> true);
            }
            return CompletableFuture.completedFuture(false);
        })).thenCompose(result -> {
            if (result.booleanValue()) {
                return eventHelper.checkDone(() -> this.isDeleted(scope, stream, context)).thenApply(x -> Controller.DeleteStreamStatus.Status.SUCCESS);
            }
            return CompletableFuture.completedFuture(Controller.DeleteStreamStatus.Status.STREAM_NOT_SEALED);
        }))).exceptionally(ex -> this.handleDeleteStreamError((Throwable)ex, requestId, NameUtils.getScopedStreamName((String)scope, (String)stream)));
    }

    private CompletableFuture<Boolean> isDeleted(String scope, String stream, OperationContext context) {
        return this.streamMetadataStore.checkStreamExists(scope, stream, context, this.executor).thenApply(x -> x == false);
    }

    public CompletableFuture<Controller.ScaleResponse> manualScale(String scope, String stream, List<Long> segmentsToSeal, List<Map.Entry<Double, Double>> newRanges, long scaleTimestamp, long requestId) {
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        ScaleOpEvent event = new ScaleOpEvent(scope, stream, segmentsToSeal, newRanges, true, scaleTimestamp, requestId);
        return this.eventHelperFuture.thenCompose(eventHelper -> eventHelper.addIndexAndSubmitTask((ControllerEvent)event, () -> this.streamMetadataStore.submitScale(scope, stream, segmentsToSeal, new ArrayList<Map.Entry<Double, Double>>(newRanges), scaleTimestamp, null, context, this.executor)).handle((startScaleResponse, e) -> {
            Controller.ScaleResponse.Builder response = Controller.ScaleResponse.newBuilder();
            if (e != null) {
                Throwable cause = Exceptions.unwrap((Throwable)e);
                if (cause instanceof EpochTransitionOperationExceptions.PreConditionFailureException) {
                    response.setStatus(Controller.ScaleResponse.ScaleStreamStatus.PRECONDITION_FAILED);
                } else {
                    log.error(requestId, "Scale for stream {}/{} failed with exception {}", new Object[]{scope, stream, cause});
                    response.setStatus(Controller.ScaleResponse.ScaleStreamStatus.FAILURE);
                }
            } else {
                log.info(requestId, "scale for stream {}/{} started successfully", new Object[]{scope, stream});
                response.setStatus(Controller.ScaleResponse.ScaleStreamStatus.STARTED);
                response.addAllSegments((Iterable)((EpochTransitionRecord)startScaleResponse.getObject()).getNewSegmentsWithRange().entrySet().stream().map(segment -> this.convert(scope, stream, (Map.Entry<Long, Map.Entry<Double, Double>>)segment)).collect(Collectors.toList()));
                response.setEpoch(((EpochTransitionRecord)startScaleResponse.getObject()).getActiveEpoch());
            }
            return response.build();
        }));
    }

    public CompletableFuture<Controller.ScaleStatusResponse> checkScale(String scope, String stream, int epoch, long requestId) {
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, stream, requestId);
        CompletableFuture<EpochRecord> activeEpochFuture = this.streamMetadataStore.getActiveEpoch(scope, stream, context, true, this.executor);
        CompletableFuture<State> stateFuture = this.streamMetadataStore.getState(scope, stream, true, context, this.executor);
        CompletionStage etrFuture = this.streamMetadataStore.getEpochTransition(scope, stream, context, this.executor).thenApply(VersionedMetadata::getObject);
        return CompletableFuture.allOf(new CompletableFuture[]{stateFuture, activeEpochFuture, etrFuture}).handle((arg_0, arg_1) -> StreamMetadataTasks.lambda$checkScale$176(activeEpochFuture, stateFuture, (CompletableFuture)etrFuture, epoch, arg_0, arg_1));
    }

    @VisibleForTesting
    <T> CompletableFuture<T> addIndexAndSubmitTask(ControllerEvent event, Supplier<CompletableFuture<T>> futureSupplier) {
        return this.eventHelperFuture.thenCompose(eventHelper -> eventHelper.addIndexAndSubmitTask(event, futureSupplier));
    }

    public CompletableFuture<Void> writeEvent(ControllerEvent event) {
        return this.eventHelperFuture.thenCompose(eventHelper -> eventHelper.writeEvent(event));
    }

    @VisibleForTesting
    public void setRequestEventWriter(EventStreamWriter<ControllerEvent> requestEventWriter) {
        this.eventHelperFuture.thenAccept(eventHelper -> eventHelper.setRequestEventWriter(requestEventWriter));
    }

    CompletableFuture<Void> removeTaskFromIndex(String hostId, String id) {
        return this.eventHelperFuture.thenCompose(eventHelper -> eventHelper.removeTaskFromIndex(hostId, id));
    }

    @VisibleForTesting
    CompletableFuture<Controller.CreateStreamStatus.Status> createStreamBody(String scope, String stream, StreamConfiguration config, long timestamp, OperationContext context) {
        long requestId = this.getRequestId(context);
        return ((CompletableFuture)this.streamMetadataStore.createStream(scope, stream, config, timestamp, context, this.executor).thenComposeAsync(response -> {
            log.debug(requestId, "{}/{} created in metadata store", new Object[]{scope, stream});
            Controller.CreateStreamStatus.Status status = this.translate(response.getStatus());
            if (response.getStatus().equals((Object)CreateStreamResponse.CreateStatus.NEW) || response.getStatus().equals((Object)CreateStreamResponse.CreateStatus.EXISTS_CREATING)) {
                int startingSegmentNumber = response.getStartingSegmentNumber();
                int minNumSegments = response.getConfiguration().getScalingPolicy().getMinNumSegments();
                List<Long> newSegments = IntStream.range(startingSegmentNumber, startingSegmentNumber + minNumSegments).boxed().map(x -> NameUtils.computeSegmentId((int)x, (int)0)).collect(Collectors.toList());
                return ((CompletableFuture)this.notifyNewSegments(scope, stream, response.getConfiguration(), newSegments, this.retrieveDelegationToken(), requestId).thenCompose(v -> this.createMarkStream(scope, stream, timestamp, requestId))).thenCompose(y -> TaskStepsRetryHelper.withRetries(() -> {
                    CompletableFuture<Object> future = config.getRetentionPolicy() != null ? this.bucketStore.addStreamToBucketStore(BucketStore.ServiceType.RetentionService, scope, stream, this.executor) : CompletableFuture.completedFuture(null);
                    return ((CompletableFuture)future.thenCompose(v -> this.streamMetadataStore.addStreamTagsToIndex(scope, stream, config, context, this.executor))).thenCompose(v -> this.streamMetadataStore.getVersionedState(scope, stream, context, this.executor).thenCompose(state -> {
                        if (((State)((Object)((Object)((Object)((Object)((Object)((Object)state.getObject()))))))).equals((Object)State.CREATING)) {
                            return this.streamMetadataStore.updateVersionedState(scope, stream, State.ACTIVE, (VersionedMetadata<State>)state, context, this.executor);
                        }
                        return CompletableFuture.completedFuture(state);
                    }));
                }, this.executor).thenApply(z -> status));
            }
            return CompletableFuture.completedFuture(status);
        }, (Executor)this.executor)).handle((result, ex) -> {
            if (ex != null) {
                Throwable cause = Exceptions.unwrap((Throwable)ex);
                log.warn(requestId, "Create stream failed due to ", new Object[]{ex});
                if (cause instanceof StoreException.DataNotFoundException) {
                    return Controller.CreateStreamStatus.Status.SCOPE_NOT_FOUND;
                }
                return Controller.CreateStreamStatus.Status.FAILURE;
            }
            return result;
        });
    }

    private CompletableFuture<Void> createMarkStream(String scope, String baseStream, long timestamp, long requestId) {
        String markStream = NameUtils.getMarkStreamForStream((String)baseStream);
        StreamConfiguration config = StreamConfiguration.builder().scalingPolicy(ScalingPolicy.fixed((int)1)).build();
        OperationContext context = this.streamMetadataStore.createStreamContext(scope, markStream, requestId);
        return ((CompletableFuture)this.streamMetadataStore.createStream(scope, markStream, config, timestamp, context, this.executor).thenCompose(response -> {
            long segmentId = NameUtils.computeSegmentId((int)response.getStartingSegmentNumber(), (int)0);
            return this.notifyNewSegment(scope, markStream, segmentId, response.getConfiguration().getScalingPolicy(), this.retrieveDelegationToken(), requestId, config.getRolloverSizeBytes());
        })).thenCompose(v -> this.streamMetadataStore.getVersionedState(scope, markStream, context, this.executor).thenCompose(state -> Futures.toVoid(this.streamMetadataStore.updateVersionedState(scope, markStream, State.ACTIVE, (VersionedMetadata<State>)state, context, this.executor))));
    }

    private Controller.CreateStreamStatus.Status translate(CreateStreamResponse.CreateStatus status) {
        Controller.CreateStreamStatus.Status retVal;
        switch (status) {
            case NEW: {
                retVal = Controller.CreateStreamStatus.Status.SUCCESS;
                break;
            }
            case EXISTS_ACTIVE: 
            case EXISTS_CREATING: {
                retVal = Controller.CreateStreamStatus.Status.STREAM_EXISTS;
                break;
            }
            default: {
                retVal = Controller.CreateStreamStatus.Status.FAILURE;
            }
        }
        return retVal;
    }

    public CompletableFuture<Void> notifyNewSegments(String scope, String stream, List<Long> segmentIds, OperationContext context, String controllerToken, long requestId) {
        return TaskStepsRetryHelper.withRetries(() -> this.streamMetadataStore.getConfiguration(scope, stream, context, this.executor), this.executor).thenCompose(configuration -> this.notifyNewSegments(scope, stream, (StreamConfiguration)configuration, segmentIds, controllerToken, requestId));
    }

    public CompletableFuture<Void> notifyNewSegments(String scope, String stream, StreamConfiguration configuration, List<Long> segmentIds, String controllerToken, long requestId) {
        return Futures.toVoid((CompletableFuture)Futures.allOfWithResults(((Stream)segmentIds.stream().parallel()).map(segment -> this.notifyNewSegment(scope, stream, (long)segment, configuration.getScalingPolicy(), controllerToken, requestId, configuration.getRolloverSizeBytes())).collect(Collectors.toList())));
    }

    public CompletableFuture<Void> notifyNewSegment(String scope, String stream, long segmentId, ScalingPolicy policy, String controllerToken, long requestId, long rolloverSize) {
        return Futures.toVoid(TaskStepsRetryHelper.withRetries(() -> this.segmentHelper.createSegment(scope, stream, segmentId, policy, controllerToken, requestId, rolloverSize), this.executor));
    }

    public CompletableFuture<Void> notifyDeleteSegments(String scope, String stream, Set<Long> segmentsToDelete, String delegationToken, long requestId) {
        return Futures.allOf((Collection)((Stream)segmentsToDelete.stream().parallel()).map(segment -> this.notifyDeleteSegment(scope, stream, (long)segment, delegationToken, requestId)).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> notifyDeleteSegment(String scope, String stream, long segmentId, String delegationToken, long requestId) {
        return Futures.toVoid(TaskStepsRetryHelper.withRetries(() -> this.segmentHelper.deleteSegment(scope, stream, segmentId, delegationToken, requestId), this.executor));
    }

    public CompletableFuture<Void> notifyTruncateSegment(String scope, String stream, Map.Entry<Long, Long> segmentCut, String delegationToken, long requestId) {
        return Futures.toVoid(TaskStepsRetryHelper.withRetries(() -> this.segmentHelper.truncateSegment(scope, stream, (Long)segmentCut.getKey(), (Long)segmentCut.getValue(), delegationToken, requestId), this.executor));
    }

    public CompletableFuture<Map<Long, Long>> getSealedSegmentsSize(String scope, String stream, List<Long> segments, String delegationToken, long requestId) {
        return Futures.allOfWithResults(((Stream)segments.stream().parallel()).collect(Collectors.toMap(x -> x, x -> this.getSegmentOffset(scope, stream, (long)x, delegationToken, requestId))));
    }

    public CompletableFuture<Void> notifySealedSegments(String scope, String stream, List<Long> sealedSegments, String delegationToken, long requestId) {
        return Futures.allOf((Collection)((Stream)sealedSegments.stream().parallel()).map(id -> this.notifySealedSegment(scope, stream, (long)id, delegationToken, requestId)).collect(Collectors.toList()));
    }

    private CompletableFuture<Void> notifySealedSegment(String scope, String stream, long sealedSegment, String delegationToken, long requestId) {
        return Futures.toVoid(TaskStepsRetryHelper.withRetries(() -> this.segmentHelper.sealSegment(scope, stream, sealedSegment, delegationToken, requestId), this.executor));
    }

    public CompletableFuture<Void> notifyPolicyUpdates(String scope, String stream, List<StreamSegmentRecord> activeSegments, ScalingPolicy policy, String delegationToken, long requestId) {
        return Futures.toVoid((CompletableFuture)Futures.allOfWithResults(((Stream)activeSegments.stream().parallel()).map(segment -> this.notifyPolicyUpdate(scope, stream, policy, segment.segmentId(), delegationToken, requestId)).collect(Collectors.toList())));
    }

    private CompletableFuture<Long> getSegmentOffset(String scope, String stream, long segmentId, String delegationToken, long requestId) {
        return TaskStepsRetryHelper.withRetries(() -> this.segmentHelper.getSegmentInfo(scope, stream, segmentId, delegationToken, requestId), this.executor).thenApply(WireCommands.StreamSegmentInfo::getWriteOffset);
    }

    private CompletableFuture<Void> notifyPolicyUpdate(String scope, String stream, ScalingPolicy policy, long segmentId, String delegationToken, long requestId) {
        return TaskStepsRetryHelper.withRetries(() -> this.segmentHelper.updatePolicy(scope, stream, policy, segmentId, delegationToken, requestId), this.executor);
    }

    private Controller.SegmentRange convert(String scope, String stream, Map.Entry<Long, Map.Entry<Double, Double>> segment) {
        return io.pravega.client.control.impl.ModelHelper.createSegmentRange((String)scope, (String)stream, (long)segment.getKey(), (double)segment.getValue().getKey(), (double)segment.getValue().getValue());
    }

    private Controller.UpdateStreamStatus.Status handleUpdateStreamError(Throwable ex, long requestId, String logMessage, String streamFullName) {
        Throwable cause = Exceptions.unwrap((Throwable)ex);
        log.error(requestId, "Exception updating Stream {}. Cause: {}.", new Object[]{streamFullName, logMessage, cause});
        if (cause instanceof StoreException.DataNotFoundException) {
            return Controller.UpdateStreamStatus.Status.STREAM_NOT_FOUND;
        }
        if (cause instanceof TimeoutException) {
            throw new CompletionException(cause);
        }
        return Controller.UpdateStreamStatus.Status.FAILURE;
    }

    private Controller.DeleteStreamStatus.Status handleDeleteStreamError(Throwable ex, long requestId, String streamFullName) {
        Throwable cause = Exceptions.unwrap((Throwable)ex);
        log.error(requestId, "Exception deleting stream {}. Cause: {}", new Object[]{streamFullName, ex});
        if (cause instanceof StoreException.DataNotFoundException) {
            return Controller.DeleteStreamStatus.Status.STREAM_NOT_FOUND;
        }
        if (cause instanceof TimeoutException) {
            throw new CompletionException(cause);
        }
        return Controller.DeleteStreamStatus.Status.FAILURE;
    }

    public CompletableFuture<Map<Long, Long>> notifyTxnCommit(String scope, String stream, List<Long> segments, UUID txnId, long requestId) {
        Timer timer = new Timer();
        return Futures.allOfWithResults(segments.stream().collect(Collectors.toMap(x -> x, x -> this.notifyTxnCommit(scope, stream, (long)x, txnId, requestId)))).whenComplete((r, e) -> TransactionMetrics.getInstance().commitTransactionSegments(timer.getElapsed()));
    }

    private CompletableFuture<Long> notifyTxnCommit(String scope, String stream, long segmentNumber, UUID txnId, long requestId) {
        return TaskStepsRetryHelper.withRetries(() -> this.segmentHelper.commitTransaction(scope, stream, segmentNumber, segmentNumber, txnId, this.retrieveDelegationToken(), requestId), this.executor);
    }

    public CompletableFuture<Void> notifyTxnAbort(String scope, String stream, List<Long> segments, UUID txnId, long requestId) {
        Timer timer = new Timer();
        return Futures.allOf((Collection)((Stream)segments.stream().parallel()).map(segment -> this.notifyTxnAbort(scope, stream, (long)segment, txnId, requestId)).collect(Collectors.toList())).thenRun(() -> TransactionMetrics.getInstance().abortTransactionSegments(timer.getElapsed()));
    }

    private CompletableFuture<Controller.TxnStatus> notifyTxnAbort(String scope, String stream, long segmentNumber, UUID txnId, long requestId) {
        return TaskStepsRetryHelper.withRetries(() -> this.segmentHelper.abortTransaction(scope, stream, segmentNumber, txnId, this.retrieveDelegationToken(), requestId), this.executor);
    }

    public CompletableFuture<Map<Long, Long>> getCurrentSegmentSizes(String scope, String stream, List<Long> segments, long requestId) {
        return Futures.allOfWithResults(segments.stream().collect(Collectors.toMap(x -> x, x -> this.getSegmentOffset(scope, stream, (long)x, this.retrieveDelegationToken(), requestId))));
    }

    public CompletableFuture<Void> processScale(String scope, String stream, VersionedMetadata<EpochTransitionRecord> record, OperationContext context, long requestId, StreamMetadataStore store) {
        ArrayList<Long> segmentIds = new ArrayList<Long>((Collection<Long>)record.getObject().getNewSegmentsWithRange().keySet());
        ArrayList<Long> segmentsToSeal = new ArrayList<Long>((Collection<Long>)record.getObject().getSegmentsToSeal());
        String delegationToken = this.retrieveDelegationToken();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.notifyNewSegments(scope, stream, segmentIds, context, delegationToken, requestId).thenCompose(x -> store.scaleCreateNewEpochs(scope, stream, record, context, this.executor))).thenCompose(x -> this.notifySealedSegments(scope, stream, segmentsToSeal, delegationToken, requestId))).thenCompose(x -> this.getSealedSegmentsSize(scope, stream, segmentsToSeal, delegationToken, requestId))).thenCompose(map -> store.scaleSegmentsSealed(scope, stream, (Map<Long, Long>)map, record, context, this.executor))).thenCompose(x -> store.completeScale(scope, stream, record, context, this.executor));
    }

    @Override
    public TaskBase copyWithContext(TaskBase.Context context) {
        return new StreamMetadataTasks(this.streamMetadataStore, this.bucketStore, this.taskMetadataStore, this.segmentHelper, this.executor, this.eventExecutor, context, this.authHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.toSetEventHelper = false;
            if (this.eventHelper != null) {
                this.eventHelper.close();
            }
        }
        this.eventHelperFuture.cancel(true);
    }

    public String retrieveDelegationToken() {
        return this.authHelper.retrieveMasterToken();
    }

    @VisibleForTesting
    public void setCompletionTimeoutMillis(long timeoutMillis) {
        this.eventHelperFuture.thenAccept(eventHelper -> eventHelper.setCompletionTimeoutMillis(timeoutMillis));
    }

    @VisibleForTesting
    void setRetentionFrequencyMillis(long timeoutMillis) {
        this.retentionFrequencyMillis.set(timeoutMillis);
    }

    @VisibleForTesting
    void setRetentionClock(Supplier<Long> clock) {
        this.retentionClock.set(clock);
    }

    public long getRequestId(OperationContext context) {
        return context != null ? context.getRequestId() : this.requestIdGenerator.nextLong();
    }

    private static /* synthetic */ Controller.ScaleStatusResponse lambda$checkScale$176(CompletableFuture activeEpochFuture, CompletableFuture stateFuture, CompletableFuture etrFuture, int epoch, Void r, Throwable ex) {
        Controller.ScaleStatusResponse.Builder response = Controller.ScaleStatusResponse.newBuilder();
        if (ex != null) {
            Throwable e = Exceptions.unwrap((Throwable)ex);
            if (e instanceof StoreException.DataNotFoundException) {
                response.setStatus(Controller.ScaleStatusResponse.ScaleStatus.INVALID_INPUT);
            } else {
                response.setStatus(Controller.ScaleStatusResponse.ScaleStatus.INTERNAL_ERROR);
            }
        } else {
            EpochRecord activeEpoch = (EpochRecord)activeEpochFuture.join();
            State state = (State)((Object)stateFuture.join());
            EpochTransitionRecord etr = (EpochTransitionRecord)etrFuture.join();
            if (epoch > activeEpoch.getEpoch()) {
                response.setStatus(Controller.ScaleStatusResponse.ScaleStatus.INVALID_INPUT);
            } else if (activeEpoch.getEpoch() == epoch || activeEpoch.getReferenceEpoch() == epoch) {
                response.setStatus(Controller.ScaleStatusResponse.ScaleStatus.IN_PROGRESS);
            } else if (epoch + 1 == activeEpoch.getReferenceEpoch() && state.equals((Object)State.SCALING) && (etr.equals(EpochTransitionRecord.EMPTY) || etr.getNewEpoch() == activeEpoch.getEpoch())) {
                response.setStatus(Controller.ScaleStatusResponse.ScaleStatus.IN_PROGRESS);
            } else {
                response.setStatus(Controller.ScaleStatusResponse.ScaleStatus.SUCCESS);
            }
        }
        return response.build();
    }

    private static /* synthetic */ Boolean lambda$isTruncated$149(CompletableFuture stateFuture, CompletableFuture configPropertyFuture, Map streamCut, Void v) {
        State state = (State)((Object)stateFuture.join());
        StreamTruncationRecord truncationRecord = (StreamTruncationRecord)configPropertyFuture.join();
        if (truncationRecord.isUpdating()) {
            return !truncationRecord.getStreamCut().equals((Object)streamCut);
        }
        return !truncationRecord.getStreamCut().equals((Object)streamCut) || !state.equals((Object)State.TRUNCATING);
    }

    private static /* synthetic */ Boolean lambda$isUpdated$79(CompletableFuture stateFuture, CompletableFuture configPropertyFuture, StreamConfiguration newConfig, Void v) {
        State state = (State)((Object)stateFuture.join());
        StreamConfigurationRecord configProperty = (StreamConfigurationRecord)configPropertyFuture.join();
        if (configProperty.isUpdating()) {
            return !configProperty.getStreamConfiguration().equals((Object)newConfig);
        }
        return !configProperty.getStreamConfiguration().equals((Object)newConfig) || !state.equals((Object)State.UPDATING);
    }
}

