/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.task;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.fault.FailoverSweeper;
import io.pravega.controller.store.task.LockFailedException;
import io.pravega.controller.store.task.TaggedResource;
import io.pravega.controller.store.task.TaskMetadataStore;
import io.pravega.controller.task.DuplicateTaskAnnotationException;
import io.pravega.controller.task.Task;
import io.pravega.controller.task.TaskBase;
import io.pravega.controller.task.TaskData;
import io.pravega.controller.util.RetryHelper;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSweeper
implements FailoverSweeper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskSweeper.class);
    private final TaskMetadataStore taskMetadataStore;
    private final TaskBase[] taskClassObjects;
    private final Map<String, Method> methodMap = new HashMap<String, Method>();
    private final Map<String, TaskBase> objectMap = new HashMap<String, TaskBase>();
    private final String hostId;
    private final ScheduledExecutorService executor;

    public TaskSweeper(TaskMetadataStore taskMetadataStore, String hostId, ScheduledExecutorService executor, TaskBase ... classes) {
        this.taskMetadataStore = taskMetadataStore;
        this.hostId = hostId;
        this.executor = executor;
        for (TaskBase object : classes) {
            Preconditions.checkArgument((boolean)object.getContext().getHostId().equals(hostId));
        }
        this.taskClassObjects = classes;
        this.initializeMappingTable();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public CompletableFuture<Void> sweepFailedProcesses(Supplier<Set<String>> runningProcesses) {
        return RetryHelper.withRetriesAsync(this.taskMetadataStore::getHosts, RetryHelper.RETRYABLE_PREDICATE, Integer.MAX_VALUE, this.executor).thenComposeAsync(registeredHosts -> {
            log.info("Hosts {} have ongoing tasks", registeredHosts);
            registeredHosts.removeAll((Collection)RetryHelper.withRetries(runningProcesses, RetryHelper.UNCONDITIONAL_PREDICATE, Integer.MAX_VALUE));
            log.info("Failed hosts {} have orphaned tasks", registeredHosts);
            return Futures.allOf((Collection)registeredHosts.stream().map(this::handleFailedProcess).collect(Collectors.toList()));
        }, (Executor)this.executor);
    }

    @Override
    public CompletableFuture<Void> handleFailedProcess(String oldHostId) {
        log.info("Sweeping orphaned tasks for host {}", (Object)oldHostId);
        return RetryHelper.withRetriesAsync(() -> Futures.doWhileLoop(() -> this.executeHostTask(oldHostId), x -> x != null, (Executor)this.executor).whenCompleteAsync((result, ex) -> log.info("Sweeping orphaned tasks for host {} complete", (Object)oldHostId), (Executor)this.executor), RetryHelper.RETRYABLE_PREDICATE.and(e -> !(Exceptions.unwrap((Throwable)e) instanceof LockFailedException)), Integer.MAX_VALUE, this.executor);
    }

    private CompletableFuture<Result> executeHostTask(String oldHostId) {
        return this.taskMetadataStore.getRandomChild(oldHostId).thenComposeAsync(taggedResourceOption -> {
            if (!taggedResourceOption.isPresent()) {
                log.debug("Host={} fetched no child of {}", (Object)this.hostId, (Object)oldHostId);
                return this.taskMetadataStore.removeNode(oldHostId).thenApplyAsync(x -> null, (Executor)this.executor);
            }
            TaggedResource taggedResource = (TaggedResource)taggedResourceOption.get();
            log.debug("Host={} processing child <{}, {}> of {}", new Object[]{this.hostId, taggedResource.getResource(), taggedResource.getTag(), oldHostId});
            return this.executeResourceTask(oldHostId, taggedResource);
        }, (Executor)this.executor);
    }

    private CompletableFuture<Result> executeResourceTask(String oldHostId, TaggedResource taggedResource) {
        CompletableFuture<Result> result = new CompletableFuture<Result>();
        this.taskMetadataStore.getTask(taggedResource.getResource(), oldHostId, taggedResource.getTag()).whenCompleteAsync((taskData, ex) -> {
            if (taskData != null && taskData.isPresent()) {
                log.debug("Host={} found task for child <{}, {}> of {}", new Object[]{this.hostId, taggedResource.getResource(), taggedResource.getTag(), oldHostId});
                this.execute(oldHostId, (TaskData)taskData.get(), taggedResource).whenCompleteAsync((value, e) -> result.complete(new Result(taggedResource, value, (Throwable)e)), (Executor)this.executor);
            } else if (taskData != null) {
                log.debug("Host={} found no task for child <{}, {}> of {}. Removing child.", new Object[]{this.hostId, taggedResource.getResource(), taggedResource.getTag(), oldHostId});
                this.taskMetadataStore.removeChild(oldHostId, taggedResource, true).whenCompleteAsync((value, e) -> result.complete(new Result(taggedResource, null, (Throwable)ex)), (Executor)this.executor);
            } else {
                result.complete(new Result(taggedResource, null, (Throwable)ex));
            }
        }, (Executor)this.executor);
        return result;
    }

    private CompletableFuture<Object> execute(String oldHostId, TaskData taskData, TaggedResource taggedResource) {
        log.debug("Host={} attempting to execute task {}-{} for child <{}, {}> of {}", new Object[]{this.hostId, taskData.getMethodName(), taskData.getMethodVersion(), taggedResource.getResource(), taggedResource.getTag(), oldHostId});
        try {
            String key = this.getKey(taskData.getMethodName(), taskData.getMethodVersion());
            if (this.methodMap.containsKey(key)) {
                Method method = this.methodMap.get(key);
                if (this.objectMap.get(key).isReady()) {
                    TaskBase o = this.objectMap.get(key).copyWithContext(new TaskBase.Context(this.hostId, oldHostId, taggedResource.getTag(), taggedResource.getResource()));
                    return (CompletableFuture)method.invoke((Object)o, (Object[])taskData.getParameters());
                }
                log.info("Task module for method {} not yet ready, delaying processing it", (Object)method.getName());
                return Futures.delayedFuture((Duration)Duration.ofMillis(100L), (ScheduledExecutorService)this.executor).thenApplyAsync(ignore -> null, (Executor)this.executor);
            }
            CompletableFuture<Object> error = new CompletableFuture<Object>();
            log.warn("Task {} not found", (Object)taskData.getMethodName());
            error.completeExceptionally(new RuntimeException(String.format("Task %s not found", taskData.getMethodName())));
            return error;
        }
        catch (Exception e) {
            CompletableFuture<Object> result = new CompletableFuture<Object>();
            result.completeExceptionally(e);
            return result;
        }
    }

    private void initializeMappingTable() {
        for (TaskBase taskClassObject : this.taskClassObjects) {
            Class<?> claz = taskClassObject.getClass();
            for (Method method : claz.getDeclaredMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    String methodVersion;
                    if (!(annotation instanceof Task)) continue;
                    String methodName = ((Task)annotation).name();
                    String key = this.getKey(methodName, methodVersion = ((Task)annotation).version());
                    if (!this.methodMap.containsKey(key)) {
                        this.methodMap.put(key, method);
                        this.objectMap.put(key, taskClassObject);
                        continue;
                    }
                    throw new DuplicateTaskAnnotationException(methodName, methodVersion);
                }
            }
        }
    }

    private String getKey(String taskName, String taskVersion) {
        return taskName + "--" + taskVersion;
    }

    static class Result {
        private final TaggedResource taggedResource;
        private final Object value;
        private final Throwable error;

        @ConstructorProperties(value={"taggedResource", "value", "error"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Result(TaggedResource taggedResource, Object value, Throwable error) {
            this.taggedResource = taggedResource;
            this.value = value;
            this.error = error;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TaggedResource getTaggedResource() {
            return this.taggedResource;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Object getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Throwable getError() {
            return this.error;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TaggedResource this$taggedResource = this.getTaggedResource();
            TaggedResource other$taggedResource = other.getTaggedResource();
            if (this$taggedResource == null ? other$taggedResource != null : !((Object)this$taggedResource).equals(other$taggedResource)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Throwable this$error = this.getError();
            Throwable other$error = other.getError();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaggedResource $taggedResource = this.getTaggedResource();
            result = result * 59 + ($taggedResource == null ? 43 : ((Object)$taggedResource).hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Throwable $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "TaskSweeper.Result(taggedResource=" + this.getTaggedResource() + ", value=" + this.getValue() + ", error=" + this.getError() + ")";
        }
    }
}

