/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression;

import com.emc.codec.EncodeInputStream;
import com.emc.codec.compression.CompressionException;
import com.emc.codec.compression.CompressionMetadata;
import com.emc.codec.util.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class CompressionInputStream
extends EncodeInputStream<CompressionMetadata> {
    private CompressionMetadata metadata;
    private boolean closed = false;
    private CountingInputStream uncompressedCounter;
    private DigestInputStream digester;
    private CountingInputStream compressedCounter;

    public CompressionInputStream(InputStream input, String encodeSpec) {
        super(input);
        this.metadata = new CompressionMetadata(encodeSpec);
    }

    protected abstract InputStream getCompressionStream(InputStream var1) throws IOException;

    protected void initStreams(InputStream originalStream) {
        try {
            this.uncompressedCounter = new CountingInputStream(originalStream);
            this.digester = new DigestInputStream(this.uncompressedCounter, MessageDigest.getInstance("SHA1"));
            InputStream compressionStream = this.getCompressionStream(this.digester);
            this.compressedCounter = new CountingInputStream(compressionStream);
            this.in = this.compressedCounter;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CompressionException("Unable to initialize digest", e);
        }
        catch (IOException e) {
            throw new CompressionException("Could not create compression stream", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        this.metadata.setOriginalSize(this.uncompressedCounter.getByteCount());
        this.metadata.setCompressedSize(this.compressedCounter.getByteCount());
        this.metadata.setOriginalDigest(this.digester.getMessageDigest().digest());
        this.notifyListeners();
    }

    @Override
    public CompressionMetadata getEncodeMetadata() {
        return this.metadata;
    }
}

