/*
 * Decompiled with CFR 0.152.
 */
package com.emc.codec.compression.lzma;

import com.emc.codec.compression.CompressionException;
import com.emc.codec.compression.lzma.DecoderThread;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class LzmaDecodeInputStream
extends FilterInputStream {
    private InputStream originalStream;
    DecoderThread decoderThread;

    public LzmaDecodeInputStream(InputStream originalStream, int bufferSize) {
        super(originalStream);
        this.originalStream = originalStream;
        try {
            PipedInputStream inputPipe = new PipedInputStream(bufferSize);
            PipedOutputStream outputPipe = new PipedOutputStream(inputPipe);
            this.decoderThread = new DecoderThread(originalStream, outputPipe);
            this.decoderThread.start();
            this.in = inputPipe;
        }
        catch (IOException e) {
            throw new CompressionException("Could not create decompression stream", e);
        }
    }

    @Override
    public int read() throws IOException {
        this.checkForError();
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkForError();
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkForError();
        return super.read(b);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.originalStream.close();
        this.decoderThread = null;
    }

    protected void checkForError() {
        if (this.decoderThread != null && this.decoderThread.isErrorSet()) {
            Throwable t = this.decoderThread.getError();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new CompressionException("Compression error", t);
        }
    }
}

