/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.local;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.impl.DefaultCredentials;
import io.pravega.common.auth.ZKTLSUtils;
import io.pravega.controller.server.ControllerServiceConfig;
import io.pravega.controller.server.ControllerServiceMain;
import io.pravega.controller.server.eventProcessor.ControllerEventProcessorConfig;
import io.pravega.controller.server.eventProcessor.impl.ControllerEventProcessorConfigImpl;
import io.pravega.controller.server.impl.ControllerServiceConfigImpl;
import io.pravega.controller.server.rest.impl.RESTServerConfigImpl;
import io.pravega.controller.server.rpc.grpc.impl.GRPCServerConfigImpl;
import io.pravega.controller.store.client.StoreClientConfig;
import io.pravega.controller.store.client.ZKClientConfig;
import io.pravega.controller.store.client.impl.StoreClientConfigImpl;
import io.pravega.controller.store.client.impl.ZKClientConfigImpl;
import io.pravega.controller.store.host.HostMonitorConfig;
import io.pravega.controller.store.host.impl.HostMonitorConfigImpl;
import io.pravega.controller.timeout.TimeoutServiceConfig;
import io.pravega.controller.util.Config;
import io.pravega.local.LocalHDFSEmulator;
import io.pravega.segmentstore.server.host.ServiceStarter;
import io.pravega.segmentstore.server.host.stat.AutoScalerConfig;
import io.pravega.segmentstore.server.logs.DurableLogConfig;
import io.pravega.segmentstore.server.store.ServiceBuilderConfig;
import io.pravega.segmentstore.server.store.ServiceConfig;
import io.pravega.segmentstore.storage.impl.bookkeeper.ZooKeeperServiceRunner;
import io.pravega.shared.metrics.MetricsConfig;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProcPravegaCluster
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(InProcPravegaCluster.class);
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    private static final int THREADPOOL_SIZE = 20;
    private boolean isInMemStorage;
    private final String clusterName = "singlenode-" + UUID.randomUUID();
    private boolean enableMetrics;
    private boolean enableAuth;
    private boolean enableTls;
    private boolean enableTlsReload;
    private boolean isInProcController;
    private int controllerCount;
    private int[] controllerPorts;
    private String controllerURI;
    private int restServerPort;
    private boolean isInProcSegmentStore;
    private int segmentStoreCount;
    private int[] segmentStorePorts;
    private boolean isInProcZK;
    private int zkPort;
    private String zkHost;
    private ZooKeeperServiceRunner zkService;
    private boolean isInProcHDFS;
    private String hdfsUrl;
    private int containerCount;
    private ServiceStarter[] nodeServiceStarter;
    private LocalHDFSEmulator localHdfs;
    @GuardedBy(value="$lock")
    private ControllerServiceMain[] controllerServers;
    private String zkUrl;
    private boolean enableRestServer;
    private String userName;
    private String passwd;
    private String certFile;
    private String keyFile;
    private String jksTrustFile;
    private String passwdFile;
    private boolean secureZK;
    private String keyPasswordFile;
    private String jksKeyFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControllerPorts(int[] controllerPorts) {
        Object object = this.$lock;
        synchronized (object) {
            this.controllerPorts = Arrays.copyOf(controllerPorts, controllerPorts.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSegmentStorePorts(int[] segmentStorePorts) {
        Object object = this.$lock;
        synchronized (object) {
            this.segmentStorePorts = Arrays.copyOf(segmentStorePorts, segmentStorePorts.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            if (this.isInProcZK) {
                this.zkUrl = "localhost:" + this.zkPort;
                this.startLocalZK();
            } else {
                URI zkUri = new URI("temp://" + this.zkUrl);
                this.zkHost = zkUri.getHost();
                this.zkPort = zkUri.getPort();
            }
            if (this.isInProcHDFS) {
                this.startLocalHDFS();
                this.hdfsUrl = String.format("hdfs://localhost:%d/", this.localHdfs.getNameNodePort());
            }
            this.cleanUpZK();
            if (this.isInProcController) {
                this.startLocalControllers();
            }
            if (this.isInProcSegmentStore) {
                this.nodeServiceStarter = new ServiceStarter[this.segmentStoreCount];
                this.startLocalSegmentStores();
            }
        }
    }

    private void startLocalZK() throws Exception {
        this.zkService = new ZooKeeperServiceRunner(this.zkPort, this.secureZK, this.jksKeyFile, this.keyPasswordFile, this.jksTrustFile);
        this.zkService.initialize();
        this.zkService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpZK() {
        String[] pathsTobeCleaned = new String[]{"/pravega", "/hostIndex", "/store", "/taskIndex"};
        ExponentialBackoffRetry rp = new ExponentialBackoffRetry(1000, 3);
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(this.zkUrl).connectionTimeoutMs(5000).sessionTimeoutMs(5000).retryPolicy((RetryPolicy)rp);
        if (this.secureZK) {
            ZKTLSUtils.setSecureZKClientProperties((String)this.jksTrustFile, (String)"1111_aaaa");
        }
        CuratorFramework zclient = builder.build();
        try {
            zclient.start();
            for (String path : pathsTobeCleaned) {
                try {
                    ((ChildrenDeletable)zclient.delete().guaranteed()).deletingChildrenIfNeeded().forPath(path);
                }
                catch (Exception e) {
                    log.warn("Not able to delete path {} . Exception {}", (Object)path, (Object)e.getMessage());
                }
            }
            zclient.close();
        }
        finally {
            if (Collections.singletonList(zclient).get(0) != null) {
                zclient.close();
            }
        }
    }

    private void startLocalHDFS() throws IOException {
        this.localHdfs = LocalHDFSEmulator.newBuilder().baseDirName("temp").build();
        this.localHdfs.start();
    }

    private void startLocalSegmentStores() throws Exception {
        for (int i = 0; i < this.segmentStoreCount; ++i) {
            this.startLocalSegmentStore(i);
        }
    }

    private void startLocalSegmentStore(int segmentStoreId) throws Exception {
        if (this.enableAuth) {
            this.setAuthSystemProperties();
        }
        ServiceBuilderConfig.Builder configBuilder = ServiceBuilderConfig.builder().include(System.getProperties()).include(ServiceConfig.builder().with(ServiceConfig.CONTAINER_COUNT, (Object)this.containerCount).with(ServiceConfig.THREAD_POOL_SIZE, (Object)20).with(ServiceConfig.ZK_URL, (Object)("localhost:" + this.zkPort)).with(ServiceConfig.SECURE_ZK, (Object)this.secureZK).with(ServiceConfig.ZK_TRUSTSTORE_LOCATION, (Object)this.jksTrustFile).with(ServiceConfig.ZK_TRUST_STORE_PASSWORD_PATH, (Object)this.keyPasswordFile).with(ServiceConfig.LISTENING_PORT, (Object)this.segmentStorePorts[segmentStoreId]).with(ServiceConfig.CLUSTER_NAME, (Object)this.clusterName).with(ServiceConfig.ENABLE_TLS, (Object)this.enableTls).with(ServiceConfig.KEY_FILE, (Object)this.keyFile).with(ServiceConfig.CERT_FILE, (Object)this.certFile).with(ServiceConfig.ENABLE_TLS_RELOAD, (Object)this.enableTlsReload).with(ServiceConfig.CACHE_POLICY_MAX_TIME, (Object)60).with(ServiceConfig.CACHE_POLICY_MAX_SIZE, (Object)0x8000000L).with(ServiceConfig.DATALOG_IMPLEMENTATION, (Object)(this.isInMemStorage ? ServiceConfig.DataLogType.INMEMORY : ServiceConfig.DataLogType.BOOKKEEPER)).with(ServiceConfig.STORAGE_IMPLEMENTATION, (Object)(this.isInMemStorage ? ServiceConfig.StorageType.INMEMORY : ServiceConfig.StorageType.FILESYSTEM))).include(DurableLogConfig.builder().with(DurableLogConfig.CHECKPOINT_COMMIT_COUNT, (Object)100).with(DurableLogConfig.CHECKPOINT_MIN_COMMIT_COUNT, (Object)100).with(DurableLogConfig.CHECKPOINT_TOTAL_COMMIT_LENGTH, (Object)0x6400000L)).include(AutoScalerConfig.builder().with(AutoScalerConfig.CONTROLLER_URI, (Object)((this.enableTls ? "tls" : "tcp") + "://localhost:" + this.controllerPorts[0])).with(AutoScalerConfig.TOKEN_SIGNING_KEY, (Object)"secret").with(AutoScalerConfig.AUTH_ENABLED, (Object)this.enableAuth).with(AutoScalerConfig.TLS_ENABLED, (Object)this.enableTls).with(AutoScalerConfig.TLS_CERT_FILE, (Object)this.certFile).with(AutoScalerConfig.VALIDATE_HOSTNAME, (Object)false)).include(MetricsConfig.builder().with(MetricsConfig.ENABLE_STATISTICS, (Object)this.enableMetrics));
        this.nodeServiceStarter[segmentStoreId] = new ServiceStarter(configBuilder.build());
        this.nodeServiceStarter[segmentStoreId].start();
    }

    private void setAuthSystemProperties() {
        if (this.authPropertiesAlreadySet()) {
            log.debug("Auth params already specified via system properties or environment variables.");
        } else if (!Strings.isNullOrEmpty((String)this.userName)) {
            DefaultCredentials credentials = new DefaultCredentials(this.passwd, this.userName);
            System.setProperty("pravega.client.auth.loadDynamic", "false");
            System.setProperty("pravega.client.auth.method", credentials.getAuthenticationType());
            System.setProperty("pravega.client.auth.token", credentials.getAuthenticationToken());
            log.debug("Done setting auth params via system properties.");
        } else {
            log.debug("Cannot set auth params as username is null or empty");
        }
    }

    private boolean authPropertiesAlreadySet() {
        return !Strings.isNullOrEmpty((String)System.getProperty("pravega.client.auth.method")) || !Strings.isNullOrEmpty((String)System.getenv("pravega_client_auth_method"));
    }

    private void startLocalControllers() {
        int i;
        this.controllerServers = new ControllerServiceMain[this.controllerCount];
        for (i = 0; i < this.controllerCount; ++i) {
            this.controllerServers[i] = this.startLocalController(i);
        }
        this.controllerURI = (this.enableTls ? "tls" : "tcp") + "://localhost:" + this.controllerPorts[0];
        for (i = 1; i < this.controllerCount; ++i) {
            this.controllerURI = this.controllerURI + ",localhost:" + this.controllerPorts[i];
        }
    }

    private ControllerServiceMain startLocalController(int controllerId) {
        ZKClientConfigImpl zkClientConfig = ZKClientConfigImpl.builder().connectionString(this.zkUrl).namespace("pravega/" + this.clusterName).initialSleepInterval(2000).maxRetries(1).sessionTimeoutMs(10000).secureConnectionToZooKeeper(this.secureZK).trustStorePath(this.jksTrustFile).trustStorePasswordPath(this.keyPasswordFile).build();
        StoreClientConfig storeClientConfig = StoreClientConfigImpl.withZKClient((ZKClientConfig)zkClientConfig);
        HostMonitorConfigImpl hostMonitorConfig = HostMonitorConfigImpl.builder().hostMonitorEnabled(true).hostMonitorMinRebalanceInterval(Config.CLUSTER_MIN_REBALANCE_INTERVAL).containerCount(Config.HOST_STORE_CONTAINER_COUNT).build();
        TimeoutServiceConfig timeoutServiceConfig = TimeoutServiceConfig.builder().maxLeaseValue(Config.MAX_LEASE_VALUE).build();
        ControllerEventProcessorConfig eventProcessorConfig = ControllerEventProcessorConfigImpl.withDefault();
        GRPCServerConfigImpl grpcServerConfig = GRPCServerConfigImpl.builder().port(this.controllerPorts[controllerId]).publishedRPCHost("localhost").publishedRPCPort(Integer.valueOf(this.controllerPorts[controllerId])).authorizationEnabled(this.enableAuth).tlsEnabled(this.enableTls).tlsTrustStore(this.certFile).tlsCertFile(this.certFile).tlsKeyFile(this.keyFile).userPasswordFile(this.passwdFile).tokenSigningKey("secret").accessTokenTTLInSeconds(Integer.valueOf(600)).replyWithStackTraceOnError(false).requestTracingEnabled(true).build();
        RESTServerConfigImpl restServerConfig = null;
        if (this.enableRestServer) {
            restServerConfig = RESTServerConfigImpl.builder().host("0.0.0.0").port(this.restServerPort).tlsEnabled(this.enableTls).keyFilePath(this.jksKeyFile).keyFilePasswordPath(this.keyPasswordFile).build();
        }
        ControllerServiceConfigImpl serviceConfig = ControllerServiceConfigImpl.builder().threadPoolSize(Config.ASYNC_TASK_POOL_SIZE).storeClientConfig(storeClientConfig).hostMonitorConfig((HostMonitorConfig)hostMonitorConfig).controllerClusterListenerEnabled(false).timeoutServiceConfig(timeoutServiceConfig).eventProcessorConfig(Optional.of(eventProcessorConfig)).grpcServerConfig(Optional.of(grpcServerConfig)).restServerConfig(Optional.ofNullable(restServerConfig)).build();
        ControllerServiceMain controllerService = new ControllerServiceMain((ControllerServiceConfig)serviceConfig);
        controllerService.startAsync();
        return controllerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getControllerURI() {
        Object object = this.$lock;
        synchronized (object) {
            return this.controllerURI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getZkUrl() {
        Object object = this.$lock;
        synchronized (object) {
            return this.zkUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            if (this.isInProcSegmentStore) {
                for (ServiceStarter serviceStarter : this.nodeServiceStarter) {
                    serviceStarter.shutdown();
                }
            }
            if (this.isInProcController) {
                for (ServiceStarter serviceStarter : this.controllerServers) {
                    serviceStarter.stopAsync();
                }
            }
            if (this.zkService != null) {
                this.zkService.close();
                this.zkService = null;
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    private static boolean $default$enableMetrics() {
        return false;
    }

    @SuppressFBWarnings(justification="generated code")
    private static boolean $default$enableAuth() {
        return false;
    }

    @SuppressFBWarnings(justification="generated code")
    private static boolean $default$enableTls() {
        return false;
    }

    @SuppressFBWarnings(justification="generated code")
    private static boolean $default$enableTlsReload() {
        return false;
    }

    @SuppressFBWarnings(justification="generated code")
    private static int[] $default$controllerPorts() {
        return null;
    }

    @SuppressFBWarnings(justification="generated code")
    private static String $default$controllerURI() {
        return null;
    }

    @SuppressFBWarnings(justification="generated code")
    private static int $default$segmentStoreCount() {
        return 0;
    }

    @SuppressFBWarnings(justification="generated code")
    private static int[] $default$segmentStorePorts() {
        return null;
    }

    @SuppressFBWarnings(justification="generated code")
    private static int $default$containerCount() {
        return 4;
    }

    @SuppressFBWarnings(justification="generated code")
    private static boolean $default$enableRestServer() {
        return true;
    }

    @ConstructorProperties(value={"isInMemStorage", "enableMetrics", "enableAuth", "enableTls", "enableTlsReload", "isInProcController", "controllerCount", "controllerPorts", "controllerURI", "restServerPort", "isInProcSegmentStore", "segmentStoreCount", "segmentStorePorts", "isInProcZK", "zkPort", "zkHost", "zkService", "isInProcHDFS", "hdfsUrl", "containerCount", "nodeServiceStarter", "localHdfs", "controllerServers", "zkUrl", "enableRestServer", "userName", "passwd", "certFile", "keyFile", "jksTrustFile", "passwdFile", "secureZK", "keyPasswordFile", "jksKeyFile"})
    @SuppressFBWarnings(justification="generated code")
    InProcPravegaCluster(boolean isInMemStorage, boolean enableMetrics, boolean enableAuth, boolean enableTls, boolean enableTlsReload, boolean isInProcController, int controllerCount, int[] controllerPorts, String controllerURI, int restServerPort, boolean isInProcSegmentStore, int segmentStoreCount, int[] segmentStorePorts, boolean isInProcZK, int zkPort, String zkHost, ZooKeeperServiceRunner zkService, boolean isInProcHDFS, String hdfsUrl, int containerCount, ServiceStarter[] nodeServiceStarter, LocalHDFSEmulator localHdfs, ControllerServiceMain[] controllerServers, String zkUrl, boolean enableRestServer, String userName, String passwd, String certFile, String keyFile, String jksTrustFile, String passwdFile, boolean secureZK, String keyPasswordFile, String jksKeyFile) {
        this.isInMemStorage = isInMemStorage;
        this.enableMetrics = enableMetrics;
        this.enableAuth = enableAuth;
        this.enableTls = enableTls;
        this.enableTlsReload = enableTlsReload;
        this.isInProcController = isInProcController;
        this.controllerCount = controllerCount;
        this.controllerPorts = controllerPorts;
        this.controllerURI = controllerURI;
        this.restServerPort = restServerPort;
        this.isInProcSegmentStore = isInProcSegmentStore;
        this.segmentStoreCount = segmentStoreCount;
        this.segmentStorePorts = segmentStorePorts;
        this.isInProcZK = isInProcZK;
        this.zkPort = zkPort;
        this.zkHost = zkHost;
        this.zkService = zkService;
        this.isInProcHDFS = isInProcHDFS;
        this.hdfsUrl = hdfsUrl;
        this.containerCount = containerCount;
        this.nodeServiceStarter = nodeServiceStarter;
        this.localHdfs = localHdfs;
        this.controllerServers = controllerServers;
        this.zkUrl = zkUrl;
        this.enableRestServer = enableRestServer;
        this.userName = userName;
        this.passwd = passwd;
        this.certFile = certFile;
        this.keyFile = keyFile;
        this.jksTrustFile = jksTrustFile;
        this.passwdFile = passwdFile;
        this.secureZK = secureZK;
        this.keyPasswordFile = keyPasswordFile;
        this.jksKeyFile = jksKeyFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public static InProcPravegaClusterBuilder builder() {
        return new InProcPravegaClusterBuilder();
    }

    public static final class InProcPravegaClusterBuilder {
        @SuppressFBWarnings(justification="generated code")
        private boolean isInMemStorage;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableMetrics$set;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableMetrics;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableAuth$set;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableAuth;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableTls$set;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableTls;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableTlsReload$set;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableTlsReload;
        @SuppressFBWarnings(justification="generated code")
        private boolean isInProcController;
        @SuppressFBWarnings(justification="generated code")
        private int controllerCount;
        @SuppressFBWarnings(justification="generated code")
        private boolean controllerPorts$set;
        @SuppressFBWarnings(justification="generated code")
        private int[] controllerPorts;
        @SuppressFBWarnings(justification="generated code")
        private boolean controllerURI$set;
        @SuppressFBWarnings(justification="generated code")
        private String controllerURI;
        @SuppressFBWarnings(justification="generated code")
        private int restServerPort;
        @SuppressFBWarnings(justification="generated code")
        private boolean isInProcSegmentStore;
        @SuppressFBWarnings(justification="generated code")
        private boolean segmentStoreCount$set;
        @SuppressFBWarnings(justification="generated code")
        private int segmentStoreCount;
        @SuppressFBWarnings(justification="generated code")
        private boolean segmentStorePorts$set;
        @SuppressFBWarnings(justification="generated code")
        private int[] segmentStorePorts;
        @SuppressFBWarnings(justification="generated code")
        private boolean isInProcZK;
        @SuppressFBWarnings(justification="generated code")
        private int zkPort;
        @SuppressFBWarnings(justification="generated code")
        private String zkHost;
        @SuppressFBWarnings(justification="generated code")
        private ZooKeeperServiceRunner zkService;
        @SuppressFBWarnings(justification="generated code")
        private boolean isInProcHDFS;
        @SuppressFBWarnings(justification="generated code")
        private String hdfsUrl;
        @SuppressFBWarnings(justification="generated code")
        private boolean containerCount$set;
        @SuppressFBWarnings(justification="generated code")
        private int containerCount;
        @SuppressFBWarnings(justification="generated code")
        private ServiceStarter[] nodeServiceStarter;
        @SuppressFBWarnings(justification="generated code")
        private LocalHDFSEmulator localHdfs;
        @SuppressFBWarnings(justification="generated code")
        private ControllerServiceMain[] controllerServers;
        @SuppressFBWarnings(justification="generated code")
        private String zkUrl;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableRestServer$set;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableRestServer;
        @SuppressFBWarnings(justification="generated code")
        private String userName;
        @SuppressFBWarnings(justification="generated code")
        private String passwd;
        @SuppressFBWarnings(justification="generated code")
        private String certFile;
        @SuppressFBWarnings(justification="generated code")
        private String keyFile;
        @SuppressFBWarnings(justification="generated code")
        private String jksTrustFile;
        @SuppressFBWarnings(justification="generated code")
        private String passwdFile;
        @SuppressFBWarnings(justification="generated code")
        private boolean secureZK;
        @SuppressFBWarnings(justification="generated code")
        private String keyPasswordFile;
        @SuppressFBWarnings(justification="generated code")
        private String jksKeyFile;

        public InProcPravegaCluster build() {
            Preconditions.checkState((this.isInProcZK || this.zkUrl != null ? 1 : 0) != 0, (Object)"ZkUrl must be specified");
            Preconditions.checkState((this.isInProcController || this.controllerURI != null ? 1 : 0) != 0, (Object)"ControllerURI should be defined for external controller");
            Preconditions.checkState((this.isInProcController || this.controllerPorts != null ? 1 : 0) != 0, (Object)"Controller ports not present");
            Preconditions.checkState((this.isInProcSegmentStore || this.segmentStorePorts != null ? 1 : 0) != 0, (Object)"SegmentStore ports not declared");
            Preconditions.checkState((!this.enableTls || !Strings.isNullOrEmpty((String)this.keyFile) && !Strings.isNullOrEmpty((String)this.certFile) && !Strings.isNullOrEmpty((String)this.jksKeyFile) && !Strings.isNullOrEmpty((String)this.jksTrustFile) && !Strings.isNullOrEmpty((String)this.keyPasswordFile) ? 1 : 0) != 0, (Object)"TLS enabled, but not all parameters set");
            if (this.isInMemStorage) {
                this.isInProcHDFS = false;
            }
            return new InProcPravegaCluster(this.isInMemStorage, this.enableMetrics, this.enableAuth, this.enableTls, this.enableTlsReload, this.isInProcController, this.controllerCount, this.controllerPorts, this.controllerURI, this.restServerPort, this.isInProcSegmentStore, this.segmentStoreCount, this.segmentStorePorts, this.isInProcZK, this.zkPort, this.zkHost, this.zkService, this.isInProcHDFS, this.hdfsUrl, this.containerCount, this.nodeServiceStarter, this.localHdfs, this.controllerServers, this.zkUrl, this.enableRestServer, this.userName, this.passwd, this.certFile, this.keyFile, this.jksTrustFile, this.passwdFile, this.secureZK, this.keyPasswordFile, this.jksKeyFile);
        }

        @SuppressFBWarnings(justification="generated code")
        InProcPravegaClusterBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder isInMemStorage(boolean isInMemStorage) {
            this.isInMemStorage = isInMemStorage;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder enableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
            this.enableMetrics$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder enableAuth(boolean enableAuth) {
            this.enableAuth = enableAuth;
            this.enableAuth$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder enableTls(boolean enableTls) {
            this.enableTls = enableTls;
            this.enableTls$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder enableTlsReload(boolean enableTlsReload) {
            this.enableTlsReload = enableTlsReload;
            this.enableTlsReload$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder isInProcController(boolean isInProcController) {
            this.isInProcController = isInProcController;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder controllerCount(int controllerCount) {
            this.controllerCount = controllerCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder controllerPorts(int[] controllerPorts) {
            this.controllerPorts = controllerPorts;
            this.controllerPorts$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder controllerURI(String controllerURI) {
            this.controllerURI = controllerURI;
            this.controllerURI$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder restServerPort(int restServerPort) {
            this.restServerPort = restServerPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder isInProcSegmentStore(boolean isInProcSegmentStore) {
            this.isInProcSegmentStore = isInProcSegmentStore;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder segmentStoreCount(int segmentStoreCount) {
            this.segmentStoreCount = segmentStoreCount;
            this.segmentStoreCount$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder segmentStorePorts(int[] segmentStorePorts) {
            this.segmentStorePorts = segmentStorePorts;
            this.segmentStorePorts$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder isInProcZK(boolean isInProcZK) {
            this.isInProcZK = isInProcZK;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder zkPort(int zkPort) {
            this.zkPort = zkPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder zkHost(String zkHost) {
            this.zkHost = zkHost;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder zkService(ZooKeeperServiceRunner zkService) {
            this.zkService = zkService;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder isInProcHDFS(boolean isInProcHDFS) {
            this.isInProcHDFS = isInProcHDFS;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder hdfsUrl(String hdfsUrl) {
            this.hdfsUrl = hdfsUrl;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder containerCount(int containerCount) {
            this.containerCount = containerCount;
            this.containerCount$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder nodeServiceStarter(ServiceStarter[] nodeServiceStarter) {
            this.nodeServiceStarter = nodeServiceStarter;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder localHdfs(LocalHDFSEmulator localHdfs) {
            this.localHdfs = localHdfs;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder controllerServers(ControllerServiceMain[] controllerServers) {
            this.controllerServers = controllerServers;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder zkUrl(String zkUrl) {
            this.zkUrl = zkUrl;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder enableRestServer(boolean enableRestServer) {
            this.enableRestServer = enableRestServer;
            this.enableRestServer$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder passwd(String passwd) {
            this.passwd = passwd;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder certFile(String certFile) {
            this.certFile = certFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder keyFile(String keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder jksTrustFile(String jksTrustFile) {
            this.jksTrustFile = jksTrustFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder passwdFile(String passwdFile) {
            this.passwdFile = passwdFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder secureZK(boolean secureZK) {
            this.secureZK = secureZK;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder keyPasswordFile(String keyPasswordFile) {
            this.keyPasswordFile = keyPasswordFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public InProcPravegaClusterBuilder jksKeyFile(String jksKeyFile) {
            this.jksKeyFile = jksKeyFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "InProcPravegaCluster.InProcPravegaClusterBuilder(isInMemStorage=" + this.isInMemStorage + ", enableMetrics=" + this.enableMetrics + ", enableAuth=" + this.enableAuth + ", enableTls=" + this.enableTls + ", enableTlsReload=" + this.enableTlsReload + ", isInProcController=" + this.isInProcController + ", controllerCount=" + this.controllerCount + ", controllerPorts=" + Arrays.toString(this.controllerPorts) + ", controllerURI=" + this.controllerURI + ", restServerPort=" + this.restServerPort + ", isInProcSegmentStore=" + this.isInProcSegmentStore + ", segmentStoreCount=" + this.segmentStoreCount + ", segmentStorePorts=" + Arrays.toString(this.segmentStorePorts) + ", isInProcZK=" + this.isInProcZK + ", zkPort=" + this.zkPort + ", zkHost=" + this.zkHost + ", zkService=" + this.zkService + ", isInProcHDFS=" + this.isInProcHDFS + ", hdfsUrl=" + this.hdfsUrl + ", containerCount=" + this.containerCount + ", nodeServiceStarter=" + Arrays.deepToString(this.nodeServiceStarter) + ", localHdfs=" + this.localHdfs + ", controllerServers=" + Arrays.deepToString(this.controllerServers) + ", zkUrl=" + this.zkUrl + ", enableRestServer=" + this.enableRestServer + ", userName=" + this.userName + ", passwd=" + this.passwd + ", certFile=" + this.certFile + ", keyFile=" + this.keyFile + ", jksTrustFile=" + this.jksTrustFile + ", passwdFile=" + this.passwdFile + ", secureZK=" + this.secureZK + ", keyPasswordFile=" + this.keyPasswordFile + ", jksKeyFile=" + this.jksKeyFile + ")";
        }
    }
}

