/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.local;

import io.pravega.common.Exceptions;
import io.pravega.common.io.FileHelpers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class LocalHDFSEmulator
implements AutoCloseable {
    private File baseDir = null;
    private MiniDFSCluster hdfsCluster = null;
    private final String baseDirName;

    private LocalHDFSEmulator(String baseDirName) {
        Exceptions.checkNotNullOrEmpty((String)baseDirName, (String)"baseDirName");
        this.baseDirName = baseDirName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void start() throws IOException {
        this.baseDir = Files.createTempDirectory(this.baseDirName, new FileAttribute[0]).toFile().getAbsoluteFile();
        Configuration conf = new Configuration();
        conf.set("hdfs.minidfs.basedir", this.baseDir.getAbsolutePath());
        conf.setBoolean("dfs.permissions.enabled", true);
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        this.hdfsCluster = builder.build();
    }

    @Override
    public void close() {
        if (this.hdfsCluster != null) {
            this.hdfsCluster.shutdown();
            this.hdfsCluster = null;
            FileHelpers.deleteFileOrDirectory((File)this.baseDir);
            this.baseDir = null;
        }
    }

    public int getNameNodePort() {
        return this.hdfsCluster.getNameNodePort();
    }

    public static class Builder {
        private String baseDirName;

        public Builder baseDirName(String baseDir) {
            Exceptions.checkNotNullOrEmpty((String)baseDir, (String)"baseDir");
            this.baseDirName = baseDir;
            return this;
        }

        public LocalHDFSEmulator build() {
            return new LocalHDFSEmulator(this.baseDirName);
        }
    }
}

