/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.local;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.local.InProcPravegaCluster;
import io.pravega.local.SingleNodeConfig;
import io.pravega.segmentstore.server.store.ServiceBuilderConfig;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPravegaEmulator
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(LocalPravegaEmulator.class);
    private int zkPort;
    private int controllerPort;
    private int segmentStorePort;
    private int restServerPort;
    private boolean enableRestServer;
    private boolean enableAuth;
    private boolean enableTls;
    private String certFile;
    private String passwd;
    private String userName;
    private String passwdFile;
    private String keyFile;
    private boolean enableTlsReload;
    private String jksKeyFile;
    private String jksTrustFile;
    private String keyPasswordFile;
    private final InProcPravegaCluster inProcPravegaCluster;

    public static void main(String[] args) {
        try {
            ServiceBuilderConfig config = ServiceBuilderConfig.builder().include(System.getProperty("singlenode.configurationFile", "./config/standalone-config.properties")).include(System.getProperties()).build();
            SingleNodeConfig conf = (SingleNodeConfig)config.getConfig(SingleNodeConfig::builder);
            final LocalPravegaEmulator localPravega = LocalPravegaEmulator.builder().controllerPort(conf.getControllerPort()).segmentStorePort(conf.getSegmentStorePort()).zkPort(conf.getZkPort()).restServerPort(conf.getRestServerPort()).enableRestServer(conf.isEnableRestServer()).enableAuth(conf.isEnableAuth()).enableTls(conf.isEnableTls()).certFile(conf.getCertFile()).keyFile(conf.getKeyFile()).enableTlsReload(conf.isEnableSegmentStoreTlsReload()).jksKeyFile(conf.getKeyStoreJKS()).jksTrustFile(conf.getTrustStoreJKS()).keyPasswordFile(conf.getKeyStoreJKSPasswordFile()).passwdFile(conf.getPasswdFile()).userName(conf.getUserName()).passwd(conf.getPasswd()).build();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        localPravega.close();
                        System.out.println("ByeBye!");
                    }
                    catch (Exception e) {
                        log.warn("Exception running local Pravega emulator: " + e.getMessage());
                    }
                }
            });
            log.info("Starting Pravega Emulator with ports: ZK port {}, controllerPort {}, SegmentStorePort {}", new Object[]{conf.getZkPort(), conf.getControllerPort(), conf.getSegmentStorePort()});
            localPravega.start();
            System.out.println(String.format("Pravega Sandbox is running locally now. You could access it at %s:%d", "127.0.0.1", conf.getControllerPort()));
        }
        catch (Exception ex) {
            log.error("Exception occurred running emulator", (Throwable)ex);
            System.exit(1);
        }
    }

    @Override
    public void close() throws Exception {
        this.inProcPravegaCluster.close();
    }

    void start() throws Exception {
        this.inProcPravegaCluster.start();
    }

    @ConstructorProperties(value={"zkPort", "controllerPort", "segmentStorePort", "restServerPort", "enableRestServer", "enableAuth", "enableTls", "certFile", "passwd", "userName", "passwdFile", "keyFile", "enableTlsReload", "jksKeyFile", "jksTrustFile", "keyPasswordFile", "inProcPravegaCluster"})
    @SuppressFBWarnings(justification="generated code")
    LocalPravegaEmulator(int zkPort, int controllerPort, int segmentStorePort, int restServerPort, boolean enableRestServer, boolean enableAuth, boolean enableTls, String certFile, String passwd, String userName, String passwdFile, String keyFile, boolean enableTlsReload, String jksKeyFile, String jksTrustFile, String keyPasswordFile, InProcPravegaCluster inProcPravegaCluster) {
        this.zkPort = zkPort;
        this.controllerPort = controllerPort;
        this.segmentStorePort = segmentStorePort;
        this.restServerPort = restServerPort;
        this.enableRestServer = enableRestServer;
        this.enableAuth = enableAuth;
        this.enableTls = enableTls;
        this.certFile = certFile;
        this.passwd = passwd;
        this.userName = userName;
        this.passwdFile = passwdFile;
        this.keyFile = keyFile;
        this.enableTlsReload = enableTlsReload;
        this.jksKeyFile = jksKeyFile;
        this.jksTrustFile = jksTrustFile;
        this.keyPasswordFile = keyPasswordFile;
        this.inProcPravegaCluster = inProcPravegaCluster;
    }

    @SuppressFBWarnings(justification="generated code")
    public static LocalPravegaEmulatorBuilder builder() {
        return new LocalPravegaEmulatorBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public InProcPravegaCluster getInProcPravegaCluster() {
        return this.inProcPravegaCluster;
    }

    public static final class LocalPravegaEmulatorBuilder {
        @SuppressFBWarnings(justification="generated code")
        private int zkPort;
        @SuppressFBWarnings(justification="generated code")
        private int controllerPort;
        @SuppressFBWarnings(justification="generated code")
        private int segmentStorePort;
        @SuppressFBWarnings(justification="generated code")
        private int restServerPort;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableRestServer;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableAuth;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableTls;
        @SuppressFBWarnings(justification="generated code")
        private String certFile;
        @SuppressFBWarnings(justification="generated code")
        private String passwd;
        @SuppressFBWarnings(justification="generated code")
        private String userName;
        @SuppressFBWarnings(justification="generated code")
        private String passwdFile;
        @SuppressFBWarnings(justification="generated code")
        private String keyFile;
        @SuppressFBWarnings(justification="generated code")
        private boolean enableTlsReload;
        @SuppressFBWarnings(justification="generated code")
        private String jksKeyFile;
        @SuppressFBWarnings(justification="generated code")
        private String jksTrustFile;
        @SuppressFBWarnings(justification="generated code")
        private String keyPasswordFile;
        @SuppressFBWarnings(justification="generated code")
        private InProcPravegaCluster inProcPravegaCluster;

        public LocalPravegaEmulator build() {
            this.inProcPravegaCluster = InProcPravegaCluster.builder().isInProcZK(true).secureZK(this.enableTls).zkUrl("localhost:" + this.zkPort).zkPort(this.zkPort).isInMemStorage(true).isInProcController(true).controllerCount(1).isInProcSegmentStore(true).segmentStoreCount(1).containerCount(4).restServerPort(this.restServerPort).enableRestServer(this.enableRestServer).enableMetrics(false).enableAuth(this.enableAuth).enableTls(this.enableTls).certFile(this.certFile).keyFile(this.keyFile).enableTlsReload(this.enableTlsReload).jksKeyFile(this.jksKeyFile).jksTrustFile(this.jksTrustFile).keyPasswordFile(this.keyPasswordFile).passwdFile(this.passwdFile).userName(this.userName).passwd(this.passwd).build();
            this.inProcPravegaCluster.setControllerPorts(new int[]{this.controllerPort});
            this.inProcPravegaCluster.setSegmentStorePorts(new int[]{this.segmentStorePort});
            return new LocalPravegaEmulator(this.zkPort, this.controllerPort, this.segmentStorePort, this.restServerPort, this.enableRestServer, this.enableAuth, this.enableTls, this.certFile, this.passwd, this.userName, this.passwdFile, this.keyFile, this.enableTlsReload, this.jksKeyFile, this.jksTrustFile, this.keyPasswordFile, this.inProcPravegaCluster);
        }

        @SuppressFBWarnings(justification="generated code")
        LocalPravegaEmulatorBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder zkPort(int zkPort) {
            this.zkPort = zkPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder controllerPort(int controllerPort) {
            this.controllerPort = controllerPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder segmentStorePort(int segmentStorePort) {
            this.segmentStorePort = segmentStorePort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder restServerPort(int restServerPort) {
            this.restServerPort = restServerPort;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder enableRestServer(boolean enableRestServer) {
            this.enableRestServer = enableRestServer;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder enableAuth(boolean enableAuth) {
            this.enableAuth = enableAuth;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder enableTls(boolean enableTls) {
            this.enableTls = enableTls;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder certFile(String certFile) {
            this.certFile = certFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder passwd(String passwd) {
            this.passwd = passwd;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder passwdFile(String passwdFile) {
            this.passwdFile = passwdFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder keyFile(String keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder enableTlsReload(boolean enableTlsReload) {
            this.enableTlsReload = enableTlsReload;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder jksKeyFile(String jksKeyFile) {
            this.jksKeyFile = jksKeyFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder jksTrustFile(String jksTrustFile) {
            this.jksTrustFile = jksTrustFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder keyPasswordFile(String keyPasswordFile) {
            this.keyPasswordFile = keyPasswordFile;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public LocalPravegaEmulatorBuilder inProcPravegaCluster(InProcPravegaCluster inProcPravegaCluster) {
            this.inProcPravegaCluster = inProcPravegaCluster;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "LocalPravegaEmulator.LocalPravegaEmulatorBuilder(zkPort=" + this.zkPort + ", controllerPort=" + this.controllerPort + ", segmentStorePort=" + this.segmentStorePort + ", restServerPort=" + this.restServerPort + ", enableRestServer=" + this.enableRestServer + ", enableAuth=" + this.enableAuth + ", enableTls=" + this.enableTls + ", certFile=" + this.certFile + ", passwd=" + this.passwd + ", userName=" + this.userName + ", passwdFile=" + this.passwdFile + ", keyFile=" + this.keyFile + ", enableTlsReload=" + this.enableTlsReload + ", jksKeyFile=" + this.jksKeyFile + ", jksTrustFile=" + this.jksTrustFile + ", keyPasswordFile=" + this.keyPasswordFile + ", inProcPravegaCluster=" + this.inProcPravegaCluster + ")";
        }
    }
}

