/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.local;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;

public class SingleNodeConfig {
    public static final String PROPERTY_FILE = "singlenode.configurationFile";
    public static final Property<Integer> ZK_PORT = Property.named((String)"zkPort", (Object)4000);
    public static final Property<Integer> SEGMENTSTORE_PORT = Property.named((String)"segmentstorePort", (Object)6000);
    public static final Property<Integer> CONTROLLER_PORT = Property.named((String)"controllerPort", (Object)9090);
    public static final Property<Integer> REST_SERVER_PORT = Property.named((String)"restServerPort", (Object)9091);
    public static final Property<Boolean> ENABLE_AUTH = Property.named((String)"enableAuth", (Object)false);
    public static final Property<String> USER_NAME = Property.named((String)"userName", (Object)"");
    public static final Property<String> PASSWD = Property.named((String)"passwd", (Object)"");
    public static final Property<Boolean> ENABLE_REST_SERVER = Property.named((String)"enableRestServer", (Object)true);
    public static final Property<Boolean> ENABLE_TLS = Property.named((String)"enableTls", (Object)false);
    public static final Property<String> KEY_FILE = Property.named((String)"keyFile", (Object)"");
    public static final Property<String> PASSWD_FILE = Property.named((String)"passwdFile", (Object)"");
    public static final Property<String> CERT_FILE = Property.named((String)"certFile", (Object)"");
    public static final Property<String> KEYSTORE_JKS = Property.named((String)"keyStoreJKS", (Object)"");
    public static final Property<String> KEYSTORE_JKS_PASSWORD_FILE = Property.named((String)"keyStoreJKSPasswordFile", (Object)"");
    public static final Property<String> TRUSTSTORE_JKS = Property.named((String)"trustStoreJKS", (Object)"");
    public static final Property<Boolean> ENABLE_TLS_RELOAD = Property.named((String)"segmentstoreEnableTlsReload", (Object)false);
    private static final String COMPONENT_CODE = "singlenode";
    private final int zkPort;
    private final int segmentStorePort;
    private final int controllerPort;
    private final int restServerPort;
    private String certFile;
    private String keyFile;
    private boolean enableSegmentStoreTlsReload;
    private String passwdFile;
    private String userName;
    private String passwd;
    private final String keyStoreJKS;
    private final String keyStoreJKSPasswordFile;
    private final String trustStoreJKS;
    private boolean enableRestServer;
    private boolean enableTls;
    private boolean enableAuth;

    private SingleNodeConfig(TypedProperties properties) {
        this.zkPort = properties.getInt(ZK_PORT);
        this.segmentStorePort = properties.getInt(SEGMENTSTORE_PORT);
        this.controllerPort = properties.getInt(CONTROLLER_PORT);
        this.restServerPort = properties.getInt(REST_SERVER_PORT);
        this.certFile = properties.get(CERT_FILE);
        this.keyFile = properties.get(KEY_FILE);
        this.passwdFile = properties.get(PASSWD_FILE);
        this.userName = properties.get(USER_NAME);
        this.passwd = properties.get(PASSWD);
        this.enableRestServer = properties.getBoolean(ENABLE_REST_SERVER);
        this.enableTls = properties.getBoolean(ENABLE_TLS);
        this.enableAuth = properties.getBoolean(ENABLE_AUTH);
        this.keyStoreJKS = properties.get(KEYSTORE_JKS);
        this.keyStoreJKSPasswordFile = properties.get(KEYSTORE_JKS_PASSWORD_FILE);
        this.trustStoreJKS = properties.get(TRUSTSTORE_JKS);
        this.enableSegmentStoreTlsReload = properties.getBoolean(ENABLE_TLS_RELOAD);
    }

    public static ConfigBuilder<SingleNodeConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, SingleNodeConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    public int getZkPort() {
        return this.zkPort;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getSegmentStorePort() {
        return this.segmentStorePort;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getControllerPort() {
        return this.controllerPort;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getRestServerPort() {
        return this.restServerPort;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getCertFile() {
        return this.certFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getKeyFile() {
        return this.keyFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isEnableSegmentStoreTlsReload() {
        return this.enableSegmentStoreTlsReload;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getPasswdFile() {
        return this.passwdFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getUserName() {
        return this.userName;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getPasswd() {
        return this.passwd;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getKeyStoreJKS() {
        return this.keyStoreJKS;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getKeyStoreJKSPasswordFile() {
        return this.keyStoreJKSPasswordFile;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getTrustStoreJKS() {
        return this.trustStoreJKS;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isEnableRestServer() {
        return this.enableRestServer;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isEnableTls() {
        return this.enableTls;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isEnableAuth() {
        return this.enableAuth;
    }
}

