/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.schemaregistry.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.pravega.auth.AuthenticationException;

public class AuthHelper {
    public static String getAuthorizationHeader(String method, String token) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)method) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0);
        return String.format("%s %s", method, token);
    }

    public static String[] extractMethodAndToken(String credentials) throws AuthenticationException {
        Preconditions.checkNotNull((Object)credentials, (Object)"Credentials cannot be null");
        String[] parts = credentials.split("\\s+", 2);
        if (parts.length != 2) {
            throw new AuthenticationException("Malformed request");
        }
        return parts;
    }
}

